--[[
Copyright (C) GtX (Andy), 2023

Author: GtX | Andy
Date: 24.01.2023
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Free for use in mods (FS22 Only) - no permission needed.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Frei verwendbar (Nur LS22) - keine erlaubnis nötig
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.


Usage Example:
<modDesc>
    <placeableSpecializations>
        <specialization name="inGameMenuPoint" className="PlaceableInGameMenuPoint" filename="scripts/PlaceableInGameMenuPoint.lua"/>
    </placeableSpecializations>

    <placeableTypes>
        <type name="inGameMenuPoint" parent="simplePlaceable" className="Placeable" filename="$dataS/scripts/placeables/Placeable.lua">
            <specialization name="inGameMenuPoint"/>
        </type>
    </placeableTypes>
</modDesc>

<placeable type="inGameMenuPoint">
    <inGameMenuPoint node="inGameMenuTrigger" page="FINANCES" accessAllPlayers="false"/>
</placeable>
]]


PlaceableInGameMenuPoint = {}

PlaceableInGameMenuPoint.MOD_NAME = g_currentModName
PlaceableInGameMenuPoint.SPEC_NAME = string.format("%s.inGameMenuPoint", g_currentModName)
PlaceableInGameMenuPoint.SPEC = string.format("spec_%s", PlaceableInGameMenuPoint.SPEC_NAME)

function PlaceableInGameMenuPoint.prerequisitesPresent(specializations)
    return true
end

function PlaceableInGameMenuPoint.registerXMLPaths(schema, basePath)
    schema:setXMLSpecializationType("InGameMenuPoint")

    schema:register(XMLValueType.BOOL, basePath .. ".inGameMenuPoint#accessAllPlayers", "Allow all players access regardless of their farm", false, false)
    schema:register(XMLValueType.NODE_INDEX, basePath .. ".inGameMenuPoint#node", "Player trigger node")
    schema:register(XMLValueType.STRING, basePath .. ".inGameMenuPoint#page", "Page to open. Available pages: FINANCES | PRODUCTION | AI | HELP", "FINANCES", false)

    schema:setXMLSpecializationType()
end

function PlaceableInGameMenuPoint.registerFunctions(placeableType)
    SpecializationUtil.registerFunction(placeableType, "inGameMenuPointOpenPage", PlaceableInGameMenuPoint.inGameMenuPointOpenPage)
    SpecializationUtil.registerFunction(placeableType, "inGameMenuPointTriggerCallback", PlaceableInGameMenuPoint.inGameMenuPointTriggerCallback)
end

function PlaceableInGameMenuPoint.registerEventListeners(placeableType)
    SpecializationUtil.registerEventListener(placeableType, "onLoad", PlaceableInGameMenuPoint)
    SpecializationUtil.registerEventListener(placeableType, "onDelete", PlaceableInGameMenuPoint)
end

function PlaceableInGameMenuPoint:onLoad(savegame)
    local spec = self[PlaceableInGameMenuPoint.SPEC]
    local xmlFile = self.xmlFile

    spec.accessAllPlayers = xmlFile:getValue("placeable.inGameMenuPoint#accessAllPlayers", false)
    spec.playerTrigger = xmlFile:getValue("placeable.inGameMenuPoint#node", nil, self.components, self.i3dMappings)

    if spec.playerTrigger ~= nil then
        if not CollisionFlag.getHasFlagSet(spec.playerTrigger, CollisionFlag.TRIGGER_PLAYER) then
            Logging.xmlWarning(xmlFile, "Missing collision mask bit '%d'. Please add this bit to vehicle selling player trigger node '%s'", CollisionFlag.getBit(CollisionFlag.TRIGGER_PLAYER), I3DUtil.getNodePath(spec.playerTrigger))
        end

        if self.isClient then
            addTrigger(spec.playerTrigger, "inGameMenuPointTriggerCallback", self)
        end
    else
        Logging.xmlWarning(xmlFile, "No trigger node found at '<placeable.inGameMenuPoint#node/>'")
    end

    local pageName = xmlFile:getValue("placeable.inGameMenuPoint#page", "FINANCES"):upper()

    if pageName ~= "FINANCES" and pageName ~= "PRODUCTION" and pageName ~= "AI" and pageName ~= "HELP" then
        Logging.xmlWarning(xmlFile, "Unknown InGameMenu page '%s'. Falling back to page 'FINANCES'\nAvailable pages: FINANCES | PRODUCTION | AI | HELP", pageName)
        pageName = "FINANCES"
    end

    spec.pageName = pageName
    spec.messageTypeName = string.format("GUI_INGAME_OPEN_%s_SCREEN", pageName)

    spec.activatable = InGameMenuPointActivatable.new(self, spec.playerTrigger, spec.accessAllPlayers, pageName)
end

function PlaceableInGameMenuPoint:onDelete()
    local spec = self[PlaceableInGameMenuPoint.SPEC]

    if self.isClient and spec.playerTrigger ~= nil then
        removeTrigger(spec.playerTrigger)
        spec.playerTrigger = nil
    end

    if spec.activatable ~= nil then
        spec.activatable.playerTrigger = nil
        g_currentMission.activatableObjectsSystem:removeActivatable(spec.activatable)
    end
end

function PlaceableInGameMenuPoint:inGameMenuPointOpenPage()
    local spec = self[PlaceableInGameMenuPoint.SPEC]
    local messageTypeName = spec.messageTypeName or "GUI_INGAME_OPEN_FINANCES_SCREEN"

    g_gui:showGui("InGameMenu")
    g_messageCenter:publish(MessageType[messageTypeName] or MessageType.GUI_INGAME_OPEN_FINANCES_SCREEN)
end

function PlaceableInGameMenuPoint:inGameMenuPointTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    if self.isClient and (onEnter or onLeave) and g_currentMission.missionInfo:isa(FSCareerMissionInfo) and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        local spec = self[PlaceableInGameMenuPoint.SPEC]

        if onEnter then
            g_currentMission.activatableObjectsSystem:addActivatable(spec.activatable)
        else
            g_currentMission.activatableObjectsSystem:removeActivatable(spec.activatable)
        end
    end
end


InGameMenuPointActivatable = {}
local InGameMenuPointActivatable_mt = Class(InGameMenuPointActivatable)

function InGameMenuPointActivatable.new(inGameMenuPoint, playerTrigger, accessAllPlayers, pageName)
    local self = setmetatable({}, InGameMenuPointActivatable_mt)

    self.inGameMenuPoint = inGameMenuPoint
    self.playerTrigger = playerTrigger
    self.accessAllPlayers = accessAllPlayers

    if pageName == "FINANCES" then
        self.activateText = g_i18n:getText("action_checkFinances")
    elseif pageName == "PRODUCTION" then
        self.activateText = g_i18n:getText("ui_permissions_manageProductions")
    elseif pageName == "AI" then
        self.activateText = g_i18n:getText("ui_permissions_hireAssistent")
    elseif pageName == "HELP" then
        self.activateText = g_i18n:getText("action_callHelpLine")
    else
        self.activateText = g_i18n:getText("input_MENU")
    end

    return self
end

function InGameMenuPointActivatable:run()
    self.inGameMenuPoint:inGameMenuPointOpenPage()
end

function InGameMenuPointActivatable:getIsActivatable()
    if self.playerTrigger == nil or not g_currentMission.controlPlayer then
        return false
    end

    local farmId = g_currentMission:getFarmId()

    if farmId == FarmManager.SPECTATOR_FARM_ID then
        return false
    end

    if self.accessAllPlayers then
        return true
    end

    local ownerFarmId = self.inGameMenuPoint:getOwnerFarmId()

    return self.accessAllPlayers or ownerFarmId == AccessHandler.EVERYONE or ownerFarmId == farmId
end

function InGameMenuPointActivatable:getDistance(x, y, z)
    if self.playerTrigger ~= nil then
        local tx, _, tz = getWorldTranslation(self.playerTrigger)

        return MathUtil.getPointPointDistance(tx, tz, x, z)
    end

    return math.huge
end
