-- realistic mulching
-- Disables the "need mulching" for crops that don't actually require it

-- Author: Piersi, with technical support from ChatGPT/OpenAI.
-- Date: 21.07.2025

-- V1.0
-- FS25 release


local RealisticMulching = {}

-- List of crops that realistically require mulching after harvest
local cropsThatNeedMulching = {
    CANOLA = true,    
    SORGHUM = true,
	MAIZE = true,      
    SUNFLOWER = true,
    COTTON = true,
    SUGARCANE = true,
    RICE = true,
    RICELONGGRAIN = true   
}

local function applyRealisticMulching()
    for _, fruit in pairs(g_fruitTypeManager.fruitTypes) do
        if fruit.name ~= nil then
            -- Default: disable mulching
            fruit.needsMulching = false

            -- Re-enable only for specific crops
            if cropsThatNeedMulching[fruit.name] then
                fruit.needsMulching = true
                print(string.format("[RealisticMulching] Enabled mulching for: %s", fruit.name))
            else
                print(string.format("[RealisticMulching] Disabled mulching for: %s", fruit.name))
            end
        end
    end
end

-- Hook into mission start
local oldStartMission = Mission00.onStartMission
function Mission00:onStartMission()
    if oldStartMission ~= nil then
        oldStartMission(self)
    end

    print("[RealisticMulching] Map loaded, applying realistic mulching rules...")
    applyRealisticMulching()
end

--print("[RealisticMulching] Mod loaded successfully!")