rvbWearable = {}

function rvbWearable.updateDamageAmount(self, superFunc, dt)
	local rvb = self.spec_faultData
	if rvb then
		local currentPartslifetime = 0
		local currentPartsoperatingHours = 0
		local ignoredParts = {
			TIREFL = true, TIREFR = true, TIRERL = true, TIRERR = true
		}
		for _, key in ipairs(g_vehicleBreakdownsPartKeys) do
			local part = rvb.parts[key]
			if part and not ignoredParts[key] then
				currentPartslifetime = currentPartslifetime + part.tmp_lifetime
				currentPartsoperatingHours = currentPartsoperatingHours + part.operatingHours
			end
		end
		if currentPartslifetime > 0 then
			self:setDamageAmount(currentPartsoperatingHours / currentPartslifetime)
		else
			self:setDamageAmount(0)
		end
		return 0
	else
		return superFunc(self, dt)
	end
end