
rvbMotorized = {}

function rvbMotorized.startMotor(self, superFunc, noEventSend)

	local spec = self.spec_motorized
	local rvbs = self.spec_faultData
	
	if rvbs == nil or not rvbs.isrvbSpecEnabled then
		superFunc(self, noEventSend)
		return 
	end

	if not rvbs.rvbMotorStart then
		if self.spec_motorized.motorTemperature.value <= self.currentTemperaturDay then
			self.spec_motorized.motorTemperature.value = self.currentTemperaturDay
		end

		--VehicleBreakdowns:checkGlowPlugFault()

		GlowPlugManager.startMotor(self)
		SelfStarterManager.startMotor(self)

		local oneGameMinute7 = 60
		if rvbs.parts[SELFSTARTER].operatingHours < rvbs.parts[SELFSTARTER].tmp_lifetime then
			rvbs.parts[SELFSTARTER].operatingHours = rvbs.parts[SELFSTARTER].operatingHours + oneGameMinute7 / 3600
		end
		RVBParts_Event.sendEvent(self, rvbs.parts)
		
		self:setBatteryDrainingIfStartMotor()

		rvbs.rvbMotorStart = true
	end

	superFunc(self, noEventSend)

end

function rvbMotorized.stopMotor(self, superFunc, noEventSend)
	local spec = self.spec_motorized
	local rvbs = self.spec_faultData
	
	if rvbs == nil or not rvbs.isrvbSpecEnabled then
		superFunc(self, noEventSend)
		return 
	end

	if rvbs.rvbMotorStart then
		rvbs.rvbMotorStart = false
	end
	
	for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
		local part = rvbs.parts[key]
		if part.runOncePerStart then
			part.runOncePerStart = false
		end
	end

	
	-- Idozites miatt ha van maradek, azt itt elmentjuk 
	if rvbs.OperatingHoursUpdateTimer and rvbs.OperatingHoursUpdateTimer > 0 then
		self:updateOperatingHours(rvbs.OperatingHoursUpdateTimer, rvbs)
		rvbs.OperatingHoursUpdateTimer = 0
	end
	
	if rvbs.LightingUpdateTimer and rvbs.LightingUpdateTimer > 0 then
		self:updateLightingOperatingHours(rvbs.LightingUpdateTimer, rvbs)
		rvbs.LightingUpdateTimer = 0
	end
	
	if rvbs.wiperOperatingHoursUpdateTimer and rvbs.wiperOperatingHoursUpdateTimer > 0 then
		self:updateWiperOperatingHours(rvbs.wiperOperatingHoursUpdateTimer, rvbs)
		rvbs.wiperOperatingHoursUpdateTimer = 0
	end

	if rvbs.chargeBatteryUpdateTimer and rvbs.chargeBatteryUpdateTimer > 0 then
		GeneratorManager.chargeBatteryFromGenerator(self, rvbs.chargeBatteryUpdateTimer, nil)
		rvbs.chargeBatteryUpdateTimer = 0
	end

	--if not self:getIsMotorStarted() then
		rvbs.batteryDrainStartMotorTriggered = false
	--end
	--rvbs.batteryDrain = false
	
	if rvbs.engineStartStop then
		rvbs.ignition = 0
		rvbs.engineStarts = false
		rvbs.motorTries = 0
		rvbs.engineStartStop = false
		rvbs.faultType = 0
		rvbs.firstStart = true
	end

	superFunc(self, noEventSend)
end

function rvbMotorized.updateMotorTemperature(self, superFunc, dt)
    local spec = self.spec_motorized
	local rvb = self.spec_faultData
	local fault = rvb.parts[THERMOSTAT].fault
	
	local ambientTemp = g_currentMission.environment.weather:getCurrentTemperature() or self.currentTemperaturDay

	local tempDiff = math.max(-15, math.min(15, ambientTemp - self.currentTemperaturDay))
	local tempFactor = 1 - (tempDiff / 100)

	local gameDt = dt
    -- Heating phase: Calculate heat generated based on load and RPM
    local heatingRate = spec.motorTemperature.heatingPerMS * gameDt
    local loadFactor = (1 + 4 * spec.actualLoadPercentage) / 5
    local rpmFactor = self:getMotorRpmPercentage()

	local totalHeating = heatingRate * (loadFactor + rpmFactor) * tempFactor
    spec.motorTemperature.value = math.min(spec.motorTemperature.valueMax, spec.motorTemperature.value + totalHeating)

	local coolingFactor = 1 + ((ambientTemp - self.currentTemperaturDay) / 50)
	local coolingPenalty = 1.0
	
	if fault == "restrictedFlow" then
		coolingPenalty = 0.5
	end
	
	local dirt = self.spec_washable and self.spec_washable:getDirtAmount() or 0
	
	-- Dirt alapú coolingPenalty (0 tiszta, 1 koszos)
	local dirtFactor = dirt / 100
	coolingPenalty = coolingPenalty * (1 - 0.3 * dirtFactor)

    -- cooling due to wind Cooling phase: Calculate cooling by wind based on speed
	local windCoolingRate = spec.motorTemperature.coolingByWindPerMS * gameDt * coolingFactor * coolingPenalty
    local speedFactor = math.pow(math.min(1, self:getLastSpeed() / 30), 2)
    spec.motorTemperature.value = math.max(spec.motorTemperature.valueMin, spec.motorTemperature.value - speedFactor * windCoolingRate)

    -- cooling per fan
    if spec.motorTemperature.value > spec.motorFan.enableTemperature then
        spec.motorFan.enabled = true
    end
	
	-- Hibakezelés: termosztát hibák
	if fault == "stuckClosed" then
		-- Gyakorlatilag nem hűt rendesen, venti nagyon magas hőfokon kapcsol
		--spec.motorFan.enabled = false
		spec.motorFan.enableTemperature = 121
		spec.motorFan.disableTemperature = 100
	elseif fault == "stuckOpen" then
		-- Túl alacsony hőmérsékleten kapcsol venti → motor hidegen fut
		spec.motorFan.enableTemperature = 55
		spec.motorFan.disableTemperature = 30
	elseif fault == "restrictedFlow" then
		if dirt > 20 then
			local extra = 20 * (dirt / 100) -- max +20°C
			spec.motorFan.enableTemperature = self.spec_motorized.motorFan.defaultEnableTemp + extra
			spec.motorFan.disableTemperature = self.spec_motorized.motorFan.defaultDisableTemp + extra
		else
			spec.motorFan.enableTemperature = self.spec_motorized.motorFan.defaultEnableTemp
			spec.motorFan.disableTemperature = self.spec_motorized.motorFan.defaultDisableTemp
		end
	else
		-- Normál működés + kosz hatás
		if dirt > 20 then
			local extra = 20 * (dirt / 100) -- max +20°C
			spec.motorFan.enableTemperature = self.spec_motorized.motorFan.defaultEnableTemp + extra
			spec.motorFan.disableTemperature = self.spec_motorized.motorFan.defaultDisableTemp + extra
		else
			spec.motorFan.enableTemperature = self.spec_motorized.motorFan.defaultEnableTemp
			spec.motorFan.disableTemperature = self.spec_motorized.motorFan.defaultDisableTemp
		end
	end

	if spec.motorFan.enabled and spec.motorTemperature.value < spec.motorFan.disableTemperature then
		spec.motorFan.enabled = false
	end

    -- Cooling phase: Additional cooling by fan if enabled
    if spec.motorFan.enabled then
        local fanCoolingRate = spec.motorFan.coolingPerMS * gameDt * coolingPenalty
        spec.motorTemperature.value = math.max(spec.motorTemperature.valueMin, spec.motorTemperature.value - fanCoolingRate)
    end
end

function rvbMotorized.getCanMotorRun(self, superFunc)
    local rvb = self.spec_faultData
    if rvb == nil or not rvb.isrvbSpecEnabled then
        return superFunc(self)
    end
    local enginePercent = (rvb.parts[ENGINE].operatingHours * 100) / rvb.parts[ENGINE].tmp_lifetime
    local batteryFault = self:getIsFaultBattery()
    local batteryOkay = rvb.batteryCHActive == false and batteryFault >= BATTERY_LEVEL.MOTOR
    local partGlowplug = rvb.parts[GLOWPLUG]
    local shortCircuit = (partGlowplug.fault ~= "empty" and partGlowplug.fault == "shortCircuit")
	local partSelfstarter = rvb.parts[SELFSTARTER]
	
	local pf = partSelfstarter.prefault
	local f = partSelfstarter.fault
	local faultSelfstarter = (
		(pf ~= "empty" and pf == "noEngineCrank") or
		(f ~= "empty" and (f == "noEngineCrank" or f == "starterClickOnly"))
	)

    -- ha már jár a motor, ne állítsa le glowplug miatt
    if self:getMotorState() == MotorState.ON and shortCircuit then
        return true
    end
	--and batteryOkay
    if enginePercent < 99 and not rvb.battery[1] and not rvb.service[1] and not rvb.repair[1] and not rvb.inspection[1]
	 and not shortCircuit and not faultSelfstarter then
        return superFunc(self)
    end
    return false
end

function rvbMotorized.getMotorNotAllowedWarning(self, superFunc, ...)
    local rvb = self.spec_faultData

    -- Ha nincs RVB spec → eredeti logika
    if rvb == nil or not rvb.isrvbSpecEnabled then
        return superFunc(self, ...)
    end

    -- Generator hiba
    if self:getIsFaultGenerator() and not rvb.repair[1] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_GENERATOR
    end

    -- Motor elhasználtság
    local engine_percent = (rvb.parts[ENGINE].operatingHours * 100) / rvb.parts[ENGINE].tmp_lifetime
    if engine_percent >= 99 and not rvb.repair[1] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE
    end

    -- Inspection
    if rvb.inspection[1] and not rvb.inspection[2] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_INSPECTION
    end
    if rvb.inspection[1] and rvb.inspection[2] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_SUSPENSION
    end

    -- Repair
    if rvb.repair[1] and not rvb.repair[2] and rvb.inspection[8] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_REPAIR
    end
    if rvb.repair[1] and rvb.repair[2] and rvb.inspection[8] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_SUSPENSION
    end

    -- Service
    if rvb.service[1] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_SERVICE
    end
    if rvb.service[1] and rvb.service[2] then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_SUSPENSION
    end

    -- Battery
    local batteryFault = self:getIsFaultBattery()
    if batteryFault >= 0.03 and batteryFault < 0.10 then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_BATTERY
    end
    if rvb.batteryCHActive then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_BATTERY
    end

    -- Glowplug
    local partGlowplug = rvb.parts[GLOWPLUG]
    local shortCircuit = (partGlowplug.fault ~= "empty" and partGlowplug.fault)
    if shortCircuit == "shortCircuit" then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_GLOWPLUG
    end
	
	local partSelfstarter = rvb.parts[SELFSTARTER]
    local partFault = (partSelfstarter.fault ~= "empty" and partSelfstarter.fault)
    if partFault == "noEngineCrank" or partFault == "starterClickOnly" then
        return g_i18n.modEnvironments[g_vehicleBreakdownsModName].texts.VehicleBreakdown_DEAD_ENGINE_GLOWPLUG
    end

    return superFunc(self, ...)
end

function rvbMotorized.getIsActiveForWipers(self, superFunc)
	local rvb = self.spec_faultData
	if rvb ~= nil and rvb.isrvbSpecEnabled then
		if self:getIsFaultWipers() and self:getMotorState() == MotorState.ON then
			return false
		end
	end
    return superFunc(self)
end

function rvbMotorized.updateConsumers(self, superFunc, p375, p376)
	local v377 = self.spec_motorized
	local v378 = (v377.motor.lastMotorRpm - v377.motor.minRpm) / (v377.motor.maxRpm - v377.motor.minRpm)
	local v379 = 0.5 + v378 * 0.5
	local v380 = v377.smoothedLoadPercentage * v378
	local v381 = math.max(v380, 0)
	local v382 = 0.5 * (0.2 * v379 + 1.8 * v381)
	local v383 = g_currentMission.missionInfo
	local v384 = v383.fuelUsage
	
	--local v385 = v384 == 1 and 1 or (v384 == 3 and 2.5 or 1.5)
	
	local rvb = self.spec_faultData

    local v385 = 1.5 -- medium
	if rvb.parts[THERMOSTAT].damaged or rvb.parts[THERMOSTAT].repairreq or self:getIsFaultGlowPlug() then
		v385 = 2.4 -- 160%
	end
    if v384 == 1 then
        v385 = 1.0 -- low
		if rvb.parts[THERMOSTAT].damaged or rvb.parts[THERMOSTAT].repairreq or self:getIsFaultGlowPlug() then
			v385 = 1.6
		end
    elseif v384 == 3 then
        v385 = 2.5 -- high
		if rvb.parts[THERMOSTAT].damaged or rvb.parts[THERMOSTAT].repairreq or self:getIsFaultGlowPlug() then
			v385 = 4.0
		end
    end
	
	
	local v386 = self:getVehicleDamage()
	if v386 > 0 then
		v385 = v385 * (1 + v386 * Motorized.DAMAGED_USAGE_INCREASE)
	end
	for _, v387 in pairs(v377.consumers) do

		if v387.permanentConsumption and v387.usage > 0 then

			local gameDt = p375
			local v388 = v385 * v382 * v387.usage * gameDt
			local oneGameMinute = 1000 * 60 * 60
			if v388 ~= 0 then
				v387.fillLevelToChange = v387.fillLevelToChange + v388
				local v389 = v387.fillLevelToChange
				if math.abs(v389) > 1 then
					v388 = v387.fillLevelToChange
					v387.fillLevelToChange = 0 
					local v390 = self:getFillUnitLastValidFillType(v387.fillUnitIndex)
					g_farmManager:updateFarmStats(self:getOwnerFarmId(), "fuelUsage", v388)
					if self:getIsAIActive() and (v390 == FillType.DIESEL or v390 == FillType.DEF) and v383.helperBuyFuel then
						if v390 == FillType.DIESEL then
							local v391 = v388 * g_currentMission.economyManager:getCostPerLiter(v390) * 1.5
							g_farmManager:updateFarmStats(self:getOwnerFarmId(), "expenses", v391)
							g_currentMission:addMoney(-v391, self:getOwnerFarmId(), MoneyType.PURCHASE_FUEL, true)
							v388 = 0
						else
							v388 = 0
						end
					end
					if v390 == v387.fillType then
						self:addFillUnitFillLevel(self:getOwnerFarmId(), v387.fillUnitIndex, -v388, v390, ToolType.UNDEFINED)
					end
				end
				if v387.fillType == FillType.DIESEL or (v387.fillType == FillType.BATTERYCHARGE or v387.fillType == FillType.ELECTRICCHARGE or v387.fillType == FillType.METHANE) then
					--v377.lastFuelUsage = v388 / p375 * 1000 * 60 * 60
					v377.lastFuelUsage = v388 / gameDt * oneGameMinute
					--print("v387.fillType "..v387.fillType.." v377.lastFuelUsage "..v377.lastFuelUsage)
					v377.lastDieselFuelUsage = v388 / gameDt * oneGameMinute
					--print("v377.lastDieselFuelUsage "..v377.lastDieselFuelUsage)
				elseif v387.fillType == FillType.DEF then
					--v377.lastDefUsage = v388 / p375 * 1000 * 60 * 60
					v377.lastFuelUsage = v388 / gameDt * oneGameMinute
				end
			end
		end
	end
	if v377.consumersByFillTypeName.AIR ~= nil then
		local v392 = v377.consumersByFillTypeName.AIR
		if self:getFillUnitLastValidFillType(v392.fillUnitIndex) == v392.fillType then
			local v393 = 0
			local v394 = self.movingDirection * self:getReverserDirection()
			local v395
			if v394 > 0 then
				v395 = p376 < 0
			else
				v395 = false
			end
			local v396
			if v394 < 0 then
				v396 = p376 > 0
			else
				v396 = false
			end
			local v397
			if self:getLastSpeed() > 1 then
				v397 = v395 or v396
			else
				v397 = false
			end
			if v397 then
				local v398 = math.abs(p376) * p375 * self:getAirConsumerUsage() / 1000
				self:addFillUnitFillLevel(self:getOwnerFarmId(), v392.fillUnitIndex, -v398, v392.fillType, ToolType.UNDEFINED)
				v393 = v398 / p375 * 1000
			end
			local v399 = self:getFillUnitFillLevelPercentage(v392.fillUnitIndex)
			if v399 < v392.refillCapacityPercentage then
				v392.doRefill = true
			elseif v399 == 1 then
				v392.doRefill = false
			end
			if v392.doRefill then
				local v400 = v392.refillLitersPerSecond / 1000 * p375
				self:addFillUnitFillLevel(self:getOwnerFarmId(), v392.fillUnitIndex, v400, v392.fillType, ToolType.UNDEFINED)
				v393 = -v400 / p375 * 1000
			end
			v377.lastAirUsage = v393
		end
	end
end


function rvbMotorized.onUpdateTick(self, superFunc, p147, _, p148, _)
	local p146 = self
	local v149 = p146.spec_motorized
	local v150 = g_currentMission.missionInfo.automaticMotorStartEnabled
	if p146.isServer then
		if not v150 then
			local v151 = p146:getMotorState()
			if (v151 == MotorState.STARTING or v151 == MotorState.ON) and not p146:getIsAIActive() then
				local v152
				if p146.getIsEntered == nil then
					v152 = false
				else
					v152 = p146:getIsEntered()
				end
				local v153
				if p146.getIsControlled == nil then
					v153 = false
				else
					v153 = p146:getIsControlled()
				end
				if not (v152 or v153) then
					local v154 = false
					for _, v155 in pairs(g_currentMission.playerSystem.players) do
						if v155.isControlled and calcDistanceFrom(p146.rootNode, v155.rootNode) < 250 then
							v154 = true
							break
						end
					end
					if not v154 then
						for _, v156 in pairs(g_currentMission.vehicleSystem.enterables) do
							if v156.spec_enterable ~= nil and (v156.spec_enterable.isControlled and calcDistanceFrom(p146.rootNode, v156.rootNode) < 250) then
								v154 = true
								break
							end
						end
					end
					if v154 then
						v149.motorStopTimer = v149.motorStopTimerDuration
					else
						v149.motorStopTimer = v149.motorStopTimer - p147
						if v149.motorStopTimer <= 0 then
							--Logging.info("[RVB] Override of the automatic engine shutdown function. The engine will not turn off if the player is not near the vehicle.")
							--p146:stopMotor()
						end
					end
				end
			end
		end
		local v157 = p146:getMotorState()
		if v157 == MotorState.STARTING or v157 == MotorState.ON then
			p146:updateMotorTemperature(p147)
		end
		if v150 then
			if v157 == MotorState.OFF or v157 == MotorState.IGNITION then
				if not g_ignitionLockManager:getIsAvailable() then
					if p146.getIsControlled ~= nil and (p146:getIsControlled() and p146:getCanMotorRun()) then
						p146:startMotor(true)
					end
					if p146:getRequiresPower() and p146:getCanMotorRun() then
						p146:startMotor(true)
					end
				end
			elseif p146.getIsControlled ~= nil and not p146:getIsControlled() then
				if p146:getStopMotorOnLeave() then
					v149.motorNotRequiredTimer = v149.motorNotRequiredTimer + p147
					if v149.motorNotRequiredTimer > 250 then
						p146:stopMotor(true)
					end
				end
				p146:raiseActive()
			end
		end
	end
	if p146.isClient then
		local v158 = p146:getMotorState()
		if v158 == MotorState.STARTING or v158 == MotorState.ON then
			local v159 = v149.motor:getEqualizedMotorRpm() / v149.motor:getMaxRpm()
			if v149.exhaustParticleSystems ~= nil then
				for _, v160 in pairs(v149.exhaustParticleSystems) do
					local v161 = MathUtil.lerp(v149.exhaustParticleSystems.minScale, v149.exhaustParticleSystems.maxScale, v159)
					ParticleUtil.setEmitCountScale(v149.exhaustParticleSystems, v161)
					ParticleUtil.setParticleLifespan(v160, v160.originalLifespan * v161)
				end
			end
			for _, v162 in ipairs(v149.exhaustFlaps) do
				local v163 = MathUtil.lerp(-0.1, 0.1, math.random()) + v159
				local v164 = math.clamp(v163, 0, 1) * v162.maxRot
				if v162.rotationAxis == 1 then
					setRotation(v162.node, v164, 0, 0)
				elseif v162.rotationAxis == 2 then
					setRotation(v162.node, 0, v164, 0)
				else
					setRotation(v162.node, 0, 0, v164)
				end
			end
			if v149.exhaustEffects ~= nil then
				for _, v165 in pairs(v149.exhaustEffects) do
					local v166, v167, v168 = localToWorld(v165.effectNode, 0, 0.5, 0)
					if v165.lastPosition == nil then
						v165.lastPosition = { v166, v167, v168 }
					end
					local v169 = (v166 - v165.lastPosition[1]) * 10
					local v170 = (v167 - v165.lastPosition[2]) * 10
					local v171 = (v168 - v165.lastPosition[3]) * 10
					local v172, v173, v174 = localToWorld(v165.effectNode, 0, 1, 0)
					local v175 = v172 - v169
					local v176 = v173 - v170 + v165.upFactor
					local v177 = v174 - v171
					local v178, v179, v180 = worldToLocal(v165.effectNode, v175, v176, v177)
					local v181 = MathUtil.vector2Length(v178, v180)
					if v181 > 0 then
						v178, v180 = MathUtil.vector2Normalize(v178, v180)
					end
					local v182 = math.max(v179, 0.01)
					local v183 = math.abs(v182)
					local v184 = v181 / v183
					local v185 = math.atan(v184) * (1.2 + 2 * v183)
					local v186 = v181 / v183
					local v187 = math.atan(v186) * (1.2 + 2 * v183)
					local v188 = v180 / v183
					local v189 = math.atan(v188) * v185
					local v190 = v178 / v183
					local v191 = -math.atan(v190) * v187
					v165.xRot = v165.xRot * 0.95 + v189 * 0.05
					v165.zRot = v165.zRot * 0.95 + v191 * 0.05
					local v192 = MathUtil.lerp(v165.minRpmScale, v165.maxRpmScale, v159)
					setShaderParameter(v165.effectNode, "param", v165.xRot, v165.zRot, 0, v192, false)
					local v193 = MathUtil.lerp(v165.minRpmColor[1], v165.maxRpmColor[1], v159)
					local v194 = MathUtil.lerp(v165.minRpmColor[2], v165.maxRpmColor[2], v159)
					local v195 = MathUtil.lerp(v165.minRpmColor[3], v165.maxRpmColor[3], v159)
					local v196 = MathUtil.lerp(v165.minRpmColor[4], v165.maxRpmColor[4], v159)
					setShaderParameter(v165.effectNode, "exhaustColor", v193, v194, v195, v196, false)
					v165.lastPosition[1] = v166
					v165.lastPosition[2] = v167
					v165.lastPosition[3] = v168
				end
			end
			v149.lastFuelUsageDisplayTime = v149.lastFuelUsageDisplayTime + p147
			if v149.lastFuelUsageDisplayTime > 250 then
				v149.lastFuelUsageDisplayTime = 0
				v149.lastFuelUsageDisplay = v149.fuelUsageBuffer:getAverage()
			end
			v149.fuelUsageBuffer:add(v149.lastFuelUsage)
		end
		if v149.clutchCrackingTimeOut < g_time then
			if g_soundManager:getIsSamplePlaying(v149.samples.clutchCracking) then
				g_soundManager:stopSample(v149.samples.clutchCracking)
			end
			if v149.clutchCrackingGearIndex ~= nil then
				p146:setGearLeversState(0, nil, 500)
			end
			if v149.clutchCrackingGroupIndex ~= nil then
				p146:setGearLeversState(nil, 0, 500)
			end
			v149.clutchCrackingTimeOut = (1 / 0)
		end
		if p148 then
			if v150 and not p146:getCanMotorRun() then
				local v197 = p146:getMotorNotAllowedWarning()
				if v197 ~= nil then
					g_currentMission:showBlinkingWarning(v197, 2000)
				end
			end
			if g_ignitionLockManager:getIsAvailable() and not p146:getIsAIActive() then
				local v198 = g_ignitionLockManager:getState()
				local v199 = p146:getMotorState()
				if v198 == IgnitionLockState.OFF then
					if v199 ~= MotorState.OFF then
						p146:setMotorState(MotorState.OFF)
					end
				elseif v198 == IgnitionLockState.IGNITION then
					if v199 == MotorState.OFF then
						p146:setMotorState(MotorState.IGNITION)
					end
				elseif v198 == IgnitionLockState.START and (v199 ~= MotorState.STARTING and v199 ~= MotorState.ON) then
					if p146:getCanMotorRun() then
						p146:setMotorState(MotorState.STARTING)
					else
						local v200 = p146:getMotorNotAllowedWarning()
						if v200 ~= nil then
							g_currentMission:showBlinkingWarning(v200, 2000)
						end
					end
				end
			end
			Motorized.updateActionEvents(p146)
		end
	end
end
Motorized.onUpdateTick = Utils.overwrittenFunction(Motorized.onUpdateTick, rvbMotorized.onUpdateTick)
