
source(g_vehicleBreakdownsDirectory .. "scripts/debug/RVBDebug.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/manager/PartManager.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/manager/GlowPlugManager.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/manager/SelfStarterManager.lua")

-- MANAGERS FOR PART FAULTS
source(g_vehicleBreakdownsDirectory .. "scripts/manager/ThermostatManager.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/manager/LightingsManager.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/manager/GeneratorManager.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/manager/EngineManager.lua")

source(g_vehicleBreakdownsDirectory .. "scripts/vehicles/rvbVehicle.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/vehicles/specializations/rvbMotorized.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/vehicles/specializations/rvbWearable.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/vehicles/specializations/rvbWorkshopScreen.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/placeables/specializations/rvbPlaceableChargingStation.lua")

source(g_vehicleBreakdownsDirectory .. "scripts/events/RVBserviceManual_Event.lua")
source(g_vehicleBreakdownsDirectory .. "scripts/events/WorkshopCount_Event.lua")

VehicleBreakdowns = {}




VehicleBreakdowns.FSSET_Daysperiod = 1
VehicleBreakdowns.GSET_Change_difficulty = 1

	
	-- ================================
	-- Helper függvény az egyes flag-ek frissítésére
	-- ================================
	local function updateFlag(self, key, isActive)
		local spec = self.spec_faultData
		-- Ellenőrizzük, hogy van-e aktív javítás/szerviz/inspection
		if not spec[key][1] then
			return false
		end
		-- Csak akkor frissítünk, ha változik az állapot
		if spec[key][2] ~= isActive then
			spec[key][2] = isActive
			--print("["..self:getFullName().."] "..key.." isActive: "..tostring(isActive))
			-- Küldés csak a szerver oldalon
			if self.isServer then
				if key == "service" then
					RVBService_Event.sendEvent(self, spec[key], {result=false, cost=0, text=""})
				elseif key == "inspection" then
					RVBInspection_Event.sendEvent(self, spec[key], {result=false, cost=0, text=""})
				elseif key == "repair" then
					RVBRepairEvent.sendEvent(self, spec[key], {result=false, cost=0, text=""})
				end
			end
			return true
		end
		return false
	end

	-- ================================
	-- Percenkénti update ciklus a járműnél
	-- ================================
	local function updateSuspensionState(self, workshopStatus)
		local spec = self.spec_faultData
		local isClosed = not workshopStatus  -- ha zárva a bolt

		-- Lista az összes RVB táblához
		local rvbTables = {"service", "inspection", "repair"}

		local anyChanged = false
		for _, key in ipairs(rvbTables) do
			-- csak aktív elemeket frissítünk
			if spec[key][1] then
				if updateFlag(self, key, isClosed) then
					anyChanged = true
				end
				--print("["..self:getFullName().."] "..key.." suspension: "..tostring(spec[key][2]))
			end
		end

		-- opcionális: log, ha bármelyik változott
		if anyChanged then
			--print("Workshop state updated for "..self:getFullName())
		end
	end
	
function VehicleBreakdowns.prerequisitesPresent(specializations)
	return true
end

local overwrittenFunctions = {
    { original = "updateMotorTemperature", replacement = rvbMotorized.updateMotorTemperature },
    { original = "getCanMotorRun", replacement = rvbMotorized.getCanMotorRun },
	{ original = "getMotorNotAllowedWarning", replacement = rvbMotorized.getMotorNotAllowedWarning },
	{ original = "startMotor", replacement = rvbMotorized.startMotor },
	{ original = "stopMotor", replacement = rvbMotorized.stopMotor },
	{ original = "updateConsumers", replacement = rvbMotorized.updateConsumers },
	{ original = "getIsActiveForWipers", replacement = rvbMotorized.getIsActiveForWipers },
	{ original = "getSpeedLimit", replacement = rvbVehicle.getSpeedLimit },
	{ original = "updateDamageAmount", replacement = rvbWearable.updateDamageAmount },
}
function VehicleBreakdowns.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "deactivateLights", VehicleBreakdowns.deactivateLights)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "setLightsTypesMask", VehicleBreakdowns.setLightsTypesMask)
	for _, func in pairs(overwrittenFunctions) do
        SpecializationUtil.registerOverwrittenFunction(vehicleType, func.original, func.replacement)
    end
end

function VehicleBreakdowns.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "saveToXMLFile", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdate", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onEnterVehicle", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onLeaveVehicle", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onReadStream", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onReadUpdateStream", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onWriteUpdateStream", VehicleBreakdowns)
	SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", VehicleBreakdowns)
	--SpecializationUtil.registerEventListener(vehicleType, "onRegisterDashboardValueTypes", VehicleBreakdowns)
end

function VehicleBreakdowns.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "getSpeed", VehicleBreakdowns.getSpeed)
	SpecializationUtil.registerFunction(vehicleType, "lightingsFault", VehicleBreakdowns.lightingsFault)
	--SpecializationUtil.registerFunction(vehicleType, "setBatteryDrain", VehicleBreakdowns.setBatteryDrain)
	SpecializationUtil.registerFunction(vehicleType, "onBatteryDrain", VehicleBreakdowns.onBatteryDrain)
	SpecializationUtil.registerFunction(vehicleType, "updateBatteryDrain", VehicleBreakdowns.updateBatteryDrain)
	--SpecializationUtil.registerFunction(vehicleType, "setBatteryDrainingIfGeneratorFailure", VehicleBreakdowns.setBatteryDrainingIfGeneratorFailure)
	SpecializationUtil.registerFunction(vehicleType, "setBatteryDrainingIfStartMotor", VehicleBreakdowns.setBatteryDrainingIfStartMotor)
	SpecializationUtil.registerFunction(vehicleType, "StopAI", VehicleBreakdowns.StopAI)
	SpecializationUtil.registerFunction(vehicleType, "DebugFaultPrint", VehicleBreakdowns.DebugFaultPrint)
	SpecializationUtil.registerFunction(vehicleType, "getFaultThermostat", VehicleBreakdowns.getFaultThermostat)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultThermostatoverHeating", VehicleBreakdowns.getIsFaultThermostatoverHeating)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultThermostatoverCooling", VehicleBreakdowns.getIsFaultThermostatoverCooling)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultLightings", VehicleBreakdowns.getIsFaultLightings)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultGlowPlug", VehicleBreakdowns.getIsFaultGlowPlug)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultWipers", VehicleBreakdowns.getIsFaultWipers)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultGenerator", VehicleBreakdowns.getIsFaultGenerator)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultEngine", VehicleBreakdowns.getIsFaultEngine)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultSelfStarter", VehicleBreakdowns.getIsFaultSelfStarter)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultBattery", VehicleBreakdowns.getIsFaultBattery)
	SpecializationUtil.registerFunction(vehicleType, "setIsFaultBattery", VehicleBreakdowns.setIsFaultBattery)
	SpecializationUtil.registerFunction(vehicleType, "getIsFaultOperatingHours", VehicleBreakdowns.getIsFaultOperatingHours)
	
	SpecializationUtil.registerFunction(vehicleType, "getThermostatPercentage", VehicleBreakdowns.getThermostatPercentage)
	SpecializationUtil.registerFunction(vehicleType, "getPartsPercentage", VehicleBreakdowns.getPartsPercentage)
	SpecializationUtil.registerFunction(vehicleType, "getFaultParts", VehicleBreakdowns.getFaultParts)
	
	SpecializationUtil.registerFunction(vehicleType, "getIsOperatingHoursTemp", VehicleBreakdowns.getIsOperatingHoursTemp)
	SpecializationUtil.registerFunction(vehicleType, "getIsRepair", VehicleBreakdowns.getIsRepair)
	SpecializationUtil.registerFunction(vehicleType, "getIsInspection", VehicleBreakdowns.getIsInspection)
	SpecializationUtil.registerFunction(vehicleType, "getIsService", VehicleBreakdowns.getIsService)
	--SpecializationUtil.registerFunction(vehicleType, "setIsService", VehicleBreakdowns.setIsService)
	SpecializationUtil.registerFunction(vehicleType, "getIsDailyService", VehicleBreakdowns.getIsDailyService)
	--SpecializationUtil.registerFunction(vehicleType, "setIsDailyService", VehicleBreakdowns.setIsDailyService)
	SpecializationUtil.registerFunction(vehicleType, "getIsPeriodicServiceTime", VehicleBreakdowns.getIsPeriodicServiceTime)
	SpecializationUtil.registerFunction(vehicleType, "setIsPeriodicServiceTime", VehicleBreakdowns.setIsPeriodicServiceTime)
	SpecializationUtil.registerFunction(vehicleType, "getIsRepairStartService", VehicleBreakdowns.getIsRepairStartService)
	SpecializationUtil.registerFunction(vehicleType, "getIsRepairClockService", VehicleBreakdowns.getIsRepairClockService)
	SpecializationUtil.registerFunction(vehicleType, "getIsRepairTimeService", VehicleBreakdowns.getIsRepairTimeService)
	SpecializationUtil.registerFunction(vehicleType, "getIsRepairTimePassedService", VehicleBreakdowns.getIsRepairTimePassedService)
	SpecializationUtil.registerFunction(vehicleType, "getIsRepairScaleService", VehicleBreakdowns.getIsRepairScaleService)

	SpecializationUtil.registerFunction(vehicleType, "CalculateFinishTime", VehicleBreakdowns.CalculateFinishTime)
	SpecializationUtil.registerFunction(vehicleType, "calculateCost", VehicleBreakdowns.calculateCost)
	SpecializationUtil.registerFunction(vehicleType, "getRepairPrice_RVBClone", VehicleBreakdowns.getRepairPrice_RVBClone)
	SpecializationUtil.registerFunction(vehicleType, "getServicePrice", VehicleBreakdowns.getServicePrice)
	SpecializationUtil.registerFunction(vehicleType, "getInspectionPrice", VehicleBreakdowns.getInspectionPrice)
	SpecializationUtil.registerFunction(vehicleType, "getSellPrice_RVBClone", VehicleBreakdowns.getSellPrice_RVBClone)
	SpecializationUtil.registerFunction(vehicleType, "onStartOperatingHours", VehicleBreakdowns.onStartOperatingHours)
	SpecializationUtil.registerFunction(vehicleType, "updateOperatingHours", VehicleBreakdowns.updateOperatingHours)
	
	SpecializationUtil.registerFunction(vehicleType, "onStartLightingsOperatingHours", VehicleBreakdowns.onStartLightingsOperatingHours)
	SpecializationUtil.registerFunction(vehicleType, "updateLightingOperatingHours", VehicleBreakdowns.updateLightingOperatingHours)
	
	SpecializationUtil.registerFunction(vehicleType, "minuteChanged", VehicleBreakdowns.minuteChanged)
	SpecializationUtil.registerFunction(vehicleType, "RVBhourChanged", VehicleBreakdowns.RVBhourChanged)
	--SpecializationUtil.registerFunction(vehicleType, "setBatteryCharging", VehicleBreakdowns.setBatteryCharging)
	--SpecializationUtil.registerFunction(vehicleType, "setGeneratorBatteryCharging", VehicleBreakdowns.setGeneratorBatteryCharging)
	--SpecializationUtil.registerFunction(vehicleType, "chargeBatteryFromGenerator", VehicleBreakdowns.chargeBatteryFromGenerator)
	--SpecializationUtil.registerFunction(vehicleType, "setVehicleInspection", VehicleBreakdowns.setVehicleInspection)

	SpecializationUtil.registerFunction(vehicleType, "updateRepair", VehicleBreakdowns.updateRepair)
	--SpecializationUtil.registerFunction(vehicleType, "setVehicleRepairDisplayMessage", VehicleBreakdowns.setVehicleRepairDisplayMessage)
	--SpecializationUtil.registerFunction(vehicleType, "setVehicleService", VehicleBreakdowns.setVehicleService)

	SpecializationUtil.registerFunction(vehicleType, "updateService", VehicleBreakdowns.updateService)
	
	SpecializationUtil.registerFunction(vehicleType, "updateInspection", VehicleBreakdowns.updateInspection)

	--SpecializationUtil.registerFunction(vehicleType, "setWiperOperatingHours", VehicleBreakdowns.setWiperOperatingHours)
	SpecializationUtil.registerFunction(vehicleType, "onStartWiperOperatingHours", VehicleBreakdowns.onStartWiperOperatingHours)
	SpecializationUtil.registerFunction(vehicleType, "updateWiperOperatingHours", VehicleBreakdowns.updateWiperOperatingHours)

	SpecializationUtil.registerFunction(vehicleType, "displayMessage", VehicleBreakdowns.displayMessage)
	SpecializationUtil.registerFunction(vehicleType, "getIsRVBMotorStarted", VehicleBreakdowns.getIsRVBMotorStarted)
	--SpecializationUtil.registerFunction(vehicleType, "RVBaddRemoveMoney", VehicleBreakdowns.RVBaddRemoveMoney)
	SpecializationUtil.registerFunction(vehicleType, "getBatteryChPrice", VehicleBreakdowns.getBatteryChPrice)
	SpecializationUtil.registerFunction(vehicleType, "calculateBatteryChPrice", VehicleBreakdowns.calculateBatteryChPrice)

	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVB", VehicleBreakdowns.SyncClientServer_RVB)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBFaultStorage", VehicleBreakdowns.SyncClientServer_RVBFaultStorage)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBService", VehicleBreakdowns.SyncClientServer_RVBService)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBRepair", VehicleBreakdowns.SyncClientServer_RVBRepair)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBInspection", VehicleBreakdowns.SyncClientServer_RVBInspection)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBBattery", VehicleBreakdowns.SyncClientServer_RVBBattery)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBParts", VehicleBreakdowns.SyncClientServer_RVBParts)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_BatteryChargeLevel", VehicleBreakdowns.SyncClientServer_BatteryChargeLevel)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_Other", VehicleBreakdowns.SyncClientServer_Other)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_RVBStartService", VehicleBreakdowns.SyncClientServer_RVBStartService)
	
	SpecializationUtil.registerFunction(vehicleType, "getBatteryFillUnitIndex", VehicleBreakdowns.getBatteryFillUnitIndex)
	
	SpecializationUtil.registerFunction(vehicleType, "batteryChargeVehicle", VehicleBreakdowns.batteryChargeVehicle)
	SpecializationUtil.registerFunction(vehicleType, "setRVBLightsStrings", VehicleBreakdowns.setRVBLightsStrings)
	--SpecializationUtil.registerFunction(vehicleType, "setRVBLightsTypesMask", VehicleBreakdowns.setRVBLightsTypesMask)
	--SpecializationUtil.registerFunction(vehicleType, "rvbVehicleSetLifetime", VehicleBreakdowns.rvbVehicleSetLifetime)

	SpecializationUtil.registerFunction(vehicleType, "onSetPartsLifetime", VehicleBreakdowns.onSetPartsLifetime)
	SpecializationUtil.registerFunction(vehicleType, "updatePartsBreakdowns", VehicleBreakdowns.updatePartsBreakdowns)
	SpecializationUtil.registerFunction(vehicleType, "updatePartsIgnitionBreakdowns", VehicleBreakdowns.updatePartsIgnitionBreakdowns)
	--SpecializationUtil.registerFunction(vehicleType, "checkGlowPlugFault", VehicleBreakdowns.checkGlowPlugFault)
	SpecializationUtil.registerFunction(vehicleType, "updatePartsNoBreakdowns", VehicleBreakdowns.updatePartsNoBreakdowns)
	SpecializationUtil.registerFunction(vehicleType, "RVBresetVehicle", VehicleBreakdowns.RVBresetVehicle)
	SpecializationUtil.registerFunction(vehicleType, "setPartsRepairreq", VehicleBreakdowns.setPartsRepairreq)
	
	SpecializationUtil.registerFunction(vehicleType, "updateTireDeformation", VehicleBreakdowns.updateTireDeformation)
	SpecializationUtil.registerFunction(vehicleType, "adjustSteeringAngle", VehicleBreakdowns.adjustSteeringAngle)
	

	SpecializationUtil.registerFunction(vehicleType, "setInflationPressure", VehicleBreakdowns.setInflationPressure)

	SpecializationUtil.registerFunction(vehicleType, "chargeBatteryViaJumpStart", VehicleBreakdowns.chargeBatteryViaJumpStart)
--	SpecializationUtil.registerFunction(vehicleType, "setRVBJumpStarting", VehicleBreakdowns.setRVBJumpStarting)
	SpecializationUtil.registerFunction(vehicleType, "setRVBJumpchargerate", VehicleBreakdowns.setRVBJumpchargerate)
	

	
	SpecializationUtil.registerFunction(vehicleType, "FillUnitloadFillUnitFromXML", VehicleBreakdowns.FillUnitloadFillUnitFromXML)
	
	SpecializationUtil.registerFunction(vehicleType, "onSleepingStateChanged", VehicleBreakdowns.onSleepingStateChanged)

	
	--SpecializationUtil.registerFunction(vehicleType, "addServiceManualEntry", VehicleBreakdowns.addServiceManualEntry)
	SpecializationUtil.registerFunction(vehicleType, "getServiceManualEntry", VehicleBreakdowns.getServiceManualEntry)
	SpecializationUtil.registerFunction(vehicleType, "SyncClientServer_serviceManual", VehicleBreakdowns.SyncClientServer_serviceManual)
	
	SpecializationUtil.registerFunction(vehicleType, "updateEngineTorque", VehicleBreakdowns.updateEngineTorque)
	SpecializationUtil.registerFunction(vehicleType, "updateExhaustEffect", VehicleBreakdowns.updateExhaustEffect)
	SpecializationUtil.registerFunction(vehicleType, "updateOverheatingFailure", VehicleBreakdowns.updateOverheatingFailure)
	
	SpecializationUtil.registerFunction(vehicleType, "addBreakdown", VehicleBreakdowns.addBreakdown)
	
	SpecializationUtil.registerFunction(vehicleType, "onUpdatejumperCable", VehicleBreakdowns.onUpdatejumperCable)
	
	SpecializationUtil.registerFunction(vehicleType, "onWorkshopStateChanged", VehicleBreakdowns.onWorkshopStateChanged)
	
	SpecializationUtil.registerFunction(vehicleType, "updateMotorRetries", VehicleBreakdowns.updateMotorRetries)
	SpecializationUtil.registerFunction(vehicleType, "startMotorWithRetriesAsync", VehicleBreakdowns.startMotorWithRetriesAsync)
	
	SpecializationUtil.registerFunction(vehicleType, "ignitionMotor", VehicleBreakdowns.ignitionMotor)
	SpecializationUtil.registerFunction(vehicleType, "onSetDifficulty", VehicleBreakdowns.onSetDifficulty)
	SpecializationUtil.registerFunction(vehicleType, "onSetPlannedDaysPerPeriod", VehicleBreakdowns.onSetPlannedDaysPerPeriod)
	
    SpecializationUtil.registerFunction(vehicleType, "onRVBVehicleReset", VehicleBreakdowns.onRVBVehicleReset)
    
end

function VehicleBreakdowns.initSpecialization()

	-- vehicle schema
	local schema = Vehicle.xmlSchema

    schema:setXMLSpecializationType("VehicleBreakdowns")

	-- savegame schema
	local schemaSavegame = Vehicle.xmlSchemaSavegame

	local rvbSavegameKey = string.format("vehicles.vehicle(?).%s.vehicleBreakdowns", g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.BOOL, rvbSavegameKey .. "#isrvbSpecEnabled", "RVB is enabled")
	schemaSavegame:register(XMLValueType.INT, rvbSavegameKey .. "#timeScale", "Idő skála")
	schemaSavegame:register(XMLValueType.FLOAT, rvbSavegameKey .. "#operatingHoursTemp", "Ideiglenes üzemóra")
	schemaSavegame:register(XMLValueType.FLOAT, rvbSavegameKey .. "#TotaloperatingHours", "Összes üzemóra")

	schemaSavegame:register(XMLValueType.FLOAT, rvbSavegameKey .. "#operatingHours", "futott üzemóra")
	schemaSavegame:register(XMLValueType.FLOAT, rvbSavegameKey .. "#chargelevel", "Akkumulátor tölttötségi szint")

	local parts = ("vehicles.vehicle(?).%s.vehicleBreakdowns.parts"):format(g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.STRING, parts .. ".part(?)#name", "")
	schemaSavegame:register(XMLValueType.INT, parts .. ".part(?)#lifetime", "")
	schemaSavegame:register(XMLValueType.FLOAT, parts .. ".part(?)#operatingHours", "Kár")
	schemaSavegame:register(XMLValueType.BOOL, parts .. ".part(?)#repairreq", "Repair is required")
	schemaSavegame:register(XMLValueType.STRING, parts .. ".part(?)#prefault", "Elő hiba")
	schemaSavegame:register(XMLValueType.STRING, parts .. ".part(?)#fault", "Hiba")
	schemaSavegame:register(XMLValueType.FLOAT, parts .. ".part(?)#cost", "Javítási költség")

	local serviceSavegameKey = string.format("vehicles.vehicle(?).%s.vehicleBreakdowns.vehicleService", g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.BOOL, serviceSavegameKey .. "#state", "Service in progress")
	schemaSavegame:register(XMLValueType.BOOL, serviceSavegameKey .. "#suspension", "Munka szüneteltetés")
	schemaSavegame:register(XMLValueType.INT, serviceSavegameKey .. "#finishday", "")
	schemaSavegame:register(XMLValueType.INT, serviceSavegameKey .. "#finishhour", "")
	schemaSavegame:register(XMLValueType.INT, serviceSavegameKey .. "#finishminute", "")
	schemaSavegame:register(XMLValueType.FLOAT, serviceSavegameKey .. "#amount", "Megadott időközönként ennyivel nőveli a javítási értéket v mi")
	schemaSavegame:register(XMLValueType.FLOAT, serviceSavegameKey .. "#cost", "Javítási költség")
	schemaSavegame:register(XMLValueType.INT, serviceSavegameKey .. "#damage", "Kár")

	local repairSavegameKey = string.format("vehicles.vehicle(?).%s.vehicleBreakdowns.vehicleRepair", g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.BOOL, repairSavegameKey .. "#state", "Repair in progress")
	schemaSavegame:register(XMLValueType.BOOL, repairSavegameKey .. "#suspension", "Munka szüneteltetés")
	schemaSavegame:register(XMLValueType.INT, repairSavegameKey .. "#finishday", "")
	schemaSavegame:register(XMLValueType.INT, repairSavegameKey .. "#finishhour", "")
	schemaSavegame:register(XMLValueType.INT, repairSavegameKey .. "#finishminute", "")
	schemaSavegame:register(XMLValueType.FLOAT, repairSavegameKey .. "#amount", "Megadott időközönként ennyivel nőveli a javítási értéket v mi")
	schemaSavegame:register(XMLValueType.FLOAT, repairSavegameKey .. "#cost", "Javítási költség")
	schemaSavegame:register(XMLValueType.FLOAT, repairSavegameKey .. "#damage", "Kár")
	schemaSavegame:register(XMLValueType.FLOAT, repairSavegameKey .. "#factor", "")
	schemaSavegame:register(XMLValueType.BOOL, repairSavegameKey .. "#inspection", "")

	local inspectionSavegameKey = string.format("vehicles.vehicle(?).%s.vehicleBreakdowns.vehicleInspection", g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.BOOL, inspectionSavegameKey .. "#state", "Inspection in progress")
	schemaSavegame:register(XMLValueType.BOOL, inspectionSavegameKey .. "#suspension", "Munka szüneteltetés")
	schemaSavegame:register(XMLValueType.INT, inspectionSavegameKey .. "#finishday", "")
	schemaSavegame:register(XMLValueType.INT, inspectionSavegameKey .. "#finishhour", "")
	schemaSavegame:register(XMLValueType.INT, inspectionSavegameKey .. "#finishminute", "")
	schemaSavegame:register(XMLValueType.FLOAT, inspectionSavegameKey .. "#cost", "Javítási költség")
	schemaSavegame:register(XMLValueType.FLOAT, inspectionSavegameKey .. "#factor", "")
	schemaSavegame:register(XMLValueType.BOOL, inspectionSavegameKey .. "#inspection", "")

	local batterySavegameKey = string.format("vehicles.vehicle(?).%s.vehicleBreakdowns.vehicleBattery", g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.BOOL, batterySavegameKey .. "#state", "Töltés elkezdve")
	schemaSavegame:register(XMLValueType.BOOL, batterySavegameKey .. "#suspension", "Munka szüneteltetés")
	schemaSavegame:register(XMLValueType.INT, batterySavegameKey .. "#finishday", "")
	schemaSavegame:register(XMLValueType.INT, batterySavegameKey .. "#finishhour", "")
	schemaSavegame:register(XMLValueType.INT, batterySavegameKey .. "#finishminute", "")
	schemaSavegame:register(XMLValueType.FLOAT, batterySavegameKey .. "#amount", "Mennyit tölt")
	schemaSavegame:register(XMLValueType.FLOAT, batterySavegameKey .. "#cost", "Töltési költség")

	local serviceManual = ("vehicles.vehicle(?).%s.vehicleBreakdowns.serviceManual"):format(g_vehicleBreakdownsModName)
	schemaSavegame:register(XMLValueType.INT, serviceManual .. ".entry(?)#entryType", "")
	schemaSavegame:register(XMLValueType.INT, serviceManual .. ".entry(?)#entryTime", "")
	schemaSavegame:register(XMLValueType.FLOAT, serviceManual .. ".entry(?)#operatingHours", "")
	schemaSavegame:register(XMLValueType.FLOAT, serviceManual .. ".entry(?)#odometer", "")
	schemaSavegame:register(XMLValueType.STRING, serviceManual .. ".entry(?)#result", "empty")
	schemaSavegame:register(XMLValueType.FLOAT, serviceManual .. ".entry(?)#cost", "Javítási költség")
	
	schemaSavegame:setXMLSpecializationType()
end

function VehicleBreakdowns:onPreLoad(savegame)
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	--print("onPreLoad " .. self:getFullName() .. " " .. GSET.difficulty)
	--g_messageCenter:publish(MessageType.SET_DIFFICULTY, GSET.difficulty)
	--print("onPreLoad END")
end


function VehicleBreakdowns:onLoad(savegame)

	if self.spec_faultData == nil then
		self.spec_faultData = {}
	end
	
	local spec = self.spec_faultData

	spec.dirtyFlag = self:getNextDirtyFlag()
	spec.motorizedDirtyFlag = self:getNextDirtyFlag()
	spec.rvbdirtyFlag = self:getNextDirtyFlag()
	spec.serviceDirtyFlag    = self:getNextDirtyFlag()
	spec.repairDirtyFlag     = self:getNextDirtyFlag()
	spec.inspectionDirtyFlag = self:getNextDirtyFlag()
	spec.partsDirtyFlag      = self:getNextDirtyFlag()
	spec.lifetimeDirtyFlag   = self:getNextDirtyFlag()

	
	self.rvbDebugger = g_currentMission.vehicleBreakdowns.rvbDebugger
	
	spec.isrvbSpecEnabled = true

	spec.messageCenter = g_messageCenter	
	
	
	spec.randoms = { 0, 0 }
	
	spec.rvb = { 5, 0, 0, 0, 0 }

	spec.service = { false, false, 0, 0, 0, 0, 0, 0 }
	spec.repair = { false, false, 0, 0, 0, 0, 0, 0, 0, false }
	spec.inspection = { false, false, 0, 0, 0, 0, 0, false }
	
	spec.serviceManual = {}

	spec.preCalculatedRepair = {}
    spec.preCalculatedRepair.day = 0
    spec.preCalculatedRepair.hour = 0
    spec.preCalculatedRepair.minute = 0
    spec.preCalculatedRepair.fault = 0
    spec.preCalculatedRepair.faultTime = 0
	
	
	spec.battery = {}
	spec.battery.drainTimer = 0
	
	spec.rvbupdateTimer = {
		battery = 0,
		repair = 0,
		motorRun = 0
	}

	
    
    
    spec.parts = {}
    if self.isServer then
        PartManager.loadPartsFromXML(self, savegame)
        self:raiseDirtyFlags(spec.partsDirtyFlag)
    else
        -- kliens oldalon default inicializálás, hogy ne legyen nil
        for _, partKey in ipairs(g_vehicleBreakdownsPartKeys) do
            spec.parts[partKey] = PartManager.PartsDefaults({name = partKey})
        end
    end


    
spec.message = nil

	spec.partsToChange = 0
	spec.serviceToChange = 0
	spec.jumpstartToChange = 0
	
	spec.runtimeToChange = 0
	spec.serviceRuntimeToChange = 0
	spec.thermostatoverHeatingRuntimeToChange = 0
	spec.glowplugRuntimeToChange = 0
	spec.wiperRuntimeToChange = 0
	spec.lightingsRuntimeToChange = 0


	spec.partfoot = 0
	spec.rvblightsTypesMask = 0
	

	spec.LightingUpdateTimer = 0
	spec.OperatingHoursUpdateTimer = 0
	spec.isRVBMotorStarted = false
	spec.rvbmotorStartTime = 0
	spec.rvbMotorStart = false
	
	
	
	spec.motorTries = 0
	spec.ignition = 0
	spec.engineStarts = false
	spec.engineStartStop = false
	spec.faultType = 0
	spec.firstStart = true

	-- load sound effects
	if g_dedicatedServerInfo == nil then
		local file, id
		VehicleBreakdowns.sounds = {}
		for _, id in ipairs({"self_starter", "battery"}) do
			VehicleBreakdowns.sounds[id] = createSample(id)
			file = g_currentMission.vehicleBreakdowns.modDirectory.."sounds/"..id..".ogg"
			loadSample(VehicleBreakdowns.sounds[id], file, false)
		end
	end
	
	

	local xmlSoundFile = loadXMLFile("rvbsounds", g_currentMission.vehicleBreakdowns.modDirectory .. "sounds/rvbsounds.xml")
    if spec.samples == nil then
        spec.samples = {}
    end
    
    if xmlSoundFile ~= nil then
        spec.samples.dasalert = g_soundManager:loadSampleFromXML(xmlSoundFile, "sounds", "dasalert", g_currentMission.vehicleBreakdowns.modDirectory, self.rootNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.motormuting = g_soundManager:loadSampleFromXML(xmlSoundFile, "sounds", "motormuting", g_currentMission.vehicleBreakdowns.modDirectory, self.rootNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        --spec.samples.self_starter = g_soundManager:loadSampleFromXML(xmlSoundFile, "sounds", "self_starter", g_currentMission.vehicleBreakdowns.modDirectory, self.rootNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        spec.samples.battery = g_soundManager:loadSampleFromXML(xmlSoundFile, "sounds", "battery", g_currentMission.vehicleBreakdowns.modDirectory, self.rootNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
        self.spec_motorized.samples.motorStop = g_soundManager:loadSampleFromXML(xmlSoundFile, "sounds", "motorStop", g_currentMission.vehicleBreakdowns.modDirectory, self.rootNode, 1, AudioGroup.VEHICLE, self.i3dMappings, self)
		delete(xmlSoundFile)
    else
        log_dbg("ERROR: g_currentMission.vehicleBreakdowns - Could not load rvbsounds.xml")
    end


	self.tireDeformationTimer = 0
	self.tireDeformationTimer2 = 0
	
	spec.inflationPressure = VehicleBreakdowns.TIRE_PRESSURE_NORMAL
    spec.inflationPressureTarget = VehicleBreakdowns.TIRE_PRESSURE_LOW 
	spec.pressureMax = VehicleBreakdowns.TIRE_PRESSURE_MAX
    spec.pressureMin = VehicleBreakdowns.TIRE_PRESSURE_MIN
	
	self.deformation = 0
	self.deformationDegrees = 0
	self.tmpdeformation = 0

	self.currentTemperaturDay = g_currentMission.environment.weather:getCurrentTemperature()
	self.currentTemperaturDay =  self.currentTemperaturDay - math.random(2,5)
	self.spec_motorized.motorTemperature.value = self.currentTemperaturDay
	self.spec_motorized.motorTemperature.valueMin = self.currentTemperaturDay
	--self.spec_motorized.motorFan.disableTemperature = 85
	self.spec_motorized.motorTemperature.valueMax = 122
	
	self.tireDeformation = false

	-- engine data
	spec.motorTemperature = self.currentTemperaturDay
	spec.fanEnabled = false
	spec.fanEnabledLast = false

	spec.fanEnableTemperature = 95
	spec.fanDisableTemperature = 85
	
	self.spec_motorized.motorFan.defaultEnableTemp = self.spec_motorized.motorFan.enableTemperature
	self.spec_motorized.motorFan.defaultDisableTemp = self.spec_motorized.motorFan.disableTemperature

	spec.lastFuelUsage = 0
	spec.lastDefUsage = 0
	spec.lastAirUsage = 0
	spec.lastDieselFuelUsage = 0
	self.spec_motorized.lastDieselFuelUsage = 0

	spec.DontStopMotor = {}
	spec.DontStopMotor.glowPlug	= false
	spec.DontStopMotor.self_starter	= false
	spec.RandomNumber = {}
	spec.RandomNumber.glowPlug = 0
	spec.TimesSoundPlayed = {}
	spec.TimesSoundPlayed.glowPlug = 2
	spec.TimesSoundPlayed.self_starter = 2
	spec.MotorTimer = {}
	spec.MotorTimer.glowPlug = -1
	spec.MotorTimer.self_starter = -1
	spec.NumberMotorTimer = {}
	spec.NumberMotorTimer.glowPlug = 0
	spec.NumberMotorTimer.self_starter = 0

	spec.DontStopMotor.battery	= false
	
	spec.updateTimer = 0
	
	spec.addDamage = {}
	spec.addDamage.alert = false
	spec.repairToChange = 0
	
	spec.ShortCircuitStop = false
	
	spec.alertMessage = {
		inspection = -1,
		service = -1,
		repair = -1
	}

	--g_messageCenter:subscribe(MessageType.MINUTE_CHANGED, self.minuteChanged, self)
	g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.RVBhourChanged, self)
--	g_messageCenter:subscribe(MessageType.RVB_START_REPAIR, self.onStartRepair, self)

	--g_messageCenter:subscribe(MessageType.RVB_START_INSPECTION, self.onStartInspection, self)
	--g_messageCenter:subscribe(MessageType.RVB_END_INSPECTION, self.onEndInspection, self)
	g_messageCenter:subscribe(MessageType.SET_PARTS_LIFETIME, self.onSetPartsLifetime, self)
	
	g_messageCenter:subscribe(MessageType.SLEEPING, self.onSleepingStateChanged, self)
	
	
	g_messageCenter:subscribe(MessageType.SET_WORKSHOP_STATE, self.onWorkshopStateChanged, self)
	
	--g_messageCenter:subscribe(MessageType.RVB_STARTMOTOR, self.rvb_startMotor, self)
	
	g_messageCenter:subscribe(MessageType.SET_DIFFICULTY, self.onSetDifficulty, self)
	g_messageCenter:subscribe(MessageType.SET_DAYSPERPERIOD, self.onSetPlannedDaysPerPeriod, self)
    

    --g_messageCenter:subscribe(ResetVehicleEvent, self.onRVBVehicleReset, self)

    g_messageCenter:subscribe(MessageType.RVB_VEHICLE_RESET, self.onRVBVehicleReset, self)
    



	--VehicleBreakdowns.FSSET_Daysperiod = g_currentMission.environment.plannedDaysPerPeriod
	--VehicleBreakdowns.GSET_Change_difficulty = g_currentMission.vehicleBreakdowns.generalSettings.difficulty
	
	if self.isClient then
		--VehicleBreakdowns.FSSET_Daysperiod = g_currentMission.environment.plannedDaysPerPeriod
		--VehicleBreakdowns.GSET_Change_difficulty = g_currentMission.vehicleBreakdowns.generalSettings.difficulty
		
	end
	--self:raiseDirtyFlags(spec.lifetimeDirtyFlag)
	if self.isServer then
		--VehicleBreakdowns.FSSET_Daysperiod = g_currentMission.environment.plannedDaysPerPeriod
		--VehicleBreakdowns.GSET_Change_difficulty = g_currentMission.vehicleBreakdowns.generalSettings.difficulty
		--self:raiseDirtyFlags(spec.lifetimeDirtyFlag)
	end

	
	local RVB = g_currentMission.vehicleBreakdowns
	--RVB:setRVBDifficulty(g_currentMission.vehicleBreakdowns.generalSettings.difficulty)
	
	
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings

	--g_messageCenter:publish(MessageType.SET_DIFFICULTY, GSET.difficulty)

	--self.speedLimit = 10
	
	
	spec.motorStart_updateDelta = 0
	spec.motorStart_updateRate = 600

	spec.lights_request_A = false
	spec.lights_request_B = false

	spec.faultListText = {}
	spec.faultList = {}




	spec.RVB_Battery = {}
	spec.RVB_BatteryFillLevel = 100.000000
	spec.updateBatteryTimer = 0
	
	spec.BatteryPlusMinus = {}
	spec.BatteryPlusMinus.lightings = 0
	
	spec.batteryFillUnitIndex = nil
	spec.isInitialized = true
	
	local specFillunit = self.spec_fillUnit
	local batteryFillUnitsCount = 0

	spec.batteryCHActive = false
	local batteryLevel = 100
	local spec_fillUnit = self.spec_fillUnit
	
	spec.updateDelta = 5001
	spec.updateRate = 5000
	
	
	spec.isRepairActive = false
	spec.isServiceActive = false
	--spec.isInspectionActive = false


	spec.totalRepairTime = 0.0

	
	local spec_m = self.spec_motorized

	if spec_m.motor ~= nil then
	
	
	
	local fillUnits = self.spec_fillUnit.fillUnits

		local xmlFillUnit = XMLFile.load("vehicleXml", Utils.getFilename("config/battery_fillUnit.xml", g_currentMission.vehicleBreakdowns.modDirectory), Vehicle.xmlSchema)
		local batteryKey = string.format("vehicle.fillUnit.fillUnitConfigurations.fillUnitConfiguration(0).fillUnits.fillUnit(0)")
		local entry = {}
		if not self:FillUnitloadFillUnitFromXML(xmlFillUnit, batteryKey, entry, #fillUnits + 1) then
			Logging.xmlWarning(xmlFillUnit, "RVB: Could not load fillUnit for \'%s\'", batteryKey)
			self:setLoadingState(VehicleLoadingState.ERROR)
		end
		--entry.fillType = FillType.BATTERYCHARGE
		--entry.startFillTypeIndex = FillType.BATTERYCHARGE
		--entry.capacity = 100
		--entry.startFillLevel = 100
		
		-- ez is kell hozzá (akku infobar megjelenítés)
		--entry.showOnHud = true
		--entry.showOnInfoHud = true
		
		local fillUnits = self.spec_fillUnit.fillUnits
		table.insert(fillUnits, entry)

		spec.batteryFillUnitIndex = #fillUnits
		spec.RVB_BatteryFillLevel = entry.capacity

	else
		spec.isInitialized = false
	end
	

	if self.getConsumerFillUnitIndex ~= nil and self:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil then

		local specConsumers = self.spec_motorized
		if spec.batteryFillUnitIndex ~= nil and spec.isInitialized then

		
			local xmlFillUnit = XMLFile.load("vehicleXml", Utils.getFilename("config/battery_consumer.xml", g_currentMission.vehicleBreakdowns.modDirectory), Vehicle.xmlSchema)
			local unitindex = 1

			local vkey, motorId = ConfigurationUtil.getXMLConfigurationKey(self.xmlFile, self.configurations["motor"], "vehicle.motorized.motorConfigurations.motorConfiguration", "vehicle.motorized", "motor")
			local fallbackConfigKey = "vehicle.motorized.motorConfigurations.motorConfiguration(0)"
			local consumerConfigurationIndex = ConfigurationUtil.getConfigurationValue(self.xmlFile, vkey, "#consumerConfigurationIndex", "", 1, fallbackConfigKey)
			local key = string.format("vehicle.motorized.consumerConfigurations.consumerConfiguration(%d)", consumerConfigurationIndex-1)
			local consumerKey = string.format(".consumer(%d)", #specConsumers.consumers + 1)
			local consumer = {}
			consumer.fillUnitIndex = spec.batteryFillUnitIndex
	--		print("spec.batteryFillUnitIndex "..spec.batteryFillUnitIndex)
			self.spec_fillUnit.fillUnits[spec.batteryFillUnitIndex].fillType = FillType.BATTERYCHARGE
			self.spec_fillUnit.fillUnits[spec.batteryFillUnitIndex].fillLevel = spec.RVB_BatteryFillLevel -- batteryLevel
			--self:raiseDirtyFlags(self.spec_fillUnit.dirtyFlag)
			local fillTypeName = "batteryCharge"
			consumer.fillType = g_fillTypeManager:getFillTypeIndexByName(fillTypeName)
			consumer.capacity = nil
			local fillUnit = self:getFillUnitByIndex(consumer.fillUnitIndex)
			if fillUnit ~= nil then
			
				if fillUnit.supportedFillTypes[consumer.fillType] == nil then
					fillUnit.supportedFillTypes = {}
					fillUnit.supportedFillTypes[consumer.fillType] = true
				end
				fillUnit.capacity = consumer.capacity or fillUnit.capacity
				if (consumer.fillType == FillType.DIESEL or (consumer.fillType == FillType.ELECTRICCHARGE or consumer.fillType == FillType.METHANE)) and fillUnit.exactFillRootNode == nil then
					Logging.xmlWarning(self.xmlFile, "Missing exactFillRootNode for fuel fill unit (%d).", consumer.fillUnitIndex)
				end
				fillUnit.startFillLevel = fillUnit.capacity
				fillUnit.startFillTypeIndex = consumer.fillType
				fillUnit.ignoreFillLimit = true
				--local v347 = ConfigurationUtil.getConfigurationValue(p338, v340, v343, "#usage", 1, "vehicle.motorized.consumers")
				--consumer.permanentConsumption = ConfigurationUtil.getConfigurationValue(p338, v340, v343, "#permanentConsumption", true, "vehicle.motorized.consumers")
				consumer.permanentConsumption = false
				local usage = 0.1
				if consumer.permanentConsumption then
					consumer.usage = usage / 3600000
				else
					consumer.usage = usage
				end
				consumer.refillLitersPerSecond = 0 --ConfigurationUtil.getConfigurationValue(p338, v340, v343, "#refillLitersPerSecond", 0, "vehicle.motorized.consumers")
				consumer.refillCapacityPercentage = 0 --ConfigurationUtil.getConfigurationValue(p338, v340, v343, "#refillCapacityPercentage", 0, "vehicle.motorized.consumers")
				consumer.fillLevelToChange = 0
				local v348 = specConsumers.consumers
				table.insert(v348, consumer)
				specConsumers.consumersByFillTypeName[string.upper(fillTypeName)] = consumer
				specConsumers.consumersByFillType[consumer.fillType] = consumer

			else
				Logging.xmlWarning(self.xmlFile, "RVB: Unknown fillUnit '%d' for consumer '%s'", consumer.fillUnitIndex, key..consumerKey)
			end
		end
	end

	
	spec.rvb_actionEventToggleLights = 0
		
	self.players = {}
	spec.isJumperCablesConnected = false
	spec.isJumpStarting = false
	spec.chargeRate = 0
	spec.actionEvents = {}
	
	self.vehicle = nil
	self.interactText = ""
	self.actionEventIdJC = nil
	
	self.rvbjumperCableConnections = {}
	self.rvb_addextra_connecting = false
	
	spec.batteryDrainStartMotorTriggered = false
	spec.batteryDrain = false
	
	spec.isTorqueModified = false
	
end

	
function VehicleBreakdowns:getBatteryFillUnitIndex()
    local spec = self.spec_fillUnit
    local batteryFillType = g_fillTypeManager:getFillTypeIndexByName("BATTERYCHARGE")
    for fillUnitIndex, _ in ipairs(spec.fillUnits) do
        if self:getFillUnitAllowsFillType(fillUnitIndex, batteryFillType) then
            return fillUnitIndex
        end
    end
    return nil
end

function VehicleBreakdowns:minuteChanged()

	local spec = self.spec_faultData
	
	if not spec.isrvbSpecEnabled then
        return
    end

	
end


function VehicleBreakdowns:onWorkshopStateChanged()
	local workshopStatus, _ = g_currentMission.vehicleBreakdowns:getWorkshopStatusMessage()
    for _, vehicle in ipairs(g_currentMission.vehicleSystem.vehicles) do
        if vehicle.spec_faultData then
            updateSuspensionState(vehicle, workshopStatus)
        end
    end
end

function VehicleBreakdowns:RVBhourChanged()
	
	local spec = self.spec_faultData
	
	if not spec.isrvbSpecEnabled then
        return
    end
	
	local GPSET = g_currentMission.vehicleBreakdowns.gameplaySettings

	self.currentTemperaturDay = g_currentMission.environment.weather:getCurrentTemperature()
	self.currentTemperaturDay =  self.currentTemperaturDay - math.random(2,5)
	
	local workshopStatus, _ = g_currentMission.vehicleBreakdowns:getWorkshopStatusMessage()

		
	updateSuspensionState(self, workshopStatus)
	
		
end


function VehicleBreakdowns:deactivateLights(superFunc, keepHazardLightsOn)
    local spec = self.spec_lights
    self:setLightsTypesMask(0, true, true)
    self:setBeaconLightsVisibility(false, true, true)
    if not keepHazardLightsOn or spec.turnLightState ~= Lights.TURNLIGHT_HAZARD then
        self:setTurnLightState(Lights.TURNLIGHT_OFF, true, true)
    end
    self:setBrakeLightsVisibility(false)
    self:setReverseLightsVisibility(false)
    self:setInteriorLightsVisibility(false)
    spec.currentLightState = 0
end

function VehicleBreakdowns.setLightsTypesMask(self, superFunc, lightsTypesMask, force, noEventSend)
	superFunc(self, lightsTypesMask, force, noEventSend)
    local currentLightMask = self:getLightsTypesMask()
	local rvb = self.spec_faultData
	rvb.rvblightsTypesMask = currentLightMask
    return
end


function getActiveLights(vehicle)
    local activeLights = {}
    local spec = vehicle.spec_lights
    if not spec then return activeLights end

    --print("getActiveLights")
    
	local LIGHT_TYPES = {
		[0] = "DIM",        -- tompított
		[1] = "WORK_BACK",  -- hátsó munkalámpa
		[2] = "WORK_FRONT", -- első munkalámpa
		[3] = "HIGH",       -- távolsági
	}
	if vehicle.typeName == "combineDrivable" then
		LIGHT_TYPES[4] = "PIPE"
	end

    for bit, name in pairs(LIGHT_TYPES) do
		--print("bit:", bit, "name:", name, "mask:", spec.lightsTypesMask)
        if bit32.band(spec.lightsTypesMask, 2^bit) ~= 0 then
            table.insert(activeLights, name)
        end
    end

    if spec.turnLightState == Lights.TURNLIGHT_LEFT then
        table.insert(activeLights, "TURN_LEFT")
    elseif spec.turnLightState == Lights.TURNLIGHT_RIGHT then
        table.insert(activeLights, "TURN_RIGHT")
    elseif spec.turnLightState == Lights.TURNLIGHT_HAZARD then
        table.insert(activeLights, "HAZARD")
    end

    if spec.beaconLightsActive then
        table.insert(activeLights, "BEACON")
    end
	
	if spec.brakeLightsVisibility then
		table.insert(activeLights, "BRAKE")
	end
	
	if spec.topLightsVisibility then
        --table.insert(activeLights, "TOP")
    end
    local default = 2 ^ Lights.LIGHT_TYPE_DEFAULT
    if bit32.band(spec.lightsTypesMask, default) ~= 0 then
        if spec.topLightsVisibility then
            --local v131_ = 2 ^ spec.additionalLightTypes.topLight
            --lightsTypesMask = bit32.bor(lightsTypesMask, v131_)
        --    table.insert(activeLights, "TOP")
        else
            --local v132_ = 2 ^ spec.additionalLightTypes.bottomLight
            --lightsTypesMask = bit32.bor(lightsTypesMask, v132_)
        --    table.insert(activeLights, "BOTTOM")
        end
    end
	
	if spec.reverseLightsVisibility then
        table.insert(activeLights, "REVERSE")
    end

    return activeLights
end

local LIGHT_DRAIN = {
    DIM = 0.25,
    HIGH = 0.25,
    WORK_FRONT = 0.15,
    WORK_BACK = 0.15,
    PIPE = 0.10,
    TURN_LEFT = 0.01,
	TURN_RIGHT = 0.01,
	HAZARD = 0.02,
	BEACON = 0.025,
    BRAKE = 0.05,
    REVERSE = 0.05,
    TOP = 0.05,
    BOTTOM = 0.05,
}

function getLightsDrain(vehicle)
    local active = getActiveLights(vehicle)
    local total = 0
    for _, light in ipairs(active) do
		--print("Aktív lámpa: " .. light)
        total = total + (LIGHT_DRAIN[light] or 0)
    end
    return total
end


		
			
function VehicleBreakdowns:onBatteryDrain(dt)
	local spec = self.spec_faultData
	local spec_light = self.spec_lights
	local lightsOk = spec.parts[LIGHTINGS].fault == "empty"
	--if not self:getIsMotorStarted() and lightsOk and spec.isInitialized then
	if lightsOk and spec.isInitialized then
		if self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS and self:getIsFaultBattery() >= BATTERY_LEVEL.LIGHTS_BEACONS then
			if self.deactivateLights ~= nil then
				self:setLightsTypesMask(0, true, true)
			end
		end
		if self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS_BEACONS then
			if self.deactivateBeaconLights ~= nil then
				self:deactivateBeaconLights()
			end
			if self.deactivateLights ~= nil then
				self:deactivateLights()
			end
		end
        if self.isServer then
		local activeDrain = getLightsDrain(self)
		if activeDrain <= 0 then return end
		spec.batteryDrainUpdateTimer = (spec.batteryDrainUpdateTimer or 0) + dt
		if spec.batteryDrainUpdateTimer >= RVB_DELAY.BATTERY_DRAIN then
			self:updateBatteryDrain(spec.batteryDrainUpdateTimer, spec)
			spec.batteryDrainUpdateTimer = 0
		end
		self:raiseActive()
        end
	end
end
function VehicleBreakdowns:updateBatteryDrain(msDelta, spec)
	local RVBSET = g_currentMission.vehicleBreakdowns
	local activeDrain = getLightsDrain(self)
    if activeDrain <= 0 then return end
	local batteryFillLevel = self:getFillUnitFillLevel(spec.batteryFillUnitIndex)
	local drainPerSec = 100 / BATTERY_DRAIN_TIME
	local runtimeIncrease = drainPerSec * activeDrain * (msDelta / 1000) * g_currentMission.missionInfo.timeScale
	if batteryFillLevel > 0 then
		if self.isServer then
			self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.batteryFillUnitIndex, -runtimeIncrease, self:getFillUnitFillType(spec.batteryFillUnitIndex), ToolType.UNDEFINED)
		end
	end
end



function VehicleBreakdowns:setBatteryDrainingIfStartMotor()
	local spec = self.spec_faultData
	local RVBSET = g_currentMission.vehicleBreakdowns

	if spec == nil or spec.batteryDrainStartMotorTriggered then return end

	local drainValue = 2
	if self.getConsumerFillUnitIndex ~= nil and self:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE) ~= nil and self:getConsumerFillUnitIndex(FillType.DIESEL) == nil then
		drainValue = 1
	end

	if self:getIsFaultBattery() <= BATTERY_LEVEL.MOTOR or self:getIsFaultSelfStarter() then
		drainValue = 0.5
		if RVBSET:getIsAlertMessage() and self.getIsEntered ~= nil and self:getIsEntered() then
			g_currentMission:showBlinkingWarning(g_i18n:getText("RVB_fault_BHlights"), 2500)
		end
	end

	if self:getIsFaultBattery() >= BATTERY_LEVEL.MOTOR then -- 0.03 then
		if self:getIsFaultGlowPlug() then
			drainValue = 1
		end
		if spec.isInitialized then
			local batteryFillLevel = self:getFillUnitFillLevel(spec.batteryFillUnitIndex)
			if batteryFillLevel > 0 then
				if self.isServer then
					spec.batteryDrainStartMotorTriggered = true
					self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.batteryFillUnitIndex, -drainValue, self:getFillUnitFillType(spec.batteryFillUnitIndex), ToolType.UNDEFINED, nil)
				end
			end
		end
	end
end


--if g_sleepManager:getIsSleeping() then
function VehicleBreakdowns:onSleepingStateChanged(isSleeping)
	if not isSleeping and self.spec_motorized ~= nil then
		self.spec_motorized.motorTemperature.value = self.currentTemperaturDay
	end
end


		
function VehicleBreakdowns:batteryChargeVehicle()
	local spec = self.spec_faultData
	 self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.batteryFillUnitIndex, 100, self:getFillUnitFillType(spec.batteryFillUnitIndex), ToolType.UNDEFINED, nil)
	if self.isServer then
		g_currentMission:addMoney(-25, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
		local total, _ = g_farmManager:updateFarmStats(self:getOwnerFarmId(), "repairVehicleCount", 1)
		if total ~= nil then
			g_achievementManager:tryUnlock("VehicleRepairFirst", total)
			g_achievementManager:tryUnlock("VehicleRepair", total)
		end
	end
end


function VehicleBreakdowns.setRVBJumpchargerate(self, rate)
	if self.isServer then
		local rvb = self.spec_faultData
		self:addFillUnitFillLevel(self:getOwnerFarmId(), rvb.batteryFillUnitIndex, rate, self:getFillUnitFillType(rvb.batteryFillUnitIndex), ToolType.UNDEFINED, nil)
		rvb.chargeRate = 0
	--	self:raiseDirtyFlags(rvb.dirtyFlag)
	end
end

function VehicleBreakdowns:chargeBatteryViaJumpStart(dt, isActiveForInputIgnoreSelection)
	local LowBatteryVehicle = g_rvbPlayer.jumperCableConnections[2]
	if LowBatteryVehicle ~= nil and self:getIsMotorStarted() then -- kellehet de lehet kulon feltetelbe and not self:getIsFaultGenerator() then
		local spec = self.spec_faultData
		local partGenerator = spec.parts[GENERATOR]
		local lowspec = LowBatteryVehicle.spec_faultData
		local batteryFillLevel = LowBatteryVehicle:getFillUnitFillLevel(lowspec.batteryFillUnitIndex)
		if LowBatteryVehicle:getIsMotorStarted() then
			spec.isJumpStarting = false
			VehicleBreakdowns.updateActionEvents(self)
			return
		end
		if batteryFillLevel < 100 then
			local generatorBaseOutput = 60 -- Alap generátor kimenet (A)
			local maxGeneratorOutput = 120 -- Maximális generátor kimenet (A)
			local specMotorized = self.spec_motorized
			local specMotorizedM = self.spec_motorized.motor
			local currentRPM = specMotorizedM.lastMotorRpm -- Aktuális fordulatszám
			local minRPM = specMotorizedM.minRpm
			local maxRPM = specMotorizedM.maxRpm

			-- Hatékonysági tényező az üzemórák alapján
			local efficiencyFactor = math.max(0.1, 1 - (partGenerator.operatingHours / partGenerator.tmp_lifetime))

			local faultName = (partGenerator.prefault ~= "empty" and partGenerator.prefault) or partGenerator.fault
			local r = FaultRegistry[GENERATOR]
			local variants = r.variants
			if faultName and faultName ~= "empty" then
				local variantData = variants[faultName]
				if variantData ~= nil then
					local severity = variantData.severity or 0.5
					local penalty = severity
					efficiencyFactor = math.max(0, 1 - penalty)
				end
			end

			-- RPM százalék és RPM faktor számítása
			local rpmPercentage = (currentRPM - minRPM) / (maxRPM - minRPM)
			local idleFactor = 0.5
			local rpmFactor = idleFactor + rpmPercentage * (1 - idleFactor)
			-- Terhelési tényező számítása
			local loadFactor = math.max(specMotorized.smoothedLoadPercentage * rpmPercentage, 0)
			--local motorFactor = 0.5 * (0.2 * rpmFactor + 1.8 * loadFactor) + 0.4  -- Motor faktor frissítve
			--local motorFactor = 0.6 * (0.4 * rpmFactor + 1.8 * loadFactor) + 0.9
			--local motorFactor = 0.5 * (0.3 * rpmFactor + 1.8 * loadFactor) + 0.5

			local motorFactor = 0.6 * (0.8 * rpmFactor + 2.1 * loadFactor) + 0.3


			-- Töltési ráta számítása a motor és generátor állapot alapján
			local oneGameHour = 1000 * 60 * 60
			local runtimeIncrease = dt * g_currentMission.missionInfo.timeScale / oneGameHour
			local generatorOutput = generatorBaseOutput + (maxGeneratorOutput - generatorBaseOutput) * loadFactor
			local chargeRate = generatorOutput * motorFactor * efficiencyFactor * runtimeIncrease
			-- Ellenőrizzük, hogy a kimeneti áram helyes legyen
			if chargeRate < 0 then
				chargeRate = 0
			end
			if chargeRate ~= 0 then
				lowspec.jumpstartToChange = lowspec.jumpstartToChange + chargeRate
				local jumpstartToChange = lowspec.jumpstartToChange
				if self.isClient and isActiveForInputIgnoreSelection then
					local LowBatteryVehicle = g_rvbPlayer.jumperCableConnections[2]
					local currentChargeLevel = (1 - LowBatteryVehicle:getIsFaultBattery())*100
					local lackofcharge = 100 - currentChargeLevel
					g_currentMission:addExtraPrintText(string.format(g_i18n:getText("RVB_addextra_progress"), string.format("%.2f", lackofcharge)))
					-- Töltési érték megjelenítése
					local approxAmps = generatorOutput * motorFactor * efficiencyFactor
					g_currentMission:addExtraPrintText(string.format(g_i18n:getText("RVB_addextra_charging"), string.format("%.2f", approxAmps)))
				end
				if math.abs(jumpstartToChange) > 0.1 then
					chargeRate = lowspec.jumpstartToChange
					lowspec.chargeRate = lowspec.jumpstartToChange
					lowspec.jumpstartToChange = 0
					local newFillLevel = batteryFillLevel + chargeRate
					if newFillLevel > 100 then
						newFillLevel = 100
						spec.isJumpStarting = false
						VehicleBreakdowns.updateActionEvents(self)
					end
					--LowBatteryVehicle:addFillUnitFillLevel(LowBatteryVehicle:getOwnerFarmId(), lowspec.batteryFillUnitIndex, chargeRate, LowBatteryVehicle:getFillUnitFillType(lowspec.batteryFillUnitIndex), ToolType.UNDEFINED, nil)
					g_client:getServerConnection():sendEvent(RVBJumpStartingEvent.new(LowBatteryVehicle, lowspec.chargeRate))
				end
			end
		end
	end
end



--- CSERÉLD LE onUpdate ben van
function VehicleBreakdowns:RVBaddRemoveMoney(amount, farmId, moneyType)
	if g_currentMission:getIsServer() then
		g_currentMission:addMoneyChange(amount, farmId, moneyType, true)
		local farm = g_farmManager:getFarmById(farmId)
		if farm ~= nil then
			farm:changeBalance(amount, moneyType)
		end
	end
end

function VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
    local GPSET = g_currentMission.vehicleBreakdowns.gameplaySettings
    local currentTimeInMinutes = g_currentMission.environment.currentHour * 60 + g_currentMission.environment.currentMinute
    local addTimeInMinutes = AddHour * 60 + AddMinute
    local workshopOpenTime = GPSET.workshopOpen * 60
    local workshopCloseTime = GPSET.workshopClose * 60
    local finishDay = g_currentMission.environment.currentDay
    if currentTimeInMinutes < workshopOpenTime then
        currentTimeInMinutes = workshopOpenTime
    end
    local finishTimeInMinutes = currentTimeInMinutes + addTimeInMinutes
    if finishTimeInMinutes >= workshopCloseTime then
        finishDay = finishDay + 1
        finishTimeInMinutes = workshopOpenTime + (finishTimeInMinutes - workshopCloseTime)
    end
    local finishHour = math.floor(finishTimeInMinutes / 60)
    local finishMinute = finishTimeInMinutes % 60
    return finishDay, finishHour, finishMinute
end


function VehicleBreakdowns:SyncClientServer_RVBRepair(repair, message)
	local spec = self.spec_faultData
	spec.repair = repair
	if spec.repair[1] then
		self.rvbDebugger:info("The repair of vehicle %s has started. Activated in the updateRepair(dt) function.", self:getFullName())
		self:raiseActive()
	end

	if message ~= nil and message.cost > 0 then
		if self.isServer then
			g_currentMission:addMoney(-message.cost, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
		end
		if self.isClient then
			local notiMessage = string.format(g_i18n:getText(message.text), self:getFullName())
			g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, notiMessage, 10000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS)
		end
	end
	local r = spec.repair
	self.rvbDebugger:info(
		"The repair of vehicle %s has been completed. Repair data block: state=%s suspension=%s finishday=%s finishhour=%s finishminute=%s amount=%s cost=%s damage=%s factor=%s inspection=%s",
		self:getFullName(),
		tostring(r[1]), tostring(r[2]), tostring(r[3]), tostring(r[4]),	tostring(r[5]),
		tostring(r[6]),	tostring(r[7]), tostring(r[8]), tostring(r[9]), tostring(r[10])
	)

	if self.isClient and not spec.repair[1] and self.getIsEntered and self:getIsEntered() then
		self.rvbDebugger:info("Repair process for vehicle %s completed: requestActionEventUpdate().", self:getFullName())
		self:requestActionEventUpdate()
	end
end

function VehicleBreakdowns:updateRepair(dt)
	local spec = self.spec_faultData
	local repair = spec.repair
	local inspection = spec.inspection
	
	local isNeeded = inspection[8] and repair[1]
	local isNotPaused = not repair[2]

	if isNeeded then

		local RVBSET = g_currentMission.vehicleBreakdowns
		local CurEnvironment = g_currentMission.environment
		local day, hour, minute = CurEnvironment.currentDay, CurEnvironment.currentHour, CurEnvironment.currentMinute
		local insDay, insHour, insMinute = repair[3], repair[4], repair[5]
		local parts = spec.parts
		local serviceManual_more = ""

		if isNotPaused then

			if spec.totalRepairTime == 0.0 then
				--spec.totalRepairTime = 0.0
				for _, key in ipairs(g_vehicleBreakdownsPartKeys) do
					local part = parts[key]
					if not part then
						self.rvbDebugger:warning("Part key '%s' is missing in vehicle %s", key, self:getFullName())
					elseif part.repairreq then
						spec.totalRepairTime = spec.totalRepairTime + (FaultRegistry[key].repairTime or 0)
						self.rvbDebugger:info("VehicleBreakdowns:updateRepair TotalRepairTime: %s", spec.totalRepairTime)
					end
				end
			end

			for _, key in ipairs(g_vehicleBreakdownsPartKeys) do
				local part = parts[key]
				if not part then
					self.rvbDebugger:warning("Part key '%s' is missing in vehicle %s", key, self:getFullName())
				elseif part.repairreq then
					if not part.startingOperatingHours then
						part.startingOperatingHours = part.operatingHours
						self.rvbDebugger:info("VehicleBreakdowns:updateRepair %s startingOperatingHours: %s", part.name, part.startingOperatingHours)
					end
					if self.isServer and spec.totalRepairTime > 0 then
						local operatingHoursPerSecond = part.startingOperatingHours / spec.totalRepairTime
						local reduction = operatingHoursPerSecond * (dt / 1000) * g_currentMission.missionInfo.timeScale
						spec.repairToChange = spec.repairToChange + reduction
						local repairToChange = spec.repairToChange
						if math.abs(repairToChange) > 0.1 then
							reduction = spec.repairToChange
							spec.repairToChange = 0
							self.rvbDebugger:info("VehicleBreakdowns:updateRepair  %s reduction: %s dt: %s", part.name, reduction, dt)
							part.operatingHours = math.max(part.operatingHours - reduction, 0)
							self:raiseDirtyFlags(spec.partsDirtyFlag)
							self.rvbDebugger:info("VehicleBreakdowns:updateRepair  %s part.operatingHours: %s", part.name, part.operatingHours)
						end
					end
				end
			end
	
			if self.isClient then
				checkAndShowAlertMessage(self, minute, "repair", "RVB_alertmessage_repair", 5)
			end
			
		end
		
		if day > insDay or (day == insDay and hour > insHour) or (day == insDay and hour == insHour and minute >= insMinute) then

			local anyRepairDone = false
		
			local partList = {}
			for _, key in ipairs(g_vehicleBreakdownsPartKeys) do
				local part = parts[key]
				if not part then
					self.rvbDebugger:warning("Part key '%s' is missing in vehicle %s", key, self:getFullName())
				elseif part.repairreq then
					table.insert(partList, g_i18n:getText("RVB_faultText_" .. part.name))
					part.repairreq = false
					part.operatingHours = 0
					part.damaged = false
					part.fault = "empty"
					part.prefault = "empty"
					part.startingOperatingHours = nil
					anyRepairDone = true
				end
			end
			if anyRepairDone then

				spec.ShortCircuitStop = false
				spec.isRepairActive = false
				spec.totalRepairTime = 0.0
				local specM = self.spec_motorized
				if specM then
					specM.motorTemperature.value = self.currentTemperaturDay
					specM.motorFan.enableTemperature = 95
					specM.motorFan.disableTemperature = 85
				end
                
                local partListText = table.concat(partList, ", ")
                local serviceManualDesc = string.format(g_i18n:getText("RVB_WorkshopMessage_repairDone"), partListText)
				local keyText = "RVB_repairDialogEnd"
				local removeMoney = repair[7]

				local message = {
					result = true,
					cost = removeMoney,
					text = keyText
				}

				local entry = {
					entryType = REPAIR.SERVICE_MANUAL,
					entryTime = CurEnvironment.currentDay,
					operatingHours = spec.rvb[3],
					odometer = 0,
					result = serviceManualDesc,
					cost = removeMoney
				}

				repair[1], repair[2], repair[3], repair[4], repair[5], repair[6], repair[7], repair[8], repair[9], repair[10] = false, false, 0, 0, 0, 0, 0, 0, 0, false
				inspection[8] = false
					
				if self.isServer then
					RVBserviceManual_Event.sendEvent(self, entry)
					RVBParts_Event.sendEvent(self, parts)
					RVBInspection_Event.sendEvent(self, inspection, {result=false,cost=0,text=""})
					RVBRepairEvent.sendEvent(self, repair, message)					
				end
			end
		--else
			--self.rvbDebugger:warning("Repair process for vehicle %s completed, but no parts were marked for repair. Please notify the developer.", self:getFullName())
			--if self.isServer then
				local RVB = g_currentMission.vehicleBreakdowns
				if RVB.workshopVehicles[self] then
					RVB.workshopVehicles[self] = nil
					RVB.workshopCount = RVB.workshopCount - 1
					WorkshopCount_Event.sendEvent(RVB.workshopCount)
				end
			--end
			
			resetEngineTorque(self)

		end
		if repair[1] then
			self:raiseActive()
		end
	end
end

			
function VehicleBreakdowns:updateService(dt)
	local spec = self.spec_faultData
	local service = spec.service

	local isNeeded = service[1]
	local isNotPaused = not service[2]

	if isNeeded then
		local RVBSET = g_currentMission.vehicleBreakdowns
		local CurEnvironment = g_currentMission.environment
		local day, hour, minute = CurEnvironment.currentDay, CurEnvironment.currentHour, CurEnvironment.currentMinute
		local insDay, insHour, insMinute = service[3], service[4], service[5]
		local serviceManual_more = ""

		if isNotPaused then

			local moreservice = 0
			local servicePeriodic = math.floor(spec.rvb[4])
			if servicePeriodic > RVBSET:getPeriodicService() then
				moreservice = math.floor(servicePeriodic - RVBSET:getPeriodicService())
			end
				
			local serviceTime = SERVICE.BASE_TIME
			if moreservice > 0 then
				serviceTime = serviceTime + SERVICE.TIME * moreservice
				serviceManual_more = string.format(g_i18n:getText("RVB_WorkshopMessage_service"), moreservice)
			end
			if not spec.startingService then
				spec.startingService = spec.rvb[4]
				self.rvbDebugger:info("VehicleBreakdowns:updateService startingService: %s", spec.startingService)
			end
	
			if self.isServer and serviceTime > 0 then
				local servicePerSecond = spec.startingService  / serviceTime
				local reduction = servicePerSecond * (dt / 1000) * g_currentMission.missionInfo.timeScale
				if reduction ~= 0 and spec.rvb[4] > 0 then
					spec.serviceToChange = spec.serviceToChange + reduction
					local serviceToChange = spec.serviceToChange
					if math.abs(serviceToChange) > 0.1 then
						reduction = spec.serviceToChange
						spec.serviceToChange = 0
						spec.rvb[4] = math.max(spec.rvb[4] - reduction, 0)
						self:raiseDirtyFlags(spec.rvbdirtyFlag)
						self.rvbDebugger:info("VehicleBreakdowns:updateService  serviceTime: %s", spec.rvb[4])
					end
				end
			end

			if self.isClient then
				checkAndShowAlertMessage(self, minute, "service", "RVB_alertmessage_service", 5)
			end
		end

		if day > insDay or (day == insDay and hour > insHour) or (day == insDay and hour == insHour and minute >= insMinute) then
			spec.startingService = nil
			spec.isServiceActive = false
			local specM = self.spec_motorized
			if specM then
				specM.motorTemperature.value = self.currentTemperaturDay
				specM.motorFan.enableTemperature = 95
				specM.motorFan.disableTemperature = 85
			end
				
            local serviceManualDesc = g_i18n:getText("RVB_WorkshopMessage_serviceDone")
            if serviceManual_more ~= "" then
                serviceManualDesc = serviceManualDesc .. " " .. serviceManual_more
            end

			local keyText = "RVB_serviceDialogEnd"
			local removeMoney = service[7]

			local message = {
				result = true,
				cost = removeMoney,
				text = keyText
			}

			local entry = {
				entryType = SERVICE.SERVICE_MANUAL,
				entryTime = CurEnvironment.currentDay,
				operatingHours = spec.rvb[3],
				odometer = 0,
				result = serviceManualDesc,
				cost = removeMoney
			}
			
			service[1], service[2], service[3], service[4], service[5], service[6], service[7], service[8] = false, false, 0, 0, 0, 0, 0, 0
			spec.rvb[4] = 0
			
			if self.isServer then
				RVBserviceManual_Event.sendEvent(self, entry)
				RVBTotal_Event.sendEvent(self, spec.rvb)
				RVBService_Event.sendEvent(self, spec.service, message)
			end

			--if self.isServer then
				local RVB = g_currentMission.vehicleBreakdowns
				if RVB.workshopVehicles[self] then
					RVB.workshopVehicles[self] = nil
					RVB.workshopCount = RVB.workshopCount - 1
					WorkshopCount_Event.sendEvent(RVB.workshopCount)
				end
			--end
		end
		if service[1] then
			self:raiseActive()
		end
	end
end

function VehicleBreakdowns:SyncClientServer_RVBService(service, message)
	local spec = self.spec_faultData
	spec.service = service
	if spec.service[1] then
		self.rvbDebugger:info("The service of vehicle %s has started. Activated in the updateService(dt) function.", self:getFullName())
		self:raiseActive()
	end

	if message ~= nil and message.cost > 0 then
		if self.isServer then
			g_currentMission:addMoney(-message.cost, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
		end
		if self.isClient then
		local notiMessage = string.format(g_i18n:getText(message.text), self:getFullName())
		g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, notiMessage, 10000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS)
		end
	end
	local s = spec.service
	self.rvbDebugger:info(
		"The service of vehicle %s has been completed. Service data block: state=%s suspension=%s finishday=%s finishhour=%s finishminute=%s amount=%s cost=%s damage=%s",
		self:getFullName(),
		tostring(s[1]), tostring(s[2]), tostring(s[3]), tostring(s[4]),
		tostring(s[5]),	tostring(s[6]),	tostring(s[7]), tostring(s[8])
	)

	if self.isClient and not spec.service[1] and self.getIsEntered and self:getIsEntered() then
		self.rvbDebugger:info("Service process for vehicle %s completed: requestActionEventUpdate().", self:getFullName())
		self:requestActionEventUpdate()
	end
end

function VehicleBreakdowns:onStartInspection(vehicle)
	if self == vehicle then
		local rvb = self.spec_faultData
		if rvb then
			--rvb.isInspectionActive = true
			local isNeeded = self:getIsInspection()
			--print("VehicleBreakdowns:onStartInspection(vehicle)")
			--if isNeeded then
	--		self:raiseActive()
			--end
		end
	end
end

function VehicleBreakdowns:onEndInspection(vehicle, message)
--if self.isClient then
	if self == vehicle then
		local rvb = self.spec_faultData
		if rvb then --print("fut a onEndInspection "..tostring(message))
			
	--			g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, "Center "..message, 10000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS)
			end
		end
	--end
end

function VehicleBreakdowns:SyncClientServer_RVBInspection(inspection, message)
	local spec = self.spec_faultData
	spec.inspection = inspection

	if spec.inspection[1] then
		self.rvbDebugger:info("The inspection of vehicle %s has started. Activated in the updateInspection(dt) function.", self:getFullName())
		self:raiseActive()
	end

	if message ~= nil and message.cost > 0 then
		if self.isServer then
			g_currentMission:addMoney(-message.cost, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
		end
		if self.isClient then
			local notiMessage
			if message.result then
				notiMessage = string.format(g_i18n:getText(message.text), self:getFullName())
			else
				notiMessage = string.format(g_i18n:getText(message.text), self:getFullName(), g_i18n:formatMoney(self:getRepairPrice_RVBClone(true)))
			end
			g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, notiMessage, 10000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS)
		end
	end

	local i = spec.inspection
	self.rvbDebugger:info(
		"The inspection of vehicle %s has been completed. Inspection data block: state=%s suspension=%s finishday=%s finishhour=%s finishminute=%s cost=%s factor=%s inspection=%s",
		self:getFullName(),
		tostring(i[1]), tostring(i[2]), tostring(i[3]), tostring(i[4]),
		tostring(i[5]),	tostring(i[6]), tostring(i[7]), tostring(i[8])
	)
	
	if self.isClient and not spec.inspection[1] and self.getIsEntered and self:getIsEntered() then
		self.rvbDebugger:info("Inspection process for vehicle %s completed: requestActionEventUpdate().", self:getFullName())
		self:requestActionEventUpdate()
	end
end

function VehicleBreakdowns:updateInspection(dt)
    local spec = self.spec_faultData
	local inspection = spec.inspection

	local isNeeded = self:getIsInspection()
	local isNotPaused = not inspection[2]

	if isNeeded then
	
		local RVBSET = g_currentMission.vehicleBreakdowns
		local CurEnvironment = g_currentMission.environment
		local day, hour, minute = CurEnvironment.currentDay, CurEnvironment.currentHour, CurEnvironment.currentMinute
		local insDay, insHour, insMinute = inspection[3], inspection[4], inspection[5]
		
		if isNotPaused then
			if self.isClient then
				checkAndShowAlertMessage(self, minute, "inspection", "RVB_alertmessage_inspection", 5)
			end
		end
		
		if day > insDay or (day == insDay and hour > insHour) or (day == insDay and hour == insHour and minute >= insMinute) then

			local faultTexts = {}
			local faultChanged = false
			-- Alkatrészek vizsgálata
			for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
				local part = spec.parts[key]
				local faultData = FaultRegistry[key]
				if part and faultData then
					local partFoot = (part.operatingHours * 100) / part.tmp_lifetime
					local shouldBreak = faultData.strictBreak and (partFoot >= faultData.breakThreshold) or (partFoot > faultData.breakThreshold)

					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					local thresholdPassed = faultData.threshold and faultData.threshold(self, 0, true) or false
					local needsNewFault = part.fault == nil or part.fault == "empty"
			
					if  shouldBreak and (thresholdPassed or criticalLevel) and needsNewFault then

						local valid = getValidFaultVariants(self, key, true)

						if valid then

							part.fault = valid
							part.repairreq = true
							spec.faultList[i] = true
							self.rvbDebugger:info("Vehicle part error: %s, specific error: %s", part.name, valid)
						end
					end
					-- Minden hibás alkatrész hozzáadása a listához
					if part.repairreq then
						table.insert(faultTexts, g_i18n:getText("RVB_faultText_" .. part.name))
					end
				end
			end
		
			local specM = self.spec_motorized
			if specM then
				specM.motorTemperature.value = self.currentTemperaturDay
				specM.motorFan.enableTemperature = 95
				specM.motorFan.disableTemperature = 85
			end

			local serviceManualDesc = ""
			local keyText = ""
			local removeMoney = inspection[6]  -- alapból mindig van pénz levonás

			if #faultTexts > 0 then
				-- Ha van hiba
				serviceManualDesc = g_i18n:getText("RVB_WorkshopS_repNeed") .. g_i18n:getText("RVB_ErrorList") .. " " .. table.concat(faultTexts, ", ")
				keyText = "RVB_inspectionDialogFault"
			else
				-- Ha nincs hiba
				serviceManualDesc = g_i18n:getText("RVB_WorkshopS_repNoNeed")
				local damage = self:getDamageAmount()
				local endTextKey = damage >= 0.90 and "RVB_inspectionDialogEnd_other" or "RVB_inspectionDialogEnd"
				keyText = endTextKey

				-- Ha a jármű nagyon sérült, adjuk hozzá a repair price-t is
				if damage >= 0.90 then
					removeMoney = removeMoney + self:getRepairPrice()
					self:setDamageAmount(math.random(20,50), true)
				end
			end
		
			local message = {
				result = (#faultTexts == 0),
				cost = removeMoney,
				text = keyText
			}
			local entry = {
				entryType = INSPECTION.SERVICE_MANUAL,
				entryTime = CurEnvironment.currentDay,
				operatingHours = spec.rvb[3],
				odometer = 0,
				result = serviceManualDesc,
				cost = removeMoney
			}
		
			inspection[1], inspection[2], inspection[3], inspection[4], inspection[5], inspection[6], inspection[7], inspection[8] = false, false, 0, 0, 0, 0, 0, true
			
			if self.isServer then
				RVBserviceManual_Event.sendEvent(self, entry)
				RVBParts_Event.sendEvent(self, spec.parts)
				RVBInspection_Event.sendEvent(self, spec.inspection, message)
			end
			
			--if self.isServer then
				local RVB = g_currentMission.vehicleBreakdowns
				if RVB.workshopVehicles[self] then
					RVB.workshopVehicles[self] = nil
					RVB.workshopCount = RVB.workshopCount - 1
					WorkshopCount_Event.sendEvent(RVB.workshopCount)
				end
			--end
		end
		if inspection[1] then
			self:raiseActive()
		end
	end

end

function VehicleBreakdowns:displayMessage(currentMinute)
	local count = 0
	local string_num = tostring(currentMinute)
	for i in string_num:gmatch("") do
		count = count + 1
	end
	count = count - 1
	return string.sub(string_num, count, count)
end





function VehicleBreakdowns:onPostLoad(savegame)

	if savegame == nil then
        return
    end
	
    

	local p25 = self
	local p26 = savegame

	local v27 = p25.spec_fillUnit
	if p25.isServer then
		local fillUnitsToLoad = {}
		
		if p26 == nil or not p26.xmlFile:hasProperty(p26.key .. ".fillUnit") then --print("NINCS MENTES")
			if not p25.vehicleLoadingData:getCustomParameter("spawnEmpty") then
				
			end
			
		else
			
			
			local v34 = p26.xmlFile
			local v35 = 0
			while true do
				local v36 = string.format("%s.fillUnit.unit(%d)", p26.key, v35)
				if not v34:hasProperty(v36) then
					break
				end
				local v37 = v34:getValue(v36 .. "#index")
				local v38
				if fillUnitsToLoad[v37] == nil then
					v38 = true
				elseif fillUnitsToLoad[v37] == nil then
					v38 = false
				else
					v38 = not p26.resetVehicles
				end
				if v38 then
					local v39 = v34:getValue(v36 .. "#fillType") --print("v39 fillType "..tostring(v39))
					local v40 = v34:getValue(v36 .. "#fillLevel") --print("v40 fillLevel "..tostring(v40))
					
					if v39 == "BATTERYCHARGE" then
						--if p25.isServer then
						local v41 = g_fillTypeManager:getFillTypeIndexByName(v39) --print("v41 "..tostring(v41))
						--p25:addFillUnitFillLevel(p25:getOwnerFarmId(), v37, v40, v41, ToolType.UNDEFINED, nil)
						local spec = p25.spec_faultData
						p25.spec_fillUnit.fillUnits[v37].fillLevel = v40
						--spec.RVB_BatteryFillLevel = v40
						
						p25:raiseDirtyFlags(p25.spec_fillUnit.dirtyFlag)
						--end
						if p25.isClient and not p25.isServer then
							p25.spec_fillUnit.fillUnits[v37].fillLevel = v40
						end

					end
					

					local fillUnit = p25.spec_fillUnit.fillUnits[v37]
					if fillUnit ~= nil then
						for _, unit in ipairs(fillUnit.fillLevelAnimations) do
					--		AnimatedVehicle.updateAnimationByName(p25, unit.name, 9999999, true)
						end
					end
	
				end
				v35 = v35 + 1
			end
		end
		for _, v44 in ipairs(v27.fillUnits) do
			--p25:updateAlarmTriggers(v44.alarmTriggers)
		end
	end
	

	if savegame == nil or savegame.resetVehicles then
        --return
    end

    local spec = self.spec_faultData
	
	local rvbkey = string.format("%s.%s.%s", savegame.key, g_vehicleBreakdownsModName, "vehicleBreakdowns")
	spec.isrvbSpecEnabled = savegame.xmlFile:getValue(rvbkey .. "#isrvbSpecEnabled", true)
	spec.rvb[1] = savegame.xmlFile:getValue(rvbkey .. "#timeScale", 5)
	local starthours = savegame.xmlFile:getValue(rvbkey .. "#operatingHoursTemp", spec.rvb[2]) * 1000
	spec.rvb[2] = math.max(Utils.getNoNil(starthours, 0), 0)
	local totaloperatinghours = savegame.xmlFile:getValue(rvbkey .. "#TotaloperatingHours", spec.rvb[3]) 
	spec.rvb[3] = math.max(Utils.getNoNil(totaloperatinghours, 0), 0)
	
	local periodic = savegame.xmlFile:getValue(rvbkey .. "#operatingHours", spec.rvb[4])
	spec.rvb[4] = math.max(Utils.getNoNil(periodic, 0), 0)
	self:setIsFaultBattery(savegame.xmlFile:getValue(rvbkey .. "#chargelevel", 0))
	
	local keyservice = string.format("%s.%s.%s", savegame.key, g_vehicleBreakdownsModName, "vehicleBreakdowns.vehicleService")
	spec.service[1] = savegame.xmlFile:getValue(keyservice .. "#state", false)
	spec.service[2] = savegame.xmlFile:getValue(keyservice .. "#suspension", false)
	spec.service[3] = savegame.xmlFile:getValue(keyservice .. "#finishday", 0)
	spec.service[4] = savegame.xmlFile:getValue(keyservice .. "#finishhour", 0)
	spec.service[5] = savegame.xmlFile:getValue(keyservice .. "#finishminute", 0)
	spec.service[6] = savegame.xmlFile:getValue(keyservice .. "#amount", 0)
	spec.service[7] = savegame.xmlFile:getValue(keyservice .. "#cost", 0)
	spec.service[8] = savegame.xmlFile:getValue(keyservice .. "#damage", 0)

	local keyrepair = string.format("%s.%s.%s", savegame.key, g_vehicleBreakdownsModName, "vehicleBreakdowns.vehicleRepair")
	spec.repair[1] = savegame.xmlFile:getValue(keyrepair .. "#state", false)
	spec.repair[2] = savegame.xmlFile:getValue(keyrepair .. "#suspension", false)
	spec.repair[3] = savegame.xmlFile:getValue(keyrepair .. "#finishday", 0)
	spec.repair[4] = savegame.xmlFile:getValue(keyrepair .. "#finishhour", 0)
	spec.repair[5] = savegame.xmlFile:getValue(keyrepair .. "#finishminute", 0)
	spec.repair[6] = savegame.xmlFile:getValue(keyrepair .. "#amount", 0)
	spec.repair[7] = savegame.xmlFile:getValue(keyrepair .. "#cost", 0)
	spec.repair[8] = savegame.xmlFile:getValue(keyrepair .. "#damage", 0)
	spec.repair[9] = savegame.xmlFile:getValue(keyrepair .. "#factor", 0)
	spec.repair[10] = savegame.xmlFile:getValue(keyrepair .. "#inspection", false)
	
	local keyinspection = string.format("%s.%s.%s", savegame.key, g_vehicleBreakdownsModName, "vehicleBreakdowns.vehicleInspection")
	spec.inspection[1] = savegame.xmlFile:getValue(keyinspection .. "#state", false)
	spec.inspection[2] = savegame.xmlFile:getValue(keyinspection .. "#suspension", false)
	spec.inspection[3] = savegame.xmlFile:getValue(keyinspection .. "#finishday", 0)
	spec.inspection[4] = savegame.xmlFile:getValue(keyinspection .. "#finishhour", 0)
	spec.inspection[5] = savegame.xmlFile:getValue(keyinspection .. "#finishminute", 0)
	spec.inspection[6] = savegame.xmlFile:getValue(keyinspection .. "#cost", 0)
	spec.inspection[7] = savegame.xmlFile:getValue(keyinspection .. "#factor", 0)
	spec.inspection[8] = savegame.xmlFile:getValue(keyinspection .. "#inspection", false)

	if spec.inspection[1] or spec.service[1] or spec.repair[1] then
		local RVB = g_currentMission.vehicleBreakdowns

		-- ha még nincs benne a jármű, hozzáadjuk
		if not RVB.workshopVehicles[self] then
			RVB.workshopVehicles[self] = true
			RVB.workshopCount = RVB.workshopCount + 1
			WorkshopCount_Event.sendEvent(RVB.workshopCount)
		end
	end
	
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings

	
	if self.isServer then
        PartManager.loadFromPostLoad(self, savegame)
    end

	--[[if savegame ~= nil and savegame.resetVehicles then
		--print("onPostLoad " .. self:getFullName() .. " " .. tostring(savegame.resetVehicles))
		for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
			local part = spec.parts[key]
			--g_resetVehiclesRVB[self] = nil
			print(string.format("Part %d: %s, Lifetime: %s, Operating Hours: %s, Repair Required: %s, Amount: %s, Cost: %s",
			i, part.name, part.lifetime, part.operatingHours, tostring(part.repairreq), part.amount, part.cost))
		end
	end]]

	local i = 0
	local xmlFile = savegame.xmlFile
	local key = string.format("%s.%s.vehicleBreakdowns.serviceManual", savegame.key, g_vehicleBreakdownsModName)
    while true do
		local entryKey = string.format("%s.entry(%d)", key, i)
		if not xmlFile:hasProperty(entryKey) then
			break
		end
		local entry = {
			entryType      = xmlFile:getValue(entryKey .. "#entryType", 0),
			entryTime      = xmlFile:getValue(entryKey .. "#entryTime", 0),
			operatingHours = xmlFile:getValue(entryKey .. "#operatingHours", 0),
			odometer       = xmlFile:getValue(entryKey .. "#odometer", 0),
			result         = xmlFile:getValue(entryKey .. "#result", ""),
			cost           = xmlFile:getValue(entryKey .. "#cost", 0)
		}
        table.insert(spec.serviceManual, entry)
        i = i + 1
    end

	if spec.totalRepairTime == nil then
        spec.totalRepairTime = 0.0
    end
	
		
		
		
if self.isServer then




	local i = 0
	local xmlFile = savegame.xmlFile
	while true do
		local key = string.format("%s.fillUnit.unit(%d)", savegame.key, i)
		if not xmlFile:hasProperty(key) then
			break
		end

		local fillTypeName = xmlFile:getValue(key.."#fillType")
		if fillTypeName == "BATTERYCHARGE" then
			local fillUnitIndex = xmlFile:getValue(key.."#index")
			--print("fillUnitIndex "..fillUnitIndex)
			local fillLevel = xmlFile:getValue(key.."#fillLevel", 100)
			if self.isClient then
		--	print("fillLevel "..fillLevel)
			end
		--	self.spec_fillUnit.fillUnits[fillUnitIndex].fillLevel = fillLevel
		--	spec.RVB_BatteryFillLevel = fillLevel
			--self:raiseDirtyFlags(spec.dirtyFlag)
		end	

		i = i + 1
	end
	
	
	
	
	
end
	
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	--print("onPostLoad " .. self:getFullName() .. GSET.difficulty)
	--g_messageCenter:publish(MessageType.SET_DIFFICULTY, GSET.difficulty)
	--print("onPostLoad END")



end



function VehicleBreakdowns:addServiceManualEntry(vehicle, entry)
	local spec = vehicle.spec_faultData
	table.insert(spec.serviceManual, 1, entry)
	RVBserviceManual_Event.sendEvent(vehicle, entry)
end

function VehicleBreakdowns:SyncClientServer_serviceManual(entry)
	local spec = self.spec_faultData
	table.insert(spec.serviceManual, 1, entry)
	
	if self.isServer then
		--g_currentMission:addMoney(-entry.cost, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
	end
end


function VehicleBreakdowns:getServiceManualEntry(vehicle)
	local spec = vehicle.spec_faultData
	return spec.serviceManual
end

function VehicleBreakdowns.SyncClientServer_Other(vehicle, batteryCHActive)
	local spec = vehicle.spec_faultData
	spec.batteryCHActive = batteryCHActive
end

function VehicleBreakdowns.SyncClientServer_RVB(vehicle, general)
	local spec = vehicle.spec_faultData
	spec.rvb = general

	--vehicle:raiseDirtyFlags(spec.rvbdirtyFlag)

	if vehicle:getIsSynchronized() then
    end
end

function VehicleBreakdowns.SyncClientServer_RVBFaultStorage(vehicle, b1, b2)
	local spec = vehicle.spec_faultData
	spec.faultStorage = spec.faultStorage or {}
	spec.faultStorage[1] = b1
    spec.faultStorage[2] = b2
--	vehicle:raiseDirtyFlags(spec.dirtyFlag)
	if vehicle:getIsSynchronized() then
    end
end





function VehicleBreakdowns:SyncClientServer_RVBStartService(yes)
	local spec = self.spec_faultData
	spec.isServiceActive = yes
	--self:raiseDirtyFlags(spec.dirtyFlag)
	if g_server ~= nil then
            --print("SERVER: SyncClientServer_RVBStartService "..tostring(spec.isServiceActive))
        else
            --print("CLIENT: SyncClientServer_RVBStartService "..tostring(spec.isServiceActive))
        end

end


function VehicleBreakdowns.SyncClientServer_RVBBattery(vehicle, b1, b2, b3, b4, b5, b6, b7)
    local spec = vehicle.spec_faultData
    spec.battery = spec.battery or {}
    spec.battery[1] = b1
    spec.battery[2] = b2
    spec.battery[3] = b3
    spec.battery[4] = b4
    spec.battery[5] = b5
    spec.battery[6] = b6
    spec.battery[7] = b7
--	vehicle:raiseDirtyFlags(spec.dirtyFlag)
    if vehicle:getIsSynchronized() then
    end
end


function VehicleBreakdowns.SyncClientServer_RVBParts(vehicle, parts)
    local spec = vehicle.spec_faultData
    spec.parts = parts
    vehicle:raiseDirtyFlags(spec.dirtyFlag)
end


function VehicleBreakdowns.SyncClientServer_BatteryChargeLevel(vehicle, level)
	local spec = vehicle.spec_faultData
	spec.RVB_BatteryFillLevel = level
end

function VehicleBreakdowns:onReadStream(streamId, connection)

	local spec = self.spec_faultData
	if spec == nil then return end

	spec.rvb = {
        streamReadInt16(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId)
    }

	spec.inspection = {
        streamReadBool(streamId),
        streamReadBool(streamId),
        streamReadInt16(streamId),
        streamReadInt16(streamId),
        streamReadInt16(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadBool(streamId)
    }

	spec.service = {
        streamReadBool(streamId),
        streamReadBool(streamId),
        streamReadInt16(streamId),
        streamReadInt16(streamId),
        streamReadInt16(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadInt16(streamId)
    }

	spec.repair = {
        streamReadBool(streamId),
        streamReadBool(streamId),
        streamReadInt16(streamId),
        streamReadInt16(streamId),
        streamReadInt16(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadFloat32(streamId),
        streamReadBool(streamId)
    }

	local count = streamReadInt32(streamId)
	for i = 1, count do
		local key = streamReadString(streamId)
		local part = {
			name            = streamReadString(streamId),
			lifetime        = streamReadInt16(streamId),
			tmp_lifetime    = streamReadInt16(streamId),
			operatingHours  = streamReadFloat32(streamId),
			repairreq       = streamReadBool(streamId),
			prefault        = streamReadString(streamId),
			fault           = streamReadString(streamId),
			cost            = streamReadFloat32(streamId),
			damaged         = streamReadBool(streamId),
			runOncePerStart = streamReadBool(streamId)
		}
		spec.parts[key] = part
	end

	spec.serviceManual = {}
	local count = streamReadInt32(streamId) or 0
    for i=1, count do
        local entry = {
            entryType = streamReadInt16(streamId),
            entryTime = streamReadInt16(streamId),
            operatingHours = streamReadFloat32(streamId),
            odometer = streamReadFloat32(streamId),
            result = streamReadString(streamId),
            cost = streamReadFloat32(streamId)
        }
        table.insert(spec.serviceManual, entry)
    end
	
	spec.RVB_BatteryFillLevel = streamReadFloat32(streamId)
	spec.batteryFillUnitIndex = streamReadInt16(streamId)
	
	--VehicleBreakdowns.GSET_Change_difficulty = streamReadInt16(streamId)
	--VehicleBreakdowns.FSSET_Daysperiod = streamReadInt16(streamId)
	--VehicleBreakdowns.FSSET_Daysperiod = streamReadUIntN(streamId, 5)
	
	--if not connection:getIsServer() then
	if connection:getIsServer() then
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	g_messageCenter:publish(MessageType.SET_DIFFICULTY, GSET.difficulty)
	end
end

function VehicleBreakdowns:onWriteStream(streamId, connection)
	
	local spec = self.spec_faultData
	if spec == nil then return end
	
	streamWriteInt16(streamId, spec.rvb[1])
	streamWriteFloat32(streamId, spec.rvb[2])
	streamWriteFloat32(streamId, spec.rvb[3])
	
	streamWriteFloat32(streamId, spec.rvb[4])
	streamWriteFloat32(streamId, spec.rvb[5])

	streamWriteBool(streamId, spec.inspection[1])
	streamWriteBool(streamId, spec.inspection[2])
	streamWriteInt16(streamId, spec.inspection[3])
	streamWriteInt16(streamId, spec.inspection[4])
	streamWriteInt16(streamId, spec.inspection[5])
	streamWriteFloat32(streamId, spec.inspection[6])
	streamWriteFloat32(streamId, spec.inspection[7])
	streamWriteBool(streamId, spec.inspection[8])

	streamWriteBool(streamId, spec.service[1])
	streamWriteBool(streamId, spec.service[2])
	streamWriteInt16(streamId, spec.service[3])
	streamWriteInt16(streamId, spec.service[4])
	streamWriteInt16(streamId, spec.service[5])
	streamWriteFloat32(streamId, spec.service[6])
	streamWriteFloat32(streamId, spec.service[7])
	streamWriteInt16(streamId, spec.service[8])

	streamWriteBool(streamId, spec.repair[1])
	streamWriteBool(streamId, spec.repair[2])
	streamWriteInt16(streamId, spec.repair[3])
	streamWriteInt16(streamId, spec.repair[4])
	streamWriteInt16(streamId, spec.repair[5])
	streamWriteFloat32(streamId, spec.repair[6])
	streamWriteFloat32(streamId, spec.repair[7])
	streamWriteFloat32(streamId, spec.repair[8])
	streamWriteFloat32(streamId, spec.repair[9])
	streamWriteBool(streamId, spec.repair[10])

	streamWriteInt32(streamId, table.count(spec.parts))
	for key, part in pairs(spec.parts) do
		streamWriteString(streamId, key)
		streamWriteString(streamId, part.name)
		streamWriteInt16(streamId, part.lifetime)
		streamWriteInt16(streamId, part.tmp_lifetime)
		streamWriteFloat32(streamId, part.operatingHours)
		streamWriteBool(streamId, part.repairreq)
		streamWriteString(streamId, part.prefault)
		streamWriteString(streamId, part.fault)
		streamWriteFloat32(streamId, part.cost)
		streamWriteBool(streamId, part.damaged)
		streamWriteBool(streamId, part.runOncePerStart)
	end

	local count = #spec.serviceManual
    streamWriteInt32(streamId, count)
    for i=1, count do
        local entry = spec.serviceManual[i]
        streamWriteInt16(streamId, entry.entryType or 0)
        streamWriteInt16(streamId, entry.entryTime or 0)
        streamWriteFloat32(streamId, entry.operatingHours or 0)
        streamWriteFloat32(streamId, entry.odometer or 0)
        streamWriteString(streamId, entry.result or "")
        streamWriteFloat32(streamId, entry.cost or 0)
    end
	
	streamWriteFloat32(streamId, spec.RVB_BatteryFillLevel)
	streamWriteInt16(streamId, spec.batteryFillUnitIndex)
	
	--streamWriteInt16(streamId, VehicleBreakdowns.GSET_Change_difficulty)
	--streamWriteInt16(streamId, VehicleBreakdowns.FSSET_Daysperiod)
	--streamWriteUIntN(streamId, VehicleBreakdowns.FSSET_Daysperiod, 5)

end

function VehicleBreakdowns:onReadUpdateStream(streamId, timestamp, connection)

	--if connection:getIsServer() then
	if connection.isServer then

		local spec = self.spec_faultData
		if spec == nil then return end

		if streamReadBool(streamId) then
			spec.rvb = {
				streamReadInt16(streamId),
				streamReadFloat32(streamId),
				streamReadFloat32(streamId),
				streamReadFloat32(streamId),
				streamReadFloat32(streamId)
			}
		end

		if streamReadBool(streamId) then
			local count = streamReadInt32(streamId)
			for i = 1, count do
				local key = streamReadString(streamId)
				local part = {
					name            = streamReadString(streamId),
					lifetime        = streamReadInt16(streamId),
					tmp_lifetime    = streamReadInt16(streamId),
					operatingHours  = streamReadFloat32(streamId),
					repairreq       = streamReadBool(streamId),
					prefault        = streamReadString(streamId),
					fault           = streamReadString(streamId),
					cost            = streamReadFloat32(streamId),
					damaged         = streamReadBool(streamId),
					runOncePerStart = streamReadBool(streamId)
				}
				spec.parts[key] = part
			end
		end
		
		if streamReadBool(streamId) then
			spec.motorTemperature = streamReadFloat32(streamId)
			spec.fanEnabled = streamReadBool(streamId)
			spec.fanEnableTemperature = streamReadFloat32(streamId)
			spec.fanDisableTemperature = streamReadFloat32(streamId)
			spec.lastFuelUsage = streamReadFloat32(streamId)
			spec.lastDefUsage = streamReadFloat32(streamId)
			spec.lastAirUsage = streamReadFloat32(streamId)
			spec.lastDieselFuelUsage = streamReadFloat32(streamId)
		end
		
		spec.RVB_BatteryFillLevel = streamReadFloat32(streamId)
		spec.batteryFillUnitIndex = streamReadInt16(streamId)
		
		--VehicleBreakdowns.GSET_Change_difficulty = streamReadInt16(streamId)
		--VehicleBreakdowns.FSSET_Daysperiod = streamReadInt16(streamId)
		--VehicleBreakdowns.FSSET_Daysperiod = streamReadUIntN(streamId, 5)

	end

end


function VehicleBreakdowns:onWriteUpdateStream(streamId, connection, dirtyMask)
	--if not connection:getIsServer() then
	if not connection.isServer then
	
		local spec = self.spec_faultData
		if spec == nil then return end
	
		if streamWriteBool(streamId, bit32.band(dirtyMask, spec.rvbdirtyFlag) ~= 0) then
			streamWriteInt16(streamId, spec.rvb[1])
			streamWriteFloat32(streamId, spec.rvb[2])
			streamWriteFloat32(streamId, spec.rvb[3])
			streamWriteFloat32(streamId, spec.rvb[4])
			streamWriteFloat32(streamId, spec.rvb[5])
		end

		if streamWriteBool(streamId, bit32.band(dirtyMask, spec.partsDirtyFlag) ~= 0) then
			streamWriteInt32(streamId, table.count(spec.parts))
			for key, part in pairs(spec.parts) do
				streamWriteString(streamId, key)
				streamWriteString(streamId, part.name)
				streamWriteInt16(streamId, part.lifetime)
				streamWriteInt16(streamId, part.tmp_lifetime)
				streamWriteFloat32(streamId, part.operatingHours)
				streamWriteBool(streamId, part.repairreq)
				streamWriteString(streamId, part.prefault)
				streamWriteString(streamId, part.fault)
				streamWriteFloat32(streamId, part.cost)
				streamWriteBool(streamId, part.damaged)
				streamWriteBool(streamId, part.runOncePerStart)
			end
		end
		
		if streamWriteBool(streamId, bit32.band(dirtyMask, spec.motorizedDirtyFlag) ~= 0) then
			streamWriteFloat32(streamId, spec.motorTemperature)
			streamWriteBool(streamId, spec.fanEnabled)
			streamWriteFloat32(streamId, spec.fanEnableTemperature)
			streamWriteFloat32(streamId, spec.fanDisableTemperature)
			streamWriteFloat32(streamId, spec.lastFuelUsage)
			streamWriteFloat32(streamId, spec.lastDefUsage)
			streamWriteFloat32(streamId, spec.lastAirUsage)
			streamWriteFloat32(streamId, spec.lastDieselFuelUsage)
		
			self.spec_motorized.motorTemperature.valueSend = spec.motorTemperature
			self.spec_motorized.motorFan.enabled = spec.fanEnabled
			self.spec_motorized.motorFan.enableTemperature = spec.fanEnableTemperature
			self.spec_motorized.motorFan.disableTemperature = spec.fanDisableTemperature
		end
		
		streamWriteFloat32(streamId, spec.RVB_BatteryFillLevel)
		streamWriteInt16(streamId, spec.batteryFillUnitIndex)
		
		--if streamWriteBool(streamId, bit32.band(dirtyMask, spec.lifetimeDirtyFlag) ~= 0) then
			--streamWriteInt16(streamId, VehicleBreakdowns.GSET_Change_difficulty)
			--streamWriteInt16(streamId, VehicleBreakdowns.FSSET_Daysperiod)
			--streamWriteUIntN(streamId, VehicleBreakdowns.FSSET_Daysperiod, 5)
		--end

	end
end

function VehicleBreakdowns:saveToXMLFile(xmlFile, key, usedModNames)
	local spec = self.spec_faultData
	
	xmlFile:setValue(key .. "#isrvbSpecEnabled", spec.isrvbSpecEnabled)
	xmlFile:setValue(key .. "#timeScale", spec.rvb[1])
	xmlFile:setValue(key .. "#operatingHoursTemp", self:getIsOperatingHoursTemp() / 1000)
	xmlFile:setValue(key .. "#TotaloperatingHours", spec.rvb[3])
	
	xmlFile:setValue(key .. "#operatingHours", spec.rvb[4])
	xmlFile:setValue(key .. "#chargelevel", self:getIsFaultBattery())
	
	xmlFile:setValue(key .. ".vehicleService#state", spec.service[1])
	xmlFile:setValue(key .. ".vehicleService#suspension", spec.service[2])
	xmlFile:setValue(key .. ".vehicleService#finishday", spec.service[3])
	xmlFile:setValue(key .. ".vehicleService#finishhour", spec.service[4])
	xmlFile:setValue(key .. ".vehicleService#finishminute", spec.service[5])
	xmlFile:setValue(key .. ".vehicleService#amount", spec.service[6])
	xmlFile:setValue(key .. ".vehicleService#cost", spec.service[7])
	xmlFile:setValue(key .. ".vehicleService#damage", spec.service[8])
		
	xmlFile:setValue(key .. ".vehicleRepair#state", spec.repair[1])
	xmlFile:setValue(key .. ".vehicleRepair#suspension", spec.repair[2])
	xmlFile:setValue(key .. ".vehicleRepair#finishday", spec.repair[3])
	xmlFile:setValue(key .. ".vehicleRepair#finishhour", spec.repair[4])
	xmlFile:setValue(key .. ".vehicleRepair#finishminute", spec.repair[5])
	xmlFile:setValue(key .. ".vehicleRepair#amount", spec.repair[6])
	xmlFile:setValue(key .. ".vehicleRepair#cost", spec.repair[7])
	xmlFile:setValue(key .. ".vehicleRepair#damage", spec.repair[8])
	xmlFile:setValue(key .. ".vehicleRepair#factor", spec.repair[9])
	xmlFile:setValue(key .. ".vehicleRepair#inspection", spec.repair[10])
	
	xmlFile:setValue(key .. ".vehicleInspection#state", spec.inspection[1])
	xmlFile:setValue(key .. ".vehicleInspection#suspension", spec.inspection[2])
	xmlFile:setValue(key .. ".vehicleInspection#finishday", spec.inspection[3])
	xmlFile:setValue(key .. ".vehicleInspection#finishhour", spec.inspection[4])
	xmlFile:setValue(key .. ".vehicleInspection#finishminute", spec.inspection[5])
	xmlFile:setValue(key .. ".vehicleInspection#cost", spec.inspection[6])
	xmlFile:setValue(key .. ".vehicleInspection#factor", spec.inspection[7])
	xmlFile:setValue(key .. ".vehicleInspection#inspection", spec.inspection[8])

	PartManager.savePartsToXML(self, xmlFile, key)

	local manual = spec.serviceManual
    if manual then
		local i = 0
		for i, entry in ipairs(manual) do
			local manualKey = string.format("%s.serviceManual.entry(%d)", key, i - 1)
			xmlFile:setValue(manualKey.."#entryType", entry.entryType)
			xmlFile:setValue(manualKey.."#entryTime", entry.entryTime)
			xmlFile:setValue(manualKey.."#operatingHours", entry.operatingHours)
			xmlFile:setValue(manualKey.."#odometer", entry.odometer)
			xmlFile:setValue(manualKey.."#result", entry.result)
			xmlFile:setValue(manualKey.."#cost", entry.cost)
        end
    end
	
end

function VehicleBreakdowns.onRegisterActionEvents(self, _, isActiveForInputIgnoreSelection)
	if self.isClient and (self.getIsEntered and self:getIsEntered()) then
		local spec = self.spec_lights
		self:clearActionEventsTable(spec.actionEvents)
		local rvbToggleLights, rvbToggleLightsBack, rvbToggleLightFront, rvbToggleWorkLightBack, rvbToggleWorkLightFront, rvbToggleHighBeamLight
		local rvbToggleBeaconLights, rvbToggleTurnLightHazard, rvbToggleTurnLightLeft, rvbToggleTurnLightRight
		if self.getIsFaultBattery then
			if self:getIsFaultBattery() > BATTERY_LEVEL.LIGHTS then
				rvbToggleLights = Lights.actionEventToggleLights
				rvbToggleLightsBack = Lights.actionEventToggleLightsBack
				rvbToggleLightFront = Lights.actionEventToggleLightFront
				rvbToggleWorkLightBack = Lights.actionEventToggleWorkLightBack
				rvbToggleWorkLightFront = Lights.actionEventToggleWorkLightFront
				rvbToggleHighBeamLight = Lights.actionEventToggleHighBeamLight
				rvbToggleBeaconLights = Lights.actionEventToggleBeaconLights
				rvbToggleTurnLightHazard = Lights.actionEventToggleTurnLightHazard
				rvbToggleTurnLightLeft = Lights.actionEventToggleTurnLightLeft
				rvbToggleTurnLightRight = Lights.actionEventToggleTurnLightRight
			elseif self:getIsFaultBattery() <= BATTERY_LEVEL.LIGHTS and self:getIsFaultBattery() > BATTERY_LEVEL.LIGHTS_BEACONS then
				rvbToggleLights = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleLightsBack = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleLightFront = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleWorkLightBack = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleWorkLightFront = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleHighBeamLight = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleBeaconLights = Lights.actionEventToggleBeaconLights
				rvbToggleTurnLightHazard = Lights.actionEventToggleTurnLightHazard
				rvbToggleTurnLightLeft = Lights.actionEventToggleTurnLightLeft
				rvbToggleTurnLightRight = Lights.actionEventToggleTurnLightRight
			elseif self:getIsFaultBattery() <= BATTERY_LEVEL.LIGHTS_BEACONS then
				rvbToggleLights = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleLightsBack = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleLightFront = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleWorkLightBack = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleWorkLightFront = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleHighBeamLight = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleBeaconLights = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleTurnLightHazard = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleTurnLightLeft = VehicleBreakdowns.actionToggleLightsFault
				rvbToggleTurnLightRight = VehicleBreakdowns.actionToggleLightsFault
			end
		end
		if self.getIsFaultLightings and self:getIsFaultLightings() then
			rvbToggleLights = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleLightsBack = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleLightFront = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleWorkLightBack = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleWorkLightFront = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleHighBeamLight = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleBeaconLights = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleTurnLightHazard = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleTurnLightLeft = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleTurnLightRight = VehicleBreakdowns.actionToggleLightsFault
		end
		if self:getIsInspection() or self:getIsRepair() or self:getIsService() then
			rvbToggleLights = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleLightsBack = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleLightFront = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleWorkLightBack = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleWorkLightFront = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleHighBeamLight = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleBeaconLights = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleTurnLightHazard = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleTurnLightLeft = VehicleBreakdowns.actionToggleLightsFault
			rvbToggleTurnLightRight = VehicleBreakdowns.actionToggleLightsFault
		end
		if isActiveForInputIgnoreSelection then
			local _, actionEventIdLight = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_LIGHTS, self, rvbToggleLights, false, true, false, true, nil)
			spec.actionEventIdLight = actionEventIdLight
			local _, actionEventIdReverse = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_LIGHTS_BACK, self, rvbToggleLightsBack, false, true, false, true, nil)
			local _, actionEventIdFront = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_LIGHT_FRONT, self, rvbToggleLightFront, false, true, false, true, nil)
			local _, actionEventIdWorkBack = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_WORK_LIGHT_BACK, self, rvbToggleWorkLightBack, false, true, false, true, nil)
			local _, actionEventIdWorkFront = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_WORK_LIGHT_FRONT, self, rvbToggleWorkLightFront, false, true, false, true, nil)
			local _, actionEventIdHighBeam = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_HIGH_BEAM_LIGHT, self, rvbToggleHighBeamLight, false, true, false, true, nil)
			self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_TURNLIGHT_HAZARD, self, rvbToggleTurnLightHazard, false, true, false, true, nil)
			self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_TURNLIGHT_LEFT, self, rvbToggleTurnLightLeft, false, true, false, true, nil)
			self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_TURNLIGHT_RIGHT, self, rvbToggleTurnLightRight, false, true, false, true, nil)
			local _, actionEventIdBeacon = self:addActionEvent(spec.actionEvents, InputAction.TOGGLE_BEACON_LIGHTS, self, rvbToggleBeaconLights, false, true, false, true, nil)
			spec.actionEventsActiveChange = {
				actionEventIdFront,
				actionEventIdWorkBack,
				actionEventIdWorkFront,
				actionEventIdHighBeam,
				actionEventIdBeacon
			}
			for _, actionEvent in pairs(spec.actionEvents) do
				if actionEvent.actionEventId ~= nil then
				--print("actionEvent.actionEventId "..actionEvent.actionEventId)
					g_inputBinding:setActionEventTextVisibility(actionEvent.actionEventId, false)
					g_inputBinding:setActionEventTextPriority(actionEvent.actionEventId, GS_PRIO_LOW)
				end
			end
			g_inputBinding:setActionEventTextVisibility(spec.actionEventIdLight, not g_currentMission.environment.isSunOn)
			g_inputBinding:setActionEventTextVisibility(actionEventIdReverse, false)
		end


		if self.spec_faultData == nil then return end
		local spec = self.spec_faultData
		if spec.actionEvents == nil then spec.actionEvents = {} end
		self:clearActionEventsTable(spec.actionEvents)
		if isActiveForInputIgnoreSelection then
			local set, actionEventIdSet = self:addActionEvent(spec.actionEvents, InputAction.VEHICLE_BREAKDOWN_MENU, self, VehicleBreakdowns.RVBMenu, true, true, false, true, nil)
			if set then
				g_inputBinding:setActionEventTextPriority(actionEventIdSet, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventTextVisibility(actionEventIdSet, true)
				g_inputBinding:setActionEventActive(actionEventIdSet, true)
			end
			local setSpec, actionEventIdSetSpec = self:addActionEvent(spec.actionEvents, InputAction.RVB_SPEC, self, VehicleBreakdowns.RVBSpec, false, true, false, true, nil)
			if setSpec then
				g_inputBinding:setActionEventTextPriority(actionEventIdSetSpec, GS_PRIO_VERY_HIGH)
				g_inputBinding:setActionEventTextVisibility(actionEventIdSetSpec, true)
				g_inputBinding:setActionEventActive(actionEventIdSetSpec, true)
			end

			--VehicleBreakdowns.updateActionEvents(self)
		end
	end
end

function VehicleBreakdowns.updateActionEvents(self)
	local spec = self.spec_faultData
	if spec.actionEvents == nil then spec.actionEvents = {} end
	local actionEventJS = spec.actionEvents[InputAction.RVB_JUMPSTARTOFF]
	local vehiclesConnecting = g_rvbPlayer:areJumperCablesConnected()
	if not vehiclesConnecting and spec.isJumpStarting then spec.isJumpStarting = false end
	if actionEventJS ~= nil then
		local text
		g_inputBinding:setActionEventTextVisibility(actionEventJS.actionEventId, vehiclesConnecting)
		if spec.isJumpStarting then
			text = g_i18n:getText("action_RVB_JUMPSTARTON")
		else
			text = g_i18n:getText("input_RVB_JUMPSTARTOFF")
		end
		g_inputBinding:setActionEventActive(actionEventJS.actionEventId, true)
		g_inputBinding:setActionEventTextPriority(actionEventJS.actionEventId, GS_PRIO_VERY_HIGH)
		g_inputBinding:setActionEventText(actionEventJS.actionEventId, text)
	end
end


function VehicleBreakdowns:RVBMenu()
	local rvb = self.spec_faultData
	if not rvb.isrvbSpecEnabled then
        return
    end
	if not self.isClient then
      return
    end
    if not g_currentMission.isSynchronizingWithPlayers then
      if not g_gui:getIsGuiVisible() then
        g_gui:showDialog("RVBMenu")
      end
    end
end
function VehicleBreakdowns:RVBSpec()
	if not self.isClient then
      return
    end
    --if not g_currentMission.isSynchronizingWithPlayers then print("RVBSpec isSynchronizingWithPlayers")
		local rvb = self.spec_faultData
		if rvb.isrvbSpecEnabled then
			rvb.isrvbSpecEnabled = false --print("RVB engedélyezve volt, tiltva lett")
		else
			rvb.isrvbSpecEnabled = true --print("RVB tiltva volt, engedélyezve lett")
		end
    --end
end


function VehicleBreakdowns:actionToggleLightsFault(actionName, inputValue, callbackState, isAnalog)
	local rvb = self.spec_faultData
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	local lightsText
	if actionName == InputAction.TOGGLE_LIGHTS then
		if not self:getIsFaultLightings() then
			--if self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS then
				lightsText = "RVB_fault_BHlights"
			--end
		else
			lightsText = "RVB_fault_lights"
		end
	elseif actionName == InputAction.TOGGLE_HIGH_BEAM_LIGHT then
		if not self:getIsFaultLightings() then
			--if self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS then
				lightsText = "RVB_fault_BHlights"
			--end
		else
			lightsText = "RVB_fault_lights"
		end
	elseif actionName == InputAction.TOGGLE_BEACON_LIGHTS then
		if not self:getIsFaultLightings() then
			--if self:getIsFaultBattery() ~= 0 and self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS_BEACONS then
				lightsText = "RVB_fault_BHlights"
			--end
		else
			lightsText = "RVB_fault_lights"
		end
	elseif actionName == InputAction.TOGGLE_BEACON_LIGHTS then
		if not self:getIsFaultLightings() then
			--if self:getIsFaultBattery() ~= 0 and self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS_BEACONS then
				lightsText = "RVB_fault_BHlights"
			--end
		else
			lightsText = "RVB_fault_lights"
		end
	end
	if self:getIsInspection() then
		lightsText = "RVB_fault_lights_INSPECTION"
	elseif self:getIsRepair() then
		lightsText = "RVB_fault_lights_REPAIR"
	elseif self:getIsService() then
		lightsText = "RVB_fault_lights_SERVICE"
	elseif not self:getIsFaultLightings() then
		lightsText = "RVB_fault_BHlights"
	else
		lightsText = "RVB_fault_lights"
	end
	if GSET.alertmessage then
		if self.getIsEntered and self:getIsEntered() then
			g_currentMission:showBlinkingWarning(g_i18n:getText(lightsText), 2500)
		else
		--	g_currentMission.hud:addSideNotification(VehicleBreakdowns.INGAME_NOTIFICATION, string.format(g_i18n:getText("RVB_fault_lights_hud"), self:getFullName()), 5000)
		end
	end
end
	
function VehicleBreakdowns:lightingsFault()
	if self:getIsFaultLightings() or self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS then
		self:setLightsTypesMask(0, true, true)
	end
	if self:getIsFaultBattery() < BATTERY_LEVEL.LIGHTS_BEACONS then
		self:setBeaconLightsVisibility(false, true, true)
		self:setTurnLightState(Lights.TURNLIGHT_OFF, true, true)
	end
end
function VehicleBreakdowns.StopAI(self)
    local rootVehicle = self.rootVehicle
    if rootVehicle ~= nil and rootVehicle:getIsAIActive() then
        rootVehicle:stopCurrentAIJob(AIMessageErrorVehicleBroken.new())
    end
end

function VehicleBreakdowns:onSetPartsLifetime(partsName, partsLifetime)
	--print("DEBUG: onSetPartsLifetime called! " .. partsName, partsLifetime)
    local GSET = g_currentMission.vehicleBreakdowns.generalSettings
    local daysPerPeriod = g_currentMission.environment.plannedDaysPerPeriod
    for _, vehicle in ipairs(g_currentMission.vehicleSystem.vehicles) do
        if vehicle.spec_faultData then
            local part = vehicle.spec_faultData.parts[partsName]
            if part and part.lifetime ~= partsLifetime then
                part.lifetime = partsLifetime
                if GSET.difficulty == 1 then
                    part.tmp_lifetime = part.lifetime * 2 * daysPerPeriod
                elseif GSET.difficulty == 2 then
                    part.tmp_lifetime = part.lifetime * 1 * daysPerPeriod
                else
                    part.tmp_lifetime = part.lifetime / 2 * daysPerPeriod
                end
                --Logging.info("[RVB] Updated %s lifetime to %s on %s", partsName, partsLifetime, vehicle:getFullName())
				self.rvbDebugger:info("Updated %s lifetime to %s on %s", partsName, partsLifetime, vehicle:getFullName())
				if self.isServer then
					--vehicle:raiseDirtyFlags(vehicle.spec_faultData.partsDirtyFlag)
				end
				RVBParts_Event.sendEvent(vehicle, vehicle.spec_faultData.parts)
            end
        end
    end
end


function VehicleBreakdowns:onStartWiperOperatingHours(dt)
	local spec = self.spec_faultData
	local lastRainScale = g_currentMission.environment.weather:getRainFallScale()
	local wipersOk = self.getIsActiveForWipers and self:getIsActiveForWipers()
	if wipersOk and lastRainScale > 0.01 then
		spec.wiperOperatingHoursUpdateTimer = (spec.wiperOperatingHoursUpdateTimer or 0) + dt
		if spec.wiperOperatingHoursUpdateTimer >= RVB_DELAY.WIPERS_OPERATINGHOURS then
			self:updateWiperOperatingHours(spec.wiperOperatingHoursUpdateTimer, spec)
			spec.wiperOperatingHoursUpdateTimer = 0
		end
		self:raiseActive()
	end
end
function VehicleBreakdowns:updateWiperOperatingHours(msDelta, spec)
	local oneGameHour = 1000 * 60 * 60
	local runtimeIncrease = msDelta * g_currentMission.missionInfo.timeScale / oneGameHour
	local part = spec.parts[WIPERS]
	part.operatingHours = math.min(part.operatingHours + runtimeIncrease, part.tmp_lifetime)
	if self.isServer then
		self:raiseDirtyFlags(spec.partsDirtyFlag)
	end
end
--[[
Növelje az ablaktörlő üzemidejét
Amikor a motor jár
Ha az ablaktörlő működik és esik az eső
Increase wiper operating hours
When the engine is running
If the wiper is working and it is raining
]]






--[[
	Növelje a világítás üzemidejét
	Amikor ég a lámpa
	A világítás működik
	Az akkumulátor működik és a töltési szint megfelelő
	Increase the operating hours of the lighting
	When the light is on
	Lighting is working
	The battery is working and the charge level is adequate
]]
function VehicleBreakdowns:onStartLightingsOperatingHours(dt, isActiveForInputIgnoreSelection)
	local spec = self.spec_faultData
	local parts = spec.parts
	local batteryOk = self:getIsFaultBattery() >= BATTERY_LEVEL.LIGHTS

    local specLights = self.spec_lights
  
    if self.isClient and isActiveForInputIgnoreSelection then
		--g_currentMission:addExtraPrintText("lightsTypesMask: "..self:getLightsTypesMask())
        local mask = specLights.lightsTypesMask or 0
        if specLights ~= nil then
            local isOn = specLights.lightsState ~= Lights.STATE_OFF
            --g_currentMission:addExtraPrintText("Lámpa állapot: " .. tostring(isOn) .. " " .. mask.. " " .. specLights.currentLightState)
        end
	end
	local activeDrain = getLightsDrain(self)
	if activeDrain <= 0 then return end
	--if specLights.currentLightState > 0 and parts[LIGHTINGS].fault == "empty" and parts[BATTERY].fault == "empty" and batteryOk then
	if parts[LIGHTINGS].fault == "empty" and parts[BATTERY].fault == "empty" and batteryOk then
		spec.LightingUpdateTimer = (spec.LightingUpdateTimer or 0) + dt
		if spec.LightingUpdateTimer >= RVB_DELAY.LIGHTINGS_OPERATINGHOURS then
			self:updateLightingOperatingHours(spec.LightingUpdateTimer, spec)
			spec.LightingUpdateTimer = 0
		end
		self:raiseActive()
	end
end
function VehicleBreakdowns:updateLightingOperatingHours(msDelta, spec)
	local oneGameHour = 1000 * 60 * 60
	local runtimeIncrease = msDelta * g_currentMission.missionInfo.timeScale / oneGameHour
	local partLightings = spec.parts[LIGHTINGS]
    --print("runtimeIncrease " .. runtimeIncrease)
	partLightings.operatingHours = math.min(partLightings.operatingHours + runtimeIncrease, partLightings.tmp_lifetime)
	if self.isServer then
		self:raiseDirtyFlags(spec.partsDirtyFlag)
	end
end


function VehicleBreakdowns:setInflationPressure(pressure, dt)
	local spec = self.spec_faultData
--	print("setInflationPressure pressure "..pressure)
	local inflationPressure = math.clamp(pressure, spec.pressureMin, spec.pressureMax)
	--print("setInflationPressure inflationPressure "..inflationPressure)
	--print("setInflationPressure spec.inflationPressure "..spec.inflationPressure)
	if spec.inflationPressure ~= inflationPressure then
		spec.inflationPressure = inflationPressure
		--self:updateInflationPressure()
		local isPlayerInRange = false
		for _, player in pairs(g_currentMission.playerSystem.players) do
			--print("distance "..calcDistanceFrom(self.rootNode, player.rootNode))
			if player.isControlled and calcDistanceFrom(self.rootNode, player.rootNode) < 25 then
				isPlayerInRange = true
				break
			end
		end
		if not isPlayerInRange then
			for _, enterable in pairs(g_currentMission.vehicleSystem.enterables) do
				if enterable.spec_enterable ~= nil and (enterable.spec_enterable.isControlled and calcDistanceFrom(self.rootNode, enterable.rootNode) < 25) then
					isPlayerInRange = true
					break
				end
			end
		end
		if isPlayerInRange then
			self:updateTireDeformation(dt)
		end
        if self.isServer then
    --        self:raiseDirtyFlags(spec.dirtyFlag)
            --spec.inflationPressureSent = inflationPressure
        end
    end
end



function VehicleBreakdowns:updateEngineTorque(isActive)
    -- Ha csak az aktív járműre akarod számolni, hagyd bent, 
    -- ha minden járműre (pl. AI, MP), akkor vedd ki:
    -- if not isActive then return end

    local spec = self.spec_faultData
    local motorized = self.spec_motorized
    if not spec or not motorized or not self:getIsMotorStarted() then
        return
    end

    local partData = spec.parts[ENGINE]
    local registry = FaultRegistry[ENGINE]
    if not partData or not registry or not registry.variants then 
        return 
    end

    -- Prefault előjele → fault valós hiba
    local faultName = (partData.prefault ~= "empty" and partData.prefault) or partData.fault
    if faultName and faultName ~= "empty" then
        local variant = registry.variants[faultName]
        if variant and variant.torqueFactor then
            local progress = 1.0

            -- Ha csak prefault van → progress arányos a küszöbig
            if partData.fault == "empty" and partData.prefault ~= "empty" then
                local partFoot = (partData.operatingHours * 100) / partData.tmp_lifetime
                local diff = math.max(0, registry.breakThreshold - partFoot)
                local maxDiff = 5 -- előhiba -1..-5%-nál jön
                progress = 1 - (diff / maxDiff) -- 0 → gyenge hatás, 1 → teljes hatás
            end

            -- Dinamikus nyomaték számítása
            local dynamicTorque = 1 - ((1 - variant.torqueFactor) * progress)

            -- Csak akkor alkalmazzuk, ha tényleg változott
            if math.abs(dynamicTorque - (spec.lastTorqueFactor or 1)) > 0.01 then
                if self.isServer then
                    applyEngineTorqueModifier(self, dynamicTorque)
                end
                spec.lastTorqueFactor = dynamicTorque
            end

            spec.isTorqueModified = true
            return
        end
    end

    -- Ha nincs sem prefault, sem fault → reset
    if spec.isTorqueModified then
        if self.isServer then
            resetEngineTorque(self)
        end
        spec.isTorqueModified = false
        spec.lastTorqueFactor = nil
    end
end

function VehicleBreakdowns:updateExhaustEffect()
    local spec = self.spec_faultData
    local motorSpec = self.spec_motorized
    if not spec or not motorSpec or not motorSpec.exhaustEffects then return end

    local registry = FaultRegistry[ENGINE]
    local partData = spec.parts[ENGINE]
    if not partData then return end

    local faultName = (partData.prefault ~= "empty" and partData.prefault) or partData.fault
    if not faultName or faultName == "empty" then return end

    local variant = registry.variants[faultName]

    local engineTemp = motorSpec.motorTemperature and motorSpec.motorTemperature.value or MOTORTEMP_THRESHOLD
    local rpm = motorSpec.motor:getEqualizedMotorRpm()
    local maxRpm = motorSpec.motor:getMaxRpm()
    local rpmFactor = rpm / maxRpm

    local progress = 1.0
    if partData.fault == "empty" and partData.prefault ~= "empty" then
        local partFoot = (partData.operatingHours * 100) / partData.tmp_lifetime
        local diff = math.max(0, registry.breakThreshold - partFoot)
        local maxDiff = 5
        progress = 1 - (diff / maxDiff)
    end

    for _, exhaustEffect in ipairs(motorSpec.exhaustEffects) do
        if not exhaustEffect.defaultMinRpmColor then
            exhaustEffect.defaultMinRpmColor = table.clone(exhaustEffect.minRpmColor)
            exhaustEffect.defaultMaxRpmColor = table.clone(exhaustEffect.maxRpmColor)
        end

        local baseMin = variant and variant.exhaustEffect and variant.exhaustEffect.minRpmColor or exhaustEffect.defaultMinRpmColor
        local baseMax = variant and variant.exhaustEffect and variant.exhaustEffect.maxRpmColor or exhaustEffect.defaultMaxRpmColor

        -- Hideg motor → fehéres gőz
        local tempFactor = 1
        if engineTemp < MOTORTEMP_THRESHOLD then
            tempFactor = 0.6 + (engineTemp / MOTORTEMP_THRESHOLD) * 0.3
        elseif engineTemp > 100 then
            tempFactor = 1.1
        end

        local rpmStrength = 0.6 + rpmFactor * 1.4

        local function interpolateColor(baseColor, progress)
			
            local r = baseColor[1] * (0.5 + 0.5 * progress)
            local g = baseColor[2] * (0.5 + 0.5 * progress)
            local b = baseColor[3] * (0.5 + 0.5 * progress)
            local a = baseColor[4] * rpmStrength * progress
			
            return {math.min(r*tempFactor,1), math.min(g*tempFactor,1), math.min(b*tempFactor,1), math.min(a,10)}
        end

		exhaustEffect.minRpmColor = interpolateColor(baseMin, progress)
		exhaustEffect.maxRpmColor = interpolateColor(baseMax, progress)
    end
end


-- Motor túlmelegedés miatti leállás
function VehicleBreakdowns:updateOverheatingFailure(dt)
	local spec = self.spec_faultData
	local motorSpec = self.spec_motorized
	if not spec or not motorSpec or not self:getIsMotorStarted() then
		return
	end
	-- Csak akkor fut, ha tényleg overheating hiba van
	local enginePart = spec.parts[ENGINE]
	if not enginePart or (enginePart.fault ~= "overheating" and enginePart.prefault ~= "overheating") then
		return
	end

	self.overheatingUpdateTimer = (self.overheatingUpdateTimer or 0) + dt
    if self.overheatingUpdateTimer >= RVB_DELAY.OVERHEATING_FAILURE then
        self.overheatingUpdateTimer = 0

		local engineTemp = motorSpec.motorTemperature and motorSpec.motorTemperature.value or 0
		if engineTemp <= 100 then
			return
		end

		-- Minél melegebb, annál nagyobb az esély leállásra
		local shutdownChance = 0
		if engineTemp > 119 then
			shutdownChance = 70
		elseif engineTemp > 110 then
			shutdownChance = 25
		elseif engineTemp > 100 then
			shutdownChance = 5
		end

		if shutdownChance > 0 and math.random(100) <= shutdownChance then
			if self.isServer then
				if self.StopAI then
					self:StopAI(self)
				end
				self:stopMotor()
				print(string.format("[RVB] Motor leállt túlmelegedés miatt! Temp=%.1f°C", engineTemp))
			end
		end
	end
	self:raiseActive()
end
	
	
function VehicleBreakdowns:onUpdatejumperCable(dt, isActiveForInputIgnoreSelection)
	
	local minRadius = JUMPERCABLE_MINRADIUS  -- Figyelmeztetés kezdő távolság
	local maxRadius = JUMPERCABLE_LENGTH -- Kapcsolat megszakításának távolsága
	local boosterVehicle = nil
	if g_rvbPlayer.jumperCableConnections[1] ~= nil then
		boosterVehicle = g_rvbPlayer.jumperCableConnections[1]
	end
	local dischargedVehicle = nil
	if g_rvbPlayer.jumperCableConnections[2] ~= nil then
		dischargedVehicle = g_rvbPlayer.jumperCableConnections[2]
	end
	if boosterVehicle ~= nil and dischargedVehicle == nil then
		local isEntered
		if self.getIsEntered == nil then
			isEntered = false
		else
			isEntered = self:getIsEntered()
		end
		local isControlled
		if self.getIsControlled == nil then
			isControlled = false
		else
			isControlled = self:getIsControlled()
		end
		local playerRootNode
		if not (isEntered or isControlled) then
			playerRootNode = g_localPlayer.rootNode
		else
			if self.rootNode == boosterVehicle.rootNode then
				playerRootNode = self.rootNode
			end
		end
		local distance = 0
		if self.rootNode == boosterVehicle.rootNode then
			distance = calcDistanceFrom(boosterVehicle.rootNode, playerRootNode)
			--local distanceLeft = maxRadius - distance
			g_currentMission:addExtraPrintText(string.format(g_i18n:getText("RVB_blinking_connecting_length"), string.format("%.1f", distance), maxRadius))
			if distance > minRadius and distance <= maxRadius then
				-- Ha a játékos 6 és 10 méter között van, figyelmeztetés jelenik meg
				local distanceLeft = maxRadius - distance
				g_currentMission:showBlinkingWarning(string.format(g_i18n:getText("RVB_blinking_connecting_toofar"), string.format("%.1f", distance)), 100, getMD5(tostring("jumperCableOutVehicle")))
			elseif distance > maxRadius then
				if self.rootNode == boosterVehicle.rootNode then
					g_rvbPlayer.jumperCableConnections = {}
				end
			end
		end
	end
	if self.isClient and isActiveForInputIgnoreSelection then
		if boosterVehicle ~= nil and boosterVehicle.rootNode == self.rootNode
		or dischargedVehicle ~= nil and dischargedVehicle.rootNode == self.rootNode then
			g_currentMission:addExtraPrintText(g_i18n:getText("RVB_addextra_connecting"))
			if not self.rvb_addextra_connecting then
				self.rvb_addextra_connecting = true
				g_currentMission:showBlinkingWarning(g_i18n:getText("RVB_addextra_connecting"), 3000)
			end
		end
	end
	if g_rvbPlayer:areJumperCablesConnected() then --and boosterVehicle:getIsMotorStarted() then
		local distance = calcDistanceFrom(boosterVehicle.rootNode, dischargedVehicle.rootNode)
		if distance <= maxRadius then
			self:chargeBatteryViaJumpStart(dt, isActiveForInputIgnoreSelection)
			if tonumber(boosterVehicle:getSpeed(boosterVehicle)) > 2
			or tonumber(dischargedVehicle:getSpeed(dischargedVehicle)) > 2 then
				g_currentMission:showBlinkingWarning(string.format(g_i18n:getText("RVB_blinking_connecting_drive"), string.format("%.1f", distance)), 2000, getMD5(tostring("jumperCableInVehicle")))
			end
		else
			--self:RVBaddRemoveMoney(-100, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR)
			if self.isServer then
				g_currentMission:addMoney(-100, self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
			end
			local message = string.format(g_i18n:getText("RVB_blinking_connecting_cableBroken"), g_i18n:formatMoney(100, 0, true, true))
			g_currentMission.hud:addSideNotification(FSBaseMission.INGAME_NOTIFICATION_OK, message, 12000, GuiSoundPlayer.SOUND_SAMPLES.SUCCESS)
			g_rvbPlayer.jumperCableConnections = {}
			g_currentMission:showMoneyChange(MoneyType.VEHICLE_REPAIR)
		end
	end
	
end
	
	
	
-- Motorindítás többszöri próbálkozása async
function VehicleBreakdowns:startMotorWithRetriesAsync(maxAttempts)
    maxAttempts = maxAttempts or 5
    self.motorStartAttempts = 0
    self.motorMaxAttempts = maxAttempts
    self.motorStartTimer = 0
    self.motorStarting = true
end

-- Update-ben hívandó
function VehicleBreakdowns:updateMotorRetries(dt)
    if not self.motorStarting then return end
	if not self.spec_motorized then return end
    self.motorStartTimer = self.motorStartTimer + dt

    if self.motorStartTimer >= (self.spec_motorized.motorStartDuration or 2) then
        self.motorStartTimer = 0
        self.motorStartAttempts = self.motorStartAttempts + 1

        local state = self:getMotorState()
        if state ~= MotorState.TURNED_ON then
            self:startMotor(false)
            print("Próbálkozás #" .. self.motorStartAttempts)
        else
            print("Motor elindult a " .. self.motorStartAttempts .. ". próbálkozásra")
            self.motorStarting = false
        end

        if self.motorStartAttempts >= self.motorMaxAttempts then
            print("Motor nem indult el a maximális próbálkozások után")
            self.motorStarting = false
        end
    end
end


function VehicleBreakdowns:rvb_startMotor(noEventSend)
	local v383_ = self:getMotorState()
	if v383_ == MotorState.OFF or v383_ == MotorState.IGNITION then
		MotorSetTurnedOnEvent.sendEvent(self, true, noEventSend)
		self:setMotorState(MotorState.STARTING, true)
	end
end


function VehicleBreakdowns:ignitionMotor(dt)

	local spec = self.spec_faultData
	local step = 100
	local minTime = 450 / step
	local maxTime = 800 / step
	local PRIORITY = {
		BATTERY = 1,
		SELFSTARTER = 2,
		GLOWPLUG = 3
	}
	local function setIgnition(priority, ignitionValue, igMin, igMax)
		if spec.faultType == 0 or priority < spec.faultType then
			spec.faultType = priority
			spec.ignition = ignitionValue
			minTime = igMin
			maxTime = igMax
		end
	end
	local batteryLevel = self:getIsFaultBattery()
	local batteryLow = batteryLevel <= BATTERY_LEVEL.MOTOR

	if spec.prevBatteryLow == nil then
		spec.prevBatteryLow = batteryLow
	end
	if spec.prevBatteryLow and not batteryLow then
		spec.firstStart = true
	end
	spec.prevBatteryLow = batteryLow
	
	if spec.firstStart and self:getMotorState() == MotorState.OFF then

		spec.faultType = 0
		if batteryLow  then
			local ignitionValue = 3
			setIgnition(PRIORITY.BATTERY, ignitionValue, 3.5, 5.5)
		else
			if spec.faultType == PRIORITY.BATTERY then
				spec.faultType = 0
				spec.ignition = 0
				spec.firstStart = true
			end
		end

		if spec.parts[SELFSTARTER] and spec.parts[SELFSTARTER].prefault ~= "empty" then
			local ignitionValue = SelfStarterManager.rbv_startMotor(self) or 0
			setIgnition(PRIORITY.SELFSTARTER, ignitionValue, 3.5, 6)
		end
		if spec.parts[GLOWPLUG] and spec.parts[GLOWPLUG].prefault ~= "empty" then
			local ignitionValue = GlowPlugManager.rbv_startMotor(self) or 0
			setIgnition(PRIORITY.GLOWPLUG, ignitionValue, 4.5, 8)
		end
		spec.firstStart = false
	end

	if spec.ignition ~= 0
	 and (self:getMotorState() == MotorState.STARTING or self:getMotorState() == MotorState.ON)
	 and (spec.motorTries or 0) < spec.ignition then

		self.playNeedsUpdateTimer = (self.playNeedsUpdateTimer or 0) + dt
		if spec.randomRestartTime == nil then
			spec.randomRestartTime = math.random(minTime, maxTime) * step
		end
		if self.playNeedsUpdateTimer >= spec.randomRestartTime then
			self.playNeedsUpdateTimer = 0 
			spec.randomRestartTime = nil
			self:stopMotor()
			self:startMotor()
			if spec.faultType == PRIORITY.SELFSTARTER or spec.faultType == PRIORITY.GLOWPLUG then
				GlowPlugManager.setVehicleDamage(self, dt)
			end
			spec.engineStarts = true
			spec.motorTries = spec.motorTries + 1
		end
	end
	
	if spec.engineStarts then
		if spec.motorTries >= spec.ignition then
			spec.engineStartStop = true
			spec.firstStart = true
			if spec.faultType == PRIORITY.BATTERY then
				self:stopMotor()
			end
		end
		spec.engineStarts = false
	end
end


VehicleBreakdowns.totalElapsed = 0
VehicleBreakdowns.timer = 0

VehicleBreakdowns.updateTimer = 0


function VehicleBreakdowns:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)


	local t0 = getTimeSec()

	
	local spec = self.spec_faultData
	local motorized = self.spec_motorized

	if not spec.isrvbSpecEnabled then
        return
    end


	self:ignitionMotor(dt)
	

	
	
	--self:updateMotorRetries(dt)

	self:updateOverheatingFailure(dt)
	
	-- motor teljesítmény csökkentés hibák alapján
	self:updateEngineTorque(isActiveForInputIgnoreSelection)
	
	if self.isClient then
		self:updateExhaustEffect()
	end

	-- TESZT
	if self.isClient and isActiveForInputIgnoreSelection and spec.parts[ENGINE].prefault ~= "empty" then
		--g_currentMission:addExtraPrintText("Elő hiba: "..spec.parts[ENGINE].prefault)
		--g_currentMission:addExtraPrintText("Hiba: "..spec.parts[ENGINE].fault)
	end
				
	-- TESZT
	if isActiveForInputIgnoreSelection then
		--local rpm = self.spec_motorized.motor:getRPM()
		local rpm = self.spec_motorized.motor:getEqualizedMotorRpm()
		local torque = self.spec_motorized.motor:getTorqueCurveValue(rpm)
		local hp, kw = g_i18n:getPower(torque)
		--print(string.format("Name %s Aktuális motorerő: %.3f HP / %.3f KW torque: %.3f, rpm: %.3f", self:getFullName(), hp, kw, torque, rpm))
	end


	
	local pressure = MathUtil.round(spec.inflationPressure, 2)
	local diff = spec.inflationPressureTarget - pressure
	if math.abs(diff) > 0.05 then
		local dir = math.sign(diff)
		local pressureChange = dt * VehicleBreakdowns.FLATE_MULTIPLIER
		self:setInflationPressure(pressure + (pressureChange * dir), dt)
	else
		--self:updateInflation(false)
	end
	
	if spec.parts[TIREFL].repairreq then
		self.spec_drivable.lastInputValues.axisSteer = -0.04
    end




	self:onUpdatejumperCable(dt, isActiveForInputIgnoreSelection)


	
	self:updateInspection(dt)

	self:updateRepair(dt)

	self:updateService(dt)


	self:onBatteryDrain(dt)
	
	if self:getMotorState() == MotorState.IGNITION then
		--print("IGNITION")
	end

	if self:getMotorState() == MotorState.STARTING then -- or self:getMotorState() == MotorState.IGNITION then
		self:updatePartsIgnitionBreakdowns(dt)
	end
			
	if self:getIsMotorStarted() then
	
		self:onStartOperatingHours(dt)

		spec.chargeBatteryUpdateTimer = (spec.chargeBatteryUpdateTimer or 0) + dt
		if spec.chargeBatteryUpdateTimer >= RVB_DELAY.BATTERY_DRAIN + 200 then
			GeneratorManager.chargeBatteryFromGenerator(self, spec.chargeBatteryUpdateTimer, isActiveForInputIgnoreSelection)
			spec.chargeBatteryUpdateTimer = 0
		end


		self:onStartWiperOperatingHours(dt)

		-- belül időzítve 1200
		self:updatePartsBreakdowns(dt)

	else

		--[[
			Motor hűtőfolyadék hőmérséklet csökkentése
			Ha a motor nem jár
			Ha a motor hőmérséklete nagyobb, mint az aktuális időjárási hőmérséklet
			Minden percben 0.55 fokkal csökken
		]]
		local specMotorized = self.spec_motorized
		if specMotorized.motorTemperature.value > self.currentTemperaturDay then
			local currentTemperaturInC = g_currentMission.environment.weather:getCurrentTemperature()
			local coolingRatePerMinute = (currentTemperaturInC < 0) and 0.75 or 0.55
			-- Ha a motor hőmérséklete 90°C felett van, kezdetben lassabb hűtés (50%)
			local tempDiff = specMotorized.motorTemperature.value - currentTemperaturInC
			-- Ha a külső hőmérséklet magasabb, akkor a hűtés lassuljon
			local coolingFactor = math.max(0.1, 1 - (tempDiff / 100))  -- Minél nagyobb a különbség, annál lassabb a hűtés
			--local coolingFactor = math.min(2.0, tempDiff / 50)

			-- Hűtés skálázása a játékidőhöz
			local coolingRatePerSecond = coolingRatePerMinute / 60  -- fok/másodperc
			-- Csökkentjük a hőmérsékletet a dt és a g_currentMission.missionInfo.timeScale figyelembevételével
			--self.spec_motorized.motorTemperature.value = self.spec_motorized.motorTemperature.value - (coolingRatePerSecond * (dt / 1000) * g_currentMission.missionInfo.timeScale)
			specMotorized.motorTemperature.value = specMotorized.motorTemperature.value - (coolingRatePerSecond * (dt / 1000) * g_currentMission.missionInfo.timeScale * coolingFactor)
			-- Biztosítjuk, hogy a hőmérséklet ne csökkenjen az időjárási hőmérséklet alá
			if specMotorized.motorTemperature.value < currentTemperaturInC then
				specMotorized.motorTemperature.value = currentTemperaturInC
			end
		end

	end

	
	self:onStartLightingsOperatingHours(dt, isActiveForInputIgnoreSelection)


	local engine_percent = (spec.parts[ENGINE].operatingHours * 100) / spec.parts[ENGINE].tmp_lifetime
	if self:getIsFaultSelfStarter() or self:getIsFaultBattery() < BATTERY_LEVEL.MOTOR or engine_percent >= 99 then
		--print("Teljesul")
		if g_modIsLoaded["FS25_AutoDrive"] then
			if FS25_AutoDrive ~= nil then
				if self.ad.stateModule:isActive() then --print("FS25_AutoDrive stopAutoDrive")
					self:stopAutoDrive(self)
					--self:updateVehiclePhysics(0, 0, 0, 16)
					self:stopVehicle()
					FS25_AutoDrive.AutoDriveMessageEvent.sendNotification(self, FS25_AutoDrive.ADMessagesManager.messageTypes.INFO, g_i18n:getText("RVB_aimessage_batterydischarged"), 8000, self:getFullName())
				end
			end
		end
		
		if g_modIsLoaded["FS25_Courseplay"] then
			if FS25_Courseplay ~= nil then
				if self:getIsCpActive() then
					if self.getIsAIActive and self:getIsAIActive() then
						self:stopCurrentAIJob(AIMessageErrorBatteryDischarged.new())
						self:stopVehicle()
					end
				end
			end
		end

	end


	if self:getIsMotorStarted() then
		if self.isClient then
			local MotorSounds = self.spec_motorized.motorSamples
			local gearboxSounds = self.spec_motorized.gearboxSamples
			if not g_soundManager:getIsSamplePlaying(MotorSounds[1]) then
				g_soundManager:playSamples(MotorSounds)
			end
			if not g_soundManager:getIsSamplePlaying(gearboxSounds[1]) then
				g_soundManager:playSamples(gearboxSounds)
			end
			if not g_soundManager:getIsSamplePlaying(self.spec_motorized.samples.retarder) then
				g_soundManager:playSample(self.spec_motorized.samples.retarder)
			end
		end	
	end
	
	
	if self:getIsFaultLightings() or self:getIsFaultBattery() ~= nil and self:getIsFaultBattery() ~= 0 then
		self:lightingsFault()
	end

	local engine_percent = (spec.parts[ENGINE].operatingHours * 100) / spec.parts[ENGINE].tmp_lifetime
	if engine_percent >= 99 then
		self:StopAI(self)
	end





	local elapsed = (getTimeSec() - t0) * 1000 -- ms-ben
	-- jarmuvenkent
    --if elapsed > 0.05 then -- csak ha 0.05ms felett van, hogy ne legyen spam
    --    print(string.format("[DEBUG] VehicleBreakdowns:onUpdate futási idő: %.3f ms", elapsed))
    --end
	-- osszes jarmu
	VehicleBreakdowns.totalElapsed = VehicleBreakdowns.totalElapsed + elapsed
    VehicleBreakdowns.timer = VehicleBreakdowns.timer + dt

    -- Kiírás percenként
    if VehicleBreakdowns.timer >= 1000*60 then
    --    print(string.format("[DEBUG] Összes járműre futott idő az utolsó percben: %.3f ms", VehicleBreakdowns.totalElapsed))
        -- reset
        VehicleBreakdowns.totalElapsed = 0
        VehicleBreakdowns.timer = 0
    end




end





function VehicleBreakdowns:onSetDifficulty(difficulty)
	--print("DEBUG: onSetDifficulty called!" .. difficulty)
    local GSET = g_currentMission.vehicleBreakdowns.generalSettings
    local daysPerPeriod = g_currentMission.environment.plannedDaysPerPeriod
	--for _, vehicle in ipairs(g_currentMission.vehicleSystem.vehicles) do
	local vehicle = self
		if vehicle.spec_faultData then
		--print(string.format("onSetDifficulty %s difficulty %s", vehicle:getFullName(), difficulty))
			local rvbVehicle = vehicle.spec_faultData
			for _, key in ipairs(g_vehicleBreakdownsPartKeys) do
				local part = rvbVehicle.parts[key]
				if part and part.name ~= nil then
					if GSET.difficulty == 1 then
						part.tmp_lifetime = part.lifetime * 2 * daysPerPeriod
					elseif GSET.difficulty == 2 then
						part.tmp_lifetime = part.lifetime * 1 * daysPerPeriod
					else
						part.tmp_lifetime = part.lifetime / 2 * daysPerPeriod
					end
				end
			end
			RVBParts_Event.sendEvent(vehicle, rvbVehicle.parts)
		end
	--end
end

function VehicleBreakdowns:onSetPlannedDaysPerPeriod()
    local GSET = g_currentMission.vehicleBreakdowns.generalSettings
    local daysPerPeriod = g_currentMission.environment.plannedDaysPerPeriod
	for _, vehicle in ipairs(g_currentMission.vehicleSystem.vehicles) do
		if vehicle.spec_faultData then
			local rvbVehicle = vehicle.spec_faultData
			for _, key in ipairs(g_vehicleBreakdownsPartKeys) do
				local part = rvbVehicle.parts[key]
				if part and part.name ~= nil then
					if GSET.difficulty == 1 then
						part.tmp_lifetime = part.lifetime * 2 * daysPerPeriod
					elseif GSET.difficulty == 2 then
						part.tmp_lifetime = part.lifetime * 1 * daysPerPeriod
					else
						part.tmp_lifetime = part.lifetime / 2 * daysPerPeriod
					end
				end
			end
			RVBParts_Event.sendEvent(vehicle, rvbVehicle.parts)
		end
	end
end




	


	
    
VehicleBreakdowns.TIRE_PRESSURE_LOW = 80  -- kPa
VehicleBreakdowns.TIRE_PRESSURE_NORMAL = 180 -- kPa
VehicleBreakdowns.TIRE_PRESSURE_MIN = 80 -- kPa
VehicleBreakdowns.TIRE_PRESSURE_MAX = 180 -- kPa

VehicleBreakdowns.INCREASE = 1.15
VehicleBreakdowns.FLATE_MULTIPLIER = 0.005
VehicleBreakdowns.MAX_INPUT_MULTIPLIER = 10
VehicleBreakdowns.INPUT_MULTIPLIER_STEP = 0.01

VehicleBreakdowns.INFLATION_PRESSURE = 50 -- Ezt változtathatod




function VehicleBreakdowns:updateTireDeformation(dt)
    local spec = self.spec_faultData
    local inflationPressure = VehicleBreakdowns.INFLATION_PRESSURE
    local tireTypeCrawler = WheelsUtil.getTireType("crawler")
    
    local flatTires = {}
    if spec.parts[TIREFL].repairreq and not spec.parts[TIREFR].repairreq then
        table.insert(flatTires, 1)
    elseif spec.parts[TIREFR].repairreq and not spec.parts[TIREFL].repairreq then
        table.insert(flatTires, 2)
    elseif spec.parts[TIREFL].repairreq and spec.parts[TIREFR].repairreq then
        flatTires = {1, 2}
    else
        flatTires = {}
    end
    
    if tonumber(self:getSpeed(self)) > 2 then
        if self.typeName == 'combineDrivable' then
            if spec.parts[TIRERL].repairreq and not spec.parts[TIRERR].repairreq then
                self.spec_drivable.lastInputValues.axisSteer = -0.04
            elseif spec.parts[TIRERR].repairreq and not spec.parts[TIRERL].repairreq then
                self.spec_drivable.lastInputValues.axisSteer = 0.04
            elseif spec.parts[TIRERL].repairreq and spec.parts[TIRERR].repairreq then
                self.spec_drivable.lastInputValues.axisSteer = self.spec_drivable.lastInputValues.axisSteer
            else
                self.spec_drivable.lastInputValues.axisSteer = 0
            end
        else
            if spec.parts[TIREFL].repairreq and not spec.parts[TIREFR].repairreq then
                self.spec_drivable.lastInputValues.axisSteer = -0.04
            elseif spec.parts[TIREFR].repairreq and not spec.parts[TIREFL].repairreq then
                self.spec_drivable.lastInputValues.axisSteer = 0.04
            elseif spec.parts[TIREFL].repairreq and spec.parts[TIREFR].repairreq then
                self.spec_drivable.lastInputValues.axisSteer = self.spec_drivable.lastInputValues.axisSteer
            else
                self.spec_drivable.lastInputValues.axisSteer = 0
            end
        end
    else
        -- self.spec_drivable.lastInputValues.axisSteer = 0
    end

    -- Timer beállítása az update gyakoriság csökkentésére
    self.tireDeformation = false
    self.tireDeformationTimer = (self.tireDeformationTimer or 0) + dt
    if self.tireDeformationTimer < 200 then  -- 200 ms-es intervallum
        return  -- Ha még nem telt el az idő, térjünk vissza
    end
    self.tireDeformationTimer = 0  -- Reseteljük a timer-t

    -- `tableContains` funkció definiálása a táblázat tartalmazás ellenőrzésére
    local function tableContains(tbl, element)
        for _, value in pairs(tbl) do
            if value == element then
                return true
            end
        end
        return false
    end

    


    for _, wheel in pairs(self:getWheels()) do
        if wheel.tireType ~= tireTypeCrawler then
            for _, visualWheel in ipairs(wheel.visualWheels) do
                for _, visualPart in ipairs(visualWheel.visualParts) do
                    if visualPart.deformation ~= nil then
                        -- Ha a kerék lapos, akkor fokozatosan laposítjuk
                        if tableContains(flatTires, wheel.wheelIndex) then
						-- Fokozatos deformáció hozzáadása
							 -- Ha lapos a kerék, lassan csökkentjük a nyomását
        --    self.tirePressure[wheel.wheelIndex] = math.max(self.tirePressure[wheel.wheelIndex] - dt * 5, VehicleBreakdowns.TIRE_PRESSURE_MIN)
                            -- Ha még nem volt hozzáadva a tpMaxDeformation, akkor inicializáljuk
                            if wheel.tpMaxDeformation == nil then
                                wheel.tpMaxDeformation = Utils.getNoNil(visualPart.maxDeformation, 0.04)
                                wheel.physics.tpSuspTravel = math.max(wheel.physics.suspTravel, 0.01)
                                wheel.physics.tpFrictionScale = wheel.physics.frictionScale
                            end

                            -- Fokozatosan növeljük a deformációt (nem egyszerre)
                            local deformationRate = 0.001  -- Az érték, amivel lassan növekszik a deformáció
                            wheel.tpDeformation = (wheel.tpDeformation or 0) + deformationRate * dt  -- Fokozatosan nő

                            -- Csak akkor növeljük, ha még nem értük el a maximális deformációt
                            if wheel.tpDeformation > visualPart.maxDeformation then
                                wheel.tpDeformation = visualPart.maxDeformation
                            end
						--		print("mass "..wheel.wheelIndex..": "..wheel.physics.mass)
								--wheel.physics.mass = 0.1599999964237213*3
								
						--		print("wheel.physics.deltaY "..wheel.wheelIndex..": "..wheel.physics.deltaY)
						--		print("visualPart.deformation "..wheel.wheelIndex..": "..visualPart.deformation)
						--		print("visualPart.maxDeformation "..wheel.wheelIndex..": "..visualPart.maxDeformation)
						--		print("visualPart.initialDeformation "..wheel.wheelIndex..": "..visualPart.initialDeformation)
						--		print("wheel.physics.tpSuspTravel "..wheel.wheelIndex..": "..wheel.physics.tpSuspTravel)
						--		print("wheel.physics.deltaYOriginal "..wheel.wheelIndex..": "..wheel.physics.deltaYOriginal)
						--		print("wheel.physics.radius "..wheel.wheelIndex..": "..wheel.physics.radius)
						--		print("wheel.physics.width "..wheel.wheelIndex..": "..wheel.physics.width)

								--[[
								2025-02-27 21:27 mass 1: 0.1599999964237213
								2025-02-27 21:27 wheel.physics.deltaY 1: 0.09359999790787697
								2025-02-27 22:17 visualPart.deformation 1: 0.03962785139679909
								2025-02-27 22:17 visualPart.maxDeformation 1: 0.0706000030040741
								2025-02-27 22:17 visualPart.initialDeformation 1: 0.04
								2025-02-27 21:27 wheel.physics.tpSuspTravel 1: 0.11999999731779099
								2025-02-27 21:27 wheel.physics.deltaYOriginal 1: 0.09359999790787697
								2025-02-27 22:17 wheel.physics.radius 1: 0.6809999942779541
								2025-02-27 22:17 wheel.physics.width 1: 0.41999998688697815
								]]
								--wheel.physics.deltaY = 0.04359999790787697
								--wheel.physics.tpSuspTravel = 0.08999999731779099
								-- elsüllyeszti a kereket alap ertek 0.5
								--wheel.physics.radius = 0.6
								--
								--wheel.physics.width = 0.81999998688697815
								--
								--visualPart.maxDeformation = visualPart.maxDeformation + 0.03
								--visualPart.deformation = 0.0697201193869114
								
								local v65, v66, v67, v68, v69, v70 = wheel.physics:getVisualInfo()
							--	print("v65 "..v65)
							--	print("v66 "..v66)
							--	print("v67 "..v67)
							--	print("v68 "..v68)
							--	print("v69 "..v69)
							--	print("v70 "..v70)
								--[[
								2025-02-27 22:17 v65 0.9000006914138794
								2025-02-27 22:17 v66 0.03454199433326721
								2025-02-27 22:17 v67 -0.0014085769653320312
								2025-02-27 22:17 v68 6.283174514770508
								2025-02-27 22:17 v69 0.0003148685395717582
								2025-02-27 22:17 v70 -0
								]]

                            -- Deformáció kiszámítása, hogy érzékelhető legyen, de ne laposodjon el azonnal
                            --local deformation = math.clamp((wheel.physics.deltaY * 1.1 + 0.04 - (wheel.physics.tpSuspTravel * 0.6)) * (VehicleBreakdowns.INCREASE - (inflationPressure - VehicleBreakdowns.TIRE_PRESSURE_LOW) / 100) * wheel.tpDeformation, 0, visualPart.maxDeformation * 0.7)
						--	local deformation = math.clamp((wheel.physics.deltaY * 1.1 + 0.04 - (wheel.physics.tpSuspTravel * 0.6)) * (VehicleBreakdowns.INCREASE - (inflationPressure - VehicleBreakdowns.TIRE_PRESSURE_LOW) / 100), 0, visualPart.maxDeformation * 0.7)
							
							
							local deformation = math.clamp((wheel.physics.deltaY * 1.1 + 0.04 - (wheel.physics.tpSuspTravel * 0.6)) * (VehicleBreakdowns.INCREASE - (spec.inflationPressure - VehicleBreakdowns.TIRE_PRESSURE_LOW) / 100), 0, visualPart.maxDeformation * 0.7)
							
							
							
							

							--[[self.deformation = deformation
							self.deformationDegrees = self.deformation / 10
							if self.tmpdeformation < self.deformation then
							self.tireDeformationTimer2 = (self.tireDeformationTimer2 or 0) + dt
							if self.tireDeformationTimer2 > 1000 then 
								self.tireDeformationTimer2 = 0  -- Reseteljük a timer-t
								deformation = self.deformationDegrees
								self.tmpdeformation = self.tmpdeformation + self.deformationDegrees
							end
							end]]

                            -- Frissítjük a magasságot és a felfüggesztést
                            local fixedHeightOffset = 0.04
                            wheel.physics.suspTravel = wheel.physics.tpSuspTravel - deformation + fixedHeightOffset
                            local delta = VehicleBreakdowns.TIRE_PRESSURE_NORMAL / spec.inflationPressure
                            visualPart.maxDeformation = wheel.tpMaxDeformation * delta
                            wheel.physics.frictionScale = wheel.physics.tpFrictionScale * delta - 0.6
                            wheel.physics.isPositionDirty = true
                            wheel.physics.isFrictionDirty = true
							
							

							-- wheel:updatePhysics()
                        else
							-- Ha nem lapos, lassan növeljük a nyomását
         --   self.tirePressure[wheel.wheelIndex] = math.min(self.tirePressure[wheel.wheelIndex] + dt * 10, VehicleBreakdowns.TIRE_PRESSURE_MAX)
                            -- Ha a kerék megjavult, visszaállítjuk az eredeti értékeket
                            if wheel.tpMaxDeformation ~= nil then
                                visualPart.maxDeformation = wheel.tpMaxDeformation
                                wheel.physics.suspTravel = wheel.physics.tpSuspTravel
                                wheel.physics.frictionScale = wheel.physics.tpFrictionScale
                                wheel:addToPhysics()
                            end
                        end
                    end
                end
            end
        end
    end

    self.tireDeformation = true
end


function VehicleBreakdowns:adjustSteeringAngle(wheel, angleAdjustment)
    local currentAngle = wheel.steeringAngle
    wheel.steeringAngle = currentAngle + angleAdjustment
    -- Kormányzási logika frissítése
	if self.isServer and self.isAddedToPhysics then
    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self:getBrakeForce()*wheel.brakeFactor, wheel.steeringAngle, wheel.rotationDamping)
	end
end

function VehicleBreakdowns:checkGlowPlugFault()
	--print("checkGlowPlugFault")
    local spec = self.spec_faultData
    if not spec then return end

    local part = spec.parts[GLOWPLUG]
    local faultData = FaultRegistry[GLOWPLUG]
    			if part and faultData then
				local partFoot = (part.operatingHours * 100) / part.tmp_lifetime
				local shouldBreak = false
				if part.prefault == "empty" then
					if not part.pre_random or part.pre_random == 0 then
						part.pre_random = math.random(1,5)
					end
					--print("part.pre_random "..part.pre_random)
					if faultData.strictBreak then
						shouldBreak = partFoot >= (faultData.breakThreshold - part.pre_random)
						--print("strictBreak shouldBreak "..tostring(shouldBreak))
					else
						shouldBreak = partFoot > (faultData.breakThreshold - part.pre_random)
						--print(part.name.." partFoot "..partFoot.." > preTreshold "..(faultData.breakThreshold - part.pre_random).. "part.pre_random "..part.pre_random.." shouldBreak "..tostring(shouldBreak))
						--print("strictBreak else shouldBreak "..tostring(shouldBreak))
					end
					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					--print("criticalLevel "..tostring(criticalLevel))
					local thresholdPassed = faultData.threshold and faultData.threshold(self, part.pre_random, false) or false
					local needsNewpreFault = part.prefault == nil or part.prefault == "empty"
					--print("thresholdPassed "..tostring(thresholdPassed))
					--print("needsNewpreFault "..tostring(needsNewpreFault))
					if shouldBreak and (thresholdPassed or criticalLevel) and needsNewpreFault then
						--print(part.name.." GLOWPLUG bejutottam")
						local valid = getValidFaultVariants(self, GLOWPLUG, false)
						if valid then
							part.prefault = valid
							faultChanged = true 
							--print("GLOWPLUG Előhiba dobva: "..part.name.." prefault="..tostring(part.prefault).." fault="..tostring(part.fault))
						end
					end
				else
					part.pre_random = 0
					local needsNewFault = part.fault == nil or part.fault == "empty"
					local thresholdPassed = faultData.threshold and faultData.threshold(self, 0, false) or false
					if faultData.strictBreak then
						shouldBreak = partFoot >= faultData.breakThreshold
					else
						shouldBreak = partFoot > faultData.breakThreshold
					end
				--	print(part.name.." else partFoot "..partFoot.." > breakThreshold "..faultData.breakThreshold.. "part.pre_random "..part.pre_random.." shouldBreak "..tostring(shouldBreak))
					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					if shouldBreak and (thresholdPassed or criticalLevel) and needsNewFault then
						part.fault = part.prefault
						faultChanged = true  
						spec.faultList[i] = true
						part.repairreq = true
						--print("GLOWPLUG Hiba dobva: "..part.name.." prefault="..tostring(part.prefault).." fault="..tostring(part.fault))
					end
				end
			end
end

function VehicleBreakdowns:updatePartsIgnitionBreakdowns(dt)
    -- Időzítő beállítása a javítási igények frissítéséhez
    self.ignitionUpdateTimer = (self.ignitionUpdateTimer or 0) + dt

	local faultChanged = false
    if self.ignitionUpdateTimer >= RVB_DELAY.PARTS_BREAKDOWNS then
	--print("updatePartsIgnitionBreakdowns")
        self.ignitionUpdateTimer = 0 -- Időzítő visszaállítása
        local spec = self.spec_faultData
		for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
			if key ~= THERMOSTAT and key ~= LIGHTINGS and key ~= WIPERS and key ~= GENERATOR and key ~= ENGINE and key ~= BATTERY
			and key ~= TIREFL and key ~= TIREFR and key ~= TIRERL and key ~= TIRERR then
			local part = spec.parts[key]
			local faultData = FaultRegistry[key]
			if part and faultData then
				local partFoot = (part.operatingHours * 100) / part.tmp_lifetime
				local shouldBreak = false
				if part.prefault == "empty" then
					if not part.pre_random or part.pre_random == 0 then
						part.pre_random = math.random(1,5)
					end
					if faultData.strictBreak then
						shouldBreak = partFoot >= (faultData.breakThreshold - part.pre_random)
					else
						shouldBreak = partFoot > (faultData.breakThreshold - part.pre_random)
						--print(part.name.." partFoot "..partFoot.." > preTreshold "..(faultData.breakThreshold - part.pre_random).. "part.pre_random "..part.pre_random.." shouldBreak "..tostring(shouldBreak))
					end
					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					local thresholdPassed = faultData.threshold and faultData.threshold(self, part.pre_random, false) or false
					local needsNewpreFault = part.prefault == nil or part.prefault == "empty"
					if part.name == "ENGINE" then
					--print(part.name.." shouldBreak "..tostring(shouldBreak))
					--print(part.name.." thresholdPassed "..tostring(thresholdPassed))
					--print(part.name.." needsNewpreFault "..tostring(needsNewpreFault))
					--print(part.name.." criticalLevel "..tostring(criticalLevel))
					end
					if shouldBreak and (thresholdPassed or criticalLevel) and needsNewpreFault then
						--print(part.name.." bejutottam")
						local valid = getValidFaultVariants(self, key, false)
						if valid then
							part.prefault = valid
							faultChanged = true 
							--print("Előhiba dobva: "..part.name.." prefault="..tostring(part.prefault).." fault="..tostring(part.fault))
						end
					end
				else
					part.pre_random = 0
					local needsNewFault = part.fault == nil or part.fault == "empty"
					local thresholdPassed = faultData.threshold and faultData.threshold(self, 0, false) or false
					if faultData.strictBreak then
						shouldBreak = partFoot >= faultData.breakThreshold
					else
						shouldBreak = partFoot > faultData.breakThreshold
					end
				--	print(part.name.." else partFoot "..partFoot.." > breakThreshold "..faultData.breakThreshold.. "part.pre_random "..part.pre_random.." shouldBreak "..tostring(shouldBreak))
					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					if shouldBreak and (thresholdPassed or criticalLevel) and needsNewFault then
						part.fault = part.prefault
						faultChanged = true  
						spec.faultList[i] = true
						part.repairreq = true
						--print("Hiba dobva: "..part.name.." prefault="..tostring(part.prefault).." fault="..tostring(part.fault))
					end
				end
			end
		end	
		end
        if faultChanged then
			if self.isServer then
				self:raiseDirtyFlags(spec.partsDirtyFlag)
			end
		end
    end
	self:raiseActive()
end

function VehicleBreakdowns:updatePartsBreakdowns(dt)
    -- Időzítő beállítása a javítási igények frissítéséhez
    self.repairNeedsUpdateTimer = (self.repairNeedsUpdateTimer or 0) + dt

	local faultChanged = false
    if self.repairNeedsUpdateTimer >= RVB_DELAY.PARTS_BREAKDOWNS then
        self.repairNeedsUpdateTimer = 0 -- Időzítő visszaállítása
        local spec = self.spec_faultData
		for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
			if key ~= GLOWPLUG and key ~= SELFSTARTER then
			local part = spec.parts[key]
			local faultData = FaultRegistry[key]
			if part and faultData then
				local partFoot = (part.operatingHours * 100) / part.tmp_lifetime
				local shouldBreak = false
				if part.prefault == "empty" then
					if not part.pre_random or part.pre_random == 0 then
						part.pre_random = math.random(1,5)
					end
					if faultData.strictBreak then
						shouldBreak = partFoot >= (faultData.breakThreshold - part.pre_random)
					else
						shouldBreak = partFoot > (faultData.breakThreshold - part.pre_random)
						--print(part.name.." partFoot "..partFoot.." > preTreshold "..(faultData.breakThreshold - part.pre_random).. "part.pre_random "..part.pre_random.." shouldBreak "..tostring(shouldBreak))
					end
					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					local thresholdPassed = faultData.threshold and faultData.threshold(self, part.pre_random, false) or false
					local needsNewpreFault = part.prefault == nil or part.prefault == "empty"
					if part.name == "ENGINE" then
					--print(part.name.." shouldBreak "..tostring(shouldBreak))
					--print(part.name.." thresholdPassed "..tostring(thresholdPassed))
					--print(part.name.." needsNewpreFault "..tostring(needsNewpreFault))
					--print(part.name.." criticalLevel "..tostring(criticalLevel))
					end
					if shouldBreak and (thresholdPassed or criticalLevel) and needsNewpreFault then
						--print(part.name.." bejutottam")
						local valid = getValidFaultVariants(self, key, false)
						if valid then
							part.prefault = valid
							faultChanged = true 
							--print("Előhiba dobva: "..part.name.." prefault="..tostring(part.prefault).." fault="..tostring(part.fault))
						end
					end
				else
					part.pre_random = 0
					local needsNewFault = part.fault == nil or part.fault == "empty"
					local thresholdPassed = faultData.threshold and faultData.threshold(self, 0, false) or false
					if faultData.strictBreak then
						shouldBreak = partFoot >= faultData.breakThreshold
					else
						shouldBreak = partFoot > faultData.breakThreshold
					end
				--	print(part.name.." else partFoot "..partFoot.." > breakThreshold "..faultData.breakThreshold.. "part.pre_random "..part.pre_random.." shouldBreak "..tostring(shouldBreak))
					local criticalLevel
					if faultData.hud.temperatureBased then
						criticalLevel = partFoot >= faultData.hud.temp.critical
					else
						criticalLevel = partFoot >= faultData.hud.condition.critical
					end
					if shouldBreak and (thresholdPassed or criticalLevel) and needsNewFault then
						part.fault = part.prefault
						faultChanged = true  
						spec.faultList[i] = true
						part.repairreq = true
						--print("Hiba dobva: "..part.name.." prefault="..tostring(part.prefault).." fault="..tostring(part.fault))
					end
				end
			end
		end	
		end
        if faultChanged then
			if self.isServer then
				self:raiseDirtyFlags(spec.partsDirtyFlag)
			end
		end
    end
	self:raiseActive()
end
function VehicleBreakdowns:updatePartsNoBreakdowns(dt)
    self.PartsNeedsUpdateTimer = (self.PartsNeedsUpdateTimer or 0) + dt
    if self.PartsNeedsUpdateTimer >= RVB_DELAY.PARTS_noBREAKDOWNS then
        self.PartsNeedsUpdateTimer = 0
        local spec = self.spec_faultData
		--- Ha van jaitas ne fusson le, mert a javitas nem fejezodik be soha
		if spec.repair[1] then return end
		local isSend = false
        for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
            local part = spec.parts[key]
            local faultData = FaultRegistry[key]
			if part and faultData then
                local partFoot = (part.operatingHours * 100) / part.tmp_lifetime
                local threshold = faultData.breakThreshold or 100
                local shouldBreak = false
				if faultData.strictBreak then
					shouldBreak = partFoot <= faultData.breakThreshold
				else
					shouldBreak = partFoot < faultData.breakThreshold
				end
				if shouldBreak and part.repairreq then
                    spec.faultList[i] = false
                    part.repairreq = false
                    part.damaged = false
                    part.fault = "empty"
					isSend = true
                end
			end
		end
        --RVBParts_Event.sendEvent(self, spec.parts)
		if isSend then
			isSend = false
			--print("VehicleBreakdowns:updatePartsNoBreakdowns isSend")
			self:raiseDirtyFlags(spec.partsDirtyFlag)
		end
    end
end

function VehicleBreakdowns:setRVBLightsStrings(lights_request_A, lights_request_B, force, noEventSend)
    local spec = self.spec_faultData

    if lights_request_A ~= spec.lights_request_A or lights_request_B ~= spec.lights_request_B or force then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(RVBLightingsStringsEvent.new(self, lights_request_A, lights_request_B), nil, nil, self)
            else
                g_client:getServerConnection():sendEvent(RVBLightingsStringsEvent.new(self, lights_request_A, lights_request_B))
            end
        end

        spec.lights_request_A = lights_request_A
		spec.lights_request_B = lights_request_B

    end

    return true
end

function VehicleBreakdowns:setRVBLightsTypesMask(rvblightsTypesMask, force, noEventSend)
    local spec = self.spec_faultData

    if rvblightsTypesMask ~= spec.rvblightsTypesMask or force then
        if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(RVBLightingsTypesMaskEvent.new(self, rvblightsTypesMask), nil, nil, self)
            else
                g_client:getServerConnection():sendEvent(RVBLightingsTypesMaskEvent.new(self, rvblightsTypesMask))
            end
        end

        spec.rvblightsTypesMask = rvblightsTypesMask

    end

    return true
end


        





function VehicleBreakdowns:getIsRVBMotorStarted(isRunning)
    return self.spec_faultData.isRVBMotorStarted and (not isRunning or self.spec_faultData.rvbmotorStartTime < g_currentMission.time)
end

function VehicleBreakdowns:onStartOperatingHours(dt)
	local spec = self.spec_faultData
	spec.OperatingHoursUpdateTimer = (spec.OperatingHoursUpdateTimer or 0) + dt
	if spec.OperatingHoursUpdateTimer >= RVB_DELAY.PARTS_OPERATINGHOURS then
		self:updateOperatingHours(spec.OperatingHoursUpdateTimer, spec)
		spec.OperatingHoursUpdateTimer = 0
	end
	self:raiseActive()
end
function VehicleBreakdowns:updateOperatingHours(msDelta, spec)
	local oneGameHour = 1000 * 60 * 60
	local runtimeIncrease = msDelta * g_currentMission.missionInfo.timeScale / oneGameHour
	if self.isServer then
		spec.rvb[3] = spec.rvb[3] + runtimeIncrease
		spec.rvb[4] = spec.rvb[4] + runtimeIncrease
	end

	local function isImplementWorking(obj, vehicle, minSpeed)
		if not obj then return false end
		if obj.spec_roller and obj.spec_roller.isWorking then
			return true
		end
		if not obj.getIsTurnedOn and obj.getIsLowered and obj:getIsLowered() and vehicle:getLastSpeed() >= minSpeed then
			return true
		end
		if obj.getIsTurnedOn and obj:getIsTurnedOn() and obj.getIsLowered and obj:getIsLowered() and obj.getIsImplementChainLowered and obj:getIsImplementChainLowered() and vehicle:getLastSpeed() >= minSpeed then
			return true
		end
		if obj.getIsTurnedOn and not obj:getIsTurnedOn() and obj.getIsLowered and obj:getIsLowered() and obj.getIsImplementChainLowered and obj:getIsImplementChainLowered() and vehicle:getLastSpeed() >= minSpeed then
			return true
		end
		if obj:getPtoRpm() > 0 then
			return true
		end
		return false
	end

	local isWorking = false
	local minSpeed = 0.5
	local attachedImplements = self:getAttachedImplements()
	if attachedImplements then
		for _, implement in ipairs(self:getAttachedImplements() or {}) do
			if isImplementWorking(implement.object, self, minSpeed) then
				isWorking = true
				break
			end
		end
	end

	if self.getDoConsumePtoPower and self:getDoConsumePtoPower() then
		isWorking = true
	end

	local specM = self.spec_motorized
	local motorTemp = specM and specM.motorTemperature.value
	local speedKmH = self:getLastSpeed()
	local maxSpeed = specM.motor and (specM.motor:getMaximumForwardSpeed() * 3.6) or 50
	local maxSpeedThreshold = math.floor(maxSpeed * MAXSPEED_THRESHOLD)
	local speedFactor = 1
	local motorFactor = 1
	if motorTemp < MOTORTEMP_THRESHOLD then
		if speedKmH >= maxSpeedThreshold then
			local extraSteps = math.floor((speedKmH - maxSpeedThreshold) / 5)
			speedFactor = math.min(1.2 + extraSteps * 0.5, 3)
		end
		if isWorking then
			motorFactor = 5
		end
	end
	
	if motorTemp > 100 then
		for _, partName in ipairs({THERMOSTAT, ENGINE}) do
			local partData = spec.parts[partName]
			partData.operatingHours = partData.operatingHours + runtimeIncrease * 1.2
		end
	end
	
	local RVBSET = g_currentMission.vehicleBreakdowns
	local fault_text = "RVB_fault_"
	if speedFactor > 1 then
		fault_text = "RVB_fault_"
	elseif motorFactor > 1 then
		fault_text = "RVB_fault_engineload"
	end
	if speedFactor > 1 or motorFactor > 1 then
		if RVBSET:getIsAlertMessage() and not spec.addDamage.alert then
			if self.getIsEntered ~= nil and self:getIsEntered() then
				if self.getConsumerFillUnitIndex ~= nil and self:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil then
					g_currentMission:showBlinkingWarning(g_i18n:getText(fault_text), 2500)
				end
			else
				--g_currentMission.hud:addSideNotification(VehicleBreakdowns.INGAME_NOTIFICATION, string.format(g_i18n:getText(fault_hud_text), self:getFullName()), 5000)
			end
			spec.addDamage.alert = true
		end
	end
	local serviceFactor = 1
	local operatingHours = math.floor(spec.rvb[4])
	local maxServiceThreshold = RVBSET:getPeriodicService()
	if operatingHours > maxServiceThreshold then
		local extraSteps = math.floor((operatingHours - maxServiceThreshold) / 5)
		serviceFactor = math.min(1.05 + extraSteps * 0.2, 3)
	end

	local boostedWear = runtimeIncrease * speedFactor * motorFactor * serviceFactor
	local normalWear  = runtimeIncrease
    for _, partName in ipairs({THERMOSTAT, GENERATOR, ENGINE, BATTERY}) do
        local partData = spec.parts[partName]
        local applied = false
		local wearToApply = ((motorFactor > 1 or speedFactor > 1) and (partName == THERMOSTAT or partName == ENGINE))
        and boostedWear or normalWear
		local wearFactor = 1

        if partData.fault and partData.fault ~= "empty" then
            local registry = FaultRegistry[partName]
            if registry and registry.variants then
                local variant = registry.variants[partData.fault]
                if variant and (not variant.wear or variant.wear(self)) then
                    if variant.wearMultiplier then
                        if variant.wearMultiplier.component then
                            local target = variant.wearMultiplier.component
                            spec.parts[target].operatingHours = spec.parts[target].operatingHours + wearToApply * (variant.wearMultiplier.multiplier or 1)
							wearFactor = variant.wearMultiplier.multiplier
                        else
                            for _, wm in ipairs(variant.wearMultiplier) do
                                local target = wm.component
                                spec.parts[target].operatingHours = spec.parts[target].operatingHours + wearToApply * (wm.multiplier or 1)
								wearFactor = wm.multiplier
                            end
                        end
                    end
                    applied = true
                end
            end
        end
        if not applied then
            partData.operatingHours = partData.operatingHours + wearToApply
        end
		--self.rvbDebugger:info(
		--	"Part: %s | Wear applied: %.6f | Mode: %s | SpeedFactor: %.2f | MotorFactor: %.2f | WearFactor: %.2f",
		--	partName, wearToApply,
		--	wearToApply == boostedWear and "BOOSTED" or "NORMAL",
		--	speedFactor, motorFactor, wearFactor
		--)
    end
	if self.isServer then
		self:raiseDirtyFlags(spec.partsDirtyFlag)
	end
end


function VehicleBreakdowns:onDelete()
    local spec = self.spec_faultData

	g_messageCenter:unsubscribe(MessageType.MINUTE_CHANGED, self)
	g_messageCenter:unsubscribe(MessageType.HOUR_CHANGED, self)
	g_messageCenter:unsubscribe(MessageType.SET_PARTS_LIFETIME, self)
	g_messageCenter:unsubscribe(MessageType.SET_DIFFICULTY, self)
	g_messageCenter:unsubscribe(MessageType.SET_DAYSPERPERIOD, self)
	--g_messageCenter:unsubscribe(MessageType.RVB_START_REPAIR, self)
	--g_messageCenter:unsubscribe(MessageType.RVB_START_SERVICE, self)
	--g_messageCenter:unsubscribe(MessageType.RVB_START_INSPECTION, self)
	--g_messageCenter:unsubscribe(MessageType.RVB_END_INSPECTION, self)

end

function VehicleBreakdowns:getBatteryChPrice()
	local spec = self.spec_faultData
	return VehicleBreakdowns.calculateBatteryChPrice(300, spec.rvb[5])
end

function VehicleBreakdowns:getBatteryChPrice_AAAA()
	local spec = self.spec_faultData
	local currentChargeLevel = math.floor((1 - self:getIsFaultBattery())*100)
	local lackofcharge = 100 - currentChargeLevel
	spec.battery.chargeAmount = self.calculateBatteryChPrice(1000, self:getIsFaultBattery()) / lackofcharge

	return self.calculateBatteryChPrice(1000, self:getIsFaultBattery())
end

function VehicleBreakdowns.calculateBatteryChPrice(price, charge)
    -- up to 9% of the price at full damage
    -- repairing more often at low damages is rewarded - repairing always at 10% saves about half of the repair price
    return price * math.pow(charge, 1.5) * 0.09
end





function VehicleBreakdowns:DebugFaultPrint(spec)
    local faultMessages = {}
    for faultIndex, isActive in pairs(spec.faultList) do
        if isActive and g_vehicleBreakdownsPartKeys[faultIndex] then
			table.insert(faultMessages, g_i18n:getText("RVB_faultText_"..g_vehicleBreakdownsPartKeys[faultIndex]))
        end
    end
    if #faultMessages > 0 then
        local NotifiText = g_i18n:getText("RVB_ErrorNotifi") .. table.concat(faultMessages, ", ")
        g_currentMission:addGameNotification(
            g_i18n:getText("input_VEHICLE_BREAKDOWN_MENU"),
            NotifiText,
            "",
            nil, --"dataS/menu/vignette.dds",
            4000
        )
    end
    for faultIndex, _ in pairs(spec.faultList) do
        spec.faultList[faultIndex] = nil
    end
end

-- IGAZÁBÓL NEM KELL
function VehicleBreakdowns:onEnterVehicle()
	local spec = self.spec_faultData
	

	local RVB = g_currentMission.vehicleBreakdowns

	
	local RVBSET = g_currentMission.vehicleBreakdowns
	local showOnHud = RVBSET:getIsAlertMessage()
	local showOnInfoHud = RVBSET:getIsAlertMessage()
	local batteryFillUnitIndex = self:getConsumerFillUnitIndex(FillType.BATTERYCHARGE)
	--self.spec_fillUnit.fillUnits[batteryFillUnitIndex].showOnHud = showOnHud
	--self.spec_fillUnit.fillUnits[batteryFillUnitIndex].showOnInfoHud = showOnInfoHud
		
	if self.isServer then 
		--spec.rvb[1] = spec.rvb[1] + 1
	--RVBTotal_Event.sendEvent(self, spec.rvb)
	end
	--print(VehicleBreakdowns.GSET_Change_difficulty)

	
end



function VehicleBreakdowns:onLeaveVehicle()
	local spec = self.spec_faultData
	--if spec.isRVBMotorStarted then
    --    	spec.isRVBMotorStarted = false
	--	if self.isClient then
	--		stopSample(VehicleBreakdowns.sounds["self_starter"], 0 , 0)
	--	end
	--end

	if not spec.isrvbSpecEnabled then
		return
	end
	self.rvb_addextra_connecting = false
end

function VehicleBreakdowns:mouseEvent(posX, posY, isDown, isUp, button)
end

function VehicleBreakdowns:keyEvent(unicode, sym, modifier, isDown)
end




function VehicleBreakdowns:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_motorized
	local rvb = self.spec_faultData
	
	VehicleBreakdowns.updateActionEvents(self)


	
	-- sync engine data with server
	if not g_modIsLoaded["FS25_gameplay_RoadMaster"] then
		rvb.updateTimer = rvb.updateTimer + dt
		if self.isServer and self.getIsMotorStarted ~= nil and self:getIsMotorStarted() then
			rvb.motorTemperature = spec.motorTemperature.value
			rvb.fanEnabled = spec.motorFan.enabled
			rvb.lastFuelUsage = spec.lastFuelUsage
			rvb.lastDefUsage = spec.lastDefUsage
			rvb.lastAirUsage = spec.lastAirUsage
			rvb.lastDieselFuelUsage = spec.lastDieselFuelUsage
			rvb.fanEnableTemperature = spec.motorFan.enableTemperature
			rvb.fanDisableTemperature = spec.motorFan.disableTemperature
			if rvb.updateTimer >= 1000 and rvb.motorTemperature ~= self.spec_motorized.motorTemperature.valueSend then
				self:raiseDirtyFlags(rvb.motorizedDirtyFlag)
			end
			if rvb.fanEnabled ~= rvb.fanEnabledLast then
				rvb.fanEnabledLast = rvb.fanEnabled
				self:raiseDirtyFlags(rvb.motorizedDirtyFlag)
			end
		end
		if self.isClient and not self.isServer and self.getIsMotorStarted ~= nil and self:getIsMotorStarted() then
			spec.motorTemperature.value = rvb.motorTemperature
			spec.motorFan.enabled = rvb.fanEnabled
			spec.lastFuelUsage = rvb.lastFuelUsage
			spec.lastDefUsage = rvb.lastDefUsage
			spec.lastAirUsage = rvb.lastAirUsage
			spec.lastDieselFuelUsage = rvb.lastDieselFuelUsage
			spec.motorFan.enableTemperature = rvb.fanEnableTemperature
			spec.motorFan.disableTemperature = rvb.fanDisableTemperature
		end
	end	
	-- sync end

	rvb.updateBatteryTimer = rvb.updateBatteryTimer + dt
	if self.isServer then
		rvb.RVB_BatteryFillLevel = self.spec_fillUnit.fillUnits[rvb.batteryFillUnitIndex].fillLevel
		if rvb.updateBatteryTimer >= 1000 then
			self:raiseDirtyFlags(rvb.dirtyFlag)
			rvb.updateBatteryTimer = 0
		end
	end
	if self.isClient and not self.isServer then
		self.spec_fillUnit.fillUnits[rvb.batteryFillUnitIndex].fillLevel = rvb.RVB_BatteryFillLevel
		self.spec_fillUnit.fillUnits[rvb.batteryFillUnitIndex].fillType = FillType.BATTERYCHARGE
		--self:raiseDirtyFlags(self.spec_fillUnit.dirtyFlag)
	end

end


function VehicleBreakdowns:getSpeed(vehicle)
	local speedMulti = g_gameSettings:getValue('useMiles') and 0.621371192 or 1
	local speed = math.max(Utils.getNoNil(vehicle.lastSpeed, 0) * 3600 * speedMulti, 0)
	return string.format("%1.0f", speed)
end

function VehicleBreakdowns:getIsOperatingHoursTemp()
	local spec = self.spec_faultData
	return spec.rvb[2]
end

function VehicleBreakdowns:getFaultThermostat()
	local spec = self.spec_faultData
	return spec.parts[THERMOSTAT].damaged or spec.parts[THERMOSTAT].repairreq
end

function VehicleBreakdowns:getIsFaultThermostatoverHeating()
	local spec = self.spec_faultData
	return spec.faultStorage[1]
end

function VehicleBreakdowns:getIsFaultThermostatoverCooling()
	local spec = self.spec_faultData
	return spec.faultStorage[2]
end

function VehicleBreakdowns:getIsFaultLightings()
	local spec = self.spec_faultData
	return spec.parts[LIGHTINGS].damaged or spec.parts[LIGHTINGS].repairreq
end

function VehicleBreakdowns:getIsFaultGlowPlug()
	local spec = self.spec_faultData
	return spec.parts[GLOWPLUG].damaged or spec.parts[GLOWPLUG].repairreq
end

function VehicleBreakdowns:getIsFaultWipers()
	local spec = self.spec_faultData
	return spec.parts[WIPERS].damaged or spec.parts[WIPERS].repairreq
end

function VehicleBreakdowns:getIsFaultGenerator()
	local spec = self.spec_faultData
	return spec.parts[GENERATOR].damaged or spec.parts[GENERATOR].repairreq
end

function VehicleBreakdowns:getIsFaultEngine()
	local spec = self.spec_faultData
	return spec.parts[ENGINE].damaged or spec.parts[ENGINE].repairreq
end

function VehicleBreakdowns:getIsFaultSelfStarter()
	local spec = self.spec_faultData
	return spec.parts[SELFSTARTER].damaged or spec.parts[SELFSTARTER].repairreq
end

function VehicleBreakdowns:getIsFaultBattery()
	local batteryFillUnitIndex = self:getConsumerFillUnitIndex(FillType.BATTERYCHARGE)
	local dieselFillUnitIndex = self:getConsumerFillUnitIndex(FillType.DIESEL)
	
	if batteryFillUnitIndex ~= nil and dieselFillUnitIndex ~= nil then
		return tonumber(self:getFillUnitFillLevelPercentage(batteryFillUnitIndex)) or 1
	end
	return 1
end

function VehicleBreakdowns:setIsFaultBattery(value)
	local spec = self.spec_faultData
	spec.rvb[5] = value
	--if spec.rvb[5] > 1 then
	--	spec.rvb[5] = 1
	--end
	return spec.rvb[5]
end

--TOROLNI
function VehicleBreakdowns:getThermostatPercentage()
	local spec = self.spec_faultData
	return (spec.parts[THERMOSTAT].operatingHours * 100) / spec.parts[THERMOSTAT].tmp_lifetime
end

function VehicleBreakdowns:getPartsPercentage(part)
	local spec = self.spec_faultData
	return (spec.parts[part].operatingHours * 100) / spec.parts[part].tmp_lifetime
end
function VehicleBreakdowns:getFaultParts(part)
	local spec = self.spec_faultData
	return spec.parts[part].damaged or spec.parts[part].repairreq
end
	
function VehicleBreakdowns:getIsFaultOperatingHours()
	local spec = self.spec_faultData
	return spec.rvb[4]
end

function VehicleBreakdowns:getIsRepair()
	local spec = self.spec_faultData
	return spec.repair[1]
end
function VehicleBreakdowns:getIsInspection()
	local spec = self.spec_faultData
	return spec.inspection[1]
end
function VehicleBreakdowns:getIsService()
	local spec = self.spec_faultData
	return spec.service[1]
end

function VehicleBreakdowns:getIsDailyService()
	local spec = self.spec_faultData
	return spec.service[2]
end

function VehicleBreakdowns:getIsPeriodicServiceTime()
	local spec = self.spec_faultData
	return spec.service[3]
end

function VehicleBreakdowns:setIsPeriodicServiceTime(servicetime)
	local spec = self.spec_faultData
	spec.service[3] = servicetime
end

function VehicleBreakdowns:getIsRepairStartService()
	local spec = self.spec_faultData
	return spec.vehicleService[3]
end

function VehicleBreakdowns:getIsRepairClockService()
	local spec = self.spec_faultData
	return spec.vehicleService[4]
end

function VehicleBreakdowns:getIsRepairTimeService()
	local spec = self.spec_faultData
	return spec.vehicleService[5]
end

function VehicleBreakdowns:getIsRepairTimePassedService()
	local spec = self.spec_faultData
	return spec.vehicleService[6]
end

function VehicleBreakdowns:getIsRepairScaleService()
	local spec = self.spec_faultData
	return spec.vehicleService[7]
end

function VehicleBreakdowns:setPartsRepairreq(part, state)
	local spec = self.spec_faultData
	spec.parts[part].repairreq = state
	--g_client:getServerConnection():sendEvent(BatteryFillUnitFillLevelEvent.new(self.vehicle, true))
	RVBParts_Event.sendEvent(self, spec.parts)
end


function VehicleBreakdowns:getSellPrice_RVBClone()
    local storeItem = g_storeManager:getItemByXMLFilename(self.configFileName)
    return VehicleBreakdowns.calculateSellPriceClone(storeItem, self.age, self.operatingTime, self:getPrice(), self:getRepairPrice(), self:getRepairPrice_RVBClone(), self:getRepaintPrice())
end
function VehicleBreakdowns.calculateSellPriceClone(storeItem, age, operatingTime, price, repairPrice, repairPriceRVBClone, repaintPrice)
	local operatingTimeHours = operatingTime / 3600000
	local maxVehicleAge = storeItem.lifetime
	local ageInYears = age / Environment.PERIODS_IN_YEAR
	StoreItemUtil.loadSpecsFromXML(storeItem)
	local operatingTimeFactor = 1 - operatingTimeHours ^ (storeItem.specs.power == nil and 1.3 or 1) / maxVehicleAge
	local ageFactor = -0.1 * math.log(ageInYears) + 0.75
	local v476 = math.min(ageFactor, 0.85)
	local v477 = price * operatingTimeFactor * v476 - repairPrice - repairPriceRVBClone - repaintPrice
	local v478 = price * 0.03
	return math.max(v477, v478)
end


function VehicleBreakdowns:calculateCost(costType)
	local ageInYears = self.age / Environment.PERIODS_IN_YEAR
	local ageFactor = 1
	if costType == "repair" then
		if ageInYears < 2 then
			ageFactor = 0.95 + 0.02 * ageInYears
		elseif ageInYears <= 20 then
			ageFactor = 1 + 0.03 * ageInYears
		else
			ageFactor = math.min(1.6 + 0.05 * (ageInYears - 20), 2.2)
		end
		local rvb = self.spec_faultData
		local faultListCosts, laborCosts = 0, 0
		local baseLaborFee, hourlyRate = 100, 50
		for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
			local part = rvb.parts[key]
			if part and part.repairreq then
				local partCost = (i >= 9 and i <= 12) and 0.03 or REPAIR_COSTS[i]
				faultListCosts = faultListCosts + partCost
				local repairTimeSec = FaultRegistry[key].repairTime or 3600
				laborCosts = laborCosts + (repairTimeSec / 3600) * hourlyRate
			end
		end
		--return (self:getPrice() * ageFactor * faultListCosts) + laborCosts + baseLaborFee
		local total = (self:getPrice() * ageFactor * faultListCosts) + laborCosts + baseLaborFee

return total
	elseif costType == "inspection" then
		if ageInYears < 2 then
			ageFactor = 0.9 + 0.05 * ageInYears
		elseif ageInYears <= 20 then
			ageFactor = 1 + 0.05 * ageInYears
		else
			ageFactor = math.min(2 + 0.05 * (ageInYears - 20), 3)
		end
		--return self:getPrice() * ageFactor * REPAIR_COSTS[10]
		local total = self:getPrice() * ageFactor * REPAIR_COSTS[10]

return total
	elseif costType == "service" then
		if ageInYears < 2 then
			ageFactor = 0.9 + 0.05 * ageInYears
		elseif ageInYears <= 20 then
			ageFactor = 1 + 0.05 * ageInYears
		else
			ageFactor = math.min(2 + 0.05 * (ageInYears - 20), 3)
		end
		local rvb = self.spec_faultData
		local baseLaborFee, hourlyRate = 75, 50
		local materialCost = self:getPrice() * ageFactor * REPAIR_COSTS[9]
		local baseserviceTime = 10800
		local periodicService = g_currentMission.vehicleBreakdowns:getPeriodicService()
		local hoursOverdue = math.max(0, math.floor(rvb.rvb[4]) - periodicService)
		local additionalTime = hoursOverdue * SERVICE.TIME
		local totalServiceTime = baseserviceTime + additionalTime
		local laborCosts = (totalServiceTime / 3600) * hourlyRate
		--return materialCost + laborCosts + baseLaborFee
		local total = materialCost + laborCosts + baseLaborFee

return total
	end

	return 0
end


function VehicleBreakdowns:getRepairPrice_RVBClone()
	return self:calculateCost("repair")
end
function VehicleBreakdowns:getServicePrice()
	return self:calculateCost("service")
end
function VehicleBreakdowns:getInspectionPrice()
	return self:calculateCost("inspection")
end


function VehicleBreakdowns:RVBresetVehicle()
	if self.isServer then
		--g_currentMission:addMoney(-self:getRepaintPrice(), self:getOwnerFarmId(), MoneyType.VEHICLE_REPAIR, true, true)
		local rvb = self.spec_faultData
		rvb.rvb = { 5, 0, 0, 0, 0 }
		rvb.faultStorage = { false, false }
		rvb.service = { false, false, 0, 0, 0, 0, 0, 0 }
		--rvb.battery = { false, false, 0, 0, 0, 0, 0 }
		rvb.repair = { false, false, 0, 0, 0, 0, 0, 0, 0, false }
		rvb.inspection = { false, false, 0, 0, 0, 0, 0, false }
		for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
			local part = rvb.parts[key]
			if part then
				part.operatingHours = 0.0
				part.repairreq = false
				part.prefault = "empty"
				part.fault = "empty"
			end
		end
		self:addFillUnitFillLevel(self:getOwnerFarmId(), rvb.batteryFillUnitIndex, 100, self:getFillUnitFillType(rvb.batteryFillUnitIndex), ToolType.UNDEFINED, nil)

		local RVB = g_currentMission.vehicleBreakdowns

		--table.remove(RVB.workshopVehicles, self)
		if RVB.workshopVehicles[self] then
			RVB.workshopVehicles[self] = nil
			RVB.workshopCount = RVB.workshopCount - 1
			WorkshopCount_Event.sendEvent(RVB.workshopCount)
		end


		
		--local v102 = self.spec_wearable
		--for _, v103 in ipairs(v102.wearableNodes) do
		--	self:setNodeWearAmount(v103, 0, true)
		--end
--		self:raiseDirtyFlags(rvb.dirtyFlag)
		--local v104, _ = g_farmManager:updateFarmStats(self:getOwnerFarmId(), "repaintVehicleCount", 1)
		--if v104 ~= nil then
		--	g_achievementManager:tryUnlock("VehicleRepaint", v104)
		--end
	end
end

function VehicleBreakdowns:onRVBVehicleReset(vehicle)
	--print("DEBUG: onRVBVehicleReset called! " .. state)
    --print("isResetInProgress " .. tostring(self.isResetInProgress) .. " " ..  self:getFullName())

    if vehicle ~= self then
        return
    end
    
    if self.isServer  then

    local rvb = self.spec_faultData

    rvb.service = { false, false, 0, 0, 0, 0, 0, 0 }
    rvb.repair = { false, false, 0, 0, 0, 0, 0, 0, 0, false }
	rvb.inspection = { false, false, 0, 0, 0, 0, 0, false }
    
    for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
        local part = rvb.parts[key]
		if part then
			part.repairreq = false
			part.prefault = "empty"
			part.fault = "empty"
		end
    end
    
    self:addFillUnitFillLevel(self:getOwnerFarmId(), rvb.batteryFillUnitIndex, 100, self:getFillUnitFillType(rvb.batteryFillUnitIndex), ToolType.UNDEFINED, nil)

	local RVB = g_currentMission.vehicleBreakdowns

	if RVB.workshopVehicles[self] then
		RVB.workshopVehicles[self] = nil
		RVB.workshopCount = RVB.workshopCount - 1
		WorkshopCount_Event.sendEvent(RVB.workshopCount)
	end
    end

end




local InGameMenuMapFrame_onYesNoReset_Orig = InGameMenuMapFrame.onYesNoReset

function InGameMenuMapFrame:onYesNoReset(yes)
    if yes then
        if self.currentHotspot ~= nil then
            local v492_ = InGameMenuMapUtil.getHotspotVehicle(self.currentHotspot)
            if v492_ ~= nil then
            
                -- Ezt tesszük hozzá:
                
                -- mentés a reset előtt
    --[[local savedOperatingHours = {}
    for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
        local part = v492_.spec_faultData.parts[key]
        if part then
            savedOperatingHours[key] = part.operatingHours
        end
    end]]

    -- tároljuk globálisan vagy vehicle-hez kötve
    --v492_.__savedOperatingHours = savedOperatingHours
                print("RVB DEBUG: Reset started for " .. v492_:getFullName())
                g_messageCenter:publish(MessageType.RVB_VEHICLE_RESET, v492_)
                
                -- eredeti kód
                self:setMapSelectionItem(nil)
                g_messageCenter:subscribe(ResetVehicleEvent, self.onVehicleReset, self)
                self.isResetPending = true
                g_client:getServerConnection():sendEvent(ResetVehicleEvent.new(v492_))
                return
            end
        end
    else
        self.elementToFocus = self.contextButtonList
    end
end



function VehicleBreakdowns.AIJob_stopTask(self, p47, p48)
	p47:stop(p48)
	if self.isServer then
		if p47.deactivateLights ~= nil then
			p47:deactivateLights()
		end
		g_server:broadcastEvent(AITaskStopEvent.new(self, p47, p48))
	end
end
AIJob.onUpdateTick = Utils.overwrittenFunction(AIJob.onUpdateTick, VehicleBreakdowns.AIJob_stopTask)



function table:count()
	local c = 0
	if self ~= nil then
		for _ in pairs(self) do
			c = c + 1
		end
	end
	return c
end

function table:contains(value)
	for _, v in pairs(self) do
		if v == value then
			return true
		end
	end
	return false
end



function VehicleBreakdowns.FillUnitloadFillUnitFromXML(p371, p372, p373, p_u_374, p375)
	local v_u_376 = p371.spec_fillUnit
	p_u_374.fillUnitIndex = p375
	--p_u_374.capacity = p372:getValue(p373 .. "#capacity", math.huge)
	p_u_374.capacity = p372:getValue(p373 .. "#capacity", 100)

	p_u_374.defaultCapacity = p_u_374.capacity
	p_u_374.updateMass = p372:getValue(p373 .. "#updateMass", true)
	p_u_374.canBeUnloaded = p372:getValue(p373 .. "#canBeUnloaded", true)
	p_u_374.allowFoldingThreshold = p372:getValue(p373 .. "#allowFoldingThreshold")
	p_u_374.needsSaving = true
	p_u_374.fillLevel = 0
	p_u_374.fillLevelSent = 0
	p_u_374.fillType = FillType.UNKNOWN
	p_u_374.fillTypeSent = FillType.UNKNOWN
	p_u_374.fillTypeToDisplay = FillType.UNKNOWN
	p_u_374.fillLevelToDisplay = nil
	p_u_374.capacityToDisplay = nil
	p_u_374.lastValidFillType = FillType.UNKNOWN
	p_u_374.lastValidFillTypeSent = FillType.UNKNOWN										   
	if p372:hasProperty(p373 .. ".exactFillRootNode") then
		XMLUtil.checkDeprecatedXMLElements(p372, p373 .. ".exactFillRootNode#index", p373 .. ".exactFillRootNode#node")
		p_u_374.exactFillRootNode = p372:getValue(p373 .. ".exactFillRootNode#node", nil, p371.components, p371.i3dMappings)
		if p_u_374.exactFillRootNode == nil then
			Logging.xmlWarning(p371.xmlFile, "ExactFillRootNode not found for fillUnit \'%s\'!", p373)
		elseif CollisionFlag.getHasGroupFlagSet(p_u_374.exactFillRootNode, CollisionFlag.FILLABLE) then
			v_u_376.exactFillRootNodeToFillUnit[p_u_374.exactFillRootNode] = p_u_374
			v_u_376.exactFillRootNodeToExtraDistance[p_u_374.exactFillRootNode] = p372:getValue(p373 .. ".exactFillRootNode#extraEffectDistance", 0)
			v_u_376.hasExactFillRootNodes = true
			g_currentMission:addNodeObject(p_u_374.exactFillRootNode, p371)
		else
			Logging.xmlWarning(p371.xmlFile, "Missing collision group %s. Please add this bit to exact fill root node \'%s\' collision filter group in \'%s\'", CollisionFlag.getBitAndName(CollisionFlag.FILLABLE), getName(p_u_374.exactFillRootNode), p373)
		end
	--- RVB mod
	else
		for _, otherFillUnit in ipairs(v_u_376.fillUnits) do
			if otherFillUnit.exactFillRootNode ~= nil then
				local cloneNode = clone(otherFillUnit.exactFillRootNode, true, false)
				link(getParent(otherFillUnit.exactFillRootNode), cloneNode)
				setTranslation(cloneNode, 0,0,0)
				local fillUnitIndexStr = tostring(p_u_374.fillUnitIndex or 0)
				setName(cloneNode, "BatteryFillRootNode_" .. fillUnitIndexStr)
				p_u_374.exactFillRootNode = cloneNode
				--print(("Klónoztam exactFillRootNode-t: fillUnit %s kapott node-ot %s-ről"):format(p375, otherFillUnit.fillType))
				break
			end
		end

		if p_u_374.exactFillRootNode == nil then
			Logging.xmlWarning(p371.xmlFile, "RVB ExactFillRootNode not found for fillUnit \'%s\'!", p373)
		elseif CollisionFlag.getHasGroupFlagSet(p_u_374.exactFillRootNode, CollisionFlag.FILLABLE) then
			v_u_376.exactFillRootNodeToFillUnit[p_u_374.exactFillRootNode] = p_u_374
			v_u_376.exactFillRootNodeToExtraDistance[p_u_374.exactFillRootNode] = p372:getValue(p373 .. ".exactFillRootNode#extraEffectDistance", 0)
			v_u_376.hasExactFillRootNodes = true
			g_currentMission:addNodeObject(p_u_374.exactFillRootNode, p371)
		else
			Logging.xmlWarning(p371.xmlFile, "RVB Missing collision group %s. Please add this bit to exact fill root node \'%s\' collision filter group in \'%s\'", CollisionFlag.getBitAndName(CollisionFlag.FILLABLE), getName(p_u_374.exactFillRootNode), p373)
		end
	--- RVB MOD END
	end
	XMLUtil.checkDeprecatedXMLElements(p372, p373 .. ".autoAimTargetNode#index", p373 .. ".autoAimTargetNode#node")
	p_u_374.autoAimTarget = {}
	p_u_374.autoAimTarget.node = p372:getValue(p373 .. ".autoAimTargetNode#node", nil, p371.components, p371.i3dMappings)
	if p_u_374.autoAimTarget.node ~= nil then
		p_u_374.autoAimTarget.baseTrans = { getTranslation(p_u_374.autoAimTarget.node) }
		p_u_374.autoAimTarget.startZ = p372:getValue(p373 .. ".autoAimTargetNode#startZ")
		p_u_374.autoAimTarget.endZ = p372:getValue(p373 .. ".autoAimTargetNode#endZ")
		p_u_374.autoAimTarget.startPercentage = p372:getValue(p373 .. ".autoAimTargetNode#startPercentage", 25) / 100
		p_u_374.autoAimTarget.invert = p372:getValue(p373 .. ".autoAimTargetNode#invert", false)
		if p_u_374.autoAimTarget.startZ ~= nil and p_u_374.autoAimTarget.endZ ~= nil then
			local v377 = p_u_374.autoAimTarget.startZ
			if p_u_374.autoAimTarget.invert then
				v377 = p_u_374.autoAimTarget.endZ
			end
			setTranslation(p_u_374.autoAimTarget.node, p_u_374.autoAimTarget.baseTrans[1], p_u_374.autoAimTarget.baseTrans[2], v377)
		end
	end
	p_u_374.supportedFillTypes = {}
	local v378 = p372:getValue(p373 .. "#fillTypeCategories")
	local v379 = p372:getValue(p373 .. "#fillTypes")
	local v380
	if v378 == nil or v379 ~= nil then
		if v378 ~= nil or v379 == nil then
			Logging.xmlWarning(p371.xmlFile, "Missing \'fillTypeCategories\' or \'fillTypes\' for fillUnit \'%s\'", p373)
			return false
		end
		v380 = g_fillTypeManager:getFillTypesByNames(v379, "Warning: \'" .. p371.configFileName .. "\' has invalid fillType \'%s\'.")
	else
		v380 = g_fillTypeManager:getFillTypesByCategoryNames(v378, "Warning: \'" .. p371.configFileName .. "\' has invalid fillTypeCategory \'%s\'.")
	end
	if v380 ~= nil then
		for _, v381 in pairs(v380) do
			p_u_374.supportedFillTypes[v381] = true
		end
	end
	p_u_374.supportedToolTypes = {}
	for v382 = 1, g_toolTypeManager:getNumberOfToolTypes() do
		p_u_374.supportedToolTypes[v382] = true
	end
	local v383 = p372:getValue(p373 .. "#startFillLevel")
	local v384 = p372:getValue(p373 .. "#startFillType")
	if v384 ~= nil then
		local v385 = g_fillTypeManager:getFillTypeIndexByName(v384)
		if v385 ~= nil then
			p_u_374.startFillLevel = v383
			p_u_374.startFillTypeIndex = v385
		end
	end
	p_u_374.fillRootNode = p372:getValue(p373 .. ".fillRootNode#node", nil, p371.components, p371.i3dMappings)
	if p_u_374.fillRootNode == nil then
		p_u_374.fillRootNode = p371.components[1].node
	end
	p_u_374.fillMassNode = p372:getValue(p373 .. ".fillMassNode#node", nil, p371.components, p371.i3dMappings)
	local v386 = p372:getValue(p373 .. "#updateFillLevelMass", true)
	if p_u_374.fillMassNode == nil and v386 then
		p_u_374.fillMassNode = p371.components[1].node
	end
	p_u_374.ignoreFillLimit = p372:getValue(p373 .. "#ignoreFillLimit", false)
	p_u_374.synchronizeFillLevel = p372:getValue(p373 .. "#synchronizeFillLevel", true)
	p_u_374.synchronizeFullFillLevel = p372:getValue(p373 .. "#synchronizeFullFillLevel", false)
	local v387 = 16
	for v388, v389 in pairs(FillUnit.CAPACITY_TO_NETWORK_BITS) do
		if v388 <= p_u_374.capacity then
			v387 = v389
		end
	end
	p_u_374.synchronizationNumBits = p372:getValue(p373 .. "#synchronizationNumBits", v387)
	p_u_374.showOnHud = p372:getValue(p373 .. "#showOnHud", true)
	p_u_374.showOnInfoHud = p372:getValue(p373 .. "#showOnInfoHud", true)
	p_u_374.uiPrecision = p372:getValue(p373 .. "#uiPrecision", 0)
	p_u_374.uiCustomFillTypeName = p372:getValue(p373 .. "#uiCustomFillTypeName", nil, p371.customEnvironment, false)
	p_u_374.uiExtraInfoText = p372:getValue(p373 .. "#uiExtraInfoText", nil, p371.customEnvironment, false)
	p_u_374.uiDisplayTypeId = FillLevelsDisplay["TYPE_" .. p372:getValue(p373 .. "#uiDisplayType", "BAR")] or FillLevelsDisplay.TYPE_BAR
	local v390 = p372:getValue(p373 .. "#unitTextOverride")
	if v390 ~= nil then
		p_u_374.unitText = g_i18n:convertText(v390)
	end
	p_u_374.parentUnitOnHud = nil
	p_u_374.childUnitOnHud = nil
	p_u_374.blocksAutomatedTrainTravel = p372:getValue(p373 .. "#blocksAutomatedTrainTravel", false)
	p_u_374.fillAnimation = p372:getValue(p373 .. "#fillAnimation")
	p_u_374.fillAnimationLoadTime = p372:getValue(p373 .. "#fillAnimationLoadTime")
	p_u_374.fillAnimationEmptyTime = p372:getValue(p373 .. "#fillAnimationEmptyTime")
	p_u_374.fillLevelAnimations = {}
	for _, v391 in p372:iterator(p373 .. ".fillLevelAnimation") do
		local v392 = {
			["name"] = p372:getValue(v391 .. "#name")
		}
		if v392.name == nil then
			Logging.xmlWarning(p372, "Missing \'name\' for fillLevelAnimation \'%s\'", v391)
		else
			v392.resetOnEmpty = p372:getValue(v391 .. "#resetOnEmpty", true)
			v392.updateWhileFilled = p372:getValue(v391 .. "#updateWhileFilled", true)
			v392.useMaxStateIfEmpty = p372:getValue(v391 .. "#useMaxStateIfEmpty", false)
			local v393 = p_u_374.fillLevelAnimations
			table.insert(v393, v392)
		end
	end
	if p371.isClient then
		p_u_374.alarmTriggers = {}
		local v394 = 0
		while true do
			local v395 = p373 .. string.format(".alarmTriggers.alarmTrigger(%d)", v394)
			if not p372:hasProperty(v395) then
				break
			end
			local v396 = {}
			if p371:loadAlarmTrigger(p372, v395, v396, p_u_374) then
				local v397 = p_u_374.alarmTriggers
				table.insert(v397, v396)
			end
			v394 = v394 + 1
		end
		p_u_374.measurementNodes = {}
		local v398 = 0
		while true do
			local v399 = p373 .. string.format(".measurementNodes.measurementNode(%d)", v398)
			if not p372:hasProperty(v399) then
				break
			end
			local v400 = {}
			if p371:loadMeasurementNode(p372, v399, v400) then
				local v401 = p_u_374.measurementNodes
				table.insert(v401, v400)
			end
			v398 = v398 + 1
		end
		p_u_374.fillPlane = {}
		p_u_374.lastFillPlaneType = nil
		if not p371:loadFillPlane(p372, p373 .. ".fillPlane", p_u_374.fillPlane, p_u_374) then
			p_u_374.fillPlane = nil
		end
		p_u_374.fillTypeMaterials = p371:loadFillTypeMaterials(p372, p373)
		p_u_374.fillEffects = g_effectManager:loadEffect(p372, p373 .. ".fillEffect", p371.components, p371, p371.i3dMappings)
		p_u_374.animationNodes = g_animationManager:loadAnimations(p372, p373 .. ".animationNodes", p371.components, p371, p371.i3dMappings)
		XMLUtil.checkDeprecatedXMLElements(p372, p373 .. ".fillLevelHud", p373 .. ".dashboard")
		p_u_374.hasDashboards = false
		if p371.registerDashboardValueType ~= nil then
			local function v_u_409(_, p402, p403, p404, _)
				-- upvalues: (copy) v_u_376, (copy) p_u_374
				local v405 = p402:getValue(p403 .. "#fillType")
				if v405 ~= nil then
					local v406 = g_fillTypeManager:getFillTypeIndexByName(v405)
					if v406 ~= nil then
						for _, v407 in ipairs(v_u_376.fillUnits) do
							if v407.supportedFillTypes[v406] then
								p404.fillUnit = v407
							end
						end
					end
				end
				local v408 = p402:getValue(p403 .. "#fillUnitIndex")
				if v408 ~= nil then
					p404.fillUnit = v_u_376.fillUnits[v408]
				end
				if p404.fillUnit == nil then
					p_u_374.hasDashboards = true
				else
					p404.fillUnit.hasDashboards = true
				end
				return true
			end
				local v410 = DashboardValueType.new("fillUnit", "fillLevel")
				v410:setXMLKey(p373)
				v410:setValue(p_u_374, function(p411, p412)
					return (p412.fillUnit or p411).fillLevel
				end)
				v410:setRange(0, function(p413, p414)
					return (p414.fillUnit or p413).capacity
				end)
				v410:setInterpolationSpeed(function(p415, p416)
					return (p416.fillUnit or p415).capacity * 0.001
				end)
				v410:setAdditionalFunctions(v_u_409, nil)
				v410:setPollUpdate(false)
				p371:registerDashboardValueType(v410)
			local v417 = DashboardValueType.new("fillUnit", "fillLevelPct")
			v417:setXMLKey(p373)
			v417:setValue(p_u_374, function(p418, p419)
				local v420 = p419.fillUnit or p418
				local v421 = v420.fillLevel / v420.capacity
				return math.clamp(v421, 0, 1) * 100
			end)
			v417:setRange(0, 100)
			v417:setInterpolationSpeed(0.1)
			v417:setAdditionalFunctions(v_u_409, nil)
			v417:setPollUpdate(false)
			p371:registerDashboardValueType(v417)
			local v422 = DashboardValueType.new("fillUnit", "fillLevelWarning")
			v422:setXMLKey(p373)
			v422:setValue(p_u_374, function(p423, p424)
				local v425 = (p424.fillUnit or p423).fillLevel
				local v426
				if p424.warningThresholdMin < v425 then
					v426 = v425 < p424.warningThresholdMax
				else
					v426 = false
				end
				return v426
			end)
			v422:setAdditionalFunctions(function(p427, p428, p429, p430, p431)
				-- upvalues: (copy) v_u_409
				v_u_409(p427, p428, p429, p430, p431)
				return Dashboard.warningAttributes(p427, p428, p429, p430, p431)
			end)
			v422:setPollUpdate(false)
			p371:registerDashboardValueType(v422)
		end
	end
	return true
end

--FillUnit.loadFillUnitFromXML = Utils.overwrittenFunction(FillUnit.loadFillUnitFromXML, VehicleBreakdowns.FillUnitloadFillUnitFromXML)





function VehicleBreakdowns:addBreakdown(partKey, fault, pre)

    local spec = self.spec_faultData
    if not spec then return end

	--print("partKey "..partKey)
	--print("fault "..fault)
	--print("pre "..tostring(pre))
	local part = spec.parts[partKey]
	local faultData = FaultRegistry[partKey]
	if part and faultData then
		if pre then
			part.prefault = fault
		else
			part.fault = fault
			part.repairreq = true
		end

	end
end


local function parseArguments(argString)
    if argString == nil or type(argString) ~= 'string' or argString == '' then
        return {}
    end
    
    local args = {}
    -- Szóközzel elválasztott argumentumok, minden karaktert elfogad
    for arg in string.gmatch(argString, "[^%s]+") do
        table.insert(args, arg)
    end
    return args
end

VehicleBreakdowns.ConsoleCommands = {}

-- A függvény a console parancsból közvetlenül kapja az argumentumokat
function VehicleBreakdowns.ConsoleCommands:addBreakdown(partKey, fault, pre)
    local vehicle = g_localPlayer:getCurrentVehicle() 
    if not vehicle then 
        print("[RVB] Hiba: nincs jármű kiválasztva!")
        return 
    end

    if not partKey or not fault then
        print("[RVB] Hiba: partKey vagy fault nincs megadva!")
        return
    end

    partKey = string.upper(partKey)
    pre = pre and pre:lower() == "yes" or false
    
    vehicle:addBreakdown(partKey, fault, pre)
    print(string.format("RVB: Added breakdown '%s' at fault '%s' at pre '%s' to '%s'.", partKey, fault, tostring(pre), vehicle:getFullName()))
end

-- rvb_addPreBreakdown engine misfire yes
-- rvb_addPreBreakdown engine lowOilPressure yes
-- rvb_addPreBreakdown engine headGasketFailure yes
-- rvb_addPreBreakdown engine overheating yes
-- rvb_addPreBreakdown engine mechanicalWear yes
-- rvb_addPreBreakdown engine sensorFault yes
-- rvb_addPreBreakdown engine completeFailure yes

addConsoleCommand("rvb_addPreBreakdown", "Adds a breakdown. Usage: rvb_addPreBreakdown partname fault pre", "addBreakdown", VehicleBreakdowns.ConsoleCommands)