
rvbVehicle = {}
rvbVehicle.Parts = {}
for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
    rvbVehicle.Parts[key] = key
end
local P = rvbVehicle.Parts

function rvbVehicle.getSpeedLimit(self, superFunc, onlyIfWorking)
	local doCheckSpeedLimit = self:doCheckSpeedLimit()
    local limit --= math.huge
	
	local rvb = self.spec_faultData
	if rvb ~= nil then
		local fault = rvb.parts[P.ENGINE].fault or "empty"
		if fault and fault == "misfiring" or fault == "overheating" or fault == "lowOilPressure" then
			limit = 7
		end
	end

    if onlyIfWorking == nil or onlyIfWorking and doCheckSpeedLimit then
        limit = self:getRawSpeedLimit()

        local damage = self:getVehicleDamage()
        if damage > 0 then
            limit = limit * (1 - damage * Vehicle.DAMAGED_SPEEDLIMIT_REDUCTION)
        end
    else
		--limit = (1 / 0)
		limit = math.huge
	end
	
    local attachedImplements
	if self.getAttachedImplements == nil then
		attachedImplements = nil
	else
		attachedImplements = self:getAttachedImplements()
	end
    if attachedImplements ~= nil then
        for _, implement in pairs(attachedImplements) do
            if implement.object ~= nil then
                local speed, implementDoCheckSpeedLimit = implement.object:getSpeedLimit(onlyIfWorking)
                if onlyIfWorking == nil or onlyIfWorking and implementDoCheckSpeedLimit then
					if fault and fault == "misfiring" or fault == "overheating" or fault == "lowOilPressure" then
						limit = 3
					end
                    --limit = math.min(limit, speed)
					limit = math.min(limit or math.huge, speed or math.huge)
                end
                doCheckSpeedLimit = doCheckSpeedLimit or implementDoCheckSpeedLimit
            end
        end
    end
    return limit, doCheckSpeedLimit
end

function rvbVehicle.showInfo(self, box)
	
	local rvb = self.spec_faultData
	if rvb == nil or not rvb.isrvbSpecEnabled then
		return
	end
	if not g_modIsLoaded["FS25_InfoDisplayExtension"] then
		if self.ideHasPower == nil and self.isDeleted == false then
			local powerConfig = Motorized.loadSpecValuePowerConfig(self.xmlFile)
			self.ideHasPower = 0
			if powerConfig ~= nil then
				for configName, config in pairs(self.configurations) do
					if powerConfig[configName] ~= nil then
						local configPower = powerConfig[configName][config]
						if configPower ~= nil then
							self.ideHasPower = configPower
						end
					end
				end
			end
		end
		box:addLine(g_i18n:getText("infohud_mass"), string.format("%1.2f t\n", self:getTotalMass()))
		if self.ideHasPower ~= nil and self.ideHasPower ~= 0 then
			local hp, kw = g_i18n:getPower(self.ideHasPower)
			local neededPower = string.format(g_i18n:getText("shop_neededPowerValue"), MathUtil.round(kw), MathUtil.round(hp))
			box:addLine(g_i18n:getText("infoDisplayExtension_currentPower"), neededPower)
		end
		if self.getDirtAmount ~= nil then
			local dirt = self:getDirtAmount()
			if dirt > 0.01 then
				box:addLine(g_i18n:getText("groundType_dirt"), string.format("%d %%", dirt * 100))
			end
		end
	end

	-- INSPECTION
	if rvb.inspection[1] then -- and not rvb.repair[10]
		local tomorrowText = ""
		if rvb.inspection[3] > g_currentMission.environment.currentDay then
			tomorrowText = g_i18n:getText("infoDisplayExtension_tomorrow")
		end
		box:addLine(g_i18n:getText("infoDisplayExtension_inspectionVheicle"), tomorrowText..string.format("%02d:%02d", rvb.inspection[4], rvb.inspection[5]))
	end
	-- REPAIR
	if rvb.repair[1] then
		local tomorrowText = ""
		if rvb.repair[3] > g_currentMission.environment.currentDay then
			tomorrowText = g_i18n:getText("infoDisplayExtension_tomorrow")
		end
		box:addLine(g_i18n:getText("infoDisplayExtension_repairVheicle"), tomorrowText..string.format("%02d:%02d", rvb.repair[4], rvb.repair[5]))
	end
	-- SERVICE
	if self:getIsService() then
		local tomorrowText = ""
		if rvb.service[3] > g_currentMission.environment.currentDay then
			tomorrowText = g_i18n:getText("infoDisplayExtension_tomorrow")
		end
		box:addLine(g_i18n:getText("infoDisplayExtension_serviceVheicle"), tomorrowText..string.format("%02d:%02d", rvb.service[4], rvb.service[5]))
	end
end

--Vehicle.showInfo = Utils.appendedFunction(Vehicle.showInfo, rvbVehicle.showInfo)
Vehicle.showInfo = Utils.prependedFunction(Vehicle.showInfo, rvbVehicle.showInfo)