
RVBPlayer = {}
local RVBPlayer_mt = Class(RVBPlayer)
function RVBPlayer.register()
	local rvbplayer = RVBPlayer:new()
	return rvbplayer
end
function RVBPlayer:new()
	local self = {}
	setmetatable(self, RVBPlayer_mt)
	self.vehicle = nil
	self.infoText = ""
	self.jumperCableEventId = nil
	self.jumperCableConnections = {}
	self.toofar = ""
	RVBPlayer.appendedFunction(PlayerInputComponent, "update", self, "PlayerInputComponent_update", false)
	RVBPlayer.appendedFunction(PlayerInputComponent, "registerActionEvents", self, "PlayerInputComponent_registerActionEvents", false)
	return self
end
function RVBPlayer:actionEventConnectJumperCables()
	local targetVehicle = self.vehicle
	local isConnected = false
	for _, vehicle in ipairs(self.jumperCableConnections) do
		if vehicle.rootNode == targetVehicle.rootNode then
			isConnected = true
			break
		end
	end
	if isConnected then
		if #self.jumperCableConnections == 2 then
			if self.jumperCableConnections[1].rootNode == targetVehicle.rootNode then
				self:showWarning("RVB_blinking_disconnecting_order", self.vehicle)
				return
			end
			table.remove(self.jumperCableConnections, 2)
		else
			table.remove(self.jumperCableConnections, 1)
		end
		self:showWarning("RVB_blinking_disconnecting", self.vehicle)
	else
		if self:areJumperCablesConnected() then
			g_currentMission:showBlinkingWarning(g_i18n:getText("RVB_blinking_no_morejumpercables"), 2000)
			return
		end
		if #self.jumperCableConnections == 0 then
			if self.vehicle:getIsFaultBattery() > BATTERY_LEVEL.MOTOR + 0.02 then
				table.insert(self.jumperCableConnections, 1, targetVehicle)
				self:showWarning("RVB_blinking_connecting", self.vehicle)
			else
				self:showWarning("RVB_blinking_connecting_order", self.vehicle)
			end
		elseif #self.jumperCableConnections > 0 then
			if calcDistanceFrom(self.jumperCableConnections[1].rootNode, g_localPlayer.rootNode) <= JUMPERCABLE_LENGTH then
				if self.vehicle:getIsFaultBattery() <= BATTERY_LEVEL.MOTOR then
					table.insert(self.jumperCableConnections, 2, targetVehicle)
					self:showWarning("RVB_blinking_connecting", self.vehicle)
				else
					local title = g_i18n:getText("RVB_dialog_titleCONNECTING_JC")
					local text = string.format(g_i18n:getText("RVB_dialog_descCONNECTING_JC"), self.vehicle:getFullName())
					local callback = self.onYesNoResetVehicleDialog
					local sound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_WRENCH
					YesNoDialog.show(callback, self, text, title, nil, nil, nil, sound)
				end
			else
				--self.jumperCableConnections = {}
			end
		end
	end
end
function RVBPlayer.onYesNoResetVehicleDialog(self, yes)
	if yes then
		table.insert(self.jumperCableConnections, 2, self.vehicle)
		self:showWarning("RVB_blinking_connecting", self.vehicle)
	end
end
function RVBPlayer:getIsValidVehicle(vehicle, farmId)
	return vehicle:getShowInVehiclesOverview() and vehicle:getOwnerFarmId() == farmId
end
function RVBPlayer:PlayerInputComponent_update(inputComponent, dt)
	if inputComponent.player.isOwner and g_inputBinding:getContextName() == PlayerInputComponent.INPUT_CONTEXT_NAME and self.jumperCableEventId ~= nil then
		self.vehicle = nil
		self.infoText = ""
		local farmId = g_currentMission:getFarmId()
		if farmId ~= FarmManager.SPECTATOR_FARM_ID then
			local targetNode = inputComponent.player.targeter:getClosestTargetedNodeFromType(PlayerInputComponent)
			if targetNode ~= nil and entityExists(targetNode) then
				local nodeObject = g_currentMission:getNodeObject(targetNode)
				if nodeObject ~= nil and nodeObject:isa(Vehicle) then -- and self:getIsValidVehicle(nodeObject, farmId) then
					self.vehicle = nodeObject
					local isConnected = false
					for _, vehicle in ipairs(self.jumperCableConnections) do
						if vehicle.rootNode == self.vehicle.rootNode then
							isConnected = true
							break
						end
					end
					self.infoText = g_i18n:getText(isConnected and "action_RVB_DISCONNECTING_JC" or "input_RVB_CONNECTING_JC")
				end
			end
		end
		g_inputBinding:setActionEventTextPriority(self.jumperCableEventId, GS_PRIO_VERY_HIGH)
		g_inputBinding:setActionEventTextVisibility(self.jumperCableEventId, self.vehicle ~= nil and self.vehicle.spec_faultData ~= nil)
		g_inputBinding:setActionEventActive(self.jumperCableEventId, self.vehicle ~= nil and self.vehicle.spec_faultData ~= nil)
		g_inputBinding:setActionEventText(self.jumperCableEventId, self.infoText)
	end
end
function RVBPlayer:PlayerInputComponent_registerActionEvents(inputComponent)
	if inputComponent.player.isOwner then
		g_inputBinding:beginActionEventsModification(PlayerInputComponent.INPUT_CONTEXT_NAME)
		local _, jumperCableEventId = g_inputBinding:registerActionEvent(InputAction.RVB_CONNECTING_JC, self, self.actionEventConnectJumperCables, false, true, false, false, nil, true)
		self.jumperCableEventId = jumperCableEventId
		g_inputBinding:endActionEventsModification()
	end
end
function RVBPlayer:areJumperCablesConnected()
	return #self.jumperCableConnections >= 2
end
function RVBPlayer:showWarning(messageKey, vehicle)
    g_currentMission:showBlinkingWarning(string.format(g_i18n:getText(messageKey), vehicle:getFullName()), 2000)
end
function RVBPlayer.appendedFunction(oldTarget, oldFunc, newTarget, newFunc)
	local superFunc = oldTarget[oldFunc]
	oldTarget[oldFunc] = function(...)
		superFunc(...)
		newTarget[newFunc](newTarget, ...)
	end
end