
rvbUseYourTyres = {}

function rvbUseYourTyres.injWokshopScreenOnOpen(screen)
	if screen.uytWorkshopInited == nil then
		-- Button
		local uytBtn = ButtonElement.new(screen.buttonsBox)
		uytBtn.name = "uytReplace"
		screen.buttonsBox:addElement(uytBtn)
		uytBtn:applyProfile("buttonActivate")
		uytBtn:setInputAction("UYT_REPLACE_TYRES")
		uytBtn.onClickCallback = function()
			FS25_useYourTyres.UseYourTyres.onReplaceTyresCallback(screen)
		end
		uytBtn:setText(string.format("%s (%s)", g_i18n:getText("input_UYT_REPLACE_TYRES", "FS25_useYourTyres"), g_i18n:formatMoney(FS25_useYourTyres.UseYourTyres.getTyresPrice(screen.vehicle), 0, true, true)))
		screen.uytBtn = uytBtn
		-- Separator
		local uytSep = BitmapElement.new(uytBtn)
		uytSep.name = "separator"
		uytBtn:addElement(uytSep)
		uytSep:applyProfile("fs25_buttonBoxSeparator")
		screen.uytWorkshopInited = true
	end
	--screen:toggleCustomInputContext(true, "MENU_UYT")
	local _, eventId = g_inputBinding:registerActionEvent("UYT_REPLACE_TYRES", screen, FS25_useYourTyres.UseYourTyres.onReplaceTyresCallback, false, true, false, true)
	screen.uytEventId = eventId
end
rvbWorkshopScreen.onOpen = Utils.appendedFunction(rvbWorkshopScreen.onOpen, rvbUseYourTyres.injWokshopScreenOnOpen)
function rvbUseYourTyres.injWokshopScreenOnClose(screen)
	if screen.uytEventId ~= nil then
		g_inputBinding:removeActionEvent(screen.uytEventId)
		screen.uytEventId = nil
	end
	-- g_inputBinding:removeActionEventsByTarget(screen)
	-- screen:toggleCustomInputContext(false)
end
rvbWorkshopScreen.onClose = Utils.appendedFunction(rvbWorkshopScreen.onClose, rvbUseYourTyres.injWokshopScreenOnClose)
function rvbUseYourTyres.injWokshopScreenSetVehicle(screen, vehicle)
	if screen.uytBtn == nil then
		return
	end
	screen.uytBtn:setVisible(vehicle ~= nil and vehicle.uytHasTyres == true)
	if vehicle == nil then
		screen.uytBtn:setText(g_i18n:getText("input_UYT_REPLACE_TYRES", "FS25_useYourTyres"))
		screen.uytBtn:setDisabled(true)
	else
		screen.uytBtn:setText(string.format("%s (%s)", g_i18n:getText("input_UYT_REPLACE_TYRES", "FS25_useYourTyres"), g_i18n:formatMoney(FS25_useYourTyres.UseYourTyres.getTyresPrice(vehicle), 0, true, true)))
		screen.uytBtn:setDisabled(false)
	end
end
rvbWorkshopScreen.setVehicle = Utils.appendedFunction(rvbWorkshopScreen.setVehicle, rvbUseYourTyres.injWokshopScreenSetVehicle)