
ThermostatManager = {}
-- Cache-elt hibaregiszter
local g = FaultRegistry[THERMOSTAT]
local ghud = g.hud
local gtemp = ghud.temp
local condition = ghud.condition
local variants = g.variants

function ThermostatManager.updateThermostatColor(hud, part, motorTemp)
	local variantDef = variants[part.fault]
	local newColor = HUDCOLOR.DEFAULT
	if motorTemp < gtemp.cool then
		newColor = HUDCOLOR.COOL
	end
	if variantDef and variantDef.hudcolor then
		newColor = variantDef.hudcolor(motorTemp, gtemp)
	end
	local hudThermostat = hud.temperature
	if not hudThermostat.lastColor or not rvb_Utils.colorsAreEqual(hudThermostat.lastColor, newColor) then
		if part.fault ~= "empty" then
			hudThermostat:setColor(unpack(HUDCOLOR.DEFAULT))--print("ez fut DEFAULT "..unpack(HUDCOLOR.DEFAULT))
		else
			hudThermostat:setColor(unpack(newColor))--print("ez fut newColor "..unpack(newColor))
		end
		hudThermostat.lastColor = newColor
	end
end

function ThermostatManager.updateThermostatHud(hud, vehicle, dt)
	local hudThermostat = hud.temperature
	local currentColor = hudThermostat.lastColor or HUDCOLOR.DEFAULT
	local rvb = vehicle.spec_faultData
	if rvb == nil then return end
	local part = rvb.parts[THERMOSTAT]
	if vehicle:getIsMotorStarted() then
		local fault = part and part.fault or "empty"
		-- Reset, ha változott a hiba
		if fault ~= hudThermostat.lastFault then
			hudThermostat.timer = 0
			hudThermostat.playCount = 0
			hudThermostat.colorState = false
			hudThermostat.lastFault = fault
		end
		if fault ~= "empty" then
			hudThermostat.timer = (hudThermostat.timer or 0) + dt
			hudThermostat.colorState = hudThermostat.colorState or false
			hudThermostat.playCount = hudThermostat.playCount or 0
			if hudThermostat.playCount < 3 and not part.runOncePerStart then
				if hudThermostat.timer > 1400 then
					if not hudThermostat.colorState then
						-- Hang csak ha még nem játszódott le 3-szor
						hudThermostat:setColor(unpack(currentColor)) --print("timer 1400 "..unpack(currentColor))
						g_soundManager:playSample(rvb.samples.dasalert)
						hudThermostat.playCount = hudThermostat.playCount + 1
						hudThermostat.colorState = true
					end
					hudThermostat.timer = 0
				elseif hudThermostat.timer > 700 then
					if hudThermostat.colorState then
						hudThermostat:setColor(unpack(HUDCOLOR.DEFAULT)) --print("timer 700 "..unpack(currentColor))
						hudThermostat.colorState = false
					end
				end
			else
				part.runOncePerStart = true
				if not hudThermostat.lastColorHud or not rvb_Utils.colorsAreEqual(hudThermostat.lastColorHud, currentColor) then
					hudThermostat:setColor(unpack(currentColor)) --print("else "..unpack(currentColor))
					hudThermostat.lastColorHud = currentColor
				end
			end
		else
			hudThermostat.timer = 0
			hudThermostat.colorState = false
			hudThermostat.playCount = 0
		end
	else
		hudThermostat.timer = 0
		hudThermostat.colorState = false
		hudThermostat.playCount = 0
	end
end

return ThermostatManager