-- PartManager.lua - Alkatrészek betöltése és mentése
PartManager = {}
-- Fixed v0.9.2.9 to v0.9.3.0: legacy part names mapped to new format
local legacyNameMap = {
	THERMOSTAT = "THERMOSTAT",
	LIGHTINGS = "LIGHTINGS",
	GLOWPLUG = "GLOWPLUG",
	WIPERS = "WIPERS",
	GENERATOR = "GENERATOR",
	ENGINE = "ENGINE",
	SELFSTARTER = "SELFSTARTER",
	BATTERY = "BATTERY",
    LFWHEEL = "TIREFL",
    RFWHEEL = "TIREFR",
    LRWHEEL = "TIRERL",
    RRWHEEL = "TIRERR"
}
function PartManager.loadPartsFromXML(vehicle, savegame)
    PartManager.loadFromDefaultConfig(vehicle)
    if savegame ~= nil and savegame.key ~= nil then
        --PartManager.loadFromSavegame(vehicle, savegame)
    end
end
function PartManager.loadFromDefaultConfig(vehicle)
	local spec = vehicle.spec_faultData
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	local GPSET = g_currentMission.vehicleBreakdowns.gameplaySettings
	spec.parts = {}
	local xmlFilePath = Utils.getFilename('config/PartsSettingsSetup.xml', g_vehicleBreakdownsDirectory)
	local xmlFile = XMLFile.load("settingSetupXml", xmlFilePath)
	if xmlFile ~= nil then
		for i, partKeyName in ipairs(g_vehicleBreakdownsPartKeys) do
			local key = string.format("Parts.Part(%d)", i - 1)
			if not xmlFile:hasProperty(key) then break end
			spec.parts[partKeyName] = {
				name = xmlFile:getString(key.."#name", "PartName"),
				operatingHours = 0.000000,
				repairreq = xmlFile:getBool(key.."#repairreq", false),
				prefault = xmlFile:getString(key.."#prefault", "empty"),
				fault = xmlFile:getString(key.."#fault", "empty"),
				cost = xmlFile:getFloat(key.."#cost", 0),
				damaged = false,
				runOncePerStart = false
			}
			if partKeyName == "THERMOSTAT" then
				spec.parts[partKeyName].lifetime = GPSET.thermostatLifetime
			elseif partKeyName == "LIGHTINGS" then
				spec.parts[partKeyName].lifetime = GPSET.lightingsLifetime
			elseif partKeyName == "GLOWPLUG" then
				spec.parts[partKeyName].lifetime = GPSET.glowplugLifetime
			elseif partKeyName == "WIPERS" then
				spec.parts[partKeyName].lifetime = GPSET.wipersLifetime
			elseif partKeyName == "GENERATOR" then
				spec.parts[partKeyName].lifetime = GPSET.generatorLifetime
			elseif partKeyName == "ENGINE" then
				spec.parts[partKeyName].lifetime = GPSET.engineLifetime
			elseif partKeyName == "SELFSTARTER" then
				spec.parts[partKeyName].lifetime = GPSET.selfstarterLifetime
			elseif partKeyName == "BATTERY" then
				spec.parts[partKeyName].lifetime = GPSET.batteryLifetime
			elseif partKeyName == "TIREFL" or partKeyName == "TIREFR" or partKeyName == "TIRERL" or partKeyName == "TIRERR" then
				spec.parts[partKeyName].lifetime = GPSET.tireLifetime
			end
			local daysPerPeriod = g_currentMission.environment.plannedDaysPerPeriod
			if GSET.difficulty == 1 then
				spec.parts[partKeyName].tmp_lifetime = spec.parts[partKeyName].lifetime * 2 * daysPerPeriod
			elseif GSET.difficulty == 2 then
				spec.parts[partKeyName].tmp_lifetime = spec.parts[partKeyName].lifetime * 1 * daysPerPeriod
			else
				spec.parts[partKeyName].tmp_lifetime = spec.parts[partKeyName].lifetime / 2 * daysPerPeriod
			end
		end
        --print("PartManager.loadFromDefaultConfig " .. tostring(vehicle))
        --for key, part in pairs(spec.parts) do
        --    print("Part: " .. key)
        --    for k, v in pairs(part) do
        --        print("  " .. k .. ": " .. tostring(v))
        --    end
        --end
		xmlFile:delete()
	end
end
function PartManager.loadFromSavegame(vehicle, savegame)
	local spec = vehicle.spec_faultData
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	local GPSET = g_currentMission.vehicleBreakdowns.gameplaySettings
	--spec.parts = {}
	if savegame ~= nil and savegame.key ~= nil then
		for i, partKeyName in ipairs(g_vehicleBreakdownsPartKeys) do
			local partKey = string.format("%s.%s.vehicleBreakdowns.parts.part(%d)", savegame.key, g_vehicleBreakdownsModName, i - 1)
			if not savegame.xmlFile:hasProperty(partKey) then break end
			-- Fixed v0.9.2.9 to v0.9.3.0: legacy part names mapped to new format
			local rawName = savegame.xmlFile:getString(partKey.."#name", "PartName")
			local newName = legacyNameMap[rawName] or rawName
			spec.parts[partKeyName] = {
				--name = savegame.xmlFile:getString(partKey.."#name", "PartName"),
				-- Fixed v0.9.2.9 to v0.9.3.0: legacy part names mapped to new format
				name = newName,
				--operatingHours = savegame.xmlFile:getFloat(partKey.."#operatingHours", 0.000000),
				--repairreq = savegame.xmlFile:getBool(partKey.."#repairreq", false),
				--fault = savegame.xmlFile:getString(partKey.."#fault", "empty"),
				--cost = savegame.xmlFile:getFloat(partKey.."#cost", 0),
				--damaged = false,
				--runOncePerStart = false
			}
			--[[if partKeyName == "THERMOSTAT" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.thermostatLifetime)
			elseif partKeyName == "LIGHTINGS" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.lightingsLifetime)
			elseif partKeyName == "GLOWPLUG" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.glowplugLifetime)
			elseif partKeyName == "WIPERS" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.wipersLifetime)
			elseif partKeyName == "GENERATOR" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.generatorLifetime)
			elseif partKeyName == "ENGINE" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.engineLifetime)
			elseif partKeyName == "SELFSTARTER" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.selfstarterLifetime)
			elseif partKeyName == "BATTERY" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.batteryLifetime)
			elseif partKeyName == "TIREFL" or partKeyName == "TIREFR" or partKeyName == "TIRERL" or partKeyName == "TIRERR" then
				spec.parts[partKeyName].lifetime = savegame.xmlFile:getInt(partKey.."#lifetime", GPSET.tireLifetime)
			end
			local daysPerPeriod = g_currentMission.environment.plannedDaysPerPeriod
			if GSET.difficulty == 1 then
				spec.parts[partKeyName].tmp_lifetime = spec.parts[partKeyName].lifetime * 2 * daysPerPeriod
			elseif GSET.difficulty == 2 then
				spec.parts[partKeyName].tmp_lifetime = spec.parts[partKeyName].lifetime * 1 * daysPerPeriod
			else
				spec.parts[partKeyName].tmp_lifetime = spec.parts[partKeyName].lifetime / 2 * daysPerPeriod
			end]]
		end
	end
end
function PartManager.loadFromPostLoad(vehicle, savegame)
	if not (vehicle and vehicle.spec_faultData) then
		Logging.error("PartManager.onPostLoad() No vehicle.")
		return false
	end
	local rvb = vehicle.spec_faultData
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	local GPSET = g_currentMission.vehicleBreakdowns.gameplaySettings
	local keyparts = string.format("%s.%s.vehicleBreakdowns", savegame.key, g_vehicleBreakdownsModName)
	for i, partKey in ipairs(g_vehicleBreakdownsPartKeys) do
		local part = rvb.parts[partKey]
		if part then
			local keyss = string.format("%s.parts.part(%d)", keyparts, i - 1)
			--part.name = savegame.xmlFile:getValue(keyss .. "#name", part.name)
			-- Fixed v0.9.2.9 to v0.9.3.0: legacy part names mapped to new format
			local rawName = savegame.xmlFile:getValue(keyss .. "#name", part.name)
			local newName = legacyNameMap[rawName] or rawName
			part.name = newName
			part.lifetime = savegame.xmlFile:getValue(keyss .. "#lifetime", part.lifetime)
			local daysPerPeriod = g_currentMission.environment.plannedDaysPerPeriod
			if GSET.difficulty == 1 then
				part.tmp_lifetime = part.lifetime * 2 * daysPerPeriod
			elseif GSET.difficulty == 2 then
				part.tmp_lifetime = part.lifetime * 1 * daysPerPeriod
			else
				part.tmp_lifetime = part.lifetime / 2 * daysPerPeriod
			end
			part.operatingHours = savegame.xmlFile:getValue(keyss .. "#operatingHours", part.operatingHours)
			part.repairreq      = savegame.xmlFile:getValue(keyss .. "#repairreq", part.repairreq)
			part.prefault       = savegame.xmlFile:getValue(keyss .. "#prefault", part.prefault)
			part.fault          = savegame.xmlFile:getValue(keyss .. "#fault", part.fault)
			part.cost           = savegame.xmlFile:getValue(keyss .. "#cost", part.cost)
		end
	end
    --print("PartManager.loadFromPostLoad " .. vehicle:getFullname())
    --for key, part in pairs(spec.parts) do
    --    print("Part: " .. key)
    --    for k, v in pairs(part) do
    --        print("  " .. k .. ": " .. tostring(v))
    --    end
    --end
end
function PartManager.savePartsToXML(vehicle, xmlFile, key)
	local spec = vehicle.spec_faultData
	local i = 0
	for _, partKeyName in ipairs(g_vehicleBreakdownsPartKeys) do
		local part = spec.parts[partKeyName]
		if part and part.name ~= nil and part.name ~= "" then
			local partKey = string.format("%s.parts.part(%d)", key, i)
			xmlFile:setValue(partKey.."#name", part.name)
			xmlFile:setValue(partKey.."#lifetime", part.lifetime)
			xmlFile:setValue(partKey.."#operatingHours", part.operatingHours)
			xmlFile:setValue(partKey.."#repairreq", part.repairreq)
			xmlFile:setValue(partKey.."#prefault", tostring(part.prefault))
			xmlFile:setValue(partKey.."#fault", tostring(part.fault))
			xmlFile:setValue(partKey.."#cost", part.cost)
			i = i + 1
		end
	end
end
function PartManager.PartsDefaults(data)
	local defaults = {
		name = "",
		lifetime = 1,
		tmp_lifetime = 1,
		operatingHours = 0,
		repairreq = false,
		prefault = "empty",
		fault = "empty",
		cost = 0,
		damaged = false,
		runOncePerStart = false
	}
	for key, defaultValue in pairs(defaults) do
		if data[key] == nil then
			data[key] = defaultValue
		end
	end
	return data
end	

return PartManager