
local function colorsAreEqual(color1, color2)
    if #color1 ~= #color2 then return false end
    for i = 1, #color1 do
        if color1[i] ~= color2[i] then return false end
    end
    return true
end

RVB_HUD = {}
local RVB_HUD_mt = Class(RVB_HUD, HUDDisplay)

function RVB_HUD:new()
	local self = RVB_HUD:superClass().new(RVB_HUD_mt)
	self.modDirectory      = g_vehicleBreakdownsDirectory
	self.vehicle           = nil

	g_overlayManager:addTextureConfigFile(self.modDirectory .. "menu/rvbgui.xml", "rvbgui")
	g_overlayManager:addTextureConfigFile(self.modDirectory .. "menu/debugHud.xml", "debugHud")

	self.temperature = g_overlayManager:createOverlay("rvbgui.temperature", 0, 0, 0, 0)
	self.temperature:setVisible(false)
	self.temperature.lastColor = nil
	self.temperature.faultlastColor = nil

	self.battery = g_overlayManager:createOverlay("rvbgui.battery", 0, 0, 0, 0)
	self.battery:setVisible(false)
	self.battery.lastColor = nil
	self.battery.faultlastColor = nil

	self.engine = g_overlayManager:createOverlay("rvbgui.engine", 0, 0, 0, 0)
	self.engine:setVisible(false)
	self.engine.lastColor = nil
	self.engine.faultlastColor = nil

	self.lights = g_overlayManager:createOverlay("rvbgui.lights", 0, 0, 0, 0)
	self.lights:setVisible(false)
	self.lights.lastColor = nil
	self.lights.faultlastColor = nil

	--self.service = g_overlayManager:createOverlay("rvbgui.service", 0, 0, 0, 0)
	--self.service:setVisible(false)

	self.debugBg = g_overlayManager:createOverlay("debugHud.debugBg", 0, 0, 0, 0)
	self.debugBgScale = g_overlayManager:createOverlay("debugHud.debugBgScale", 0, 0, 0, 0)
	self.debugBgRight = g_overlayManager:createOverlay("debugHud.debugBgRight", 0, 0, 0, 0)

	self.isVehicleDrawSafe = false
	return self
end
function RVB_HUD:delete()
	if self.vehicle ~= nil then
		self.vehicle = nil
	end
	self.isVehicleDrawSafe = false
	self.temperature:delete()
	self.battery:delete()
	self.engine:delete()
	self.lights:delete()
	--self.service:delete()
	self.debugBg:delete()
	self.debugBgScale:delete()
	self.debugBgRight:delete()
	RVB_HUD:superClass().delete(self)
end
function RVB_HUD:update(dt)
	RVB_HUD:superClass().update(self, dt)
	if self.vehicle ~= nil then
		self.isVehicleDrawSafe = true
		GeneratorManager.updateHud(self, self.vehicle, dt)
		LightingsManager.updateHud(self, self.vehicle, dt)
		EngineManager.updateHud(self, self.vehicle, dt)
		ThermostatManager.updateThermostatHud(self, self.vehicle, dt)
	else
        self.isVehicleDrawSafe = false	
	end
end
function RVB_HUD:storeScaledValues()
	self.temperatureOffsetX, self.temperatureOffsetY = self:scalePixelValuesToScreenVector(34, -16)
	local temperatureWidth, temperatureHeight = self:scalePixelValuesToScreenVector(16, 14)
	self.temperature:setDimension(temperatureWidth, temperatureHeight)
	
	self.batteryOffsetX, self.batteryOffsetY = self:scalePixelValuesToScreenVector(-50, -16)
	local batteryWidth, batteryHeight = self:scalePixelValuesToScreenVector(16, 14)
	self.battery:setDimension(batteryWidth, batteryHeight)
	
	self.engineOffsetX, self.engineOffsetY = self:scalePixelValuesToScreenVector(-50, 5)
	local engineWidth, engineHeight = self:scalePixelValuesToScreenVector(16, 14)
	self.engine:setDimension(engineWidth, engineHeight)
	
	self.lightsOffsetX, self.lightsOffsetY = self:scalePixelValuesToScreenVector(34, 5)
	local lightsWidth, lightsHeight = self:scalePixelValuesToScreenVector(16, 14)
	self.lights:setDimension(lightsWidth, lightsHeight)
	
	--self.serviceOffsetX, self.serviceOffsetY = self:scalePixelValuesToScreenVector(-15, 25)
	--local serviceWidth, serviceHeight = self:scalePixelValuesToScreenVector(35, 33)
	--self.service:setDimension(serviceWidth, serviceHeight)
	self.serviceTextOffsetX, self.serviceTextOffsetY = self:scalePixelValuesToScreenVector(0, 48)
	self.serviceTextSize = self:scalePixelToScreenHeight(8)

	local debugBgX, debugBgY = self:scalePixelValuesToScreenVector(247, 232)
	self.debugBg:setDimension(debugBgX, debugBgY)
	self.debugBgScale:setDimension(0, debugBgY)
	local debugBgRightX, debugBgRightY = self:scalePixelValuesToScreenVector(23, 232)
	self.debugBgRight:setDimension(debugBgRightX, debugBgRightY)
	self.debugBg:setColor(unpack({0, 0, 0, 0.55}))
	self.debugBgScale:setColor(unpack({0, 0, 0, 0.55}))
	self.debugBgRight:setColor(unpack({0, 0, 0, 0.55}))

	self.speedBgScaleWidth = self:scalePixelToScreenWidth(5)
	
	self.tempTextOffsetX, self.tempTextOffsetY = self:scalePixelValuesToScreenVector(52, -59)
	self.tempTextSize = self:scalePixelToScreenHeight(10)
	self.rpmTextOffsetX, self.rpmTextOffsetY = self:scalePixelValuesToScreenVector(-54, -59)
	self.rpmTextSize = self:scalePixelToScreenHeight(10)
	self.fuelTextOffsetX, self.fuelTextOffsetY = self:scalePixelValuesToScreenVector(12, 5)
	self.fuelTextSize = self:scalePixelToScreenHeight(12)
	
	self.debugTextSize = self:scalePixelToScreenHeight(14)
	self.damageTextOffsetX, self.damageTextOffsetY = self:scalePixelValuesToScreenVector(20, 212)
	self.thermostatTextOffsetX, self.thermostatTextOffsetY = self:scalePixelValuesToScreenVector(20, 192)
	self.lightingsTextOffsetX, self.lightingsTextOffsetY = self:scalePixelValuesToScreenVector(20, 172)
	self.glowplugTextOffsetX, self.glowplugTextOffsetY = self:scalePixelValuesToScreenVector(20, 152)
	self.wipersTextOffsetX, self.wipersTextOffsetY = self:scalePixelValuesToScreenVector(20, 132)
	self.generatorTextOffsetX, self.generatorTextOffsetY = self:scalePixelValuesToScreenVector(20, 112)
	self.engineTextOffsetX, self.engineTextOffsetY = self:scalePixelValuesToScreenVector(20, 92)
	self.selfstarterTextOffsetX, self.selfstarterTextOffsetY = self:scalePixelValuesToScreenVector(20, 72)
	self.batteryTextOffsetX, self.batteryTextOffsetY = self:scalePixelValuesToScreenVector(20, 52)
	self.serviceDTextOffsetX, self.serviceDTextOffsetY = self:scalePixelValuesToScreenVector(20, 32)
end
function RVB_HUD:setVehicle(vehicle)
	self.vehicle = nil
	local hasVehicle = vehicle ~= nil
	local isMotorized = hasVehicle and vehicle.spec_motorized ~= nil
	if hasVehicle and isMotorized then
        self.vehicle = vehicle
		self.temperature.lastColor = nil
		self.temperature.faultlastColor = nil
		self.battery.lastColor = nil
		self.battery.faultlastColor = nil
		self.engine.lastColor = nil
		self.engine.faultlastColor = nil
		self.lights.lastColor = nil
		self.lights.faultlastColor = nil
    end
	self:setVisible(self.vehicle ~= nil)
	self.isVehicleDrawSafe = false
end
function RVB_HUD:draw()

	local vehicle = self.vehicle
	if vehicle == nil or not self.isVehicleDrawSafe then
		return
	end
	
	local rvb = vehicle.spec_faultData
	
	if rvb ~= nil and not rvb.isrvbSpecEnabled then
        return
    end

	g_currentMission.hud.speedMeter.speedTextSize = self:scalePixelToScreenHeight(43)

	local speedBgX, speedBgY = g_currentMission.hud.speedMeter.speedBg:getPosition()
	local posX = speedBgX + g_currentMission.hud.speedMeter.speedGaugeCenterOffsetX
	local posY = speedBgY + g_currentMission.hud.speedMeter.speedGaugeCenterOffsetY
	
	

	local motorState = vehicle:getMotorState()
	local RVBMain = g_currentMission.vehicleBreakdowns
	local GSET = g_currentMission.vehicleBreakdowns.generalSettings
	local GPSET = g_currentMission.vehicleBreakdowns.gameplaySettings
	local serviceVisible = false
	
	if not g_modIsLoaded["FS25_gameplay_RoadMaster"] then
		if RVBMain:getIsShowTempDisplay() and rvb ~= nil and vehicle.getConsumerFillUnitIndex ~= nil and vehicle:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil then	
			if vehicle.spec_motorized ~= nil then --and vehicle.isServer then
				local _useF = g_gameSettings:getValue(GameSettings.SETTING.USE_FAHRENHEIT)
				local _s = "C"
				if _useF then _s = "F" end
				local temp_txt1 = "0"
				local temp_txt2 = "\n°" .. _s
				--if motorState == MotorState.ON then
				if motorState == MotorState.ON or motorState == MotorState.IGNITION or motorState == MotorState.STARTING then
					local _value = vehicle.spec_motorized.motorTemperature.value
					if _useF then _value = _value * 1.8 + 32 end
					temp_txt1 = string.format("%i", _value)
				end
				local tempTextOffsetX = posX + self.tempTextOffsetX 
				local tempTextOffsetY = posY + self.tempTextOffsetY
				setTextColor(1, 1, 1, 1)
				setTextAlignment(RenderText.ALIGN_CENTER)
				setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
				setTextBold(true)
				renderText(tempTextOffsetX, tempTextOffsetY, self.tempTextSize, temp_txt1)
				setTextColor(unpack(HUD.COLOR.ACTIVE))
				renderText(tempTextOffsetX, tempTextOffsetY, self.tempTextSize, temp_txt2)
			end
		end
		if RVBMain:getIsShowRpmDisplay() and rvb ~= nil and vehicle.getConsumerFillUnitIndex ~= nil and vehicle:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil then
			if vehicle.spec_motorized ~= nil then --and vehicle.isServer then
				local rpm_txt1 = "0"
				local rpm_txt2 = "\nrpm"
				--if motorState == MotorState.ON then
				if motorState == MotorState.ON or motorState == MotorState.STARTING then
					rpm_txt1 = string.format("%i", vehicle.spec_motorized:getMotorRpmReal())
				end
				local rpmTextOffsetX = posX + self.rpmTextOffsetX 
				local rpmTextOffsetY = posY + self.rpmTextOffsetY
				setTextColor(1, 1, 1, 1)
				setTextAlignment(RenderText.ALIGN_CENTER)
				setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
				setTextBold(true)
				renderText(rpmTextOffsetX, rpmTextOffsetY, self.rpmTextSize, rpm_txt1)
				setTextColor(unpack(HUD.COLOR.ACTIVE))
				renderText(rpmTextOffsetX, rpmTextOffsetY + 0.002, self.rpmTextSize, rpm_txt2)
			end
		end
		if RVBMain:getIsShowFuelDisplay() and rvb ~= nil then
			if vehicle.spec_fillUnit ~= nil then --and vehicle.isServer then
				local fuelDiesel_current = -1
				local fuelElectric_current = -1
				local fuelAdblue_current = -1
				local fuelMethane_current = -1
				local specfillUnit = vehicle.spec_fillUnit
				if vehicle.getConsumerFillUnitIndex ~= nil then
					if vehicle:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil then
						if specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.DIESEL)] ~= nil then
							fuelDiesel_max = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.DIESEL)].capacity
							fuelDiesel_current = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.DIESEL)].fillLevel
						end
					end
					if vehicle:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE) ~= nil then
						if specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE)] ~= nil then
							fuelElectric_max = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE)].capacity
							fuelElectric_current = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE)].fillLevel
						end
					end
					if vehicle:getConsumerFillUnitIndex(FillType.DEF) ~= nil then
						if specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.DEF)] ~= nil then
							fuelAdblue_max = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.DEF)].capacity
							fuelAdblue_current = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.DEF)].fillLevel
						end
					end
					if vehicle:getConsumerFillUnitIndex(FillType.METHANE) ~= nil then
						if specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.METHANE)] ~= nil then
							fuelMethane_max = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.METHANE)].capacity
							fuelMethane_current = specfillUnit.fillUnits[vehicle:getConsumerFillUnitIndex(FillType.METHANE)].fillLevel
						end
					end
				end
				local fuel_txt1 = ""
				local fuel_txt2 = "0"
				if fuelElectric_current >= 0 then
					fuel_txt1 = "kW/h"
					--if motorState == MotorState.ON then
					if motorState == MotorState.ON or motorState == MotorState.STARTING then
						fuel_txt2 = string.format("%.1f", vehicle.spec_motorized.lastFuelUsage)
					end
				elseif fuelDiesel_current >= 0 then
					fuel_txt1 = "l/h"
					--if motorState == MotorState.ON then
					if motorState == MotorState.ON or motorState == MotorState.STARTING then
						fuel_txt2 = string.format("%.1f", vehicle.spec_motorized.lastDieselFuelUsage)
					end
				else
					fuel_txt1 = "l/h"
					--if motorState == MotorState.ON then
					if motorState == MotorState.ON or motorState == MotorState.STARTING then
						fuel_txt2 = string.format("%.1f", vehicle.spec_motorized.lastFuelUsage)
					end
				end
				local fuelIconX, fuelIconY = g_currentMission.hud.speedMeter.fuelIcon:getPosition()
				local fuelTextOffsetX = fuelIconX + self.fuelTextOffsetX - 0.001
				local fuelTextOffsetX_ = fuelIconX + self.fuelTextOffsetX + 0.001
				local fuelTextOffsetY = fuelIconY + self.fuelTextOffsetY
				setTextAlignment(RenderText.ALIGN_LEFT)
				setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
				setTextBold(true)
				setTextColor(unpack(HUD.COLOR.ACTIVE))
				renderText(fuelTextOffsetX_, fuelTextOffsetY, self.fuelTextSize, fuel_txt1)
				setTextAlignment(RenderText.ALIGN_RIGHT)
				setTextColor(1, 1, 1, 1)
				renderText(fuelTextOffsetX, fuelTextOffsetY, self.fuelTextSize, fuel_txt2)
			end
		end
	end

	if vehicle.getConsumerFillUnitIndex ~= nil and rvb ~= nil and vehicle:getConsumerFillUnitIndex(FillType.DIESEL) ~= nil then
		
		if motorState == MotorState.ON then

			local thermostatName = "THERMOSTAT"
			local thermostatPart = rvb.parts[thermostatName]
			local thermostat = FaultRegistry[thermostatName]
			local thermostatHudVisible = thermostat.hud.visible
			if thermostat.isApplicable(vehicle) then
				self.temperature:setVisible(thermostatHudVisible)
				local motorTemp = vehicle.spec_motorized.motorTemperature.value
				ThermostatManager.updateThermostatColor(self, thermostatPart, motorTemp)
			end

			local generatorName = "GENERATOR"
			local generatorPart = rvb.parts[generatorName]
			local generator = FaultRegistry[generatorName]
			local generatorHud = generator.hud
			local generatorHudVisible = generatorHud.visible
			if generator.isApplicable(vehicle) then
				self.battery:setVisible(generatorHudVisible)
				GeneratorManager.updateColor(self, generatorPart)
			end
		
			local engineName = "ENGINE"
			local enginePart = rvb.parts[engineName]
			local engine = FaultRegistry[engineName]
			local engineHud = engine.hud
			local engineHudVisible = engineHud.visible
			if engine.isApplicable(vehicle) then
				self.engine:setVisible(engineHudVisible)
				EngineManager.updateColor(self, enginePart)
			end

			local lightingsName = "LIGHTINGS"
			local lightingsPart = rvb.parts[lightingsName]
			local lightings = FaultRegistry[lightingsName]
			local lightingsHud = lightings.hud
			local lightingsHudVisible = lightingsHud.visible
			if lightings.isApplicable(vehicle) then
				self.lights:setVisible(lightingsHudVisible)
				LightingsManager.updateColor(self, lightingsPart)
			end
			
			serviceVisible = true
			local service_percent = (rvb.rvb[4] * 100) / RVBMain:getPeriodicService()
			--if not rvb.parts[GENERATOR].damaged or not rvb.parts[GENERATOR].repairreq then
				if service_percent < 90 then
					setTextColor(unpack(RVB_HUD.COLOR.DEFAULT))
				elseif service_percent >= 90 and service_percent < 99 then
					setTextColor(unpack(RVB_HUD.COLOR.WARNING))
				else
					setTextColor(unpack(RVB_HUD.COLOR.CRITICAL))
				end
			--else
				--setTextColor(unpack(RVB_HUD.COLOR.CRITICAL))
			--end



		elseif motorState == MotorState.STARTING or motorState == MotorState.IGNITION then
            self.temperature:setVisible(true)
			self.temperature:setColor(unpack(RVB_HUD.COLOR.COOL))
			
			self.battery:setVisible(true)
			self.battery:setColor(unpack(RVB_HUD.COLOR.CRITICAL))
			
			self.engine:setVisible(true)
			self.engine:setColor(unpack(RVB_HUD.COLOR.WARNING))
			
			self.lights:setVisible(true)
			self.lights:setColor(unpack(RVB_HUD.COLOR.WARNING))
			
			serviceVisible = true
			--self.service:setVisible(true)
			--self.service:setColor(unpack(RVB_HUD.COLOR.WARNING))
			setTextColor(unpack(RVB_HUD.COLOR.WARNING))

		else
            self.temperature:setVisible(false)
			self.battery:setVisible(false)
			self.engine:setVisible(false)
			self.lights:setVisible(false)
			--self.service:setVisible(false)
			serviceVisible = false
			self.temperature.lastColor = nil
			self.temperature.faultlastColor = nil
			self.battery.lastColor = nil
			self.battery.faultlastColor = nil
			self.engine.lastColor = nil
			self.engine.faultlastColor = nil
			self.lights.lastColor = nil
			self.lights.faultlastColor = nil
		end

		self.temperature:setPosition(posX + self.temperatureOffsetX, posY + self.temperatureOffsetY)
		self.temperature:render()
		--setTextAlignment(RenderText.ALIGN_LEFT)
		
		self.battery:setPosition(posX + self.batteryOffsetX, posY + self.batteryOffsetY)
		self.battery:render()
		--setTextAlignment(RenderText.ALIGN_LEFT)
		
		self.engine:setPosition(posX + self.engineOffsetX, posY + self.engineOffsetY)
		self.engine:render()
		--setTextAlignment(RenderText.ALIGN_LEFT)
		
		self.lights:setPosition(posX + self.lightsOffsetX, posY + self.lightsOffsetY)
		self.lights:render()
		--setTextAlignment(RenderText.ALIGN_LEFT)

		--self.service:setPosition(posX + self.serviceOffsetX, posY + self.serviceOffsetY)
		--self.service:render()
		--setTextAlignment(RenderText.ALIGN_CENTER)
		local service_txt1 = "SERVICE"
		if serviceVisible then
			setTextAlignment(RenderText.ALIGN_CENTER)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(posX + self.serviceTextOffsetX, posY + self.serviceTextOffsetY, self.serviceTextSize, service_txt1)
		end
	end
	
	if GSET.vhuddisplay then
		local specf = vehicle.spec_faultData
		if specf ~= nil and vehicle.spec_motorized ~= nil and vehicle.getConsumerFillUnitIndex ~= nil and vehicle:getConsumerFillUnitIndex(FillType.DIESEL) then
			local width = 0
			local debugBgScaleWidth = width + self.speedBgScaleWidth
			local speedBgX, speedBgY = g_currentMission.hud.speedMeter.speedBg:getPosition()
			speedBgX = speedBgX - 0.0025
			self.debugBgRight:setPosition(speedBgX - self.debugBgRight.width, speedBgY)
			self.debugBgScale:setDimension(debugBgScaleWidth, nil)
			self.debugBgScale:setPosition(self.debugBgRight.x - self.debugBgScale.width , speedBgY)
			self.debugBg:setPosition(self.debugBgScale.x - self.debugBg.width, speedBgY)
			self.debugBg:render()
			self.debugBgScale:render()
			self.debugBgRight:render()
		
			--local specf = vehicle.spec_faultData
			local COLOR = {}
			COLOR.DEFAULT = {1, 1, 1, 1}
			COLOR.YELLOW = {1.0000, 0.6592, 0.0000, 1}

			local posX = self.debugBg.x
			local posY = self.debugBg.y
			local damageTextOffsetX = posX + self.damageTextOffsetX 
			local damageTextOffsetY = posY + self.damageTextOffsetY
			local Partfoot = (vehicle:getDamageAmount() * 100) / 1
			--local batteryFillUnitIndex = vehicle:getConsumerFillUnitIndex(FillType.ELECTRICCHARGE)
			--local Partfoot = (vehicle:getFillUnitFillLevel(batteryFillUnitIndex) * 100) / 100
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local damage_Text = rvb_Utils.to_upper(g_i18n:getText("ui_condition"))..": "..string.format("%.4f", vehicle:getDamageAmount()).." ("..string.format("%.0f", Partfoot).."%)"
			--local damage_Text = "DAMAGE: "..string.format("%.4f", vehicle:getFillUnitFillLevel(batteryFillUnitIndex)).." ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.DEFAULT))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(damageTextOffsetX, damageTextOffsetY, self.debugTextSize, damage_Text)	
		
			local thermostatTextOffsetX = posX + self.thermostatTextOffsetX 
			local thermostatTextOffsetY = posY + self.thermostatTextOffsetY
			local Partfoot = (specf.parts[THERMOSTAT].operatingHours * 100) / specf.parts[THERMOSTAT].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[THERMOSTAT].operatingHours)
			local minutes = math.floor((specf.parts[THERMOSTAT].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local thermostat_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_THERMOSTAT"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[THERMOSTAT].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(thermostatTextOffsetX, thermostatTextOffsetY, self.debugTextSize, thermostat_Text)

			local lightingsTextOffsetX = posX + self.lightingsTextOffsetX 
			local lightingsTextOffsetY = posY + self.lightingsTextOffsetY
			local Partfoot = (specf.parts[LIGHTINGS].operatingHours * 100) / specf.parts[LIGHTINGS].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[LIGHTINGS].operatingHours)
			local minutes = math.floor((specf.parts[LIGHTINGS].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local lightings_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_LIGHTINGS"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[LIGHTINGS].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(lightingsTextOffsetX, lightingsTextOffsetY, self.debugTextSize, lightings_Text)
		
			local glowplugTextOffsetX = posX + self.glowplugTextOffsetX 
			local glowplugTextOffsetY = posY + self.glowplugTextOffsetY
			local Partfoot = (specf.parts[GLOWPLUG].operatingHours * 100) / specf.parts[GLOWPLUG].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[GLOWPLUG].operatingHours)
			local minutes = math.floor((specf.parts[GLOWPLUG].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local glowplug_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_GLOWPLUG"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[GLOWPLUG].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(glowplugTextOffsetX, glowplugTextOffsetY, self.debugTextSize, glowplug_Text)

			local wipersTextOffsetX = posX + self.wipersTextOffsetX 
			local wipersTextOffsetY = posY + self.wipersTextOffsetY
			local Partfoot = (specf.parts[WIPERS].operatingHours * 100) / specf.parts[WIPERS].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[WIPERS].operatingHours)
			local minutes = math.floor((specf.parts[WIPERS].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local wipers_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_WIPERS"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[WIPERS].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(wipersTextOffsetX, wipersTextOffsetY, self.debugTextSize, wipers_Text)
		
			local generatorTextOffsetX = posX + self.generatorTextOffsetX 
			local generatorTextOffsetY = posY + self.generatorTextOffsetY
			local Partfoot = (specf.parts[GENERATOR].operatingHours * 100) / specf.parts[GENERATOR].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[GENERATOR].operatingHours)
			local minutes = math.floor((specf.parts[GENERATOR].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local generator = FaultRegistry[GENERATOR]
			local generator_Text = rvb_Utils.to_upper(g_i18n:getText(generator.name))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[GENERATOR].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(generatorTextOffsetX, generatorTextOffsetY, self.debugTextSize, generator_Text)

			local engineTextOffsetX = posX + self.engineTextOffsetX 
			local engineTextOffsetY = posY + self.engineTextOffsetY
			local Partfoot = (specf.parts[ENGINE].operatingHours * 100) / specf.parts[ENGINE].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[ENGINE].operatingHours)
			local minutes = math.floor((specf.parts[ENGINE].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local engine_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_ENGINE"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[ENGINE].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(engineTextOffsetX, engineTextOffsetY, self.debugTextSize, engine_Text)

			local selfstarterTextOffsetX = posX + self.selfstarterTextOffsetX 
			local selfstarterTextOffsetY = posY + self.selfstarterTextOffsetY
			local Partfoot = (specf.parts[SELFSTARTER].operatingHours * 100) / specf.parts[SELFSTARTER].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[SELFSTARTER].operatingHours)
			local minutes = math.floor((specf.parts[SELFSTARTER].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local selfstarter_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_SELFSTARTER"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[SELFSTARTER].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(selfstarterTextOffsetX, selfstarterTextOffsetY, self.debugTextSize, selfstarter_Text)
		
			local batteryTextOffsetX = posX + self.batteryTextOffsetX 
			local batteryTextOffsetY = posY + self.batteryTextOffsetY
			local Partfoot = (specf.parts[BATTERY].operatingHours * 100) / specf.parts[BATTERY].tmp_lifetime
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.parts[BATTERY].operatingHours)
			local minutes = math.floor((specf.parts[BATTERY].operatingHours - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local battery_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_faultText_BATTERY"))..": "..string.format("%s:%s", hours, minutes).."/"..specf.parts[BATTERY].tmp_lifetime..":00 ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(batteryTextOffsetX, batteryTextOffsetY, self.debugTextSize, battery_Text)
			
			local serviceDTextOffsetX = posX + self.serviceDTextOffsetX 
			local serviceDTextOffsetY = posY + self.serviceDTextOffsetY
			local Partfoot = (specf.rvb[4] * 100) / g_currentMission.vehicleBreakdowns:getPeriodicService()
			Partfoot = MathUtil.round(Partfoot)
			Partfoot = 100 - Partfoot
			if Partfoot < 0 then Partfoot = 0 end
			local hours = math.floor(specf.rvb[4])
			local minutes = math.floor((specf.rvb[4] - hours) * 60)
			if hours < 10 then hours = string.format("0%s", hours) else hours = string.format("%s", hours) end
			if minutes < 10 then minutes = string.format("0%s", minutes) else minutes = string.format("%s", minutes) end
			local service_Text = rvb_Utils.to_upper(g_i18n:getText("RVB_settingSectionHeader_Service"))..": "..string.format("%s", hours).."/"..g_currentMission.vehicleBreakdowns:getPeriodicService().." ("..string.format("%.0f", Partfoot).."%)"
			setTextColor(unpack(COLOR.YELLOW))
			setTextAlignment(RenderText.ALIGN_LEFT)
			setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_TOP)
			setTextBold(true)
			renderText(serviceDTextOffsetX, serviceDTextOffsetY, self.debugTextSize, service_Text)
		end
	end
	
	setTextColor(1,1,1,1)
	setTextAlignment(RenderText.ALIGN_LEFT)
	setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_BASELINE)
	setTextBold(false)
end
RVB_HUD.COLOR = {}
RVB_HUD.COLOR.DEFAULT = {1, 1, 1, 0.2}
RVB_HUD.COLOR.WARNING  = { 1, 0.4287, 0.0006, 1 }
RVB_HUD.COLOR.CRITICAL = {0.8069, 0.0097, 0.0097, 1}
RVB_HUD.COLOR.COOL = { 0.0097, 0.4287, 0.6445, 1 }