rvbWorkshopScreen = {}
local rvbWorkshopScreen_mt = Class(rvbWorkshopScreen, ScreenElement)
rvbWorkshopScreen.Parts = {}
for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
    rvbWorkshopScreen.Parts[key] = key
end
local P = rvbWorkshopScreen.Parts
function rvbWorkshopScreen.register()
	local v2 = rvbWorkshopScreen.new()
	g_gui:loadGui(g_vehicleBreakdownsDirectory .. "gui/rvbWorkshopScreen.xml", "rvbWorkshopScreen", v2)
	return v2
end
function rvbWorkshopScreen.new(target, custom_mt)
	local self = rvbWorkshopScreen:superClass().new(target, custom_mt or rvbWorkshopScreen_mt)
	self.vehicles = {}
	self.vehicleSelected = nil
	self.selectedItem = false
	return self
end
function rvbWorkshopScreen.createFromExistingGui(self, p7)
	local v8 = rvbWorkshopScreen.new()
	local v9 = self.vehicles
	g_gui.guis[p7]:delete()
	g_gui.guis[p7].target:delete()
	FocusManager:deleteGuiFocusData("rvbWorkshopScreen")
	g_gui:loadGui(self.xmlFilename, p7, v8)
	v8:setVehicles(v9)
	g_RVBworkshopScreen = v8
	return v8
end
function rvbWorkshopScreen.onOpen(self)
	rvbWorkshopScreen:superClass().onOpen(self)
	self:updateBalanceText()
	g_messageCenter:subscribe(SellVehicleEvent, self.onVehicleSellEvent, self)
	g_messageCenter:subscribe(MessageType.MONEY_CHANGED, self.updateBalanceText, self)
	g_messageCenter:subscribe(MessageType.VEHICLE_REPAIRED, self.onVehicleRepairEvent, self)
	g_messageCenter:subscribe(MessageType.VEHICLE_REPAINTED, self.onVehicleRepaintEvent, self)
	g_messageCenter:subscribe(MessageType.RVB_RESET_VEHICLE, self.onVehicleResetEvent, self)
	if g_modIsLoaded["FS25_gameplay_ExtendedSellingSystem"] then
		g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.onextended, self)
	end
	self.refreshTimer = 0
	self.refreshTimeTimer = 0
	if self.isMobileWorkshop then
		self.headerText:setText(g_i18n:getText("ui_mobileWorkshop"))
		return
	elseif self.isOwnWorkshop then
		self.headerText:setText(g_i18n:getText("ui_sellOrCustomizeVehicleTitle"))
	else
		self.headerText:setText(g_i18n:getText("ui_dealer"))
	end
	local workshopStatus, timeInfo = g_currentMission.vehicleBreakdowns:getWorkshopStatusMessage()
	if not workshopStatus then
		self.headerTimeText:setText(timeInfo)
	end
end
function rvbWorkshopScreen.onClose(self)
	rvbWorkshopScreen:superClass().onClose(self)
	self.vehicle = nil
	self.owner = nil
	g_messageCenter:unsubscribeAll(self)
	g_currentMission:showMoneyChange(MoneyType.SHOP_VEHICLE_BUY)
	g_currentMission:showMoneyChange(MoneyType.SHOP_VEHICLE_SELL)
end
function rvbWorkshopScreen.setSellingPoint(self, sellingPoint, isDealer, isOwnWorkshop, isMobileWorkshop)
	self.owner = sellingPoint
	self.isDealer = isDealer
	self.isOwnWorkshop = isOwnWorkshop
	self.isMobileWorkshop = isMobileWorkshop
end
function rvbWorkshopScreen.setConfigurations(self, p18, p19)
	g_shopConfigScreen:onClickBack()
	if p18:isValid() then
		local v20 = false
		local v21 = NetworkUtil.getObject(p19)
		if v21 == nil then
			return
		end
		for v22, v23 in pairs(p18.configurations) do
			if v21.configurations[v22] ~= v23 then
				v20 = true
				break
			end
		end
		local v24 = ConfigurationUtil.getConfigurationDataHasChanged(v21.configFileName, p18.configurationData, v21.configurationData) and true or v20
		if v21.getLicensePlatesDataIsEqual ~= nil and not v21:getLicensePlatesDataIsEqual(p18.licensePlateData) and true or v24 then
			local v25 = g_localPlayer:getCurrentVehicle()
			if v25 ~= nil and v21 == v25 then
				g_localPlayer:leaveVehicle()
			end
			g_client:getServerConnection():sendEvent(ChangeVehicleConfigEvent.new(v21, p18))
			return
		end
	else
		self:onClickBack()
		if self.owner ~= nil then
			self.owner:openMenu()
		end
	end
end
function rvbWorkshopScreen.update(p24, p25)
	rvbWorkshopScreen:superClass().update(p24, p25)
	if p24.vehicle ~= nil then
		if p24.vehicle.isDeleted then
			table.removeElement(p24.vehicles, p24.vehicle)
			p24.vehicle = nil
			p24.list:reloadData()
			if #p24.vehicles == 0 then
				p24:setVehicle(nil)
				--return
			end
		elseif g_server == nil then
			p24.refreshTimer = p24.refreshTimer + p25
			if p24.refreshTimer > 250 then
				p24.refreshTimer = 0
				p24:setVehicle(p24.vehicle)
			end
		end
		if p24.selectedItem then
			p24.vehicleSelected = p24.vehicle
			p24.selectedItem = false
			--	p24.list:reloadData()
			p24.needsListReload = true
		end
	end
	local timeInfo = ""
	local timevisible = false
	p24.refreshTimeTimer = p24.refreshTimeTimer + p25
	if p24.refreshTimeTimer > 500 then
		p24.refreshTimeTimer = 0
		local workshopStatus, timeInfo = g_currentMission.vehicleBreakdowns:getWorkshopStatusMessage()
		if not workshopStatus then
			p24.headerTimeText:setText(timeInfo)
		else
			p24.headerTimeText:setText("")
		end
	end
	if p24.needsListReload then
		p24.list:reloadData()
		p24.needsListReload = false
	end
end
function rvbWorkshopScreen.setVehicles(p26, p27)
	p26.vehicles = p27
	p26.list:reloadData()
	if #p27 == 0 then
		p26:setVehicle(nil)
	end
end
function rvbWorkshopScreen.updateVehicles(p28, p29, p30)
	if p29 == p28.owner then
		p28:setVehicles(p30)
	end
end
function rvbWorkshopScreen.setVehicle(p31, p32)
	p31.storeItem = nil
	p31.canBeConfigured = false
	p31.canBeSold = not p31.mobileWorkshop
	local workshopStatus, timeInfo = g_currentMission.vehicleBreakdowns:getWorkshopStatusMessage()
	if p32 == nil then
		p31.repairButton:setLocaKey("button_repair")
		p31.repairButton:setDisabled(true)
		p31.repaintButton:setLocaKey("button_repaint")
		p31.repaintButton:setDisabled(true)
		p31.inspectionButton:setLocaKey("RVB_button_inspection")
		p31.inspectionButton:setDisabled(true)
		p31.serviceButton:setLocaKey("RVB_button_service")
		p31.serviceButton:setDisabled(true)
		p31.batteryChargingButton:setLocaKey("RVB_button_battery_ch")
		p31.batteryChargingButton:setDisabled(true)
	else
		p31.vehicle = p32
		p31.storeItem = g_storeManager:getItemByXMLFilename(p32.configFileName)
		local rvb = p32.spec_faultData
		if p31.storeItem ~= nil then
			local v33
			if p31.storeItem.configurations == nil then
				v33 = false
			else
				v33 = p32.propertyState == VehiclePropertyState.OWNED
			end
			p31.canBeConfigured = v33
			local v34 = p31.storeItem.canBeSold
			if v34 then
				v34 = not p31.mobileWorkshop
			end
			p31.canBeSold = v34
		end
		p31.sellButton:setDisabled(false)
		if p32.propertyState == VehiclePropertyState.OWNED then
			p31:setButtonText(g_i18n:getText("button_sell"))
		elseif p32.propertyState == VehiclePropertyState.LEASED then
			p31:setButtonText(g_i18n:getText("button_return"))
		elseif p32.propertyState == VehiclePropertyState.MISSION then
			p31.sellButton:setDisabled(true)
		end
		--local repairPrice = p32:getRepairPrice()
		local repairPrice = 0
		if rvb ~= nil then
			repairPrice = p32:getRepairPrice_RVBClone()
			if rvb.inspection[8] then 
				if not rvb.repair[1] and repairPrice >= 1 then
					p31.repairButton:setText(string.format("%s (%s)", g_i18n:getText("button_repair"), g_i18n:formatMoney(repairPrice, 0, true, true)))
				else
					p31.repairButton:setLocaKey("button_repair")
				end
			else
				p31.repairButton:setLocaKey("button_repair")
			end
			p31.repairButton:setDisabled(repairPrice < 1 or not rvb.inspection[8] or rvb.repair[1] or rvb.inspection[1] or rvb.service[1])
		else
			repairPrice = p32:getRepairPrice()
			if repairPrice >= 1 then
				p31.repairButton:setText(string.format("%s (%s)", g_i18n:getText("button_repair"), g_i18n:formatMoney(repairPrice, 0, true, true)))
			else
				p31.repairButton:setLocaKey("button_repair")
			end
			p31.repairButton:setDisabled(repairPrice < 1 or not workshopStatus)
		end
		local v36 = p32:getRepaintPrice()
		if v36 >= 1 then
			p31.repaintButton:setText(string.format("%s (%s)", g_i18n:getText("button_repaint"), g_i18n:formatMoney(v36, 0, true, true)))
		else
			p31.repaintButton:setLocaKey("button_repaint")
		end
		p31.repaintButton:setDisabled(v36 < 1 and true or p32.propertyState == VehiclePropertyState.MISSION or not workshopStatus)
		if rvb ~= nil then
			if rvb.inspection[1] or rvb.repair[1] or rvb.service[1] then
				p31.repaintButton:setDisabled(true)
			end
		end
		-- INSPECTION
		if rvb ~= nil then
			if not rvb.inspection[1] then
				p31.inspectionButton:setText(string.format("%s (%s)", g_i18n:getText("RVB_button_inspection"), g_i18n:formatMoney(p32:getInspectionPrice(), 0, true, true)))
			else
				p31.inspectionButton:setLocaKey("RVB_button_inspection")
			end
			p31.inspectionButton:setDisabled(rvb.inspection[1] or rvb.service[1] or rvb.repair[1] or not workshopStatus)
		end
		-- SERVICE
		if rvb ~= nil then
			--if rvb.service ~= nil then
				if not rvb.service[1] then
					p31.serviceButton:setText(string.format("%s (%s)", g_i18n:getText("RVB_button_service"), g_i18n:formatMoney(p32:getServicePrice(), 0, true, true)))
				else
					p31.serviceButton:setLocaKey("RVB_button_service")
				end
			--end
			p31.serviceButton:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1] or not workshopStatus)
		end
		-- BATTERYCHARGING
		if rvb ~= nil then
			if p32:getIsFaultBattery() ~= nil then
				if p32:getIsFaultBattery() <= 0.1 then
					p31.batteryChargingButton:setText(string.format("%s (%s)", g_i18n:getText("RVB_button_battery_ch"), g_i18n:formatMoney(25, 0, true, true)))
				else
					p31.batteryChargingButton:setLocaKey("RVB_button_battery_ch")
				end
			end
			p31.batteryChargingButton:setDisabled(p32:getIsFaultBattery() > 0.1 or not workshopStatus)
		end
	end
	p31.configButton:setDisabled(not p31.canBeConfigured or not workshopStatus)
	if p31.vehicle ~= nil then
		local rvb = p31.vehicle.spec_faultData
		if rvb ~= nil then
			if rvb.inspection[1] or rvb.repair[1] or rvb.service[1] then
				p31.configButton:setDisabled(true)
			end
		end
	end
	p31.configButton:setVisible(Platform.gameplay.hasVehicleConfigs)
	p31.sellButton:setDisabled(p32 == nil and true or (p31.isOwnWorkshop or (p31.vehicle.propertyState == VehiclePropertyState.MISSION and true or not p31.canBeSold)))
	local v37 = p31.sellButton
	local v38 = p32 ~= nil and not p31.isOwnWorkshop
	if v38 then
		v38 = p31.vehicle.propertyState ~= VehiclePropertyState.MISSION
	end
	v37:setVisible(v38)
	local v39 = p31.repaintButton
	local v40 = not p31.isOwnWorkshop
	if v40 then
		v40 = Platform.gameplay.hasVehicleDamage
	end
	v39:setVisible(v40)
	p31.repairButton:setVisible(Platform.gameplay.hasVehicleDamage)
	p31.dialogInfo:setVisible(p32 == nil)
	p31.buttonsBox:invalidateLayout()
end
function rvbWorkshopScreen.setButtonText(p41, p42)
	p41.sellButton:setText(p42)
end
function rvbWorkshopScreen.setStatusBarValue(_, bar, value)
	local lastBar = (bar.lastStatusBarValue or -1) - value
	if math.abs(lastBar) > 0.01 then
		local fullWidth = bar.parent.size[1] - bar.margin[1] * 2
		local minSize = bar.startSize == nil and 0 or bar.startSize[1] + bar.endSize[1]
		local maxSize = fullWidth * math.min(value, 1)
		bar:setSize(math.max(minSize, maxSize), nil)
		bar.lastStatusBarValue = value
	end
end
function rvbWorkshopScreen.updateBalanceText(p49)
	local v50 = g_currentMission == nil and 0 or (g_currentMission:getMoney() or 0)
	p49.lastBalance = v50
	p49.balanceElement:setValue(v50)
	if v50 > 0 then
		p49.balanceElement:applyProfile(ShopMenu.GUI_PROFILE.SHOP_MONEY)
	else
		p49.balanceElement:applyProfile(ShopMenu.GUI_PROFILE.SHOP_MONEY_NEGATIVE)
	end
	if p49.moneyBox ~= nil then
		p49.moneyBox:invalidateLayout()
		p49.moneyBoxBg:setSize(p49.moneyBox.flowSizes[1] + 60 * g_pixelSizeScaledX)
	end
end
function rvbWorkshopScreen.onClickBack(p51, _)
	rvbWorkshopScreen:superClass().onClickBack(p51)
	p51.vehicle = nil
	p51.vehicles = {}
	p51:changeScreen(nil)
end
function rvbWorkshopScreen.onClickRepair(self)
	if self.vehicle == nil then
		return false
	end
	local rvb = self.vehicle.spec_faultData
	if rvb ~= nil then
		if self.vehicle:getRepairPrice_RVBClone(true) < 1 then
			return false
		end
		local faultListTime = 0
		local faultListText = {}
		for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
			local part = rvb.parts[key]
			if part and part.repairreq then
				table.insert(faultListText, g_i18n:getText("RVB_faultText_"..VehicleBreakdowns.faultText[i]))
				faultListTime = faultListTime + VehicleBreakdowns.IRSBTimes[i]
			end
		end
		local AddHour = math.floor(faultListTime / 3600)
		local AddMinute = math.floor(((faultListTime / 3600) - AddHour) * 60)
		local FinishDay, FinishHour, FinishMinute = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
		local timeText = string.format("%02d:%02d", FinishHour, FinishMinute)
		local DialogRepairText = "RVB_repairTimeDialog"
		if FinishDay > g_currentMission.environment.currentDay then
			DialogRepairText = "RVB_repairDayDialog"
		end
		if #faultListText > 0 then
			local text = string.format(g_i18n:getText("ui_repairDialog"), g_i18n:formatMoney(self.vehicle:getRepairPrice_RVBClone(true))).."\n"..
						 string.format(g_i18n:getText(DialogRepairText), timeText).."\n"..g_i18n:getText("RVB_ErrorList").."\n"..table.concat(faultListText,", ")
			local callback = self.onYesNoRepairDialog
			local yesSound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_WRENCH
			YesNoDialog.show(callback, self, text, nil, nil, nil, nil, yesSound)
		end
		return true
	else
		if self.vehicle == nil or self.vehicle:getRepairPrice(true) < 1 then
			return false
		end
		local text = string.format(g_i18n:getText("ui_repairDialog"), g_i18n:formatMoney(self.vehicle:getRepairPrice(true)))
		local callback = self.onYesNoRepairDialog
		local yesSound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_WRENCH
		YesNoDialog.show(callback, self, text, nil, nil, nil, nil, yesSound)
		return true
	end
end
function rvbWorkshopScreen.onClickRepaint(p56)
	if p56.vehicle == nil or p56.vehicle:getRepaintPrice() < 1 then
		return false
	end
	local v57 = string.format(g_i18n:getText("ui_repaintDialog"), g_i18n:formatMoney(p56.vehicle:getRepaintPrice()))
	local v58 = p56.onYesNoRepaintDialog
	local v59 = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_SPRAY
	YesNoDialog.show(v58, p56, v57, nil, nil, nil, nil, v59)
	return true
end
function rvbWorkshopScreen.onClickConfigure(p60)
	if not p60.canBeConfigured then
		return true
	end
	local v61 = EconomyManager.CONFIG_CHANGE_PRICE
	local v62 = p60.isOwnWorkshop and 0 or v61
	local v63 = p60.vehicle
	local v64 = p60.storeItem
	p60:changeScreen(ShopConfigScreen, nil, rvbWorkshopScreen)
	g_shopConfigScreen:setReturnScreenClass(rvbWorkshopScreen)
	g_shopConfigScreen:setStoreItem(v64, v63, nil, v62)
	g_shopConfigScreen:setCallbacks(p60.setConfigurations, p60)
	return false
end
function rvbWorkshopScreen.onClickSell(p65)
	if p65.vehicle == nil or (p65.isOwnWorkshop or (p65.vehicle.propertyState == VehiclePropertyState.MISSION or not p65.canBeSold)) then
		return true
	end
	local v66 = g_storeManager:getItemByXMLFilename(p65.vehicle.configFileName)
	g_shopController:sell(v66, p65.vehicle, true)
	return false
end
function rvbWorkshopScreen.getNumberOfItemsInSection(p67, _, _)
	return #p67.vehicles
end
function rvbWorkshopScreen.populateCellForItemInSection(p68, _, _, p69, p70)
	local v71 = p68.vehicles[p69]
	p70:getAttribute("icon"):setImageFilename(v71:getImageFilename())
	local v72 = g_brandManager:getBrandByIndex(v71:getBrand())
	local v73 = v72 == nil and "" or v72.title .. " "	
	p70:getAttribute("name"):setText(v73 .. v71:getName() ) -- .. "  " .. p68:powerString(v71, true))
	p68:setVehicleDetails(p68.vehicles[p69], p70)
end
function rvbWorkshopScreen.powerString(self, vehicle, noBrace)
	local storeItem = g_storeManager:getItemByXMLFilename(vehicle.configFileName)
	if vehicle.configurations == nil or vehicle.configurations.motor == nil then
		return 0
	end
	local boughtMotor = vehicle.configurations.motor
	local motorPower  = storeItem.configurations.motor[boughtMotor].power
	if motorPower == nil then return "" end
	local hp, kw = g_i18n:getPower(motorPower)
	local returnText = string.format(g_i18n:getText("shopConfig_maxPowerValue"), MathUtil.round(kw), MathUtil.round(hp))
	if noBrace == nil or noBrace == false then
		return " [" .. returnText .. "]"
	end
	return returnText
end
function rvbWorkshopScreen.setVehicleDetails(p74, p75, p76)
	local v77, v78
	local rvb = p75.spec_faultData
	if p75 == nil then
		v77 = 0
		v78 = 0
	else
		v77 = p75:getOperatingTime()
		v78 = p75.age
		if p75.propertyState == VehiclePropertyState.OWNED then
			local v79 = p75:getSellPrice() * EconomyManager.DIRECT_SELL_MULTIPLIER
			local v80 = math.floor(v79)
			local v81 = math.min(v80, p75:getPrice())
			p76:getAttribute("priceText"):setText(g_i18n:formatMoney(v81))
		elseif p75.propertyState == VehiclePropertyState.LEASED then
			p76:getAttribute("priceText"):setText("-")
		elseif p75.propertyState == VehiclePropertyState.MISSION then
			p76:getAttribute("priceText"):setText("-")
		end

		if p75.getWearTotalAmount ~= nil then
			p74:setStatusBarValue(p76:getAttribute("paintConditionBar"), 1 - p75:getWearTotalAmount())
		end
		local v82 = p76:getAttribute("paintConditionBar").parent
		local v83 = Platform.gameplay.hasVehicleDamage
		if v83 then
			v83 = p75.getWearTotalAmount ~= nil
		end
		v82:setVisible(v83)
		if p75.getDamageAmount ~= nil then
			p74:setStatusBarValue(p76:getAttribute("conditionBar"), 1 - p75:getDamageAmount())
		end
		local v84 = p76:getAttribute("conditionBar").parent
		local v85 = Platform.gameplay.hasVehicleDamage
		if v85 then
			v85 = p75.getDamageAmount ~= nil
		end
		v84:setVisible(v85)
		
		if rvb ~= nil and p75.getIsFaultBattery ~= nil then
			p74:setStatusBarValue(p76:getAttribute("batteryConditionBar"), p75:getIsFaultBattery())
			p76:getAttribute("batteryText"):setVisible(true)
		else
			p76:getAttribute("batteryText"):setVisible(false)
		end
		local batteryCell = p76:getAttribute("batteryConditionBar").parent
		local batteryVehicleDamage = Platform.gameplay.hasVehicleDamage
		if batteryVehicleDamage then
			batteryVehicleDamage = p75.getIsFaultBattery ~= nil
		end
		batteryCell:setVisible(batteryVehicleDamage)


		if rvb ~= nil then
			if p75.propertyState == VehiclePropertyState.OWNED then
				local gText = ""
				local timeText = ""
				local infoText = ""
				if rvb.service[1] then
					gText = "RVB_periodicserviceTimeDialog"
					if rvb.service[3] > g_currentMission.environment.currentDay then
						gText = "RVB_periodicserviceDayDialog"
					end
					timeText = string.format("%02d:%02d", rvb.service[4], rvb.service[5])
				elseif rvb.inspection[1] then
					gText = "RVB_inspectionTimeDialog"
					if rvb.inspection[3] > g_currentMission.environment.currentDay then
						gText = "RVB_inspectionDayDialog"
					end
					timeText = string.format("%02d:%02d", rvb.inspection[4], rvb.inspection[5])
				elseif rvb.repair[1] then
					if rvb.inspection[8] then
						gText = "RVB_repairTimeDialog"
						if rvb.repair[3] > g_currentMission.environment.currentDay then
							gText = "RVB_repairDayDialog"
						end
						timeText = string.format("%02d:%02d", rvb.repair[4], rvb.repair[5])
					end
				else
					infoText = ""
				end
				if gText ~= "" then
					infoText = string.format(g_i18n:getText(gText), timeText)
				end
				p76:getAttribute("rvbinfoText"):setText(infoText)
			end
		local noyes = { g_i18n:getText("button_no"), g_i18n:getText("button_yes") }
		p76:getAttribute("checkThermostatPart"):setTexts(noyes)
		p76:getAttribute("checkLightingsPart"):setTexts(noyes)
		p76:getAttribute("checkGlowPlugPart"):setTexts(noyes)
		p76:getAttribute("checkWipersPart"):setTexts(noyes)
		p76:getAttribute("checkGeneratorPart"):setTexts(noyes)
		p76:getAttribute("checkEnginePart"):setTexts(noyes)
		p76:getAttribute("checkSelfstarterPart"):setTexts(noyes)
		p76:getAttribute("checkBatteryPart"):setTexts(noyes)
		--p76:getAttribute("checkResetVehicle"):setText("Alaphelyzetbe")
		
		if rvb ~= nil then
			p76:getAttribute("checkResetVehicle").parent:setVisible(true)
			p76:getAttribute("checkResetVehicle"):setDisabled(p75 ~= p74.vehicleSelected)
		end

		local Partfoot = 0
		if rvb.parts[P.thermostat].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.thermostat)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("thermostatPartBar"), 1 - PartValue)
			local thermostatPartTitle = p76:getAttribute("thermostatPartTitle")
			local checkThermostatPart = p76:getAttribute("checkThermostatPart")
			thermostatPartTitle:setText(g_i18n:getText("RVB_setting_thermostatLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkThermostatPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				thermostatPartTitle:setText(g_i18n:getText("RVB_setting_thermostatLifetime") .. " (" .. Pfoot .. "%)")
				checkThermostatPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			else
				checkThermostatPart:setDisabled(true)
			end

			if p75.getFaultParts ~= nil then
				checkThermostatPart:setIsChecked(p75:getFaultParts(P.thermostat))
			end
			local thermostatBox = thermostatPartTitle.parent
			thermostatBox:setVisible(true and rvb.inspection[8])
		end
		local thermostatCell = p76:getAttribute("thermostatPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[1].operatingHours ~= nil
		--end
		thermostatCell:setVisible(rvb.inspection[8]) -- v85 or
		if rvb.parts[P.lightings].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.lightings)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("lightingsPartBar"), 1 - PartValue)
			local lightingsPartTitle = p76:getAttribute("lightingsPartTitle")
			local checkLightingsPart = p76:getAttribute("checkLightingsPart")
			lightingsPartTitle:setText(g_i18n:getText("RVB_setting_lightingsLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkLightingsPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				lightingsPartTitle:setText(g_i18n:getText("RVB_setting_lightingsLifetime") .. " (" .. Pfoot .. "%)")
				checkLightingsPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkLightingsPart:setIsChecked(p75:getFaultParts(P.lightings))
			end
			local lightingsBox = lightingsPartTitle.parent
			lightingsBox:setVisible(true and rvb.inspection[8])
		end
		local lightingsCell = p76:getAttribute("lightingsPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[2].operatingHours ~= nil
		--end
		lightingsCell:setVisible(rvb.inspection[8])
		if rvb.parts[P.glowplug].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.glowplug)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("glowplugPartBar"), 1 - PartValue)
			local glowplugPartTitle = p76:getAttribute("glowplugPartTitle")
			local checkGlowPlugPart = p76:getAttribute("checkGlowPlugPart")
			glowplugPartTitle:setText(g_i18n:getText("RVB_setting_glowplugLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkGlowPlugPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				glowplugPartTitle:setText(g_i18n:getText("RVB_setting_glowplugLifetime") .. " (" .. Pfoot .. "%)")
				checkGlowPlugPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkGlowPlugPart:setIsChecked(p75:getFaultParts(P.glowplug))
			end
			local glowplugBox = glowplugPartTitle.parent
			glowplugBox:setVisible(true and rvb.inspection[8])
		end
		local glowplugCell = p76:getAttribute("glowplugPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[3].operatingHours ~= nil
		--end
		glowplugCell:setVisible(rvb.inspection[8])
		if rvb.parts[P.wipers].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.wipers)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("wipersPartBar"), 1 - PartValue)
			local wipersPartTitle = p76:getAttribute("wipersPartTitle")
			local checkWipersPart = p76:getAttribute("checkWipersPart")
			wipersPartTitle:setText(g_i18n:getText("RVB_setting_wipersLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkWipersPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				wipersPartTitle:setText(g_i18n:getText("RVB_setting_wipersLifetime") .. " (" .. Pfoot .. "%)")
				checkWipersPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkWipersPart:setIsChecked(p75:getFaultParts(P.wipers))
			end
			local wipersBox = wipersPartTitle.parent
			wipersBox:setVisible(true and rvb.inspection[8])
		end
		local wipersCell = p76:getAttribute("wipersPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[4].operatingHours ~= nil
		--end
		wipersCell:setVisible(rvb.inspection[8])
		if rvb.parts[P.generator].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.generator)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("generatorPartBar"), 1 - PartValue)
			local generatorPartTitle = p76:getAttribute("generatorPartTitle")
			local checkGeneratorPart = p76:getAttribute("checkGeneratorPart")
			generatorPartTitle:setText(g_i18n:getText("RVB_setting_generatorLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkGeneratorPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				generatorPartTitle:setText(g_i18n:getText("RVB_setting_generatorLifetime") .. " (" .. Pfoot .. "%)")
				checkGeneratorPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkGeneratorPart:setIsChecked(p75:getFaultParts(P.generator))
			end
			local generatorBox = generatorPartTitle.parent
			generatorBox:setVisible(true and rvb.inspection[8])
		end
		local generatorCell = p76:getAttribute("generatorPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[5].operatingHours ~= nil
		--end
		generatorCell:setVisible(rvb.inspection[8])
		if rvb.parts[P.engine].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.engine)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("enginePartBar"), 1 - PartValue)
			local enginePartTitle = p76:getAttribute("enginePartTitle")
			local checkEnginePart = p76:getAttribute("checkEnginePart")
			enginePartTitle:setText(g_i18n:getText("RVB_setting_engineLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkEnginePart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				enginePartTitle:setText(g_i18n:getText("RVB_setting_engineLifetime") .. " (" .. Pfoot .. "%)")
				checkEnginePart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkEnginePart:setIsChecked(p75:getFaultParts(P.engine))
			end
			local engineBox = enginePartTitle.parent
			engineBox:setVisible(true and rvb.inspection[8])
		end
		local engineCell = p76:getAttribute("enginePartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[6].operatingHours ~= nil
		--end
		engineCell:setVisible(rvb.inspection[8])
		if rvb.parts[P.selfstarter].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.selfstarter)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("selfstarterPartBar"), 1 - PartValue)
			local selfstarterPartTitle = p76:getAttribute("selfstarterPartTitle")
			local checkSelfstarterPart = p76:getAttribute("checkSelfstarterPart")
			selfstarterPartTitle:setText(g_i18n:getText("RVB_setting_selfstarterLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkSelfstarterPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				selfstarterPartTitle:setText(g_i18n:getText("RVB_setting_selfstarterLifetime") .. " (" .. Pfoot .. "%)")
				checkSelfstarterPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkSelfstarterPart:setIsChecked(p75:getFaultParts(P.selfstarter))
			end
			local selfstarterBox = selfstarterPartTitle.parent
			selfstarterBox:setVisible(true and rvb.inspection[8])
		end
		local selfstarterCell = p76:getAttribute("selfstarterPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[7].operatingHours ~= nil
		--end
		selfstarterCell:setVisible(rvb.inspection[8])
		if rvb.parts[P.battery].operatingHours ~= nil and p75.getPartsPercentage ~= nil then
			Partfoot = math.max(0, MathUtil.round(p75:getPartsPercentage(P.battery)))
			local PartValue = Partfoot / 100
			local Pfoot = 100 - Partfoot
			p74:setStatusBarValue(p76:getAttribute("batteryPartBar"), 1 - PartValue)
			local batteryPartTitle = p76:getAttribute("batteryPartTitle")
			local checkBatteryPart = p76:getAttribute("checkBatteryPart")
			batteryPartTitle:setText(g_i18n:getText("RVB_setting_batteryLifetime"))
			if Partfoot < 50 or (Partfoot >= 99 and rvb.inspection[8]) then
				checkBatteryPart:setDisabled(true)
			elseif Partfoot >= 50 and rvb.inspection[8] then
				batteryPartTitle:setText(g_i18n:getText("RVB_setting_batteryLifetime") .. " (" .. Pfoot .. "%)")
				checkBatteryPart:setDisabled(rvb.service[1] or rvb.inspection[1] or rvb.repair[1])
			end
			if p75.getFaultParts ~= nil then
				checkBatteryPart:setIsChecked(p75:getFaultParts(P.battery))
			end
			local batteryBox = batteryPartTitle.parent
			batteryBox:setVisible(true and rvb.inspection[8])
		end
		local batteryCell = p76:getAttribute("batteryPartBar").parent
		--local v85 = Platform.gameplay.hasVehicleDamage
		--if v85 then
		--	v85 = rvb.parts[8].operatingHours ~= nil
		--end
		batteryCell:setVisible(rvb.inspection[8])
		else
			local thermostatBox = p76:getAttribute("thermostatPartTitle").parent
			thermostatBox:setVisible(false)
			local lightingsBox = p76:getAttribute("lightingsPartTitle").parent
			lightingsBox:setVisible(false)
			local glowplugBox = p76:getAttribute("glowplugPartTitle").parent
			glowplugBox:setVisible(false)
			local wipersBox = p76:getAttribute("wipersPartTitle").parent
			wipersBox:setVisible(false)
			local generatorBox = p76:getAttribute("generatorPartTitle").parent
			generatorBox:setVisible(false)
			local engineBox = p76:getAttribute("enginePartTitle").parent
			engineBox:setVisible(false)
			local selfstarterBox = p76:getAttribute("selfstarterPartTitle").parent
			selfstarterBox:setVisible(false)
			local batteryBox = p76:getAttribute("batteryPartTitle").parent
			batteryBox:setVisible(false)
		end
		

	end
	local v86 = v77 / 60000
	local v87 = v86 / 60
	local v88 = math.floor(v87)
	local v89 = (v86 - v88 * 60) / 6
	local v90 = math.floor(v89) * 10
	p76:getAttribute("operatingHoursText"):setText(string.format(g_i18n:getText("shop_operatingTime"), v88, v90))
	p76:getAttribute("ageText"):setText(string.format(g_i18n:getText("shop_age"), string.format("%d", v78)))
	
	if rvb ~= nil then
		local rvbMain = g_currentMission.vehicleBreakdowns
		local periodicServiceInterval = rvbMain:getPeriodicService()
		local ServiceAmount = math.floor(rvb.rvb[4])
		ServiceAmount = ServiceAmount.."."..math.floor((rvb.rvb[4] - ServiceAmount) * 60)
		p76:getAttribute("service"):setText(string.format(g_i18n:getText("RVB_serviceHours"), ServiceAmount, periodicServiceInterval))
	else
		p76:getAttribute("service"):setText("-")
	end
	

end
function rvbWorkshopScreen.onListSelectionChanged(p91, _, _, p92)
	p91:setVehicle(p91.vehicles[p92])
	p91.selectedItem = true
end
function rvbWorkshopScreen.onInfoDialogCallback(_) end
function rvbWorkshopScreen.onYesNoRepaintDialog(p93, p94)
	if p94 then
		if g_currentMission:getMoney() < p93.vehicle:getRepaintPrice() then
			InfoDialog.show(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))
			return
		end
		g_client:getServerConnection():sendEvent(WearableRepaintEvent.new(p93.vehicle))
	end
end
function rvbWorkshopScreen.onYesNoRepairDialog(self, yes)
	local rvb = self.vehicle.spec_faultData
	if rvb == nil then
		if yes then
			if g_currentMission:getMoney() < self.vehicle:getRepairPrice() then
				InfoDialog.show(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))
				return
			end
			g_client:getServerConnection():sendEvent(WearableRepairEvent.new(self.vehicle, true))
		end
	else
		if yes then
			if g_currentMission:getMoney() < self.vehicle:getRepairPrice_RVBClone() then
				InfoDialog.show(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))
				return
			else
				local faultListTime = 0
				local fault = 0
				for i, key in ipairs(g_vehicleBreakdownsPartKeys) do
					local part = rvb.parts[key]
					if part and part.repairreq then
						faultListTime = faultListTime + VehicleBreakdowns.IRSBTimes[i]
						fault = fault + 1
					end
				end
				local damage = self.vehicle.spec_wearable.damage
				local currentDamageLevel = math.ceil((1 - damage)*100)
				local AddHour = math.floor(faultListTime / 3600)
				local AddMinute = math.floor(((faultListTime / 3600) - AddHour) * 60)
				rvb.repair[8] = fault
				rvb.repair[1] = true
				rvb.repair[2] = false
				rvb.repair[3], rvb.repair[4], rvb.repair[5] = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
				rvb.repair[6] = rvb.repair[8] / faultListTime * 60
				rvb.repair[7] = self.vehicle:getRepairPrice_RVBClone()
				local ageFactor = math.floor(self.vehicle.age / Environment.PERIODS_IN_YEAR)
				local stringformat = "0.0%s"
				local randfirst = 0
				if ageFactor <= 1 then
					randfirst = ageFactor
				elseif ageFactor > 1 and ageFactor < 6 then
					randfirst = ageFactor - 1
				elseif ageFactor > 5 and ageFactor < 10 then
					randfirst = ageFactor - 2
				elseif ageFactor > 9 then
					randfirst = ageFactor - 3
				end
				local stringformat = "0.0%s"
				local rand = math.random(randfirst, ageFactor)
				if rand > 9 then
					stringformat = "0.%s"
				end
				local randomfactor = math.ceil((1 - string.format(stringformat, rand)) * 100)
				if randomfactor <= currentDamageLevel then
					rvb.repair[9] = 0
				elseif randomfactor > currentDamageLevel then
					rvb.repair[9] = randomfactor - currentDamageLevel
				end

			--	rvb.rvb[1] = g_currentMission.missionInfo.timeScale

				--if self.vehicle.isServer then
				--elseif self.vehicle.isClient then
		--		RVBRepair_Event.sendEvent(self.vehicle, unpack(rvb.repair))
			--	RVBTotal_Event.sendEvent(self.vehicle, unpack(rvb.rvb))
			--	self.vehicle:raiseDirtyFlags(rvb.dirtyFlag)
				--end
				
				g_client:getServerConnection():sendEvent(RVBRepairEvent.new(self.vehicle, unpack(rvb.repair)))
				print("Sending RVBRepairEvent (rvbWorkshopScreen.onYesNoRepairDialog()):", unpack(rvb.repair))

				self.vehicle:StopAI(self.vehicle)
				self.vehicle:stopMotor()
				if self.vehicle.deactivateLights ~= nil then
					self.vehicle:deactivateLights()
				end

				g_messageCenter:publish(MessageType.RVB_START_REPAIR, self.vehicle)


				local specm = self.vehicle.spec_motorized
				if specm.motor ~= nil then
					specm.motor:setGearShiftMode(specm.gearShiftMode)
				end
			end
		end
	end
	self.list:reloadData()
end
function rvbWorkshopScreen.onVehicleSold(p97, _, p98, _)
	local v99 = g_i18n:getText("shop_messageSoldVehicle")
	if not p98 then
		v99 = g_i18n:getText("shop_messageReturnedVehicle")
	end
	InfoDialog.show(v99, p97.onInfoDialogCallback, p97, DialogElement.TYPE_INFO)
end
function rvbWorkshopScreen.onVehicleSellFailed(_, p100, p101)
	local v102
	if p100 then
		if p101 == SellVehicleEvent.SELL_NO_PERMISSION then
			v102 = g_i18n:getText("shop_messageNoPermissionToSellVehicleText")
		elseif p101 == SellVehicleEvent.SELL_VEHICLE_IN_USE then
			v102 = g_i18n:getText("shop_messageSellVehicleInUse")
		else
			v102 = g_i18n:getText("shop_messageFailedToSellVehicle")
		end
	elseif p101 == SellVehicleEvent.SELL_NO_PERMISSION then
		v102 = g_i18n:getText("shop_messageNoPermissionToReturnVehicleText")
	elseif p101 == SellVehicleEvent.SELL_VEHICLE_IN_USE then
		v102 = g_i18n:getText("shop_messageReturnVehicleInUse")
	else
		v102 = g_i18n:getText("shop_messageFailedToReturnVehicle")
	end
	InfoDialog.show(v102)
end
function rvbWorkshopScreen.onVehicleChanged(p103, p104)
	if p103.owner ~= nil then
		p103.owner:openMenu()
	end
	if p104 then
		InfoDialog.show(g_i18n:getText("shop_messageConfigurationChanged"), p103.onInfoDialogCallback, p103, DialogElement.TYPE_INFO)
	else
		InfoDialog.show(g_i18n:getText("shop_messageConfigurationChangeFailed"), p103.onInfoDialogCallback, p103)
	end
end
function rvbWorkshopScreen.onVehicleRepairEvent(p105, p106, _)
	if p106 == p105.vehicle then
		p105:setVehicle(p106)
	end
	p105.needsListReload = true
end
function rvbWorkshopScreen.onVehicleRepaintEvent(p107, p108, _)
	if p108 == p107.vehicle then
		p107:setVehicle(p108)
	end
	p107.needsListReload = true
end
function rvbWorkshopScreen.onVehicleSellEvent(p109, p110, p111, p112, p113, p114)
	if p110 then
		if p111 == SellVehicleEvent.SELL_SUCCESS then
			p109:onVehicleSold(p112, p113, p114)
		else
			p109:onVehicleSellFailed(p113, p111)
		end
	else
		return
	end
end
function rvbWorkshopScreen.onextended(p107)

	p107.list:reloadData()
end




function rvbWorkshopScreen.onClickInspection(self)
	local rvb = self.vehicle.spec_faultData
	if self.vehicle == nil or rvb == nil then
		return false
	end
	local AddHour = math.floor(VehicleBreakdowns.IRSBTimes[10] / 3600)
	local AddMinute = math.floor(((VehicleBreakdowns.IRSBTimes[10] / 3600) - AddHour) * 60)
	local FinishDay, FinishHour, FinishMinute = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
	local timeText = string.format("%02d:%02d", FinishHour, FinishMinute)

	local DialogInspectionText = "RVB_inspectionTimeDialog"
	if FinishDay > g_currentMission.environment.currentDay then
		DialogInspectionText = "RVB_inspectionDayDialog"
	end
	local text = string.format(g_i18n:getText("RVB_inspectionDialog"), g_i18n:formatMoney(self.vehicle:getInspectionPrice())).."\n"..
				 string.format(g_i18n:getText(DialogInspectionText), timeText)
	local callback = self.onYesNoInspectionDialog
	local yesSound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_SPRAY
	YesNoDialog.show(callback, self, text, nil, nil, nil, nil, yesSound)
	return true
end
function rvbWorkshopScreen.onYesNoInspectionDialog(self, yes)
	local rvbSpec = self.vehicle.spec_faultData
	if yes and rvbSpec ~= nil then
		if g_currentMission:getMoney() < self.vehicle:getInspectionPrice() then
			InfoDialog.show(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))
			return
		end
		--g_client:getServerConnection():sendEvent(WearableRepairEvent.new(self.vehicle, true))
		local AddHour = math.floor(VehicleBreakdowns.IRSBTimes[10] / 3600)
		local AddMinute = math.floor(((VehicleBreakdowns.IRSBTimes[10] / 3600) - AddHour) * 60)
		rvbSpec.inspection[1] = true
		rvbSpec.inspection[2] = false
		rvbSpec.inspection[3], rvbSpec.inspection[4], rvbSpec.inspection[5] = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
		rvbSpec.inspection[6] = self.vehicle:getInspectionPrice()
		RVBInspection_Event.sendEvent(self.vehicle, unpack(rvbSpec.inspection))
		RVBTotal_Event.sendEvent(self.vehicle, unpack(rvbSpec.rvb))
		self.vehicle:raiseDirtyFlags(rvbSpec.dirtyFlag)
		self.vehicle:StopAI(self.vehicle)
		self.vehicle:stopMotor()
		if self.vehicle.deactivateLights ~= nil then
			self.vehicle:deactivateLights()
		end
		local specm = self.vehicle.spec_motorized
		if specm.motor ~= nil then
			specm.motor:setGearShiftMode(specm.gearShiftMode)
		end
		self.list:reloadData()
	end
end

function rvbWorkshopScreen.onClickService(self)
	local rvb = self.vehicle.spec_faultData
	if self.vehicle == nil or rvb == nil then
		return false
	end
	local moreservice = 1
	local servicePeriodic = math.floor(rvb.rvb[4])
	if servicePeriodic > g_currentMission.vehicleBreakdowns:getPeriodicService() then
		moreservice = math.ceil(servicePeriodic - g_currentMission.vehicleBreakdowns:getPeriodicService())
	end
	local defaultValue = 10800
	local serviceTime = defaultValue + VehicleBreakdowns.IRSBTimes[9] * moreservice
	local AddHour = math.floor(serviceTime / 3600)
	local AddMinute = math.floor(((serviceTime / 3600) - AddHour) * 60)
	local FinishDay, FinishHour, FinishMinute = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
	local timeText = string.format("%02d:%02d", FinishHour, FinishMinute)

	local DialogServiceText = "RVB_periodicserviceTimeDialog"
	if FinishDay > g_currentMission.environment.currentDay then
		DialogServiceText = "RVB_periodicserviceDayDialog"
	end
	local text = string.format(g_i18n:getText("RVB_periodicserviceDialog"), g_i18n:formatMoney(self.vehicle:getServicePrice())).."\n"..
				 string.format(g_i18n:getText(DialogServiceText), timeText)
	local callback = self.onYesNoServiceDialog
	local yesSound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_SPRAY
	YesNoDialog.show(callback, self, text, nil, nil, nil, nil, yesSound)
	return true
end
function rvbWorkshopScreen.onYesNoServiceDialog(self, yes)
	local rvbSpec = self.vehicle.spec_faultData
	if yes and rvbSpec ~= nil then
		if g_currentMission:getMoney() < self.vehicle:getServicePrice() then
			InfoDialog.show(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))
			return
		end
		local moreservice = 1
		local servicePeriodic = math.floor(rvbSpec.rvb[4])
		if servicePeriodic > g_currentMission.vehicleBreakdowns:getPeriodicService() then
			moreservice = math.ceil(servicePeriodic - g_currentMission.vehicleBreakdowns:getPeriodicService())
		end
		local defaultValue = 10800
		local serviceTime = defaultValue + VehicleBreakdowns.IRSBTimes[9] * moreservice
		local AddHour = math.floor(serviceTime / 3600)
		local AddMinute = math.floor(((serviceTime / 3600) - AddHour) * 60)
		rvbSpec.service[8] = servicePeriodic

		rvbSpec.service[1] = true
		rvbSpec.service[2] = false
		rvbSpec.service[3], rvbSpec.service[4], rvbSpec.service[5] = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
		rvbSpec.service[6] = rvbSpec.service[8] / serviceTime * 60
		rvbSpec.service[7] = self.vehicle:getServicePrice()

		--rvbSpec.rvb[1] = g_currentMission.missionInfo.timeScale

			--if self.vehicle.isServer then
			--elseif self.vehicle.isClient then
		--RVBService_Event.sendEvent(self.vehicle, unpack(rvbSpec.service))
		g_client:getServerConnection():sendEvent(RVBService_Event.new(self.vehicle, unpack(rvbSpec.service)))
		print("Sending RVBService_Event (rvbWorkshopScreen.onYesNoServiceDialog()):", unpack(rvbSpec.service))
		--RVBTotal_Event.sendEvent(self.vehicle, unpack(rvbSpec.rvb))
		--self.vehicle:raiseDirtyFlags(rvbSpec.dirtyFlag)
			--end

		self.vehicle:StopAI(self.vehicle)
		self.vehicle:stopMotor()
		if self.vehicle.deactivateLights ~= nil then
			self.vehicle:deactivateLights()
		end
		local specm = self.vehicle.spec_motorized
		if specm.motor ~= nil then
			specm.motor:setGearShiftMode(specm.gearShiftMode)
		end
		self.list:reloadData()
	end
end
function rvbWorkshopScreen.onClickBatteryCh(self)
	local rvb = self.vehicle.spec_faultData
	if self.vehicle == nil or rvb == nil then
		return false
	end
	local defaultValue = 5400
	local chargingTime = defaultValue -- + VehicleBreakdowns.IRSBTimes[9] * moreservice
	local AddHour = math.floor(chargingTime / 3600)
	local AddMinute = math.floor(((chargingTime / 3600) - AddHour) * 60)
	local FinishDay, FinishHour, FinishMinute = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
	local timeText = string.format("%02d:%02d", FinishHour, FinishMinute)

	local DialogServiceText = "RVB_batteryChTimeDialog"
	if FinishDay > g_currentMission.environment.currentDay then
		DialogServiceText = "RVB_batteryChDayDialog"
	end
	--local text = string.format(g_i18n:getText("RVB_batteryChDialog"), g_i18n:formatMoney(self.vehicle:getServicePrice(5))).."\n"..
	--			 string.format(g_i18n:getText(DialogServiceText), timeText)
	local text = string.format(g_i18n:getText("RVB_batteryChDialog"), g_i18n:formatMoney(25))
	local callback = self.onYesNoBatteryChDialog
	local yesSound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_SPRAY
	YesNoDialog.show(callback, self, text, nil, nil, nil, nil, yesSound)
	return true
end
function rvbWorkshopScreen.onYesNoBatteryChDialog(self, yes)
	local rvbSpec = self.vehicle.spec_faultData
	if yes and rvbSpec ~= nil then
		if g_currentMission:getMoney() < 25 then
			InfoDialog.show(g_i18n:getText("shop_messageNotEnoughMoneyToBuy"))
			return
		end
		local defaultValue = 5400
		local chargingTime = defaultValue -- + VehicleBreakdowns.IRSBTimes[9] * moreservice
		local AddHour = math.floor(chargingTime / 3600)
		local AddMinute = math.floor(((chargingTime / 3600) - AddHour) * 60)
		--rvbSpec.service[8] = servicePeriodic
		--rvbSpec.service[1] = true
		--rvbSpec.service[2] = false
		--rvbSpec.service[3], rvbSpec.service[4], rvbSpec.service[5] = VehicleBreakdowns:CalculateFinishTime(AddHour, AddMinute)
		--rvbSpec.service[6] = rvbSpec.service[8] / chargingTime * 60
		--rvbSpec.service[7] = self.vehicle:getServicePrice()
		--rvbSpec.rvb[1] = g_currentMission.missionInfo.timeScale
		--RVBService_Event.sendEvent(self.vehicle, unpack(rvbSpec.service))
		--RVBTotal_Event.sendEvent(self.vehicle, unpack(rvbSpec.rvb))
		--self.vehicle:raiseDirtyFlags(rvbSpec.dirtyFlag)
		g_client:getServerConnection():sendEvent(BatteryFillUnitFillLevelEvent.new(self.vehicle, true))
		self.vehicle:StopAI(self.vehicle)
		self.vehicle:stopMotor()
		if self.vehicle.deactivateLights ~= nil then
			self.vehicle:deactivateLights()
		end
		local specm = self.vehicle.spec_motorized
		if specm.motor ~= nil then
			specm.motor:setGearShiftMode(specm.gearShiftMode)
		end
		self.list:reloadData()
	end
end
													--state
function rvbWorkshopScreen.onClickThermostatPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.thermostat, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Thermostat: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickLightingsPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.lightings, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Lightings: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickGlowPlugPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.glowplug, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part GlowPlug: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickWipersPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.wipers, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Wipers: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickGeneratorPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.generator, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Generator: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickEnginePart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.engine, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Engine: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickSelfstarterPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.selfstarter, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Selfstarter: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickBatteryPart(self, _, elements)
	local rvb = self.vehicle.spec_faultData
	self.vehicle:setPartsRepairreq(P.battery, elements:getIsChecked())
	self:setVehicle(self.vehicle)
	self.needsListReload = true
	Logging.info("  RVB Repair Part Battery: \'" .. tostring(elements:getIsChecked()) .. "\'")
end
function rvbWorkshopScreen.onClickResetVehicle(self, _, elements)
	if self.vehicle == nil then
        Logging.error("rvbWorkshopScreen.onClickResetVehicle() No vehicle found for reset.")
        return false
    end
	local rvb = self.vehicle.spec_faultData
	local title = g_i18n:getText("RVB_workshopVResetTitle")
	local text = string.format(g_i18n:getText("RVB_workshopVResetDesc"), self.vehicle:getFullName())
	local callback = self.onYesNoResetVehicleDialog
	local sound = GuiSoundPlayer.SOUND_SAMPLES.CONFIG_WRENCH
	YesNoDialog.show(callback, self, text, title, nil, nil, nil, sound)
	return true
end
function rvbWorkshopScreen.onYesNoResetVehicleDialog(self, yes)
	if yes then
		g_client:getServerConnection():sendEvent(RVBResetVehicle_Event.new(self.vehicle, true))
		self.vehicle:StopAI(self.vehicle)
		self.vehicle:stopMotor()
		if self.vehicle.deactivateLights ~= nil then
			self.vehicle:deactivateLights()
		end
		local specm = self.vehicle.spec_motorized
		if specm.motor ~= nil then
			specm.motor:setGearShiftMode(specm.gearShiftMode)
		end
	end
end
function rvbWorkshopScreen.onVehicleResetEvent(p107, p108, _)
	if p108 == p107.vehicle then
		p107:setVehicle(p108)
	end
	p107.needsListReload = true
end
if g_modIsLoaded["FS25_useYourTyres"] then
	source(Utils.getFilename("scripts/mods/useYourTyres/rvbUseYourTyres.lua", g_vehicleBreakdownsDirectory))
end