RVBMenuSettingsFrame = {}

local v_u_1 = Class(RVBMenuSettingsFrame, TabbedMenuFrameElement)
local function v_u_2() end
RVBMenuSettingsFrame.SUB_CATEGORY = {
	["GAME_SETTINGS"] = 1,
	["GENERAL_SETTINGS"] = 2
}

function RVBMenuSettingsFrame.register()
	local v3 = RVBMenuSettingsFrame.new()
	g_gui:loadGui(g_vehicleBreakdownsDirectory .. "gui/RVBMenuSettingsFrame.xml", "SettingsFrame", v3, true)
end
function RVBMenuSettingsFrame.new(p4, p5)
	local v6 = TabbedMenuFrameElement.new(p4, p5 or v_u_1)
	v6.missionInfo = nil
	v6.RVB = nil
	v6.hasMasterRights = false
	v6.isOpening = false
	v6.currentUser = User.new()
	return v6
end
function RVBMenuSettingsFrame.createFromExistingGui(p11, p12)
	local v13 = RVBMenuSettingsFrame.new()
	g_gui.frames[p11.name].target:delete()
	g_gui.frames[p11.name]:delete()
	g_gui:loadGui(p11.xmlFilename, p12, v13, true)
	return v13
end
function RVBMenuSettingsFrame.initialize(p_u_14)
	p_u_14:initializeSubCategoryPages()
	p_u_14:initializeGameSettings()
	p_u_14:initializeGeneralSettings()
	p_u_14:initializeButtons()
	p_u_14.subCategoryPagingFocusChangeFunc = p_u_14.subCategoryPaging.shouldFocusChange
end
function RVBMenuSettingsFrame.initializeSubCategoryPages(p_u_24)
	local v25 = {}
	for v_u_26, v27 in pairs(p_u_24.subCategoryTabs) do
		v27:getDescendantByName("background").getIsSelected = function()
			local v28 = v_u_26
			local v29 = p_u_24.subCategoryPaging.texts[p_u_24.subCategoryPaging:getState()]
			return v28 == tonumber(v29)
		end
		function v27.getIsSelected()
			local v30 = v_u_26
			local v31 = p_u_24.subCategoryPaging.texts[p_u_24.subCategoryPaging:getState()]
			return v30 == tonumber(v31)
		end
		local v32 = g_currentMission
		if v_u_26 == RVBMenuSettingsFrame.SUB_CATEGORY.SERVER_SETTINGS and not (p_u_24.hasMasterRights and v32.missionDynamicInfo.isMultiplayer) then
			v27:setVisible(false)
		else
			v27:setVisible(true)
			local v33 = tostring(v_u_26)
			table.insert(v25, v33)
		end
	end
	p_u_24.subCategoryBox:invalidateLayout()
	p_u_24.subCategoryPaging:setTexts(v25)
	p_u_24.subCategoryPaging:setSize(p_u_24.subCategoryBox.maxFlowSize + 140 * g_pixelSizeScaledX)
end
function RVBMenuSettingsFrame.initializeGameSettings(p_u_34, p35, p36)
	p_u_34:assignStaticTexts()
	p_u_34.onClickBackCallback = p36 or v_u_2
end
function RVBMenuSettingsFrame.initializeGeneralSettings(self)
	local difficultyTable = {}
	table.insert(difficultyTable, g_i18n:getText(RVBMenuSettingsFrame.L10N_SYMBOL.DIFFICULTY_SLOW))
	table.insert(difficultyTable, g_i18n:getText(RVBMenuSettingsFrame.L10N_SYMBOL.DIFFICULTY_MEDIUM))
	table.insert(difficultyTable, g_i18n:getText(RVBMenuSettingsFrame.L10N_SYMBOL.DIFFICULTY_FAST))
	self.multiRvbDifficulty:setTexts(difficultyTable)
end
function RVBMenuSettingsFrame.initializeButtons(p_u_39)
	p_u_39.backButtonInfo = {
		["inputAction"] = InputAction.MENU_BACK
	}
	p_u_39.nextPageButtonInfo = {
		["inputAction"] = InputAction.MENU_PAGE_NEXT,
		["text"] = g_i18n:getText("ui_ingameMenuNext"),
		["callback"] = p_u_39.onPageNext
	}
	p_u_39.prevPageButtonInfo = {
		["inputAction"] = InputAction.MENU_PAGE_PREV,
		["text"] = g_i18n:getText("ui_ingameMenuPrev"),
		["callback"] = p_u_39.onPagePrevious
	}
	p_u_39.resetButtonInfo = {
		["inputAction"] = InputAction.MENU_CANCEL,
		["text"] = g_i18n:getText(RVBMenuSettingsFrame.L10N_SYMBOL.BUTTON_DEFAULTS),
		["callback"] = function()
			p_u_39:onClickDefaults()
		end,
		["showWhenPaused"] = true
	}
	p_u_39.adminButtonInfo = {
		["inputAction"] = InputAction.MENU_ACTIVATE,
		["text"] = g_i18n:getText("button_adminLogin"),
		["callback"] = function()
			p_u_39:onButtonAdminLogin()
		end
	}
end
function RVBMenuSettingsFrame.setMissionInfo(p42, p43)
	p42.missionInfo = p43

end
function RVBMenuSettingsFrame.setHasMasterRights(p47, p48)
	p47.hasMasterRights = p48
	if g_currentMission ~= nil then
		p47:updateButtons()
	end
end
function RVBMenuSettingsFrame.onFrameOpen(p49, _)
	RVBMenuSettingsFrame:superClass().onFrameOpen(p49)
	g_messageCenter:subscribe(MessageType.MASTERUSER_ADDED, p49.onMasterUserAdded, p49)
	p49:setCurrentUserId(g_currentMission.playerUserId)
	p49:initializeSubCategoryPages()
	p49.isOpening = true
	local v50 = g_currentMission
	local v51 = v50.missionDynamicInfo.isMultiplayer
	if not v51 or (v51 and g_inGameMenu.isServer or g_inGameMenu.isMasterUser) then
		p49:updateGameSettings()
		p49.gameSettingsLayout:setVisible(true)
		p49.gameSettingsLayout:invalidateLayout()
		p49.gameSettingsSeparator:setVisible(true)
		p49.gameSettingsNoPermissionText:setVisible(false)
	else
		p49.gameSettingsLayout:setVisible(false)
		p49.gameSettingsSeparator:setVisible(false)
		p49.gameSettingsNoPermissionText:setVisible(true)
	end
	p49:updateGeneralSettings()
	local v59 = true
	for _, v60 in pairs(p49.gameSettingsLayout.elements) do
		if v60.name == "sectionHeader" then
			v59 = true
		elseif v60:getIsVisible() then
			local v61 = RVBMenuSettingsFrame.COLOR_ALTERNATING[v59]
			v60:setImageColor(nil, unpack(v61))
			v59 = not v59
		end
	end
	local v62 = true
	for _, v63 in pairs(p49.generalSettingsLayout.elements) do
		if v63.name == "sectionHeader" then
			v62 = true
		elseif v63:getIsVisible() then
			local v64 = RVBMenuSettingsFrame.COLOR_ALTERNATING[v62]
			v63:setImageColor(nil, unpack(v64))
			v62 = not v62
		end
	end
	p49.generalSettingsLayout:invalidateLayout()
	p49:updateSubCategoryPages((p49.subCategoryPaging:getState()))
	p49.isOpening = false
end
function RVBMenuSettingsFrame.onFrameClose(p76)
	--g_settingsModel:saveChanges(SettingsModel.SETTING_CLASS.SAVE_GAMEPLAY_SETTINGS)
	RVBMenuSettingsFrame:superClass().onFrameClose(p76)
end
function RVBMenuSettingsFrame.update(p77, p78)
	RVBMenuSettingsFrame:superClass().update(p77, p78)
	if p77.nextFocusSection ~= nil then
		local v79 = p77.controlsList:getElementAtSectionIndex(p77.nextFocusSection, p77.nextFocusCell)
		if v79 ~= nil then
			local v80 = v79:getAttribute(p77.nextFocusedButtonName)
			FocusManager:setFocus(v80)
			p77.nextFocusSection = nil
			p77.nextFocusCell = nil
		end
	end
end
function RVBMenuSettingsFrame.updateButtons(p97)
	p97.menuButtonInfo = { p97.backButtonInfo, p97.nextPageButtonInfo, p97.prevPageButtonInfo }
	--local v98 = p97.subCategoryPaging.texts[p97.subCategoryPaging:getState()]

	if p97.subCategoryPaging:getState() == RVBMenuSettingsFrame.SUB_CATEGORY.GAME_SETTINGS then
		--if p97.currentUser:getIsMasterUser() then
		--	local v106 = p97.menuButtonInfo
			--local v107 = p97.createMenuButton
			--table.insert(v106, v107)
		--elseif
		if g_currentMission ~= nil and (g_currentMission.connectedToDedicatedServer and not p97.currentUser:getIsMasterUser()) then
			local v108 = p97.menuButtonInfo
			local v109 = p97.adminButtonInfo
			table.insert(v108, v109)
		end
	end
	p97:setMenuButtonInfoDirty()
end
function RVBMenuSettingsFrame.setCurrentUserId(p22, p23)
	p22.currentUserId = p23
	p22.currentUser = g_currentMission.userManager:getUserByUserId(p23) or p22.currentUser
	p22:updateButtons()
end
function RVBMenuSettingsFrame.onButtonAdminLogin(p202)
	PasswordDialog.show(p202.onAdminPassword, p202, nil, "", g_i18n:getText("button_adminLogin"))
end
function RVBMenuSettingsFrame.onAdminPassword(_, password, yes)
	if yes then
		g_client:getServerConnection():sendEvent(GetAdminEvent.new(password))
	end
end
function RVBMenuSettingsFrame.onMasterUserAdded(p178, _)
	local v50 = g_currentMission
	local v51 = v50.missionDynamicInfo.isMultiplayer
	if not v51 or (v51 and g_inGameMenu.isServer or g_inGameMenu.isMasterUser) then
		p178:updateGameSettings()
		p178.gameSettingsLayout:setVisible(true)
		p178.gameSettingsLayout:invalidateLayout()
		p178.gameSettingsSeparator:setVisible(true)
		p178.gameSettingsNoPermissionText:setVisible(false)
	end
	p178:updateButtons()
end
function RVBMenuSettingsFrame.updateGameSettings(self)
	local RVB = g_currentMission.vehicleBreakdowns
	self.multidailyServiceInterval:setState(rvb_Utils.getDailyServiceIndex(RVB:getDailyService(), 2))
	self.multiperiodicServiceInterval:setState(rvb_Utils.getPeriodicServiceIndex(RVB:getPeriodicService(), 1))
	--self.checkonlyWorkshop:setIsChecked(RVB:getIsRepairShop(), self.isOpening)
	self.multiworkshopOpen:setState(rvb_Utils.getWorkshopOpenIndex(RVB:getWorkshopOpen(), 1))
	self.multiworkshopClose:setState(rvb_Utils.getWorkshopCloseIndex(RVB:getWorkshopClose(), 1))
	self.multiworkshopCountMax:setState(rvb_Utils.getWorkshopCountMaxIndex(RVB:getWorkshopCountMax(), 2))
	self.multiThermostatLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getThermostatLifetime(), 30))
	self.multiLightingsLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getLightingsLifetime(), 44))
	self.multiGlowplugLifetime:setState(rvb_Utils.getSmallLifetimeIndex(RVB:getGlowplugLifetime(), 2))
	self.multiWipersLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getWipersLifetime(), 16))
	self.multiGeneratorLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getGeneratorLifetime(), 36))
	self.multiEngineLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getEngineLifetime(), 42))
	self.multiSelfstarterLifetime:setState(rvb_Utils.getSmallLifetimeIndex(RVB:getSelfstarterLifetime(), 3))
	self.multiBatteryLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getBatteryLifetime(), 28))
	self.multiTireLifetime:setState(rvb_Utils.getLargeLifetimeIndex(RVB:getTireLifetime(), 68))
end
function RVBMenuSettingsFrame.assignStaticTexts(self)
	self:assignDailyServiceTexts()
	self:assignPeriodicServiceTexts()
	self:assignWorkshopOpenTexts()
	self:assignWorkshopCloseTexts()
	self:assignWorkshopCountMaxTexts()
	self:assignThermostatLifetimeTexts()
	self:assignLightingsLifetimeTexts()
	self:assignGlowplugLifetimeTexts()
	self:assignWipersLifetimeTexts()
	self:assignGeneratorLifetimeTexts()
	self:assignEngineLifetimeTexts()
	self:assignSelfstarterLifetimeTexts()
	self:assignBatteryLifetimeTexts()
	self:assignTireLifetimeTexts()
end
function RVBMenuSettingsFrame.assignDailyServiceTexts(self)
	local dailyServiceTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.DailyService) do
		local dailyServiceStrings = rvb_Utils.getDailyServiceString
		table.insert(dailyServiceTable, dailyServiceStrings(i))
	end
	self.multidailyServiceInterval:setTexts(dailyServiceTable)
	-- deactivate
	self.multidailyServiceInterval:setDisabled(true)
	self.multidailyServiceInterval:setVisible(true)
end
function RVBMenuSettingsFrame.assignPeriodicServiceTexts(self)
	local periodicServiceTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.PeriodicService) do
		local periodicServiceStrings = rvb_Utils.getPeriodicServiceString
		table.insert(periodicServiceTable, periodicServiceStrings(i))
	end
	self.multiperiodicServiceInterval:setTexts(periodicServiceTable)
end
function RVBMenuSettingsFrame.assignWorkshopOpenTexts(self)
	local workshopOpenTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.WorkshopOpen) do
		local workshopOpenStrings = rvb_Utils.getWorkshopOpenString
		table.insert(workshopOpenTable, workshopOpenStrings(i))
	end
	self.multiworkshopOpen:setTexts(workshopOpenTable)
end
function RVBMenuSettingsFrame.assignWorkshopCloseTexts(self)
	local workshopCloseTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.WorkshopClose) do
		local workshopCloseStrings = rvb_Utils.getWorkshopCloseString
		table.insert(workshopCloseTable, workshopCloseStrings(i))
	end
	self.multiworkshopClose:setTexts(workshopCloseTable)
end
function RVBMenuSettingsFrame.assignWorkshopCountMaxTexts(self)
	local workshopCountMaxTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.WorkshopCountMax) do
		local workshopCountMaxStrings = rvb_Utils.getWorkshopCountMaxString
		table.insert(workshopCountMaxTable, workshopCountMaxStrings(i))
	end
	self.multiworkshopCountMax:setTexts(workshopCountMaxTable)
end
function RVBMenuSettingsFrame.assignThermostatLifetimeTexts(self)
	local thermostatLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(thermostatLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiThermostatLifetime:setTexts(thermostatLifetimeTable)
end
function RVBMenuSettingsFrame.assignLightingsLifetimeTexts(self)
	local lightingsLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(lightingsLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiLightingsLifetime:setTexts(lightingsLifetimeTable)
end
function RVBMenuSettingsFrame.assignGlowplugLifetimeTexts(self)
	local glowplugLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.SmallArray) do
		local smallLifetimeStrings = rvb_Utils.getSmallLifetimeString
		table.insert(glowplugLifetimeTable, smallLifetimeStrings(i))
	end
	self.multiGlowplugLifetime:setTexts(glowplugLifetimeTable)
end
function RVBMenuSettingsFrame.assignWipersLifetimeTexts(self)
	local wipersLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(wipersLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiWipersLifetime:setTexts(wipersLifetimeTable)
end
function RVBMenuSettingsFrame.assignGeneratorLifetimeTexts(self)
	local generatorLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(generatorLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiGeneratorLifetime:setTexts(generatorLifetimeTable)
end
function RVBMenuSettingsFrame.assignEngineLifetimeTexts(self)
	local engineLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(engineLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiEngineLifetime:setTexts(engineLifetimeTable)
end
function RVBMenuSettingsFrame.assignSelfstarterLifetimeTexts(self)
	local selfstarterLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.SmallArray) do
		local smallLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(selfstarterLifetimeTable, smallLifetimeStrings(i))
	end
	self.multiSelfstarterLifetime:setTexts(selfstarterLifetimeTable)
end
function RVBMenuSettingsFrame.assignBatteryLifetimeTexts(self)
	local batteryLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(batteryLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiBatteryLifetime:setTexts(batteryLifetimeTable)
end
function RVBMenuSettingsFrame.assignTireLifetimeTexts(self)
	local tireLifetimeTable = {}
	for i = 1, rvb_Utils.table_count(rvb_Utils.LargeArray) do
		local largeLifetimeStrings = rvb_Utils.getLargeLifetimeString
		table.insert(tireLifetimeTable, largeLifetimeStrings(i))
	end
	self.multiTireLifetime:setTexts(tireLifetimeTable)
end
function RVBMenuSettingsFrame.updateGeneralSettings(self)
	local RVB = g_currentMission.vehicleBreakdowns
	self.checkAlertDialog:setIsChecked(RVB:getIsAlertMessage(), self.isOpening)
	self.multiRvbDifficulty:setState(RVB:getRVBDifficulty())
	self.checkVHud:setIsChecked(RVB:getIsVHudDisplay(), self.isOpening)
	self.checkshowTemp:setIsChecked(RVB:getIsShowTempDisplay(), self.isOpening)
	self.checkshowRpm:setIsChecked(RVB:getIsShowRpmDisplay(), self.isOpening)
	self.checkshowFuel:setIsChecked(RVB:getIsShowFuelDisplay(), self.isOpening)
	self.checkshowDebug:setIsChecked(RVB:getIsShowDebugDisplay(), self.isOpening)
end
function RVBMenuSettingsFrame.onClickPeriodicServiceInterval(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setPeriodicServiceInterval(rvb_Utils.getPeriodicServiceFromIndex(state))
	end
end
--function RVBMenuSettingsFrame.onClickOnlyWorkshop(self, _, elements)
--	if self.hasMasterRights then
--		g_currentMission.vehicleBreakdowns:setIsRepairShop(elements:getIsChecked())
--	end
--end
function RVBMenuSettingsFrame.onClickWorkshopOpen(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setWorkshopOpen(rvb_Utils.getWorkshopOpenFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickWorkshopClose(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setWorkshopClose(rvb_Utils.getWorkshopCloseFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickWorkshopCountMax(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setWorkshopCountMax(rvb_Utils.getWorkshopCountMaxFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickThermostatLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setThermostatLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickLightingsLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setLightingsLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickGlowplugLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setGlowplugLifetime(rvb_Utils.getSmallLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickWipersLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setWipersLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickGeneratorLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setGeneratorLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickEngineLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setEngineLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickSelfstarterLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setSelfstarterLifetime(rvb_Utils.getSmallLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickBatteryLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setBatteryLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickTireLifetime(self, state)
	if self.hasMasterRights then
		g_currentMission.vehicleBreakdowns:setTireLifetime(rvb_Utils.getLargeLifetimeFromIndex(state))
	end
end
function RVBMenuSettingsFrame.onClickAlertDialog(self, _, elements)
	g_currentMission.vehicleBreakdowns:setIsAlertMessage(elements:getIsChecked())
end
function RVBMenuSettingsFrame.onClickRvbDifficulty(self, state)
	g_currentMission.vehicleBreakdowns:setRVBDifficulty(state)
end
function RVBMenuSettingsFrame.onClickVHud(self, _, elements)
	g_currentMission.vehicleBreakdowns:setIsVHudDisplay(elements:getIsChecked())
end
function RVBMenuSettingsFrame.onClickshowTemp(self, _, elements)
	g_currentMission.vehicleBreakdowns:setIsShowTempDisplay(elements:getIsChecked())
end
function RVBMenuSettingsFrame.onClickshowRpm(self, _, elements)
	g_currentMission.vehicleBreakdowns:setIsShowRpmDisplay(elements:getIsChecked())
end
function RVBMenuSettingsFrame.onClickshowFuel(self, _, elements)
	g_currentMission.vehicleBreakdowns:setIsShowFuelDisplay(elements:getIsChecked())
end
function RVBMenuSettingsFrame.onClickshowDebug(self, _, elements)
	g_currentMission.vehicleBreakdowns:setIsShowDebugDisplay(elements:getIsChecked())
end
function RVBMenuSettingsFrame.onClickGameSettings(p266)
	p266.subCategoryPaging:setState(RVBMenuSettingsFrame.SUB_CATEGORY.GAME_SETTINGS, true)
end
function RVBMenuSettingsFrame.onClickGeneralSettings(p267)
	p267.subCategoryPaging:setState(RVBMenuSettingsFrame.SUB_CATEGORY.GENERAL_SETTINGS, true)
end
function RVBMenuSettingsFrame.onClickPreviousSubCategory(p270)
	p270.subCategoryPaging:onLeftButtonClicked()
end
function RVBMenuSettingsFrame.onClickNextSubCategory(p271)
	p271.subCategoryPaging:onRightButtonClicked()
end
function RVBMenuSettingsFrame.updateSubCategoryPages(p_u_272, p_u_273)
	local v274 = p_u_272.subCategoryPaging.texts[p_u_273]
	if v274 == nil then
		return
	else
		local v275 = tonumber(v274)
		if p_u_272:requestClose(function()
			p_u_272:updateSubCategoryPages(p_u_273)
		end) then
			for v276, v277 in pairs(p_u_272.subCategoryPages) do
				v277:setVisible(v276 == v275)
			end
			p_u_272.subCategoryPaging.shouldFocusChange = p_u_272.subCategoryPagingFocusChangeFunc
			p_u_272.categoryHeaderIcon:setImageSlice(nil, RVBMenuSettingsFrame.HEADER_SLICES[v275])
			p_u_272.categoryHeaderText:setText(g_i18n:getText(RVBMenuSettingsFrame.HEADER_TITLES[v275]))
			if p_u_272.menuAcceptUpEventId ~= nil then
				g_inputBinding:removeActionEvent(p_u_272.menuAcceptUpEventId)
			end
			if v275 == RVBMenuSettingsFrame.SUB_CATEGORY.GAME_SETTINGS then
				p_u_272.settingsSlider:setDataElement(p_u_272.gameSettingsLayout)
				FocusManager:linkElements(p_u_272.subCategoryPaging, FocusManager.TOP, p_u_272.gameSettingsLayout.elements[#p_u_272.gameSettingsLayout.elements].elements[1])
				FocusManager:linkElements(p_u_272.subCategoryPaging, FocusManager.BOTTOM, p_u_272.gameSettingsLayout.elements[1].elements[1])
			elseif v275 == RVBMenuSettingsFrame.SUB_CATEGORY.GENERAL_SETTINGS then
				p_u_272.settingsSlider:setDataElement(p_u_272.generalSettingsLayout)
				FocusManager:linkElements(p_u_272.subCategoryPaging, FocusManager.TOP, p_u_272.generalSettingsLayout.elements[#p_u_272.generalSettingsLayout.elements].elements[1])
				FocusManager:linkElements(p_u_272.subCategoryPaging, FocusManager.BOTTOM, p_u_272.generalSettingsLayout.elements[1].elements[1])
			end
			p_u_272:updateButtons()
			FocusManager:setFocus(p_u_272.subCategoryPaging)
		end
	end
end
function RVBMenuSettingsFrame.inputEvent(p324, p325, _, p326)
	if p325 == InputAction.MENU_ACCEPT then
		return FocusManager:getFocusedElement() ~= p324.buttonPauseGame
	else
		return p326
	end
end
function RVBMenuSettingsFrame.onClickDefaults(p_u_337)
	YesNoDialog.show(function(p338)
		if p338 then
			p_u_337:updateButtons()
			InfoDialog.show(g_i18n:getText(SettingsControlsFrame.L10N_SYMBOL.DEFAULTS_LOADED), function(p339)
				p339.nextFocusSection = 1
				p339.nextFocusCell = 1
				p339.nextFocusedButtonName = "actionButton1"
			end, p_u_337, DialogElement.TYPE_INFO)
		end
	end, nil, g_i18n:getText(RVBMenuSettingsFrame.L10N_SYMBOL.LOAD_DEFAULTS), g_i18n:getText(RVBMenuSettingsFrame.L10N_SYMBOL.BUTTON_RESET))
end

RVBMenuSettingsFrame.L10N_SYMBOL = {
	["DIFFICULTY_SLOW"] = "RVB_difficulty_slow",
	["DIFFICULTY_MEDIUM"] = "RVB_difficulty_medium",
	["DIFFICULTY_FAST"] = "RVB_difficulty_fast",
	["BUTTON_DEFAULTS"] = "button_defaults",
	["LOAD_DEFAULTS"] = "ui_loadDefaultSettings",
	["DEFAULTS_LOADED"] = "ui_loadedDefaultSettings",
	["BUTTON_RESET"] = "button_reset"
}
RVBMenuSettingsFrame.HEADER_SLICES = {
	[RVBMenuSettingsFrame.SUB_CATEGORY.GAME_SETTINGS] = "gui.icon_options_gameSettings2",
	[RVBMenuSettingsFrame.SUB_CATEGORY.GENERAL_SETTINGS] = "gui.icon_options_generalSettings2"
}
RVBMenuSettingsFrame.HEADER_TITLES = {
	[RVBMenuSettingsFrame.SUB_CATEGORY.GAME_SETTINGS] = "ui_ingameMenuGameSettingsGame",
	[RVBMenuSettingsFrame.SUB_CATEGORY.GENERAL_SETTINGS] = "ui_ingameMenuGameSettingsGeneral"
}
RVBMenuSettingsFrame.COLOR_ALTERNATING = {
	[true] = {
		0.02956,
		0.02956,
		0.02956,
		0.6
	},
	[false] = {
		0.02956,
		0.02956,
		0.02956,
		0.2
	}
}
RVBMenuSettingsFrame.COLOR = {
	["BLACK"] = {
		0.00439,
		0.00478,
		0.00368,
		1
	},
	["GREEN"] = {
		0.22323,
		0.40724,
		0.00368,
		1
	}
}