
RVBService_Event = {}
local RVBService_Event_mt = Class(RVBService_Event, Event)
InitEventClass(RVBService_Event, "RVBService_Event")

function RVBService_Event.emptyNew()
	local self = Event.new(RVBService_Event_mt)
	return self
end
function RVBService_Event.new(vehicle, service, message)
	local self = RVBService_Event.emptyNew()
	self.vehicle = vehicle
	self.service = service or {}
	self.message = message or {}
	return self
end
function RVBService_Event:readStream(streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.service = {}
	self.service[1] = streamReadBool(streamId)
	self.service[2] = streamReadBool(streamId)
	self.service[3] = streamReadInt16(streamId)
	self.service[4] = streamReadInt16(streamId)
	self.service[5] = streamReadInt16(streamId)
	self.service[6] = streamReadFloat32(streamId)
	self.service[7] = streamReadFloat32(streamId)
	self.service[8] = streamReadInt16(streamId)
	self.message = {}
	self.message.result = streamReadBool(streamId) or false
	self.message.cost   = streamReadFloat32(streamId) or 0
	self.message.text   = streamReadString(streamId) or ""
	self:run(connection)
end
function RVBService_Event:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteBool(streamId, self.service[1])
	streamWriteBool(streamId, self.service[2])
	streamWriteInt16(streamId, self.service[3])
	streamWriteInt16(streamId, self.service[4])
	streamWriteInt16(streamId, self.service[5])
	streamWriteFloat32(streamId, self.service[6])
	streamWriteFloat32(streamId, self.service[7])
	streamWriteInt16(streamId, self.service[8])
	streamWriteBool(streamId, self.message.result or false)
    streamWriteFloat32(streamId, self.message.cost or 0)
    streamWriteString(streamId, self.message.text or "")
end
function RVBService_Event:run(connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
		self.vehicle:SyncClientServer_RVBService(self.service, self.message)
		if not connection:getIsServer() then
			g_server:broadcastEvent(RVBService_Event.new(self.vehicle, self.service, self.message), nil, nil, self.vehicle)
		end
	end
end
function RVBService_Event.sendEvent(vehicle, data, message, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RVBService_Event.new(vehicle, data, message), true, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(RVBService_Event.new(vehicle, data, message))
		end
	end
end