
RVBRepairEvent = {}
local RVBRepairEvent_mt = Class(RVBRepairEvent, Event)
InitEventClass(RVBRepairEvent, "RVBRepairEvent")

function RVBRepairEvent.emptyNew()
	return Event.new(RVBRepairEvent_mt)
end
function RVBRepairEvent.new(vehicle, repair, message)
	local self = RVBRepairEvent.emptyNew()
	self.vehicle = vehicle
	self.repair = repair or {}
	self.message = message or {}
	return self
end
function RVBRepairEvent.writeStream(self, streamId, _)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteBool(streamId, self.repair[1])
	streamWriteBool(streamId, self.repair[2])
	streamWriteInt16(streamId, self.repair[3])
	streamWriteInt16(streamId, self.repair[4])
	streamWriteInt16(streamId, self.repair[5])
	streamWriteFloat32(streamId, self.repair[6])
	streamWriteFloat32(streamId, self.repair[7])
	streamWriteFloat32(streamId, self.repair[8])
	streamWriteFloat32(streamId, self.repair[9])
	streamWriteBool(streamId, self.repair[10])
	streamWriteBool(streamId, self.message.result or false)
    streamWriteFloat32(streamId, self.message.cost or 0)
    streamWriteString(streamId, self.message.text or "")
end
function RVBRepairEvent.readStream(self, streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.repair = {}
	self.repair[1] = streamReadBool(streamId)
	self.repair[2] = streamReadBool(streamId)
	self.repair[3] = streamReadInt16(streamId)
	self.repair[4] = streamReadInt16(streamId)
	self.repair[5] = streamReadInt16(streamId)
	self.repair[6] = streamReadFloat32(streamId)
	self.repair[7] = streamReadFloat32(streamId)
	self.repair[8] = streamReadFloat32(streamId)
	self.repair[9] = streamReadFloat32(streamId)
	self.repair[10] = streamReadBool(streamId)
	self.message = {}
	self.message.result = streamReadBool(streamId) or false
	self.message.cost   = streamReadFloat32(streamId) or 0
	self.message.text   = streamReadString(streamId) or ""
	self:run(connection)
end
function RVBRepairEvent.run(self, connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
		self.vehicle:SyncClientServer_RVBRepair(self.repair, self.message)
		if not connection:getIsServer() then
			g_server:broadcastEvent(RVBRepairEvent.new(self.vehicle, self.repair, self.message), nil, nil, self.vehicle)
		end
	end
end
function RVBRepairEvent.sendEvent(vehicle, data, message, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RVBRepairEvent.new(vehicle, data, message), true, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(RVBRepairEvent.new(vehicle, data, message))
		end
	end
end