
RVBInspection_Event = {}
local RVBInspection_Event_mt = Class(RVBInspection_Event, Event)
InitEventClass(RVBInspection_Event, "RVBInspection_Event")

function RVBInspection_Event.emptyNew()
	local self = Event.new(RVBInspection_Event_mt)
	return self
end
function RVBInspection_Event.new(vehicle, inspection, message)
	local self = RVBInspection_Event.emptyNew()
	self.vehicle = vehicle
	self.inspection = inspection or {}
	self.message = message or {}
	return self
end
function RVBInspection_Event.readStream(self, streamId, connection)
	self.vehicle = NetworkUtil.readNodeObject(streamId)
	self.inspection = {}
	self.inspection[1] = streamReadBool(streamId)
	self.inspection[2] = streamReadBool(streamId)
	self.inspection[3] = streamReadInt16(streamId)
	self.inspection[4] = streamReadInt16(streamId)
	self.inspection[5] = streamReadInt16(streamId)
	self.inspection[6] = streamReadFloat32(streamId)
	self.inspection[7] = streamReadFloat32(streamId)
	self.inspection[8] = streamReadBool(streamId)
	self.message = {}
	self.message.result = streamReadBool(streamId) or false
	self.message.cost   = streamReadFloat32(streamId) or 0
	self.message.text   = streamReadString(streamId) or ""
	self:run(connection)
end
function RVBInspection_Event.writeStream(self, streamId, _)
	NetworkUtil.writeNodeObject(streamId, self.vehicle)
	streamWriteBool(streamId, self.inspection[1])
	streamWriteBool(streamId, self.inspection[2])
	streamWriteInt16(streamId, self.inspection[3])
	streamWriteInt16(streamId, self.inspection[4])
	streamWriteInt16(streamId, self.inspection[5])
	streamWriteFloat32(streamId, self.inspection[6])
	streamWriteFloat32(streamId, self.inspection[7])
	streamWriteBool(streamId, self.inspection[8])
	streamWriteBool(streamId, self.message.result or false)
	streamWriteFloat32(streamId, self.message.cost or 0)
	streamWriteString(streamId, self.message.text or "")
end
function RVBInspection_Event:run(connection)
	if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
		self.vehicle:SyncClientServer_RVBInspection(self.inspection, self.message)
		if not connection:getIsServer() then
			g_server:broadcastEvent(RVBInspection_Event.new(self.vehicle, self.inspection, self.message), nil, nil, self.vehicle)
		end
	end
end
function RVBInspection_Event.sendEvent(vehicle, data, message, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(RVBInspection_Event.new(vehicle, data, message), true, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(RVBInspection_Event.new(vehicle, data, message))
		end
	end
end