
local directory = g_currentModDirectory
local modName = g_currentModName
g_vehicleBreakdownsModName = modName
g_vehicleBreakdownsDirectory = directory
g_resetVehiclesRVB = {}

source(directory .. "scripts/rvbConfig.lua")

source(Utils.getFilename("scripts/RVBMain.lua", directory))
-- TABBEDMENU
source(Utils.getFilename("scripts/gui/RVBMenu.lua", directory))
-- FRAME FILES
source(Utils.getFilename("scripts/gui/RVBMenuSettingsFrame.lua", directory))
source(Utils.getFilename("scripts/gui/RVBMenuPartsSettingsFrame.lua", directory))
-- EVENT FILES
source(Utils.getFilename("scripts/events/RVBTotal_Event.lua", directory))
source(Utils.getFilename("scripts/events/RVB_Event.lua", directory))
source(Utils.getFilename("scripts/events/RVBRepairEvent.lua", directory))
source(Utils.getFilename("scripts/events/RVBInspection_Event.lua", directory))

source(Utils.getFilename("scripts/events/RVBService_Event.lua", directory))


source(Utils.getFilename("scripts/events/RVBParts_Event.lua", directory))
source(Utils.getFilename("scripts/events/RVBJumpStartingEvent.lua", directory))
source(Utils.getFilename("scripts/events/BatteryFillUnitFillLevelEvent.lua", directory))
source(Utils.getFilename("scripts/events/RVBLightingsStringsEvent.lua", directory))
source(Utils.getFilename("scripts/events/RVBLightingsTypesMaskEvent.lua", directory))
source(Utils.getFilename("scripts/events/RVBResetVehicle_Event.lua", directory))

--source(Utils.getFilename("scripts/events/RVBStartService_Event.lua", directory))

source(Utils.getFilename("scripts/events/RVBGenSettingsSync_Event.lua", directory))
-- HUD
source(Utils.getFilename("scripts/hud/RVB_HUD.lua", directory))
-- UTILS
source(Utils.getFilename("scripts/utils/rvb_Utils.lua", directory))
-- AIMessage
source(Utils.getFilename("scripts/ai/errors/AIMessageErrorBatteryDischarged.lua", directory))
-- PLAYER ACTION
source(Utils.getFilename("scripts/player/RVBPlayer.lua", directory))
-- Dialogs
source(Utils.getFilename("scripts/gui/dialogs/RVBInfoDialog.lua", directory))
g_gui:loadProfiles(directory .. "menu/guiProfiles.xml")
source(Utils.getFilename("scripts/gui/dialogs/rvbWorkshopDialog.lua", directory))


local vehicleBreakdowns
local function isEnabled()
	return vehicleBreakdowns ~= nil
end
function init()
	g_rvbPlayer = RVBPlayer.register()
	FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, unload)
	Mission00.load = Utils.prependedFunction(Mission00.load, loadMission)
	Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, loadedMission)
	FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, rvbgamePlaySetsaveToXMLFile)
	SavegameSettingsEvent.readStream = Utils.appendedFunction(SavegameSettingsEvent.readStream, readStream)
	SavegameSettingsEvent.writeStream = Utils.appendedFunction(SavegameSettingsEvent.writeStream, writeStream)
	FillTypeManager.loadMapData = Utils.appendedFunction(FillTypeManager.loadMapData, loadBatteryType)
	TypeManager.finalizeTypes = Utils.prependedFunction(TypeManager.finalizeTypes, validateVehicleTypes)
	
	
	Mission00.loadMission00Finished = Utils.appendedFunction(Mission00.loadMission00Finished, function()
		print("[RVB] Hooked into FSBaseMission:setPlannedDaysPerPeriod")
	end)


	MessageType.RVB_RESET_VEHICLE = nextMessageTypeId()
    MessageType.RVB_VEHICLE_RESET = nextMessageTypeId()
	MessageType.RVB_START_REPAIR = nextMessageTypeId()
	MessageType.RVB_START_SERVICE = nextMessageTypeId()
	MessageType.RVB_START_INSPECTION = nextMessageTypeId()
	MessageType.RVB_END_INSPECTION = nextMessageTypeId()
	MessageType.SET_PARTS_LIFETIME = nextMessageTypeId()
	MessageType.SET_WORKSHOP_STATE = nextMessageTypeId()
	MessageType.RVB_STARTMOTOR = nextMessageTypeId()
	MessageType.SET_DIFFICULTY = nextMessageTypeId()
	MessageType.SET_DAYSPERPERIOD = nextMessageTypeId()
	
	vehicleBreakdowns = RVBMain:new(directory, modName)
	RVBInfoDialog.register()
	rvbWorkshopDialog.register()

end
function loadMission(mission)
	mission.vehicleBreakdowns = vehicleBreakdowns
	addModEventListener(vehicleBreakdowns)
end
function loadedMission(mission, node)
	if not isEnabled() then
		print("Error: vehicleBreakdowns is nil, not enabled")
		return
	end
	if mission.cancelLoading then
		return
	end
	vehicleBreakdowns:onMissionLoaded(mission)
end
function rvbgamePlaySetsaveToXMLFile(missionInfo)
	if isEnabled() and missionInfo.isValid then
		local savegameFolderPath = missionInfo.savegameDirectory 
		if savegameFolderPath == nil then
			savegameFolderPath = ('%ssavegame%d'):format(getUserProfileAppPath(), missionInfo.savegameIndex)
		end
		local GAMEPLAY_SETTINGS_XML = Utils.getFilename("/RVBGamePlaySettings.xml", savegameFolderPath)
		vehicleBreakdowns:rvbsaveToXMLFile(GAMEPLAY_SETTINGS_XML)
	end
end
function validateVehicleTypes(typeManager)
	if typeManager.typeName == "vehicle" then
		RVBMain.installSpecializations(g_vehicleTypeManager, g_specializationManager, directory, modName)
	end
end
function registerActionEvents()
	vehicleBreakdowns:registerActionEvents()
end
function unregisterActionEvents()
	vehicleBreakdowns:unregisterActionEvents()
end
function unload()
	if not isEnabled() then
		return
	end
	removeModEventListener(vehicleBreakdowns)
	vehicleBreakdowns:delete()
	vehicleBreakdowns = nil
	if g_currentMission ~= nil then
		g_currentMission.vehicleBreakdowns = nil
	end
end
function readStream(e, streamId, connection)
	if not isEnabled() then
		return
	end
	vehicleBreakdowns:onReadStream(streamId, connection)
end
function writeStream(e, streamId, connection)
	if not isEnabled() then
		return
	end
	vehicleBreakdowns:onWriteStream(streamId, connection)
end
function loadBatteryType()
	local battery = loadXMLFile("fillTypes", g_vehicleBreakdownsDirectory .. "data/battery_fillType.xml")
	if battery ~= nil then
		g_fillTypeManager:loadFillTypes(battery, g_vehicleBreakdownsDirectory, false, g_vehicleBreakdownsModName)
		delete(battery)
	end
end


-- =========================================================================
-- FSBaseMission:setPlannedDaysPerPeriod HOOK
-- =========================================================================

local FSBaseMission_setPlannedDaysPerPeriod = FSBaseMission.setPlannedDaysPerPeriod

-- Eredeti függvény megtartása és kiegészítése
function FSBaseMission:setPlannedDaysPerPeriod(days, noEventSend)
    -- Eredeti futtatása
    FSBaseMission_setPlannedDaysPerPeriod(self, days, noEventSend)

    -- Saját logika
    print(string.format("[RVB] PlannedDaysPerPeriod changed to %s", days))

	-- Esemény küldése, ha a g_messageCenter már elérhető
    if g_messageCenter ~= nil then
        g_messageCenter:publish(MessageType.SET_DAYSPERPERIOD, days)
        print("[RVB] g_messageCenter: published SET_DAYSPERPERIOD message")
    else
        print("[RVB] Warning: g_messageCenter was nil when trying to publish SET_DAYSPERPERIOD")
    end
	
    -- Csak akkor fussunk, ha a mission már fut
    --[[if g_currentMission ~= nil and g_currentMission.vehicleBreakdowns ~= nil then
        local vb = g_currentMission.vehicleBreakdowns
        VehicleBreakdowns.FSSET_Daysperiod = days

        if g_server ~= nil then
            print("[RVB] Server detected plannedDaysPerPeriod change → sync dirty flag")
            vb:raiseDirtyFlags(vb.spec_lifetimeDirtyFlag)
        else
            print("[RVB] Client detected plannedDaysPerPeriod change")
        end
    end]]
end

init()