--Sandmann
--20/09/2025

-- Adjust first-person camera to a more realistic eye height (~1.65 m)
-- Ego-Kamera auf eine realistischere Augenhöhe einstellen (~1,65 m)
-- Ajuster la caméra à la première personne à une hauteur d’yeux plus réaliste (~1,65 m)

RealisticFirstPerson = {}
RealisticFirstPerson.offsetY = -0.05  -- negative = lower, positive = higher
RealisticFirstPerson.DEBUG   = false  -- set true for extra logs

local originalInit = PlayerCamera.initialiseCameraNodes

function PlayerCamera:initialiseCameraNodes(...)
    -- call original function first
    originalInit(self, ...)

    if self.firstPersonCamera ~= nil then
        if RealisticFirstPerson.DEBUG then
            local _, y, _ = getTranslation(self.firstPersonCamera)
            print("[RealisticFirstPerson] original camera Y = " .. tostring(y))
        end

        -- create offset node and attach it
        local offsetNode = createTransformGroup("realisticFirstPersonOffset")
        link(getParent(self.firstPersonCamera), offsetNode)
        setTranslation(offsetNode, 0, RealisticFirstPerson.offsetY, 0)

        -- re-parent the camera under the offset node
        link(offsetNode, self.firstPersonCamera)
        setTranslation(self.firstPersonCamera, 0, 0, 0)

        self.realisticViewOffsetNode = offsetNode

        print("[RealisticFirstPerson] camera moved by " .. RealisticFirstPerson.offsetY .. " m")
    end
end
