Financing_InGameMenuStatisticsFrame = {}
local modDirectory = g_currentModDirectory


function Financing_InGameMenuStatisticsFrame:updateVehicles(superFunc)

    self.vehicles = {}

    if g_localPlayer ~= nil then

        local currentMission = g_currentMission
        local accessHandler = currentMission.accessHandler

        for _, vehicle in ipairs(currentMission.vehicleSystem.vehicles) do

            if accessHandler:canPlayerAccess(vehicle) and (vehicle:getShowInVehiclesOverview() and g_localPlayer.farmId == vehicle:getOwnerFarmId()) then

                local info = {
                    ["vehicle"] = vehicle,
                    ["columns"] = {}
                }

                local vehicleName = vehicle:getFullName()

                info.columns[InGameMenuStatisticsFrame.COLUMN_NAME] = {
                    ["text"] = vehicleName,
                    ["value"] = vehicleName
                }

                local ageColumn = {
                    ["text"] = Vehicle.getSpecValueAge(nil, vehicle),
                    ["value"] = vehicle.age
                }

                info.columns[InGameMenuStatisticsFrame.COLUMN_AGE] = ageColumn

                local specValueOperatingTime, operatingTime

                if vehicle.getOperatingTime == nil then
                    specValueOperatingTime = "-"
                    operatingTime = 0
                else
                    specValueOperatingTime = Vehicle.getSpecValueOperatingTime(nil, vehicle)
                    operatingTime = vehicle:getOperatingTime()
                end

                info.columns[InGameMenuStatisticsFrame.COLUMN_HOURS] = {
                    ["text"] = specValueOperatingTime,
                    ["value"] = operatingTime
                }

                local vehicleDamageFactor, vehicleDamageText

                if SpecializationUtil.hasSpecialization(Wearable, vehicle.specializations) then
                    vehicleDamageFactor = vehicle:getDamageAmount()
                    local vehicleDamage = (1 - vehicleDamageFactor) * 100
                    vehicleDamageText = g_i18n:formatNumber(math.ceil(vehicleDamage), 0) .. " %"
                else
                    vehicleDamageText = "-"
                    vehicleDamageFactor = 0
                end

                info.columns[InGameMenuStatisticsFrame.COLUMN_DAMAGE] = {
                    ["text"] = vehicleDamageText,
                    ["value"] = vehicleDamageFactor
                }

                local leasePrice, leasePriceText

                if vehicle.propertyState == VehiclePropertyState.LEASED then
                    leasePrice = vehicle.price * (EconomyManager.DEFAULT_RUNNING_LEASING_FACTOR + EconomyManager.PER_DAY_LEASING_FACTOR)
                    leasePriceText = g_i18n:formatMoney(leasePrice)
                else
                    leasePriceText = "-"
                    leasePrice = 0
                end

                info.columns[InGameMenuStatisticsFrame.COLUMN_LEASING] = {
                    ["text"] = leasePriceText,
                    ["value"] = leasePrice
                }


                -- FINANCING COLUMN -----------------

                local financingPrice, financingText = 0, "-"

                local farm = g_farmManager.farmIdToFarm[g_localPlayer.farmId]

                if farm.financing ~= nil then

                    for _, financeEntry in farm.financing do

                        if financeEntry.vehicle == vehicle.uniqueId then
                            local env = currentMission.environment
                            local period = env.currentPeriod
                            local year = env.currentYear
                            local entryPeriod = 1
                            local entryYear = 1

                            for a, b in string.gmatch(financeEntry.date, "(%w+)-(%w+)") do
                                entryPeriod = tonumber(a)
                                entryYear = tonumber(b)
                            end

                            local totalPeriods = (12 * year) + period -- 18
                            local finishedPeriods = (12 * entryYear) + entryPeriod -- 14 15 16 17 18 .. 19

                            financingPrice = (financeEntry.amount - financeEntry.amountPaid) / ((finishedPeriods + (financeEntry.length - 1)) - totalPeriods)
                            financingText = g_i18n:formatMoney(financingPrice)
                        end

                    end

                end

                info.columns[6] = {
                    ["text"] = financingText,
                    ["value"] = financingPrice
                }

                --------------------------------------

                local sellPrice, sellPriceText

                if vehicle.propertyState == VehiclePropertyState.OWNED then
                    sellPrice = vehicle:getSellPrice()
                    sellPriceText = g_i18n:formatMoney(sellPrice)
                else
                    sellPriceText = "-"
                    sellPrice = 0
                end

                info.columns[InGameMenuStatisticsFrame.COLUMN_VALUE + 1] = {
                    ["text"] = sellPriceText,
                    ["value"] = sellPrice
                }

                local vehiclesTable = self.vehicles
                table.insert(vehiclesTable, info)

            end

        end

    end

    self:updateView()

end

--InGameMenuStatisticsFrame.updateVehicles = Utils.overwrittenFunction(InGameMenuStatisticsFrame.updateVehicles, Financing_InGameMenuStatisticsFrame.updateVehicles)