Financing_BuyVehicleData = {}

function Financing_BuyVehicleData:setFinancingLength(length)

    self.financingLength = length

end

BuyVehicleData.setFinancingLength = Financing_BuyVehicleData.setFinancingLength


function Financing_BuyVehicleData:setFinancingInterest(interest)

    self.financingInterest = interest

end

BuyVehicleData.setFinancingInterest = Financing_BuyVehicleData.setFinancingInterest


function Financing_BuyVehicleData:buy()

    if self.financing ~= nil then self:updatePrice() end

    --local farm = g_farmManager.farmIdToFarm[self.ownerFarmId]
    --if farm.financing == nil then farm.financing = {} end

    local env = g_currentMission.environment

    if self.financingLength == nil or self.financingLength == 0 then return end

    local newFinancing = {
        date = env.currentPeriod .. "-" .. env.currentYear,
        amount = self.price * self.financingLength,
        amountPaid = self.price,
        length = self.financingLength,
        vehicle = "placeholder",
        paid = false
    }

    --table.insert(farm.financing, newFinancing)

    self.financing = newFinancing

end

BuyVehicleData.buy = Utils.prependedFunction(BuyVehicleData.buy, Financing_BuyVehicleData.buy)

function Financing_BuyVehicleData.onBought(buyVehicleData, loadedVehicles, loadingState, callbackArguments)

    if loadingState == VehicleLoadingState.OK then

        for _, vehicle in loadedVehicles do

            if buyVehicleData.financing ~= nil then
                buyVehicleData.financing.vehicle = vehicle.uniqueId
                local farm = g_farmManager.farmIdToFarm[buyVehicleData.ownerFarmId]
                if farm.financing == nil then farm.financing = {} end
                table.insert(farm.financing, buyVehicleData.financing)
                break
            end

        end

    end

end

BuyVehicleData.onBought = Utils.prependedFunction(BuyVehicleData.onBought, Financing_BuyVehicleData.onBought)


function Financing_BuyVehicleData:updatePrice()
	
    if self.financingLength == nil or self.financingLength == 0 then return end

    self.financingInterest = (self.financingLength == 6 and 1.02) or (self.financingLength == 12 and 1.05) or (self.financingLength == 24 and 1.1) or 1

    self.price = (self.price * self.financingInterest) / math.max(self.financingLength or self.financing.length, 6)

end

BuyVehicleData.updatePrice = Utils.appendedFunction(BuyVehicleData.updatePrice, Financing_BuyVehicleData.updatePrice)



function Financing_BuyVehicleData:readStream(streamId, connection)

    local f = streamReadUInt8(streamId)
    if f ~= nil and f ~= 0 then self.financingLength = f end

    local f1 = streamReadString(streamId)
    local f2 = streamReadUInt32(streamId)
    local f3 = streamReadUInt32(streamId)
    local f4 = streamReadUInt8(streamId)
    local f5 = streamReadString(streamId)

    self.financing = {
        date = f1,
        amount = f2,
        amountPaid = f3,
        length = f4,
        vehicle = f5,
        paid = false
    }

    if self.financingLength == nil or self.financingLength == 0 then self.financing = nil end

end

BuyVehicleData.readStream = Utils.appendedFunction(BuyVehicleData.readStream, Financing_BuyVehicleData.readStream)

function Financing_BuyVehicleData:writeStream(streamId, connection)

    if self.financingLength ~= nil then
        streamWriteUInt8(streamId, self.financingLength)
    else
        streamWriteUInt8(streamId, 0)
    end

    if self.financing ~= nil then
        streamWriteString(streamId, self.financing.date)
        streamWriteUInt32(streamId, self.financing.amount)
        streamWriteUInt32(streamId, self.financing.amountPaid)
        streamWriteUInt8(streamId, self.financing.length)
        streamWriteString(streamId, self.financing.vehicle)
    else
        streamWriteString(streamId, "1-1")
        streamWriteUInt32(streamId, 0)
        streamWriteUInt32(streamId, 0)
        streamWriteUInt8(streamId, 0)
        streamWriteString(streamId, "0")
    end

end

BuyVehicleData.writeStream = Utils.appendedFunction(BuyVehicleData.writeStream, Financing_BuyVehicleData.writeStream)