EAS_UpdateAutomaticInseminationStateEvent = {}

local EAS_UpdateAutomaticInseminationStateEvent_mt = Class(EAS_UpdateAutomaticInseminationStateEvent, Event)
InitEventClass(EAS_UpdateAutomaticInseminationStateEvent, "EAS_UpdateAutomaticInseminationStateEvent")

function EAS_UpdateAutomaticInseminationStateEvent.emptyNew()
    local self = Event.new(EAS_UpdateAutomaticInseminationStateEvent_mt)

    return self
end

function EAS_UpdateAutomaticInseminationStateEvent.new(husbandry, state)
    local self = EAS_UpdateAutomaticInseminationStateEvent.emptyNew()

    self.husbandry = husbandry
    self.state = state

    return self
end

function EAS_UpdateAutomaticInseminationStateEvent:readStream(streamId, connection)
    self.husbandry = NetworkUtil.readNodeObject(streamId)
    self.state = streamReadBool(streamId)

    self:run(connection)
end

function EAS_UpdateAutomaticInseminationStateEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.husbandry)
    streamWriteBool(streamId, self.state)
end

function EAS_UpdateAutomaticInseminationStateEvent:run(connection)
    self.husbandry.spec_husbandryAnimals.automaticInsemination = self.state

    if not connection:getIsServer() then
        g_server:broadcastEvent(EAS_UpdateAutomaticInseminationStateEvent.new(self.husbandry, self.state), false)
    end
end