EAS_SettingsEvent = {}

local EAS_SettingsEvent_mt = Class(EAS_SettingsEvent, Event)
InitEventClass(EAS_SettingsEvent, "EAS_SettingsEvent")

function EAS_SettingsEvent.emptyNew()
    return Event.new(EAS_SettingsEvent_mt)
end

function EAS_SettingsEvent.new()
    return EAS_SettingsEvent.emptyNew()
end

function EAS_SettingsEvent:readStream(streamId, connection)
	local animalsCanDie = streamReadInt32(streamId)

	if connection:getIsServer() or g_currentMission.userManager:getIsConnectionMasterUser(connection) then
        g_eas_inGameMenuSettingsFrameExtension:updateAnimalsCanDie(animalsCanDie, true)

		if not connection:getIsServer() then
			g_server:broadcastEvent(self, false, connection)
		end
    end
end

function EAS_SettingsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, g_eas_inGameMenuSettingsFrameExtension.animalsCanDieState)
end

function EAS_SettingsEvent.run(_, _)
    Logging.error("Error: EAS_SettingsEvent is not allowed to be executed on a local client")
end

function EAS_SettingsEvent.sendEvent(noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_currentMission:getIsServer() then
			g_server:broadcastEvent(EAS_SettingsEvent.new(), false)
			return
		end
		g_client:getServerConnection():sendEvent(EAS_SettingsEvent.new())
	end
end
