EAS_PlaceableHusbandryPallets = {}

function EAS_PlaceableHusbandryPallets.onHusbandryAnimalsUpdate(self, superFunc, clusters)
	local spec = self.spec_husbandryPallets
	for fillType, _ in pairs(spec.litersPerHour) do
		spec.litersPerHour[fillType] = 0
	end
	spec.activeFillTypes = {}
	for _, cluster in ipairs(clusters) do
		local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster.subTypeIndex)
		if subType ~= nil then
			local litersPerAnimals = subType.output.pallets
			if litersPerAnimals ~= nil then
                local fillType =  g_fillTypeManager:getFillTypeByIndex(litersPerAnimals.fillType)
                if string.find(fillType.name, "MILK") then
                    if cluster.reproduction < 80 and cluster.hadABirth then
                        local age = cluster:getAge()
                        local litersPerDay = litersPerAnimals.curve:get(age) * cluster:getNumAnimals()
                        local lactationFactor = EAS_AnimalCluster.getLactationMilkFactor(cluster)
                        local litersPerHourWithLactation = (litersPerDay / 24) * lactationFactor
                        spec.litersPerHour[litersPerAnimals.fillType] = spec.litersPerHour[litersPerAnimals.fillType] + litersPerHourWithLactation
                    end
                else
                    local age = cluster:getAge()
                    local litersPerDay = litersPerAnimals.curve:get(age) * cluster:getNumAnimals()
                    spec.litersPerHour[litersPerAnimals.fillType] = spec.litersPerHour[litersPerAnimals.fillType] + litersPerDay / 24
                    table.addElement(spec.activeFillTypes, litersPerAnimals.fillType)
                end
                table.addElement(spec.activeFillTypes, litersPerAnimals.fillType)
			end
		end
	end
end

PlaceableHusbandryPallets.onHusbandryAnimalsUpdate = Utils.overwrittenFunction(PlaceableHusbandryPallets.onHusbandryAnimalsUpdate, EAS_PlaceableHusbandryPallets.onHusbandryAnimalsUpdate)