EAS_PlaceableHusbandryFood = {}

function EAS_PlaceableHusbandryFood:onHusbandryAnimalsUpdate(superFunc, clusters)
    local spec = self.spec_husbandryFood
	spec.litersPerHour = 0
	for _, cluster in ipairs(clusters) do
		local subType = g_currentMission.animalSystem:getSubTypeByIndex(cluster.subTypeIndex)
		if subType ~= nil then
			local food = subType.input.food
			if food ~= nil then
				local litersPerDay = food:get((cluster:getAge())) * cluster:getNumAnimals()
                local foodFactor = EAS_AnimalCluster.getLactationFoodFactor(cluster)
				local litersPerHourWithFoodFactor = (litersPerDay / 24) * foodFactor

				spec.litersPerHour = spec.litersPerHour + litersPerHourWithFoodFactor
			end
		end
	end
end

PlaceableHusbandryFood.onHusbandryAnimalsUpdate = Utils.overwrittenFunction(PlaceableHusbandryFood.onHusbandryAnimalsUpdate, EAS_PlaceableHusbandryFood.onHusbandryAnimalsUpdate)
